﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using SeguridadAlumnos;
using SeguridadTutores;
using System.Security.Claims;
using System.Web.Mvc;

namespace Nova.Models
{
    public static class Usuario
    {
        public static string ValidaTipoUsuario(string email)
        {
            bdNovaEntities bd = new bdNovaEntities();
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria trabajador = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(b => (b.Convenios_stConvenioLaboralTrabajador.FechaTermino >= System.DateTime.Now || b.Convenios_stConvenioLaboralTrabajador.FechaTermino == null) && b.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico.ToLower() == email).FirstOrDefault();
            string regresa = "";
            if (trabajador != null)
                regresa = "trabajador";
            else
            {
                var status = SeguridadAlumnos.Alumnos.Instance.ValidateUser(email);
                if (status.Success)
                    regresa = "alumno";
                else
                {
                    var tutor = SeguridadTutores.Tutores.Instance.ValidateUser(email);
                    if (tutor.Success)
                        regresa = "tutor";

                }
            }

            return regresa;
        }



        public static SeguridadAlumnos.catalogoAlumnos Alumno()
        {
            return SeguridadAlumnos.Alumnos.Instance.Logeado(System.Web.HttpContext.Current.User.Identity.Name);

        }

        public static SeguridadTutores.catalogoAlumnos Tutor()
        {
            return SeguridadTutores.Tutores.Instance.Logeado(System.Web.HttpContext.Current.User.Identity.Name);

        }
        public static string Rol()
        {
            string regresa = "";
            var user = System.Web.HttpContext.Current.User as ClaimsPrincipal;
            if (user != null)
            {

                if (user.HasClaim(c => c.Type == ClaimTypes.Role))
                    regresa = user.FindFirst(c => c.Type == ClaimTypes.Role).Value;
            }
            return regresa;
        }


    }
}