﻿using DevExpress.Web.ASPxHtmlEditor.Internal;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;
using Nova.Libraries;
using Nova.Models.Kardex;


namespace Nova.Models
{
    public class Kardex_SolicitudEvaluacionesIncidencia : Kardex_SolicitudEvaluaciones
    {
        public string IdConvenioLaboralTrabajadorCategoriaIncidencia { get; set; }
    }
    public class TrabajadoresEvaluaciones
    {
        public int IdKardex { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string CURP { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string TelefonoCelular { get; set; }
        public string CorreoElectronico { get; set; }
        public string GradoAcademico { get; set; }
        public string Categoria { get; set; }
        public string EstructuraOrganica { get; set; }
        public DateTime FechaInicioIncidencia { get; set; }
        public DateTime FechaTerminoIncidencia { get; set; }
        public long? IdIncidenciaTrabajador { get; set; }
        public string UbicacionFisica { get; set; }


    }
    public class TrabajadoresHistorico
    {
        public int IdKardex { get; set; }
        public string CURP { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string NombreC { get; set; }
        public string ApellidoPaternoC { get; set; }
        public string ApellidoMaternoC { get; set; }
        public string TipoSuplencia { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string CicloEscolar { get; set; }
        public string NumeroOficio { get; set; }





    }
    public class TrabajadoresCubiertos
    {

        public DateTime FechaSolicitud { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public int IdConvenioLaboralTrabajadorCategoriaCubierto { get; set; }
        public bool EsAtendida { get; set; }
        public string CicloEscolar { get; set; }
        public int IdSuplente { get; set; }

        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }






    }

    public class ExpedienteTrabajadorCentro
    {


        public int IdKardexSolicitudEvaluacion { get; set; }
        public int IdKardexCandidato { get; set; }
        public int IdEstructuraOrganicaLaboraFisicamente { get; set; }
        public DateTime FechaRegistro { get; set; }
        public int IdKardex { get; set; }
        public int IdKardexDocumentoCentro { get; set; }
        public byte[] Archivo { get; set; }
        public string NombreArchivo { get; set; }
        public string TipoDocumento { get; set; }

        public bool EsAceptable { get; set; }



    }




    public class Kardex_ctDatosPersonalesCandidato
    {
        public int IdKardex { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string CURP { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Telefono { get; set; }
        public string CorreoElectronico { get; set; }
        public int IdKardexNivelEstudio { get; set; }
        public string NivelEstudioDescripcion { get; set; }
        public string AbreviaturaProfesion { get; set; }





    }




    public class TrabajadoresContratos
    {
        public int IdTrabajador { get; set; }
        public int IdKardexSolicitudEvaluacion { get; set; }
        public int IdKardexCandidato { get; set; }
        public int IdConvenioLaboralTrabajadorCategoriaaCubrir { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string CicloEscolar { get; set; }
        public string TipoSuplencia { get; set; }
        public string EstructuraOrganica { get; set; }
        public int IdEstructuraOrganica { get; set; }
        public string EstructuraOrganicaAdscripcion { get; set; }
        public string Categoria { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public DateTime FechaSolicitud { get; set; }
        public string EstatusContratos { get; set; }
        public string GradoAcademico { get; set; }
        public int IdAreaConocimiento { get; set; }

        public string AreaConocimiento { get; set; }
        public int HorasSemanaMes { get; set; }
        public string NombreRegistro { get; set; }
        public string ApellidoPaternoRegistro { get; set; }
        public string ApellidoMaternoRegistro { get; set; }
        public string CorreoElectronico { get; set; }

        public string NombreCubrir { get; set; }
        public string ApellidoPaternoCubrir { get; set; }
        public string ApellidoMaternoCubrir { get; set; }
        public string CategoriaCubrir { get; set; }

        public string NumeroOficio { get; set; }
        public bool EsAceptable { get; set; }
        public string RelacionLaboral { get; set; }
        public string TelefonoCelular { get; set; }
        public string Observaciones { get; set; }
        public string Curp { get; set; }

        public string NivelEstudio { get; set; }



    }

    public class TrabajadoresContratosHistorial
    {
        public int IdTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string EstructuraOrganica { get; set; }
        public string GradoAcademico { get; set; }
        public string NumeroCedulaProfesional { get; set; }
        public string AreaConocimiento { get; set; }
        public int HorasSemanaMes { get; set; }
        public string Categoria { get; set; }

        public bool EsAceptable { get; set; }
        public bool EsEvaluado { get; set; }
        public DateTime FechaEvaluacion { get; set; }
        public string RelacionLaboral { get; set; }
        public string TelefonoCelular { get; set; }
        public string TipoSuplencia { get; set; }
        public string CicloEscolar { get; set; }

        //public string Observaciones { get; set; }

        //public string Curp { get; set; }

        //public string NivelEstudio { get; set; }




    }
    public class CiclosEscolares
    {
        public int IdContratosFechas { get; set; }
        public string CicloEscolar { get; set; }
        //        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
    }

    public class TodosCiclosEscolares
    {

        public string CicloEscolar { get; set; }
        //        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
    }

    public class cicloescolarvigente
    {
        public static List<CiclosEscolares> GetCiclosEscolares()
        {
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string query;

            query = @"select IdContratosFechas,CicloEscolar from Nomina_ContratosConfiguracion
                        where EsVigente=1";
            List<CiclosEscolares> listat = (List<CiclosEscolares>)dp.connection.Query<CiclosEscolares>(query);
            dp.Close();
            return listat.ToList();

        }

    }
    public partial class SolicitudesTrabajadores
    {
        public static List<TrabajadoresContratos> getSolicitudesTrabajadores()
        {

            string CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;
            string query = string.Format(@"select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, n.EstructuraOrganica as EstructuraOrganicaAdscripcion, p.Categoria, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
											g.AreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,
											m.Nombre as NombreCubrir, m.ApellidoPaterno as ApellidoPaternoCubrir,  m.ApellidoMaterno  as ApellidoMaternoCubrir,
                                             m.Categoria as CategoriaCubrir, a.NumeroOficio, q.EsAceptable
											 from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											left join  Kardex_ResultadoEvaluacion q on a.IdKardexCandidato = q.IdKardex and q.IdAreaConocimiento = a.IdAreaConocimiento
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
											inner join  Catalogos_ctEstructuraOrganica n on a.IdEstructuraOrganicaAdscripcion= n.IdEstructuraOrganica
											inner join  Plazas_ctCategoria p on a.IdCategoriaAspirante = p .IdCategoria 
											left join  vwDatosAspirantesTrabajadores m on  a.IdConvenioLaboralTrabajadorCategoriaaCubrir  = m.IdConvenioLaboralTrabajadorCategoria 
                                            where  a.CicloEscolar = '{0}'", CicloEscolar);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosContratos = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(query);
            dp.Close();
            return kardex_DatosContratos.ToList();

        }
        public static List<TrabajadoresContratos> getSolicitudesTrabajadoresFiltro(string Filtro)
        {

            string query = string.Format(@" select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, n.EstructuraOrganica as EstructuraOrganicaAdscripcion, p.Categoria, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
											g.AreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,
											m.Nombre as NombreCubrir, m.ApellidoPaterno as ApellidoPaternoCubrir,  m.ApellidoMaterno  as ApellidoMaternoCubrir,
                                             m.Categoria as CategoriaCubrir, a.NumeroOficio, q.EsAceptable
											 from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											left join  Kardex_ResultadoEvaluacion q on a.IdKardexCandidato = q.IdKardex and q.IdAreaConocimiento = a.IdAreaConocimiento
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
											inner join  Catalogos_ctEstructuraOrganica n on a.IdEstructuraOrganicaAdscripcion= n.IdEstructuraOrganica
											inner join  Plazas_ctCategoria p on a.IdCategoriaAspirante = p .IdCategoria 
											left join  vwDatosAspirantesTrabajadores m on  a.IdConvenioLaboralTrabajadorCategoriaaCubrir  = m.IdConvenioLaboralTrabajadorCategoria
                                            " + Filtro + " order by a.IdKardexSolicitudEvaluacion DESC ");
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosContratos = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(query);
            dp.Close();
            return kardex_DatosContratos.ToList();

        }

    }
    public partial class TrabajadoresEvaluacionesSuplir
    {


        public static bool getValidarFechas(DateTime FechaInicio, DateTime FechaTermino, DateTime FechaInicioComparar, DateTime FechaTerminoComparar)
        {
            if (FechaTerminoComparar == null)
            {
                if (FechaInicio == FechaInicioComparar)
                {
                    return true;
                }
                else { return false; }


            }
            if (FechaInicio < FechaTerminoComparar && FechaTermino > FechaInicioComparar)
            {
                return true;
            }
            else { return false; }


        }
        public static bool getValidarFechasTrabajadorDuplicado(DateTime FechaInicio, DateTime FechaTermino, int? IdConvenioLaboralTrabajadorCategoriaaCubrir, DateTime FechaInicioComparar, DateTime FechaTerminoComparar, int? IdConvenioLaboralTrabajadorCategoriaaCubrirExiste)
        {
            if (IdConvenioLaboralTrabajadorCategoriaaCubrir == IdConvenioLaboralTrabajadorCategoriaaCubrirExiste)
            {
                if (FechaTerminoComparar == null)
                {
                    if (FechaInicio == FechaInicioComparar)
                    {
                        return true;
                    }
                    else { return false; }


                }
                if (FechaInicio < FechaTerminoComparar && FechaTermino > FechaInicioComparar)
                {
                    return true;
                }
                else { return false; }


            }
            else
            {
                return false;

            }



        }

        public static bool getValidarFechasTrabajadorDuplicadoLIC(DateTime FechaInicio, DateTime FechaTermino, int? IdConvenioLaboralTrabajadorCategoriaaCubrir, DateTime FechaInicioComparar, DateTime FechaTerminoComparar, int? IdConvenioLaboralTrabajadorCategoriaaCubrirExiste)
        {
            if (IdConvenioLaboralTrabajadorCategoriaaCubrir == IdConvenioLaboralTrabajadorCategoriaaCubrirExiste)
            {
                if (FechaTerminoComparar == null)
                {
                    if (FechaInicio == FechaInicioComparar)
                    {
                        return false;
                    }
                    else { return true; }


                }
                if (FechaInicio < FechaTerminoComparar && FechaTermino > FechaInicioComparar && FechaTermino <= FechaTerminoComparar)
                {
                    return false;
                }
                if (FechaInicio < FechaInicioComparar)
                    return true;
                else
                if (FechaTermino > FechaTerminoComparar)
                    return true;
                else { return true; }


            }
            else
            {
                return false;

            }



        }
        public static List<TrabajadoresEvaluaciones> getTrabajadoresSuplir(int id, int idrelacion)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var datos = bd.Nomina_SuplenciaTipo.Find(id);
            List<TrabajadoresEvaluaciones> m = new List<TrabajadoresEvaluaciones>();
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (id != 0)
            {

                switch (id)
                {
                    case 1:
                    case 10:
                    case 11:
                    case 17:
                    case 12:
                        u = $@"select a.IdKardex,a.IdConvenioLaboralTrabajadorCategoria,a.CURP,a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,a.TelefonoCelular,a.CorreoElectronico,a.Categoria,a.EstructuraOrganica,a.UbicacionFisica ,b.FechaInicioIncidencia,b.FechaTerminoIncidencia
                                            , b.IdIncidenciaTrabajador
                                            from vwDatosAspirantesTrabajadores a
											inner join vwLicenciasTrabajadores b on a.IdKardex = b.IdKardex and b.Estatus in  ('ACTIVA', 'PROXIMA') 
                                            where a.ConvenioLaboral in ('BASE') AND a.EstatusTrabajador= 'ALTA'and a.IdRelacionLaboral= {idrelacion} and a.IdConvenioLaboralTrabajadorCategoria in 
                                            (select IdConvenioLaboralTrabajadorCategoria from vwLicenciasTrabajadores
                                            where Estatus in  ('ACTIVA', 'PROXIMA')) AND  b.Incidencia in ('{datos.TipoSuplencia}') ";
                        m = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(u);

                        break;
                    case 5:
                        u = $@"select  IdKardex,IdConvenioLaboralTrabajadorCategoria,CURP,Nombre,ApellidoPaterno,ApellidoMaterno,TelefonoCelular,CorreoElectronico,Categoria,EstructuraOrganica,UbicacionFisica  from vwDatosAspirantesTrabajadores where
                                ConvenioLaboral='BASE' and EstatusTrabajador='BAJA' AND IdRelacionLaboral= {idrelacion} AND
                                 IdConvenioLaboralTrabajadorCategoria
                                in (
                                SELECT a.IdConvenioLaboralTrabajadorCategoria FROM [IncidenciaPermiso_stIncidenciaTrabajador] a
                                inner join Convenios_stConvenioLaboralTrabajadorCategoria x on x.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                                inner join Plazas_stDistribucionPlazaCategoria y on y.IdDistribucionPlazaCategoria=x.IdDistribucionPlazaCategoria
                                  inner join Catalogos_ctTipoIncidencia b on
                                   a.IdTipoIncidencia=b.IdTipoIncidencia
                                   inner join Catalogos_ctTipoIncidenciaPermiso c on c.IdTipoIncidenciaPermiso=b.IdTipoIncidenciaPermiso
                                   where c.TipoIncidenciaPermiso='BAJAS' and EsVacante=1
                                   )";
                        m = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(u);

                        break;
                    case 18:
                        u = $@" select  IdKardex,IdConvenioLaboralTrabajadorCategoria,CURP,Nombre,ApellidoPaterno,ApellidoMaterno,TelefonoCelular,CorreoElectronico,
                                (select top 1 categoria from vwdatosaspirantestrabajadores xx where xx.idtrabajador=s.idtrabajador and restringirmenu is not null order by fechatermino desc) as Categoria,
                                (select top 1 UbicacionFisica from vwdatosaspirantestrabajadores xx where xx.idtrabajador=s.idtrabajador and restringirmenu is not null order by fechatermino desc) as UbicacionFisica,
                                EstructuraOrganica ,FechaInicioIncidencia,FechaTerminoIncidencia 
                                               ,IdIncidenciaTrabajador                
                              from vwLicenciasTrabajadores s 
                              where ESTATUS in ('ACTIVA','PROXIMA') and s.IdRelacionLaboral={idrelacion}
                             and ConvenioLaboral in ('BASE')  and 
                             IdTipoIncidenciaPermiso in (select  IdTipoIncidenciaPermiso 
                            from Catalogos_ctTipoIncidenciaPermiso
                            where    (incidencia='ESCALAFON PROVISIONAL' or incidencia='COMISIÓN PARA OCUPAR PLAZA VACANTE') )

                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
			                            
					                            
					                            where z.ESTATUS='ACTIVA' and k.EsAtendida=0)";
                        m = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(u);

                        break;
                    case 24:
                        u = $@" select  IdKardex,IdConvenioLaboralTrabajadorCategoria,CURP,Nombre,ApellidoPaterno,ApellidoMaterno,TelefonoCelular,CorreoElectronico,
                                (select top 1 categoria from vwdatosaspirantestrabajadores xx where xx.idtrabajador=s.idtrabajador and restringirmenu is not null order by fechatermino desc) as Categoria,
                                (select top 1 UbicacionFisica from vwdatosaspirantestrabajadores xx where xx.idtrabajador=s.idtrabajador and restringirmenu is not null order by fechatermino desc) as UbicacionFisica,
                                EstructuraOrganica ,FechaInicioIncidencia,FechaTerminoIncidencia 
                                               ,IdIncidenciaTrabajador                
                              from vwLicenciasTrabajadores s 
                              where ESTATUS in ('ACTIVA','PROXIMA') and s.IdRelacionLaboral={idrelacion}
                             and ConvenioLaboral in ('BASE')  and 
                             IdTipoIncidenciaPermiso in (select  IdTipoIncidenciaPermiso 
                            from Catalogos_ctTipoIncidenciaPermiso
                            where    (incidencia='LICENCIA CON GOCE DE SUELDO POR ESTUDIOS DE POSTGRADO') )

                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
			                            
					                            
					                            where z.ESTATUS='ACTIVA' and k.EsAtendida=0)";
                        m = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(u);

                        break;
                    case 13:
                    case 14:
                    case 16:
                        u = $@"select a.IdKardex,a.IdConvenioLaboralTrabajadorCategoria,a.CURP,a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,a.TelefonoCelular,a.CorreoElectronico,a.Categoria, a.EstructuraOrganica,a.UbicacionFisica,b.FechaInicioIncidencia,b.FechaTerminoIncidencia
                                            , b.IdIncidenciaTrabajador
                                            from vwDatosAspirantesTrabajadores a
											inner join vwLicenciasTrabajadores b on a.IdKardex = b.IdKardex and b.Estatus in  ('ACTIVA', 'PROXIMA') AND RESTRINGIRMENU IS NOT NULL
                                            where a.ConvenioLaboral in ('BASE','DEFINITIVO SPD','CONTRATO') AND a.EstatusTrabajador= 'ALTA' and a.IdRelacionLaboral= {idrelacion} and a.IdConvenioLaboralTrabajadorCategoria in 
                                            (select IdConvenioLaboralTrabajadorCategoria from vwLicenciasTrabajadores
                                            where Estatus in  ('ACTIVA', 'PROXIMA')) AND  b.Incidencia in ('{datos.TipoSuplencia}') ";

                        m = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(u);
                        break;
                    case 6:
                        u = $@"select a.IdKardex,a.IdConvenioLaboralTrabajadorCategoria,a.CURP,a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,a.TelefonoCelular,a.CorreoElectronico,a.Categoria, a.EstructuraOrganica,a.UbicacionFisica,b.FechaInicioIncidencia,b.FechaTerminoIncidencia
                                            , b.IdIncidenciaTrabajador
                                            from vwDatosAspirantesTrabajadores a
											inner join vwLicenciasTrabajadores b on a.IdKardex = b.IdKardex and b.Estatus in  ('ACTIVA', 'PROXIMA') AND RESTRINGIRMENU IS NOT NULL
                                            where a.ConvenioLaboral in ('BASE','DEFINITIVO SPD') AND a.EstatusTrabajador= 'ALTA' and a.IdRelacionLaboral= {idrelacion} and a.IdConvenioLaboralTrabajadorCategoria in 
                                            (select IdConvenioLaboralTrabajadorCategoria from vwLicenciasTrabajadores
                                            where Estatus in  ('ACTIVA', 'PROXIMA')) AND  b.Incidencia in ('{datos.TipoSuplencia}')
                                union
                                select a.IdKardex,a.IdConvenioLaboralTrabajadorCategoria,a.CURP,a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,a.TelefonoCelular,a.CorreoElectronico,a.Categoria, a.EstructuraOrganica,a.UbicacionFisica,b.FechaInicioIncidencia,b.FechaTerminoIncidencia
                                                                            , b.IdIncidenciaTrabajador
                                                                            from vwDatosAspirantesTrabajadores a
											                                inner join vwLicenciasTrabajadores b on a.IdKardex = b.IdKardex and b.Estatus in  ('PROXIMA')
                                                                            where a.ConvenioLaboral in ('BASE','DEFINITIVO SPD') AND a.EstatusTrabajador= 'ALTA' and a.IdRelacionLaboral= {idrelacion} and a.IdConvenioLaboralTrabajadorCategoria in 
                                                                            (select IdConvenioLaboralTrabajadorCategoria from vwLicenciasTrabajadores
                                                                            where Estatus in  ('PROXIMA')) AND  b.Incidencia in ('{datos.TipoSuplencia}')";
                        m = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(u);
                        break;
                    default:
                        // Do the Default
                        break;

                }








            }
            return m;
        }


        public static List<Kardex_ctAreaConocimiento> getAreasConocimiento(int id, int idrelacion)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var datos = bd.Catalogos_ctEstructuraOrganica.Find(id);
            int modalidaestudio = datos.IdModalidadEstudio;


            List<Kardex_ctAreaConocimiento> m = new List<Kardex_ctAreaConocimiento>();
            DapperQuery dp = new DapperQuery("bdNovaEntities");


            if (id != 0)
            {
                m = bd.Kardex_ctAreaConocimiento.Where(a => a.EsVigente == true && a.IdModalidadEstudio == modalidaestudio && a.IdRelacionLaboral == idrelacion).ToList();


            }
            return m;
        }

    }
}