﻿using Dapper;
using Nova.Libraries;
using System;


namespace Nova.Models.Sindicato
{



    public class DatosOficioPresentacion
    {
        public Int64 IdKardexSolicitudEvaluacion { get; set; }
        public int IdConvenioLaboralTrabajadorCategoriaaCubrir { get; set; }
        public int IdKardexCandidato { get; set; }
        public DateTime FechaInicioContrato { get; set; }
        public DateTime FechaTerminoContrato { get; set; }
        public string NumeroOficio { get; set; }
        public string CicloEscolar { get; set; }
        public string TipoSuplencia { get; set; }
        public int HorasSemanaMes { get; set; }
        public string EstructuraOrganicaCubre { get; set; }
        public string PrefijoPersonalBase { get; set; }
        public string NombrePersonalBase { get; set; }
        public string ApellidoPaternoPersonalBase { get; set; }
        public string ApellidoMaternoPersonalBase { get; set; }
        public string CategoriaPersonalBase { get; set; }
        public string EstructuraOrganicaPersonalBase { get; set; }
        public string EstructuraOrganicaLaboraFisicamente { get; set; }
        public int IdModalidadEstudio { get; set; }

        public string ModalidadEstudioEvaluacion { get; set; }
        public bool EsComisionado { get; set; }
        public string RelacionLaboral { get; set; }

        public int IdAreaConocimiento { get; set; }
        public string AreaConocimiento { get; set; }
        public string AbreviaturaProfesionDirectorGeneral { get; set; }
        public string NombreDirectorGeneral { get; set; }
        public string ApellidoPaternoDirectorGeneral { get; set; }
        public string ApellidoMaternoDirectorGeneral { get; set; }
        public string CategoriaDirectorGeneral { get; set; }
        public string AbreviaturaProfesionDirectorAdministrativo { get; set; }
        public string NombreDirectorAdministrativo { get; set; }
        public string ApellidoPaternoDirectorAdministrativo { get; set; }
        public string ApellidoMaternoDirectorAdministrativo { get; set; }
        public string CategoriaDirectorAdministrativo { get; set; }
        public string AbreviaturaProfesionJefeHumanos { get; set; }
        public string NombreJefeHumanos { get; set; }
        public string ApellidoPaternoJefeHumanos { get; set; }
        public string ApellidoMaternoJefeHumanos { get; set; }
        public string CategoriaJefeHumanos { get; set; }
        public string AbreviaturaProfesionCandidato { get; set; }
        public string NivelEstudioDescripcionCandidato { get; set; }
        public string NivelEstudioCandidato { get; set; }
        public string NombreCandidato { get; set; }
        public string ApellidoPaternoCandidato { get; set; }
        public string ApellidoMaternoCandidato { get; set; }
        public string SexoCandidato { get; set; }
        public string PrefijoCandidato { get; set; }
        public string CategoriaAspirante { get; set; }

        public string AbreviaturaProfesionDirectorAcademico { get; set; }
        public string NombreDirectorAcademico { get; set; }
        public string ApellidoPaternoDirectorAcademico { get; set; }
        public string ApellidoMaternoDirectorAcademico { get; set; }
        public string CategoriaDirectorAcademico { get; set; }

        public string AbreviaturaProfesionDirectorEMSAD { get; set; }
        public string NombreDirectorEMSAD { get; set; }
        public string ApellidoPaternoDirectorEMSAD { get; set; }
        public string ApellidoMaternoDirectorEMSAD { get; set; }
        public string CategoriaDirectorEMSAD { get; set; }
        public bool EsPorNecesidadCentro { get; set; } = false;

        public int IdKardexEvaluacion { get; set; }
        public bool EsAceptable { get; set; } = false;
        public string NumeroOficioEvaluacion { get; set; }

        public DateTime FechaEvaluacion { get; set; }

        public string AbreviaturaProfesionIngreso { get; set; }
        public string NombreJefeIngreso { get; set; }
        public string ApellidoPaternoJefeIngreso { get; set; }
        public string ApellidoMaternoJefeIngreso { get; set; }
        public string CategoriaJefeIngreso { get; set; }
        public string ObservacionSindicato { get; set; }
        public string ConvenioLaboralPersonalBase { get; set; }
        public string LeyendaTipoContrato { get; set; }

        public DatosOficioPresentacion GetDatosContrato(int IdKardexSolicitudEvaluacion)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = $@"
                            select IdKardexSolicitudEvaluacion
                                ,a.IdConvenioLaboralTrabajadorCategoriaaCubrir
                                ,a.IdKardexCandidato
                                ,a.FechaInicio as FechaInicioContrato
                                ,a.FechaTermino as FechaTerminoContrato
                                ,NumeroOficio
                                ,CicloEscolar
                                ,d.TextoImpresionTipoSuplencia as TipoSuplencia
                                ,a.HorasSemanaMes
                                ,e.EstructuraOrganica as EstructuraOrganicaCubre
                                ,PrefijoPersonalBase=case when (f.Sexo='M') then 'de la' else 'del' end
                                ,f.Nombre as NombrePersonalBase
                                ,f.ApellidoPaterno as ApellidoPaternoPersonalBase
                                ,f.ApellidoMaterno as ApellidoMaternoPersonalBase
                                ,f.Categoria as CategoriaPersonalBase
                                ,f.EstructuraOrganica as EstructuraOrganicaPersonalBase
                                ,f.ConvenioLaboral as ConvenioLaboralPersonalBase
                                ,h.EstructuraOrganica as EstructuraOrganicaLaboraFisicamente
                                ,hh.IdModalidadEstudio
                                ,ModalidadEstudioEvaluacion= case when c.IdModalidadEstudio=1 then 'BACHILLERATO TECNOLÓGICO'
								   else case when c.IdModalidadEstudio=2 then 'BACHILLERATO GENERAL (EMSaD)' else 'OFICINAS CENTRALES' end end
                                ,hh.IdCampusEquivalencia
                                ,f.EsComisionado
                                ,g.RelacionLaboral
                                ,a.IdAreaConocimiento
                                ,c.AreaConocimiento
                                ,i.Categoria as CategoriaAspirante
                                ,isnull(a.Observaciones,'') as ObservacionSindicato
                                into #DatosContrato
                                from Kardex_SolicitudEvaluaciones a
                                inner join Kardex_ctDatosPersonales b on a.IdKardexCandidato=b.IdKardex
                                inner join Kardex_ctAreaConocimiento c on c.IdAreaConocimiento=a.IdAreaConocimiento
                                inner join Nomina_SuplenciaTipo d on d.IdTipoSuplencia=a.IdTipoSuplencia
                                inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=a.IdEstructuraOrganicaAdscripcion
                                inner join Catalogos_ctEstructuraOrganica h on h.IdEstructuraOrganica=a.IdEstructuraOrganicaLaboraFisicamente
                                left join vwDatosAspirantesTrabajadores f on f.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoriaaCubrir
                                inner join Catalogos_ctRelacionLaboral g on g.IdRelacionLaboral=a.IdRelacionLaboral 
                                inner join Catalogos_ctEstructuraOrganica hh on hh.IdEstructuraOrganica=a.IdEstructuraOrganicaLaboraFisicamente
                                inner join Plazas_ctCategoria i on i.IdCategoria=a.IdCategoriaAspirante
                                where IdKardexSolicitudEvaluacion = {IdKardexSolicitudEvaluacion}

                                select IdKardex,EsAceptable,NumeroOficio as NumeroOficioEvaluacion 
								,a.FechaEvaluacion
                                into #ResultadoEvaluacion
								from Kardex_ResultadoEvaluacion a
								where  a.IdKardex=(select IdKardexCandidato from #DatosContrato)
								and a.IdAreaConocimiento= (select IdAreaConocimiento from #DatosContrato)

							    select top 1 AbreviaturaProfesionCandidato=ISNULL(AbreviaturaProfesion,'C.')
							    ,isnull(b.NivelEstudioDescripcion,'SIN DATOS') as NivelEstudioDescripcionCandidato
                                ,isnull(KardexNivelEstudio,'SIN DATOS') as NivelEstudioCandidato
                                ,Nombre as NombreCandidato
							    ,ApellidoPaterno as ApellidoPaternoCandidato
							    ,ApellidoMaterno as ApellidoMaternoCandidato
							    ,PrefijoCandidato=case when (a.Sexo='M') then 'la' else 'el' end
                                ,SexoCandidato=a.Sexo
                                ,a.LeyendaTipoContrato
							    into #DatosCandidato
							    from vwDatosAspirantesTrabajadores a
							    left join Kardex_GradoAcademico b on a.IdKardex=b.IdKardex
							    left join Kardex_NivelEstudio c on c.IdKardexNivelEstudio=b.IdKardexNivelEstudio
							    where  a.IdKardex=(select IdKardexCandidato from #DatosContrato)
							    order by  c.Orden desc,b.IdKardexGradoAcademico desc

							    select top 1 
							        AbreviaturaProfesionDirectorAcademico=ISNULL(AbreviaturaProfesion,'C.')
								    ,Nombre as NombreDirectorAcademico
								    ,ApellidoPaterno as ApellidoPaternoDirectorAcademico
								    ,ApellidoMaterno as ApellidoMaternoDirectorAcademico
								    ,CategoriaDirectorAcademico=case when (a.Sexo='M') then 'DIRECTORA ACADÉMICA' else 'DIRECTOR ACADÉMICO' end
								    into #DatosDirectorAcademico
										    from vwDatosAspirantesTrabajadores a
										    left join Kardex_GradoAcademico b on a.IdKardex=b.IdKardex
										    left join Kardex_NivelEstudio c on c.IdKardexNivelEstudio=b.IdKardexNivelEstudio
											    where EstatusTrabajador='ALTA' and ConvenioLaboral='MANDO MEDIO Y SUPERIOR' 
											    and UbicacionFisica='DIRECCIÓN ACADÉMICA'
											    order by  c.Orden,b.IdKardexGradoAcademico desc


								    select top 1 
							        AbreviaturaProfesionDirectorEMSAD=ISNULL(AbreviaturaProfesion,'C.')
								    ,Nombre as NombreDirectorEMSAD
								    ,ApellidoPaterno as ApellidoPaternoDirectorEMSAD
								    ,ApellidoMaterno as ApellidoMaternoDirectorEMSAD
								    ,CategoriaDirectorEMSAD=case when (a.Sexo='M') then 'DIRECTORA DE EDUCACIÓN A DISTANCIA' else 'DIRECTOR DE EDUCACIÓN A DISTANCIA' end
										    into #DatosDirectorEMSAD
										    from vwDatosAspirantesTrabajadores a
										    left join Kardex_GradoAcademico b on a.IdKardex=b.IdKardex
										    left join Kardex_NivelEstudio c on c.IdKardexNivelEstudio=b.IdKardexNivelEstudio
											    where EstatusTrabajador='ALTA' and ConvenioLaboral='MANDO MEDIO Y SUPERIOR' 
											    and UbicacionFisica='DIRECCIÓN DE EDUCACIÓN A DISTANCIA'
											    order by  c.Orden,b.IdKardexGradoAcademico desc

							    select top 1 
							        AbreviaturaProfesionDirectorGeneral=ISNULL(AbreviaturaProfesion,'C.')
								    ,Nombre as NombreDirectorGeneral
								    ,ApellidoPaterno as ApellidoPaternoDirectorGeneral
								    ,ApellidoMaterno as ApellidoMaternoDirectorGeneral
								    ,CategoriaDirectorGeneral=case when (a.Sexo='M') then 'DIRECTORA GENERAL' else 'DIRECTOR GENERAL' end
								    into #DatosDirectorGeneral
										    from vwDatosAspirantesTrabajadores a
										    left join Kardex_GradoAcademico b on a.IdKardex=b.IdKardex
										    left join Kardex_NivelEstudio c on c.IdKardexNivelEstudio=b.IdKardexNivelEstudio
											    where EstatusTrabajador='ALTA' and ConvenioLaboral='MANDO MEDIO Y SUPERIOR' 
											    and UbicacionFisica='DIRECCIÓN GENERAL'
											    order by  c.Orden,b.IdKardexGradoAcademico desc
							select top 1 
								AbreviaturaProfesionDirectorAdministrativo=ISNULL(AbreviaturaProfesion,'C.')
								,Nombre as NombreDirectorAdministrativo
								,ApellidoPaterno as ApellidoPaternoDirectorAdministrativo
								,ApellidoMaterno as ApellidoMaternoDirectorAdministrativo
								,CategoriaDirectorAdministrativo=case when (a.Sexo='M') then 'DIRECTORA ADMINISTRATIVA' else 'DIRECTOR ADMINISTRATIVO' end
									into #DatosDirectorAdministrativo
										from vwDatosAspirantesTrabajadores a
										left join Kardex_GradoAcademico b on a.IdKardex=b.IdKardex
										left join Kardex_NivelEstudio c on c.IdKardexNivelEstudio=b.IdKardexNivelEstudio
											where EstatusTrabajador='ALTA' and ConvenioLaboral='MANDO MEDIO Y SUPERIOR' 
											and UbicacionFisica='DIRECCIÓN ADMINISTRATIVA'
											order by  c.Orden,b.IdKardexGradoAcademico desc

                                	select top 1 
								AbreviaturaProfesionIngreso=ISNULL(AbreviaturaProfesion,'C.')
								,Nombre as NombreJefeIngreso
								,ApellidoPaterno as ApellidoPaternoJefeIngreso
								,ApellidoMaterno as ApellidoMaternoJefeIngreso
								,CategoriaJefeIngreso=case when (a.Sexo='M') then 'JEFA DEL DEPARTAMENTO DE INGRESO Y FORMACIÓN DE PERSONAL' else 'JEFE DEL DEPARTAMENTO DE INGRESO Y FORMACIÓN DE PERSONAL' end
									into #DatosJefeIngreso
										from vwDatosAspirantesTrabajadores a
										left join Kardex_GradoAcademico b on a.IdKardex=b.IdKardex
										left join Kardex_NivelEstudio c on c.IdKardexNivelEstudio=b.IdKardexNivelEstudio
											where EstatusTrabajador='ALTA' and ConvenioLaboral='MANDO MEDIO Y SUPERIOR' 
											and UbicacionFisica='DEPARTAMENTO DE INGRESO Y FORMACIÓN DE PERSONAL'
											order by  c.Orden,b.IdKardexGradoAcademico desc    
                                                                


								select top 1 
								AbreviaturaProfesionJefeHumanos=ISNULL(AbreviaturaProfesion,'C.')
								,Nombre as NombreJefeHumanos
								,ApellidoPaterno as ApellidoPaternoJefeHumanos
								,ApellidoMaterno as ApellidoMaternoJefeHumanos
								,CategoriaJefeHumanos=case when (a.Sexo='M') then 'JEFA DE DEPARTAMENTO DE RECURSOS HUMANOS' else 'JEFE DE DEPARTAMENTO DE RECURSOS HUMANOS' end
									into #DatosJefeHumanos
										from vwDatosAspirantesTrabajadores a
										left join Kardex_GradoAcademico b on a.IdKardex=b.IdKardex
										left join Kardex_NivelEstudio c on c.IdKardexNivelEstudio=b.IdKardexNivelEstudio
											where EstatusTrabajador='ALTA' and ConvenioLaboral='MANDO MEDIO Y SUPERIOR' 
											and UbicacionFisica='DEPARTAMENTO DE RECURSOS HUMANOS'
											order by  c.Orden,b.IdKardexGradoAcademico desc

										select a.*,b.*
										,c.*,d.*,e.*
                                        ,AbreviaturaProfesionDirectorAcademico=isnull(f.AbreviaturaProfesionDirectorAcademico,'MAE')
										,ApellidoPaternoDirectorAcademico=isnull(f.ApellidoPaternoDirectorAcademico,'ARANGO')
										,ApellidoMaternoDirectorAcademico=isnull(f.ApellidoMaternoDirectorAcademico,'ARANGO')
										,NombreDirectorAcademico=isnull(f.NombreDirectorAcademico,'CECILIA CARMELA')
										,CategoriaDirectorAcademico=CASE WHEN LEN(f.CategoriaDirectorAcademico)>0 THEN f.CategoriaDirectorAcademico ELSE 'JEFA DE DEPARTAMENTO' END
                                        --,CategoriaDirectorAcademico=ISNULL(f.CategoriaDirectorAcademico,'JEFA DE DEPARTAMENTO')
                                        ,g.*,i.*
										,isnull(h.IdKardex,0) IdKardexEvaluacion
										,isnull(h.EsAceptable,0) as EsAceptable
                                        ,isnull(h.NumeroOficioEvaluacion,'N/A')  as NumeroOficioEvaluacion  
                                        ,h.FechaEvaluacion
										from #DatosContrato  a
										cross join #DatosDirectorGeneral  b
										cross join #DatosDirectorAdministrativo c
										cross join #DatosJefeHumanos  d
										cross join #DatosCandidato e
										LEFT JOIN #DatosDirectorAcademico f ON 1 = 1 
										cross join #DatosDirectorEMSAD g
										cross join #DatosJefeIngreso i
                                        left join #ResultadoEvaluacion h on a.IdKardexCandidato=h.IdKardex
                            ";
            var model = (DatosOficioPresentacion)dp.connection.QuerySingleOrDefault<DatosOficioPresentacion>(query);
            dp.Close();
            return model;
        }
    }
}