﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Transactions;
using System.Web;
using static DevExpress.Utils.Drawing.Helpers.NativeMethods;

namespace Nova.Models
{
    public class NominasCerradas
    {
        public string Plantilla { get; set; }
        public string Año { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string QuincenaMes { get; set; }
        public string AliasNomina { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public short IdPeriodoNomina { get; set; }
        public int IdTrabajador { get; set; }
        public int IdNomina { get; set; }
        public int DiasEfectivosLaborados { get; set; }
        public double SueldoNeto { get; set; }
        

    }

    public class ReCalculosNomina
    {
        public string createSqlHistorial(string condicion, int idnomina, DateTime FechaInicio, DateTime FechaTermino, int idmotivodevolucion = 0)
        {
            if (idmotivodevolucion > 0)
            {
                condicion = condicion + $" and a.IdMotivoDevolucion={idmotivodevolucion}  ";
            }
            string query = $@"insert into Nomina_stNominaTrabajadorHistorial select *
 ,[CLC]=null,[UUID]=null,[EsTimbreCancelado]=null,[IdAjustePresupuestal]=null,[NumPoliza]=null
      ,[NumTransferencia]=null
      ,[NumCuentaConcentradora]=null
      ,[NumCuentaTrabajador]=null
from (
select 
vwH.RelacionLaboral
,vwH.RelacionConvenioLaboral
,vwH.ConvenioLaboral
,vwH.ConvenioLaboralTipo
,vwH.Categoria
,vwH.ClaveCategoria
,vwH.ClaveCentroTrabajo
,vwH.ApellidoPaterno + SPACE(1) + vwH.ApellidoMaterno + SPACE(1) + vwH.Nombre as NombreCompleto
,vwH.ApellidoPaterno ,vwH.ApellidoMaterno, vwH.Nombre as Nombre
,a.FechaIngreso
,vwH.Sexo,vwH.RFC,vwH.CURP,vwH.CodigoPostal,vwH.CorreoElectronico,vwH.NSS
,Domicilio=vwH.Calle + Space(1) + cast(vwH.NumeroExterior as varchar(50))+ ', COL.' +vwH.Colonia+ ', '
+vwH.LocalidadVive+ ', ' +vwH.EstadoVive + ', C.P.' + cast(vwH.CodigoPostal as varchar(20))
,Percepcion
,c.Concepto
,c.Importe
,c.Importe as ImporteOperacion
,i.Plantilla
,ig.PlantillaGrupo
,ig.GrupoPagoNomina
,pt.Partida as ConceptoPartida
,pt.PartidaGenerica+pt.PartidaEspecifica as Partida
,vwH.EstructuraOrganica as Adscripcion
,vwH.UbicacionFisica
,Proyecto=case when vwH.UbicacionFisica like 'EMSAD%' then '20004000002' else '20004000001' end
,tn.TipoNomina
,tn.Abreviatura as TiponominaAbreviatura
--,mg.Mes as MesGeneracion
,mp.Mes as MesNomina
,mp.Abreviatura
,mg.Orden as OrdenMesGeneracion
,b.Año
,qm.QuincenaMes
,b.FechaInicio
,b.FechaTermino
,a.IdNomina,a.IdConvenioLaboralTrabajadorCategoria,a.SueldoBruto,a.SueldoDiario,a.SueldoNeto,a.SueldoTransferencia,a.SueldoMonedero,a.IdTrabajadorCuentasTransferencia,a.IdTrabajadorCuentasMonedero,a.HorasSemanaMes,a.HorasSemanaMesTrabajadas,a.HorasExcedentes,a.HorasTrabajadasExcedentes,a.HorasInterinas,a.HorasTrabajadasInterinas,a.DiasEfectivosLaborados,a.CostoPorHora,a.CostoPorHoraExcedente,a.CostoPorHorasInterinas,a.SalarioDiarioIntegrado,a.QuinquenioDiario,a.MaterialDidacticoDiario,a.SueldoBrutoQuinquenioDiario,a.SumaPercepcionesVariables,a.BaseGravable,a.HorasEfectivasDeTrabajo,a.EsHorarioSinCambios,a.SalarioBrutoGravable,a.SubsidioEmpleoMensual,a.Isr,a.IsrRdl,a.Rdl,a.CantidadSubsidioEmpleoMensual,a.EsHorarioAnterior,a.EsHorarioAjustado,a.CostoEficienciaExcedente,a.CostoMaterialDidactico,a.CostoEficienciaJornada,a.CostoMaterialDidacticoExcedente,a.IdNominaTrabajadorEstatus,a.DiasFaltas,a.HorasFaltas,a.EsMedioRecibo,a.CicloEscolar,a.AjusteRealizado,a.MotivoAjuste,a.TotalDeducciones,a.IdMotivoDevolucion,a.SueldoTabular,a.PercepcionesAdicionales
,cl.IdTrabajador  
,e.IdPercepcion
,i.IdPlantillaNomina
,i.IdRelacionConvenioLaboral
,i.IdTipoNomina
,b.IdMesGeneracion
,vwh.IdModalidadEstudio
,b.IdQuincenaMes 
,TipoConcepto='P'
,SubTipoConcepto='P'
,m.IdNominaTrabajadorEstatusGrupo
,m.EstatusNomina
,b.IdTipoCalculo
,ntc.TipoCalculo
,a.IdNominaTrabajador
,b.EsCerrada
,c.IdNominaTrabajadorPercepcion as IdPercepcionDeducionCreditoPension
,la.IdClasificacionLaboral
,la.ClasificacionLaboral
,a.DiasIncapacidadImss
,a.DiasRetencion
,a.Obrero_RCV
,a.Obrero_IMSS
from Nomina_stNominaTrabajador a
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Percepciones_stNominaTrabajadorPercepciones c on c.IdNominaTrabajador=a.IdNominaTrabajador
inner join Percepciones_stPlantillaNominaPercepciones d on d.IdPlantillaNominaPercepcion=c.IdPlantillaNominaPercepcion
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Percepciones_ctPercepcion e on e.IdPercepcion=d.IdPercepcion
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Plazas_stDistribucionPlazaCategoria dp on ct.IdDistribucionPlazaCategoria=dp.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria ca on dp.IdCategoria=ca.IdCategoria
inner join Catalogos_ctClasificacionLaboral la on ca.IdClasificacionLaboral=la.IdClasificacionLaboral
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
left join Nomina_PartidasPercepciones g on g.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion
and g.Concepto=c.Concepto
left join Poa_Partidas pt on g.IdPartidas=pt.IdPartidas
left join vwNominaAjustesDevolucionesPercepciones j on j.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion and j.idnomina=b.IdNomina and a.IdNominaTrabajador=j.IdNominaTrabajador
and j.IdNominaTrabajadorPercepcion=c.IdNominaTrabajadorPercepcion
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
inner join vwDatosAspirantesTrabajadoresHistorial vwH on vwH.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Nomina_ctTipoNomina tn on tn.IdTipoNomina=i.IdTipoNomina
inner join Catalogos_ctMes mg on mg.IdMes= b.IdMesGeneracion
 inner join Catalogos_ctQuincenaMes qm on qm.IdQuincenaMes=b.IdQuincenaMes 
inner join Catalogos_ctMes mp on mp.IdMes=qm.IdMes
inner join Nomina_ctTipoCalculo ntc on ntc.IdTipoCalculo=b.IdTipoCalculo
where a.IdNomina={idnomina.ToString()} {condicion} and EstatusNominaGrupo ='PARA PAGO' and m.EstatusNomina <> 'CANCELADO' 
 and b.FechaInicio BETWEEN '{FechaInicio.ToString("yyyyMMdd")}' AND '{FechaTermino.ToString("yyyyMMdd")}'
 ----- DEDUCCIONES ----
 union all 
select 
vwH.RelacionLaboral
,vwH.RelacionConvenioLaboral
,vwH.ConvenioLaboral
,vwH.ConvenioLaboralTipo
,vwH.Categoria
,vwH.ClaveCategoria
,vwH.ClaveCentroTrabajo
,vwH.ApellidoPaterno + SPACE(1) + vwH.ApellidoMaterno + SPACE(1) + vwH.Nombre as NombreCompleto
,vwH.ApellidoPaterno ,vwH.ApellidoMaterno, vwH.Nombre as Nombre
,a.FechaIngreso
,vwH.Sexo,vwH.RFC,vwH.CURP,vwH.CodigoPostal,vwH.CorreoElectronico,vwH.NSS
,Domicilio=vwH.Calle + Space(1) + cast(vwH.NumeroExterior as varchar(50))+ ', COL.' +vwH.Colonia+ ', '
+vwH.LocalidadVive+ ', ' +vwH.EstadoVive + ', C.P.' + cast(vwH.CodigoPostal as varchar(20))
,Deduccion
,c.Concepto
,c.Importe
,(c.Importe*-1) as ImporteOperacion
,i.Plantilla
,ig.PlantillaGrupo
,ig.GrupoPagoNomina
,ConceptoPartida='Cuenta Contable'
,Partida=isnull(e.CuentaContable,'0')
,vwH.EstructuraOrganica as Adscripcion
,vwH.UbicacionFisica
,Proyecto=case when vwH.UbicacionFisica like 'EMSAD%' then '20004000002' else '20004000001' end
,tn.TipoNomina
,tn.Abreviatura as TiponominaAbreviatura
--,mg.Mes as MesGeneracion
,mp.Mes as MesNomina
,mp.Abreviatura
,mg.Orden as OrdenMesGeneracion
,b.Año
,qm.QuincenaMes
,b.FechaInicio
,b.FechaTermino
,a.IdNomina,a.IdConvenioLaboralTrabajadorCategoria,a.SueldoBruto,a.SueldoDiario,a.SueldoNeto,a.SueldoTransferencia,a.SueldoMonedero,a.IdTrabajadorCuentasTransferencia,a.IdTrabajadorCuentasMonedero,a.HorasSemanaMes,a.HorasSemanaMesTrabajadas,a.HorasExcedentes,a.HorasTrabajadasExcedentes,a.HorasInterinas,a.HorasTrabajadasInterinas,a.DiasEfectivosLaborados,a.CostoPorHora,a.CostoPorHoraExcedente,a.CostoPorHorasInterinas,a.SalarioDiarioIntegrado,a.QuinquenioDiario,a.MaterialDidacticoDiario,a.SueldoBrutoQuinquenioDiario,a.SumaPercepcionesVariables,a.BaseGravable,a.HorasEfectivasDeTrabajo,a.EsHorarioSinCambios,a.SalarioBrutoGravable,a.SubsidioEmpleoMensual,a.Isr,a.IsrRdl,a.Rdl,a.CantidadSubsidioEmpleoMensual,a.EsHorarioAnterior,a.EsHorarioAjustado,a.CostoEficienciaExcedente,a.CostoMaterialDidactico,a.CostoEficienciaJornada,a.CostoMaterialDidacticoExcedente,a.IdNominaTrabajadorEstatus,a.DiasFaltas,a.HorasFaltas,a.EsMedioRecibo,a.CicloEscolar,a.AjusteRealizado,a.MotivoAjuste,a.TotalDeducciones,a.IdMotivoDevolucion,a.SueldoTabular,a.PercepcionesAdicionales
,cl.IdTrabajador  
,e.IdDeduccion
,i.IdPlantillaNomina
,i.IdRelacionConvenioLaboral
,i.IdTipoNomina
,b.IdMesGeneracion
,vwh.IdModalidadEstudio
,b.IdQuincenaMes 
,TipoConcepto='D'
,SubTipoConcepto='D'
,m.IdNominaTrabajadorEstatusGrupo
,m.EstatusNomina
,b.IdTipoCalculo
,ntc.TipoCalculo
,a.IdNominaTrabajador
,b.EsCerrada
,c.IdNominaTrabajadorDeduccion as IdPercepcionDeducionCreditoPension
,la.IdClasificacionLaboral
,la.ClasificacionLaboral
,a.DiasIncapacidadImss
,a.DiasRetencion
,a.Obrero_RCV
,a.Obrero_IMSS
from Nomina_stNominaTrabajador a
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Deducciones_stNominaTrabajadorDeduccion c on c.IdNominaTrabajador=a.IdNominaTrabajador
inner join Deducciones_stPlantillaNominaDeducciones d on d.IdPlantillaNominaDeduccion=c.IdPlantillaNominaDeduccion
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Deducciones_ctDeduccion e on e.IdDeduccion=d.IdDeduccion
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Plazas_stDistribucionPlazaCategoria dp on ct.IdDistribucionPlazaCategoria=dp.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria ca on dp.IdCategoria=ca.IdCategoria
inner join Catalogos_ctClasificacionLaboral la on ca.IdClasificacionLaboral=la.IdClasificacionLaboral
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
left join Nomina_PartidasDeducciones g on g.IdPlantillaNominaDeduccion=d.IdPlantillaNominaDeduccion
and g.Concepto=c.Concepto
left join Poa_Partidas pt on g.IdPartidas=pt.IdPartidas
left join vwNominaAjustesDevolucionesPercepciones j on j.IdPlantillaNominaPercepcion=d.IdPlantillaNominaDeduccion and j.idnomina=b.IdNomina and a.IdNominaTrabajador=j.IdNominaTrabajador
and j.IdNominaTrabajadorPercepcion=c.IdNominaTrabajadorDeduccion
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
inner join vwDatosAspirantesTrabajadoresHistorial vwH on vwH.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Nomina_ctTipoNomina tn on tn.IdTipoNomina=i.IdTipoNomina
inner join Catalogos_ctMes mg on mg.IdMes= b.IdMesGeneracion
inner join Catalogos_ctQuincenaMes qm on qm.IdQuincenaMes=b.IdQuincenaMes 
inner join Catalogos_ctMes mp on mp.IdMes=qm.IdMes
inner join Nomina_ctTipoCalculo ntc on ntc.IdTipoCalculo=b.IdTipoCalculo
where a.IdNomina={idnomina.ToString()} {condicion} and EstatusNominaGrupo ='PARA PAGO' and m.EstatusNomina <> 'CANCELADO' 
 and b.FechaInicio BETWEEN '{FechaInicio.ToString("yyyyMMdd")}' AND '{FechaTermino.ToString("yyyyMMdd")}'

 UNION ALL
 ------ PENSIONES 
select 
vwH.RelacionLaboral
,vwH.RelacionConvenioLaboral
,vwH.ConvenioLaboral
,vwH.ConvenioLaboralTipo
,vwH.Categoria
,vwH.ClaveCategoria
,vwH.ClaveCentroTrabajo
,vwH.ApellidoPaterno + SPACE(1) + vwH.ApellidoMaterno + SPACE(1) + vwH.Nombre as NombreCompleto
,vwH.ApellidoPaterno ,vwH.ApellidoMaterno, vwH.Nombre as Nombre
,a.FechaIngreso
,vwH.Sexo,vwH.RFC,vwH.CURP,vwH.CodigoPostal,vwH.CorreoElectronico,vwH.NSS
,Domicilio=vwH.Calle + Space(1) + cast(vwH.NumeroExterior as varchar(50))+ ', COL.' +vwH.Colonia+ ', '
+vwH.LocalidadVive+ ', ' +vwH.EstadoVive + ', C.P.' + cast(vwH.CodigoPostal as varchar(20))
,Deduccion
,cn.Concepto
,cn.Importe
,(cn.Importe*-1) as ImporteOperacion
,i.Plantilla
,ig.PlantillaGrupo
,ig.GrupoPagoNomina
,cn.Concepto+ SPACE(1) +tc.TipoPension  as Concepto
,e.CuentaContable as Partida
,vwH.EstructuraOrganica as Adscripcion
,vwH.UbicacionFisica
,Proyecto=case when vwH.UbicacionFisica like 'EMSAD%' then '20004000002' else '20004000001' end

,tn.TipoNomina
,tn.Abreviatura as TiponominaAbreviatura
--,mg.Mes as MesGeneracion
,mp.Mes as MesNomina
,mp.Abreviatura
,mg.Orden as OrdenMesGeneracion
,b.Año
,qm.QuincenaMes
,b.FechaInicio
,b.FechaTermino
,a.IdNomina,a.IdConvenioLaboralTrabajadorCategoria,a.SueldoBruto,a.SueldoDiario,a.SueldoNeto,a.SueldoTransferencia,a.SueldoMonedero,a.IdTrabajadorCuentasTransferencia,a.IdTrabajadorCuentasMonedero,a.HorasSemanaMes,a.HorasSemanaMesTrabajadas,a.HorasExcedentes,a.HorasTrabajadasExcedentes,a.HorasInterinas,a.HorasTrabajadasInterinas,a.DiasEfectivosLaborados,a.CostoPorHora,a.CostoPorHoraExcedente,a.CostoPorHorasInterinas,a.SalarioDiarioIntegrado,a.QuinquenioDiario,a.MaterialDidacticoDiario,a.SueldoBrutoQuinquenioDiario,a.SumaPercepcionesVariables,a.BaseGravable,a.HorasEfectivasDeTrabajo,a.EsHorarioSinCambios,a.SalarioBrutoGravable,a.SubsidioEmpleoMensual,a.Isr,a.IsrRdl,a.Rdl,a.CantidadSubsidioEmpleoMensual,a.EsHorarioAnterior,a.EsHorarioAjustado,a.CostoEficienciaExcedente,a.CostoMaterialDidactico,a.CostoEficienciaJornada,a.CostoMaterialDidacticoExcedente,a.IdNominaTrabajadorEstatus,a.DiasFaltas,a.HorasFaltas,a.EsMedioRecibo,a.CicloEscolar,a.AjusteRealizado,a.MotivoAjuste,a.TotalDeducciones,a.IdMotivoDevolucion,a.SueldoTabular,a.PercepcionesAdicionales
,cl.IdTrabajador  
,e.IdDeduccion
,i.IdPlantillaNomina
,i.IdRelacionConvenioLaboral
,i.IdTipoNomina
,b.IdMesGeneracion
,vwh.IdModalidadEstudio
,b.IdQuincenaMes
,TipoConcepto='D'
,SubTipoConcepto='PE'
,m.IdNominaTrabajadorEstatusGrupo
,m.EstatusNomina
,b.IdTipoCalculo
,ntc.TipoCalculo
,a.IdNominaTrabajador
,b.EsCerrada
,cn.IdNominaPensionTrabajador as IdPercepcionDeducionCreditoPension
,la.IdClasificacionLaboral
,la.ClasificacionLaboral
,a.DiasIncapacidadImss
,a.DiasRetencion
,a.Obrero_RCV
,a.Obrero_IMSS
from Pensiones_stNominaPensionTrabajador cn
inner join Pensiones_stPensionesTrabajador cr on cn.IdPensionTrabajador=cr.IdPensionTrabajador
inner join Pensiones_ctTipoPension tc on tc.IdTipoPension=cr.IdTipoPension
inner join Deducciones_ctDeduccion e on e.IdDeduccion=tc.IdDeduccion
inner join Nomina_stNominaTrabajador a on cn.IdNominaTrabajador=a.IdNominaTrabajador
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Plazas_stDistribucionPlazaCategoria dp on ct.IdDistribucionPlazaCategoria=dp.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria ca on dp.IdCategoria=ca.IdCategoria
inner join Catalogos_ctClasificacionLaboral la on ca.IdClasificacionLaboral=la.IdClasificacionLaboral
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
inner join vwDatosAspirantesTrabajadoresHistorial vwH on vwH.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Nomina_ctTipoNomina tn on tn.IdTipoNomina=i.IdTipoNomina
inner join Catalogos_ctMes mg on mg.IdMes= b.IdMesGeneracion
inner join Catalogos_ctQuincenaMes qm on qm.IdQuincenaMes=b.IdQuincenaMes 
inner join Catalogos_ctMes mp on mp.IdMes=qm.IdMes
inner join Nomina_ctTipoCalculo ntc on ntc.IdTipoCalculo=b.IdTipoCalculo
where a.IdNomina={idnomina.ToString()} {condicion} and EstatusNominaGrupo ='PARA PAGO' and m.EstatusNomina <> 'CANCELADO' 
 and b.FechaInicio BETWEEN '{FechaInicio.ToString("yyyyMMdd")}' AND '{FechaTermino.ToString("yyyyMMdd")}'

 UNION ALL
 --- CRÉDITOS
 select 
vwH.RelacionLaboral
,vwH.RelacionConvenioLaboral
,vwH.ConvenioLaboral
,vwH.ConvenioLaboralTipo
,vwH.Categoria
,vwH.ClaveCategoria
,vwH.ClaveCentroTrabajo
,vwH.ApellidoPaterno + SPACE(1) + vwH.ApellidoMaterno + SPACE(1) + vwH.Nombre as NombreCompleto
,vwH.ApellidoPaterno ,vwH.ApellidoMaterno, vwH.Nombre as Nombre
,a.FechaIngreso
,vwH.Sexo,vwH.RFC,vwH.CURP,vwH.CodigoPostal,vwH.CorreoElectronico,vwH.NSS
,Domicilio=vwH.Calle + Space(1) + cast(vwH.NumeroExterior as varchar(50))+ ', COL.' +vwH.Colonia+ ', '
+vwH.LocalidadVive+ ', ' +vwH.EstadoVive + ', C.P.' + cast(vwH.CodigoPostal as varchar(20))
,TipoCredito
,'CRÉDITO'
,Importe
,(Importe*-1) as ImporteOperacion
,i.Plantilla
,ig.PlantillaGrupo
,ig.GrupoPagoNomina
, case when cn.EsAjuste=1 then 'AJUSTE '+ e.Deduccion+' '+emc.Empresa ELSE e.Deduccion+' '+emc.Empresa END as Concepto
,tc.CuentaContable as Partida
--,pt.Partida as ConceptoPartida
--,pt.PartidaGenerica+pt.PartidaEspecifica as Partida
,vwH.EstructuraOrganica as Adscripcion
,vwH.UbicacionFisica
,Proyecto=case when vwH.UbicacionFisica like 'EMSAD%' then '20004000002' else '20004000001' end

,tn.TipoNomina
,tn.Abreviatura as TiponominaAbreviatura
--,mg.Mes as MesGeneracion
,mp.Mes as MesNomina
,mp.Abreviatura
,mg.Orden as OrdenMesGeneracion
,b.Año
,qm.QuincenaMes
,b.FechaInicio
,b.FechaTermino
,a.IdNomina,a.IdConvenioLaboralTrabajadorCategoria,a.SueldoBruto,a.SueldoDiario,a.SueldoNeto,a.SueldoTransferencia,a.SueldoMonedero,a.IdTrabajadorCuentasTransferencia,a.IdTrabajadorCuentasMonedero,a.HorasSemanaMes,a.HorasSemanaMesTrabajadas,a.HorasExcedentes,a.HorasTrabajadasExcedentes,a.HorasInterinas,a.HorasTrabajadasInterinas,a.DiasEfectivosLaborados,a.CostoPorHora,a.CostoPorHoraExcedente,a.CostoPorHorasInterinas,a.SalarioDiarioIntegrado,a.QuinquenioDiario,a.MaterialDidacticoDiario,a.SueldoBrutoQuinquenioDiario,a.SumaPercepcionesVariables,a.BaseGravable,a.HorasEfectivasDeTrabajo,a.EsHorarioSinCambios,a.SalarioBrutoGravable,a.SubsidioEmpleoMensual,a.Isr,a.IsrRdl,a.Rdl,a.CantidadSubsidioEmpleoMensual,a.EsHorarioAnterior,a.EsHorarioAjustado,a.CostoEficienciaExcedente,a.CostoMaterialDidactico,a.CostoEficienciaJornada,a.CostoMaterialDidacticoExcedente,a.IdNominaTrabajadorEstatus,a.DiasFaltas,a.HorasFaltas,a.EsMedioRecibo,a.CicloEscolar,a.AjusteRealizado,a.MotivoAjuste,a.TotalDeducciones,a.IdMotivoDevolucion,a.SueldoTabular,a.PercepcionesAdicionales
,cl.IdTrabajador  
,tc.IdTipoCredito
,i.IdPlantillaNomina
,i.IdRelacionConvenioLaboral
,i.IdTipoNomina
,b.IdMesGeneracion
,vwh.IdModalidadEstudio
,b.IdQuincenaMes    
,TipoConcepto='D'
,SubTipoConcepto='CR'
,m.IdNominaTrabajadorEstatusGrupo
,m.EstatusNomina
,b.IdTipoCalculo
,ntc.TipoCalculo
,a.IdNominaTrabajador
,b.EsCerrada
,cn.IdNominaCreditoTrabajador as IdPercepcionDeducionCreditoPension
,la.IdClasificacionLaboral
,la.ClasificacionLaboral
,a.DiasIncapacidadImss
,a.DiasRetencion
,a.Obrero_RCV
,a.Obrero_IMSS
from Creditos_stNominaCreditoTrabajador cn
inner join Creditos_stCreditoTrabajador cr on cn.IdCreditoTrabajador=cr.IdCreditoTrabajador
inner join Catalogos_ctTipoCredito tc on tc.IdTipoCredito=cr.IdTipoCredito
inner join Catalogos_ctCreditosEmpresas emc on emc.IdCreditosEmpresas=tc.IdCreditosEmpresas
inner join Deducciones_ctDeduccion e on e.IdDeduccion=tc.IdDeduccion
inner join Nomina_stNominaTrabajador a on cn.IdNominaTrabajador=a.IdNominaTrabajador 
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Plazas_stDistribucionPlazaCategoria dp on ct.IdDistribucionPlazaCategoria=dp.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria ca on dp.IdCategoria=ca.IdCategoria
inner join Catalogos_ctClasificacionLaboral la on ca.IdClasificacionLaboral=la.IdClasificacionLaboral
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
inner join vwDatosAspirantesTrabajadoresHistorial vwH on vwH.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Nomina_ctTipoNomina tn on tn.IdTipoNomina=i.IdTipoNomina
inner join Catalogos_ctMes mg on mg.IdMes= b.IdMesGeneracion
 inner join Catalogos_ctQuincenaMes qm on qm.IdQuincenaMes=b.IdQuincenaMes 
inner join Catalogos_ctMes mp on mp.IdMes=qm.IdMes
inner join Nomina_ctTipoCalculo ntc on ntc.IdTipoCalculo=b.IdTipoCalculo
where a.IdNomina={idnomina.ToString()} {condicion} and EstatusNominaGrupo ='PARA PAGO'  and m.EstatusNomina <> 'CANCELADO' 
and b.FechaInicio BETWEEN '{FechaInicio.ToString("yyyyMMdd")}' AND '{FechaTermino.ToString("yyyyMMdd")}'
) as Universo  
";
            return query;
        }
        public List<Nomina_stNominaTrabajador> GetNominasTrabajador(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();

            var t = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(s =>
            s.Nomina_stNomina.EsCerrada==true && s.SueldoNeto>0 &&
            s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == id)
                .Include(a=> a.Nomina_stNominaTrabajadorEstatus)
                .ToList();
            return t;

        }

        public List<NominasCerradas> GetNominasCerradas(int id)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query;

            query = @"select c.Plantilla,b.Año,b.FechaInicio,b.FechaTermino,d.QuincenaMes+'-'+e.Mes as QuincenaMes,b.AliasNomina,a.IdConvenioLaboralTrabajadorCategoria,c.IdPeriodoNomina 
,x.IdTrabajador,b.IdNomina,a.DiasEfectivosLaborados,a.SueldoNeto
from Nomina_stNominaTrabajador a
                inner join Nomina_stNomina b on a.IdNomina = b.IdNomina
                inner join Nomina_ctPlantillaNomina c on b.IdPlantillaNomina= c.IdPlantillaNomina
                inner join Catalogos_ctQuincenaMes d on b.IdQuincenaMes=d.IdQuincenaMes
                inner join Catalogos_ctMes e on d.IdMes=e.IdMes
                inner join Convenios_stConvenioLaboralTrabajadorCategoria z on z.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                inner join Convenios_stConvenioLaboralTrabajador x on x.IdConvenioLaboralTrabajador=z.IdConvenioLaboralTrabajador
                inner join Nomina_stNominaTrabajadorEstatus h on h.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
                where x.IdTrabajador=" + id + " and b.EsCerrada=1 and h.EstatusNomina<>'CANCELADO'";

            var t = (List<NominasCerradas>)dp.connection.Query<NominasCerradas>(query);
            dp.Close();
            return t;

        }

        public Boolean QuitarCuentaCeroxxx(long id)
        {
            bool regresa = false;
            bdNovaEntities bd = new bdNovaEntities();

            var model = bd.Nomina_stNominaTrabajador.Find(id);

            
            //0 es normal para pago
            model.IdNominaTrabajadorEstatus = 0;
            model.IdMotivoDevolucion = null;

            try
            {

                bd.Entry(model).State = EntityState.Modified;
                bd.SaveChanges();
                regresa = true;
            }
            catch (Exception es)
            {

                regresa = false;
            }

            return regresa;

        }

        public Boolean QuitarCuentaCero(long id)
        {
            bool regresa = false;

            Nomina_stNominaTrabajador model;
            Nomina_stNominaTrabajadorEstatus estatus;
            using (var bd = new bdNovaEntities())
            {
                bd.Database.Connection.Open();
                model = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(s => s.IdNominaTrabajador == id).Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                estatus = bd.Nomina_stNominaTrabajadorEstatus.AsNoTracking().Where(a => a.EstatusNomina.Contains("NORMAL")).FirstOrDefault();


                bd.Database.Connection.Close();
            }


            TransactionOptions transactionoptions2 = new TransactionOptions();
            transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope2 = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
            {



                DapperQuery dp = new DapperQuery("bdNovaEntities");

                string condicion = $"     IdNomina={model.IdNomina.ToString()} and IdConvenioLaboralTrabajadorCategoria={model.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria}";


                dp.connection.Execute(@"update Nomina_stNominaTrabajador  set  IdMotivoDevolucion=null,IdNominaTrabajadorEstatus=" + estatus.IdNominaTrabajadorEstatus + " where " + condicion, null, null, 0, null);



              

                try
                {

                    //bd.Entry(model).State = EntityState.Modified;
                    //bd.SaveChanges();

                    //string updatesql = this.createSqlHistorial(condicion, model.IdNomina, model.Nomina_stNomina.FechaInicio, model.Nomina_stNomina.FechaTermino);
                    //dp.connection.Execute(updatesql, null, null, 0, null);

                    dp.connection.Execute(@"update Nomina_stNominaTrabajadorHistorial  set  IdMotivoDevolucion=null,IdNominaTrabajadorEstatus=" + estatus.IdNominaTrabajadorEstatus + ",EstatusNomina='" + estatus.EstatusNomina + "',IdNominaTrabajadorEstatusGrupo=" + estatus.IdNominaTrabajadorEstatusGrupo + " where " + condicion, null, null, 0, null);


                    regresa = true;
                }
                catch (Exception es)
                {

                    regresa = false;
                }
                scope2.Complete();
            }
            return regresa;

        }
        public Boolean Devoluciones(long id,int idm)
        { bool regresa = false;

            Nomina_stNominaTrabajador model;
            Nomina_stNominaTrabajadorEstatus estatus;
            using (var bd = new bdNovaEntities())
            {
                bd.Database.Connection.Open();
                  model = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(s=> s.IdNominaTrabajador== id).Include(q=> q.Convenios_stConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                 estatus = bd.Nomina_stNominaTrabajadorEstatus.AsNoTracking().Where(a => a.EstatusNomina.Contains("CUENTA CERO")).FirstOrDefault();


                bd.Database.Connection.Close();
            }

          
            TransactionOptions transactionoptions2 = new TransactionOptions();
            transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope2 = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
            {
               
               

                DapperQuery dp = new DapperQuery("bdNovaEntities");

                string condicion = $"     IdNomina={model.IdNomina.ToString()} and IdConvenioLaboralTrabajadorCategoria={model.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria}";


                var x= dp.connection.Execute(@"update Nomina_stNominaTrabajador  set  IdMotivoDevolucion="+idm+",IdNominaTrabajadorEstatus=" + estatus.IdNominaTrabajadorEstatus + " where " + condicion, null, null, 0, null);


              
               

                try
                {

                    //bd.Entry(model).State = EntityState.Modified;
                    //bd.SaveChanges();

                    //string updatesql = this.createSqlHistorial(condicion, model.IdNomina, model.Nomina_stNomina.FechaInicio, model.Nomina_stNomina.FechaTermino);
                    //dp.connection.Execute(updatesql, null, null, 0, null);

                  var s=  dp.connection.Execute(@"update Nomina_stNominaTrabajadorHistorial  set IdMotivoDevolucion="+idm+",IdNominaTrabajadorEstatus=" + estatus.IdNominaTrabajadorEstatus + ",EstatusNomina='" + estatus.EstatusNomina + "',IdNominaTrabajadorEstatusGrupo=" + estatus.IdNominaTrabajadorEstatusGrupo +" where "+ condicion, null, null, 0, null);


                    regresa = true;
                }
                catch (Exception es)
                {

                    regresa = false;
                }
                scope2.Complete();
            }
            return regresa;
        
        }

        public Boolean CambiarCuentaCeroaDevolucion(long id)
        {
            bool regresa = false;

            Nomina_stNominaTrabajador model;
            Nomina_stNominaTrabajadorEstatus estatus;
            using (var bd = new bdNovaEntities())
            {
                bd.Database.Connection.Open();
                model = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(s => s.IdNominaTrabajador == id).Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                estatus = bd.Nomina_stNominaTrabajadorEstatus.AsNoTracking().Where(a => a.EstatusNomina.Contains("DEVOLUCION COMPLETA")).FirstOrDefault();


                bd.Database.Connection.Close();
            }


            TransactionOptions transactionoptions2 = new TransactionOptions();
            transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope2 = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
            {



                DapperQuery dp = new DapperQuery("bdNovaEntities");

                string condicion = $"     IdNomina={model.IdNomina.ToString()} and IdConvenioLaboralTrabajadorCategoria={model.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria}";


                dp.connection.Execute(@"update Nomina_stNominaTrabajador  set  IdNominaTrabajadorEstatus=" + estatus.IdNominaTrabajadorEstatus + " where " + condicion, null, null, 0, null);



 

                try
                {

                    //bd.Entry(model).State = EntityState.Modified;
                    //bd.SaveChanges();

                    //string updatesql = this.createSqlHistorial(condicion, model.IdNomina, model.Nomina_stNomina.FechaInicio, model.Nomina_stNomina.FechaTermino);
                    //dp.connection.Execute(updatesql, null, null, 0, null);

                    dp.connection.Execute(@"update Nomina_stNominaTrabajadorHistorial  set IdNominaTrabajadorEstatus=" + estatus.IdNominaTrabajadorEstatus + ",EstatusNomina='" + estatus.EstatusNomina + "',IdNominaTrabajadorEstatusGrupo=" + estatus.IdNominaTrabajadorEstatusGrupo + " where " + condicion, null, null, 0, null);


                    regresa = true;
                }
                catch (Exception es)
                {

                    regresa = false;
                }
                scope2.Complete();
            }
            return regresa;

        }

        public List<Nomina_stNominaTrabajador> GetRecalculos(int id)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            bdNovaEntities bd = new bdNovaEntities();

            var t = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(a => a.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == id && a.Nomina_stNominaTrabajadorEstatus.EstatusNomina=="CANCELADO").ToList();
            //string query;

            //query = @"select a.IdDeduccionesPersonalizadas,b.Deduccion,a.FechaInicioDeduccion as FechaInicio,a.FechaTermino,a.Importe,c.PeriodoNomina,a.Observacion from Deducciones_stDeduccionesPersonalizadas a
            //inner join Deducciones_ctDeduccion b on a.IdDeduccion=b.IdDeduccion
            //inner join Catalogos_ctPeriodoNomina c on a.IdPeriodoNomina=c.IdPeriodoNomina
            //where a.IdConvenioLaboralTrabajadorCategoria=" + idcltc + " and a.EsDescuento=1 ";

            //var t = (List<Descuento>)dp.connection.Query<Descuento>(query);
            //dp.Close();
            return t;

        }
    }
}