﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public partial class Portal_Articulos : validacionModelos
    {
        public override ResultadoValidacion ValidaModelo(string ext)
        {
            string[] formatos = new string[] { "jpg", "jpeg", "bmp", "png", "gif" };

            if (Array.IndexOf(formatos, ext) < 0)
            {
                parenresult.Mensaje = "La extension de archivo no es aceptada";
                parenresult.IsValid = false;
            }
            return parenresult;
        }


        private static Image RedimensionarImagen(Stream stream)
        {
            Image img = Image.FromStream(stream);

            int h = img.Height;
            int w = img.Width;
            int newH, newW;
            newH = 58;
            newW = 60;

            if (h != newH && w != newW)
            {
                Bitmap newImg = new Bitmap(img, newW, newH);
                Graphics g = Graphics.FromImage(newImg);
                g.InterpolationMode =
                  System.Drawing.Drawing2D.InterpolationMode.HighQualityBilinear;
                g.DrawImage(img, 0, 0, newImg.Width, newImg.Height);
                return newImg;
            }
            else
                return img;
        }

        public ResultadoValidacion EliminarImage(string path)
        {
            if (File.Exists(path))
            {
                File.Delete(path);
                parenresult.IsValid = true;
            }
            else { parenresult.IsValid = false; }

            return parenresult;
        }

    }
}