﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public partial class Portal_ArticulosAnexos : validacionModelos
    {
        public override ResultadoValidacion ValidaModelo(String ext)
        {
            string[] formatos = new string[] { "pdf", "doc", "docx", "xls", "xlsx", "rar" };

            if (Array.IndexOf(formatos, ext) < 0)
            {
                parenresult.Mensaje = "La extension de archivo no es aceptada";
                parenresult.IsValid = false;
            }
            return parenresult;
        }

        public ResultadoValidacion ValidarArchivo(string path)
        {
            if (File.Exists(path))
            {
                parenresult.Mensaje = "Ya existe un archivo con el mismo nombre";
                parenresult.IsValid = false;
            }
            return parenresult;
        }
        public ResultadoValidacion ValidarBorrar(string path)
        {
            if (File.Exists(path))
            {
                File.Delete(path);
            }
            else
            {
                parenresult.Mensaje = "Error al cambiar el archivo";
                parenresult.IsValid = false;
            }

            return parenresult;
        }
    }
}