﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;
using Nova.Libraries;

namespace Nova.Models
{
    public class PortalNovaAries
    {

        //get team
        public static List<vwDatosAspirantesTrabajadores> getDirectorio()
        {
            TeamSingleton cuadro = TeamSingleton.Instance;
            return cuadro.directivos;

        }

        public static List<Catalogos_ctEstructuraOrganica> ObtenerListaPlateles()
        {
            bdNovaEntities bd = new bdNovaEntities();


            // Consulta para obtener las estructuras organizativas vigentes que contienen las cadenas específicas.
            //var lista = bd.Catalogos_ctEstructuraOrganica
            //    .Where(t => t.EsVigente == true && (t.EstructuraOrganica.Contains("PLANTEL NÚM") || t.EstructuraOrganica.Contains("EMSAD NÚM")))
            //    .OrderBy(t => t.IdEstructuraOrganica) // Ordena si es necesario
            //    .ToList();
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"SELECT a.*
                                FROM bdNova.dbo.Catalogos_ctEstructuraOrganica a
                                INNER JOIN bdCentrosEducativos.dbo.ptCentrosEducativos b 
                                ON b.IdCampus = a.IdCampusEquivalencia
                                WHERE b.vigente = 1
                                ORDER BY b.IdTipoCentro, b.Numero";

            List<Catalogos_ctEstructuraOrganica> lista = new List<Catalogos_ctEstructuraOrganica>();

            lista = (List<Catalogos_ctEstructuraOrganica>)dp.connection.Query<Catalogos_ctEstructuraOrganica>(query);


            dp.Close();

            return lista;


        }


        public static List<Catalogos_ctEstructuraOrganica> ObtenerEstructura()
        {
            bdNovaEntities bd = new bdNovaEntities();


            // Consulta para obtener las estructuras organizativas vigentes que contienen las cadenas específicas.
            //var lista = bd.Catalogos_ctEstructuraOrganica
            //    .Where(t => t.EsVigente == true && (t.EstructuraOrganica.Contains("PLANTEL NÚM") || t.EstructuraOrganica.Contains("EMSAD NÚM")))
            //    .OrderBy(t => t.IdEstructuraOrganica) // Ordena si es necesario
            //    .ToList();
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"      SELECT*
                                FROM bdNova.dbo.Catalogos_ctEstructuraOrganica


                                WHERE EsVigente = 1
                                ORDER BY  IDEstructuraOrganica";

            List<Catalogos_ctEstructuraOrganica> lista = new List<Catalogos_ctEstructuraOrganica>();

            lista = (List<Catalogos_ctEstructuraOrganica>)dp.connection.Query<Catalogos_ctEstructuraOrganica>(query);


            dp.Close();

            return lista;


        }
        public static List<Kardex_ctDatosPersonalesFotografias> getDirectorioFotos()
        {
            TeamSingleton cuadrofotos = TeamSingleton.Instance;
            return cuadrofotos.directivosfotos;

        }

        public static List<Cinedebates_ctPeliculas> getPeliculas()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Cinedebates_ctPeliculas.OrderBy(c => c.IdPelicula).ToList();

        }
        


        //get honore cuadre of all studens
        public static List<Portal_AlumnosDestacados> getHonoresAlumnos()
        {
            bdAriesEntities bds = new bdAriesEntities();

            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query = @"select top 10 a.curp,
                                MAX(a.idcicloescolar) idcicloescolar

                                ,MAX(b.Nombre) Nombre,MAX(b.ApPaterno) ApPaterno
                                ,MAX(b.ApMaterno) ApMaterno
                                ,MAX(a.IdCampus) IdCampus
                                --,truncate (AVG(calificacion) calificacion,2)
                                ,round(AVG(calificacion), 2, 1)calificacion
                                ,MAX(a.IdValorCiclo) IdValorCiclo
                                 from Acreditacion_stAlumnosCalificacionGrado  a
                                 inner join ctAlumnos b on a.Curp=b.Curp and a.Matricula=b.Matricula
                                where a.IdValorCiclo in (1,2,3,4,5,6) and calificacion > 9
                                group by a.Curp
                                order by 2 desc ,8 desc, 7 desc,4 asc";

            List<Portal_AlumnosDestacados> alumnos = new List<Portal_AlumnosDestacados>();

            alumnos = (List<Portal_AlumnosDestacados>)dp.connection.Query<Portal_AlumnosDestacados>(query);



            //var alumnos = bds.Acreditacion_stAlumnosCalificacionGrado.Where(f =>
            //                                                                f.ctAlumnos.ctStatusAlumno.ctStatusAlumnoGrupal.Nombre.Equals("ALTAS")).OrderByDescending(d=> d.IdCicloEscolar)
            //                                                       .GroupBy(g => new { g.Curp })
            //                                                       .Select(j => new
            //                                                       {
            //                                                           Curp = j.Key.Curp
            //                                                           ,
            //                                                           Nombre = j.Max(x => x.ctAlumnos.Nombre)
            //                                                           ,
            //                                                           ApPaterno = j.Max(x => x.ctAlumnos.ApPaterno)
            //                                                           ,
            //                                                           ApMaterno = j.Max(x => x.ctAlumnos.ApMaterno)
            //                                                           ,
            //                                                           Calificacion = j.Average(x => x.Calificacion)
            //                                                           ,
            //                                                           CampusId = j.Max(x => x.ctAlumnos.IdCampus)
            //                                                       }).OrderByDescending(x => x.Calificacion ).Take(10);

            List<Portal_AlumnosDestacados> parts = new List<Portal_AlumnosDestacados>();
            
            foreach(var item in alumnos){
                
                    parts.Add(new Portal_AlumnosDestacados() { Curp = item.Curp, Nombre = item.Nombre, ApPaterno = item.ApPaterno, ApMaterno = item.ApMaterno, Calificacion = Math.Round(item.Calificacion,2), CampusId = item.CampusId });
                
                
            }
            parts = parts.OrderBy(x => x.ApPaterno).ToList();

            return parts;
        }


        //get fotogram of one student
        public static byte[] getFotografiaDirectivos(string Id)
        {
            //            bdAriesEntities bd = new bdAriesEntities();

            //            DapperQuery dp = new DapperQuery("bdAriesEntities");
            //            string query;
            byte[] w = null;
            //             query = @"SELECT curp,foto,TipoImagen,Qrcodigo FROM stAlumnosFotos 
            //where  Curp='" + Id.ToString() + "' ";
            int idkardex = Nova.Libraries.ConvertToInt.ConvertToInt32(Id);
            TeamSingleton cuadro = TeamSingleton.Instance;
            TeamSingleton cuadrofotos = TeamSingleton.Instance;

            vwDatosAspirantesTrabajadores ultimo = cuadro.directivos.Where(x => x.IdKardex == idkardex).FirstOrDefault();

            Kardex_ctDatosPersonalesFotografias ultimo2 = cuadrofotos.directivosfotos.Where(x => x.IdKardex == idkardex).FirstOrDefault();

            if (ultimo2 != null)
            {
                w = ultimo2.Fotografia;
                
            }




            return w;
        }

        //get fotogram of one student
        public static byte[] getFotografia(string Id, ref string tipo, List<stAlumnosFotos> bdfotos)
        {
//            bdAriesEntities bd = new bdAriesEntities();
            
//            DapperQuery dp = new DapperQuery("bdAriesEntities");
//            string query;
             byte[] w=null;
//             query = @"SELECT curp,foto,TipoImagen,Qrcodigo FROM stAlumnosFotos 
//where  Curp='" + Id.ToString() + "' ";
            stAlumnosFotos ultimo = bdfotos.Where(x => x.Curp == Id).FirstOrDefault();
            
            if (ultimo!=null)
            {
                w = ultimo.Foto;
                tipo = ultimo.TipoImagen;
            }


            
            
            return w;
        }
        //get type fotogram
        public static string getTipoFotografia(string Id)
        {
            bdAriesEntities bd = new bdAriesEntities();
            string t = bd.stAlumnosFotos.Where(a => a.Curp == Id).Select(f => f.TipoImagen).SingleOrDefault();
            return t;
        }
        //get all educative center
        public static List<Catalogos_ctEstructuraOrganica> getCentrosAlumnos()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Catalogos_ctEstructuraOrganica.Where(c => c.IdCampusEquivalencia != null).ToList();
        }

        //obtener los centros educativos, para mostrar en oferta educativa
        public static List<Catalogos_ctEstructuraOrganica> getCentrosEducativos()
        {
            bdNovaEntities bd = new bdNovaEntities();
            
            return bd.Catalogos_ctEstructuraOrganica.Where(c => 
                                                            c.EsVigente==true &&                                             
                                                            c.EstructuraOrganica.Contains("PLANTEL N") ||
                                                            c.EstructuraOrganica.Contains("EMSAD N")&&
                                                            c.IdCampusEquivalencia != null
                                                            ).ToList();
        }
        public static List<Catalogos_ctEstructuraOrganica> getCentrosEducativosPlantel()
        {
            bdNovaEntities bd = new bdNovaEntities();

            var planteles = from a in bd.Catalogos_ctEstructuraOrganica
                            from b in bd.vwCampus
                            where a.IdCampusEquivalencia == b.IdCampus && a.EsVigente == true
                            select a.EstructuraOrganica;

            List<Catalogos_ctEstructuraOrganica> listaplanteles = bd.Catalogos_ctEstructuraOrganica.Where(f => planteles.Contains(f.EstructuraOrganica) && f.EstructuraOrganica.Contains("PLANTEL N") && f.IdCampusEquivalencia != null).ToList();

            return listaplanteles;


        }

        public static List<PortalArchivos> getNombresArticulo70()
        {
            bdNovaEntities bd = new bdNovaEntities();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"select max (c.NombrePortalCatalogoDocumento) as NombrePortalCatalogoDocumento , max (b.PortalCatalogoApartado) as PortalCatalogoApartado, 
                                max (d.IdFraccionDocumento) as IdFraccionDocumento,
                                d.NombreFraccionDocumento, max(a.Año) as Año, max(f.NombreTrimestre) as NombreTrimestre, max(f.Numero) as Numero from Portal_DatosDocumentoWeb a
                                inner join Portal_CatalogoApartado b on a.IdPortalCatalogoApartado = b.IdPortalCatalogoApartado
                                inner join Portal_CatalogoDocumento c on b.IdPortalCatalogoDocumento = c.IdPortalCatalogoDocumento
                                inner join Portal_FraccionDocumento d on a.IdFraccionDocumento = d.IdFraccionDocumento
                                inner join Portal_TrimestreDocumentoWeb f on a.IdTrimesteDocumentoWeb=f.IdTrimesteDocumentoWeb
                                group by  d.NombreFraccionDocumento
                                order by  IdFraccionDocumento";



            List<PortalArchivos> listadocumentos = new List<PortalArchivos>();

            listadocumentos = (List<PortalArchivos>)dp.connection.Query<PortalArchivos>(query);

            return listadocumentos;


        }
        public static List<PortalArchivos> getNombresIncisos70()
        {
            bdNovaEntities bd = new bdNovaEntities();

            DapperQuery dp = new DapperQuery("bdNovaEntities");


            string query = @"select max (c.NombrePortalCatalogoDocumento) as NombrePortalCatalogoDocumento , max (b.PortalCatalogoApartado) as PortalCatalogoApartado, 
                                max (d.IdFraccionDocumento) as IdFraccionDocumento, g.NombreIncisoDocumento,
                                d.NombreFraccionDocumento, max(a.Año) as Año, max(f.NombreTrimestre) as NombreTrimestre, max(f.Numero) as Numero 
								,max (a.IdDatosDocumentoWeb) as IdDatosDocumentoWeb
								from Portal_DatosDocumentoWeb a
                                inner join Portal_CatalogoApartado b on a.IdPortalCatalogoApartado = b.IdPortalCatalogoApartado
                                inner join Portal_CatalogoDocumento c on b.IdPortalCatalogoDocumento = c.IdPortalCatalogoDocumento
                                inner join Portal_FraccionDocumento d on a.IdFraccionDocumento = d.IdFraccionDocumento
                                inner join Portal_TrimestreDocumentoWeb f on a.IdTrimesteDocumentoWeb=f.IdTrimesteDocumentoWeb
								left join  Portal_IncisoFraccionDocumento g on d.IdIncisoFraccionDocumento = g.IdIncisoFraccionDocumento
                                group by  g.NombreIncisoDocumento, d.NombreFraccionDocumento";

            List<PortalArchivos> listadocumentos = new List<PortalArchivos>();

            listadocumentos = (List<PortalArchivos>)dp.connection.Query<PortalArchivos>(query);

            return listadocumentos;


        }
        public static List<PortalArchivos> getArchivosArticulo70()
        {
            bdNovaEntities bd = new bdNovaEntities();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"select c.NombrePortalCatalogoDocumento,b.PortalCatalogoApartado,d.IdFraccionDocumento, d.NombreFraccionDocumento, a.NombreDocumentoWeb, a.Año,a.Orden,f.NombreTrimestre,f.Numero,g.IdDatosDocumentoWeb,g.NombreArchivo,g.Archivo,g.TipoDocumento from Portal_DatosDocumentoWeb a
                                inner join Portal_CatalogoApartado b on a.IdPortalCatalogoApartado = b.IdPortalCatalogoApartado
                                inner join Portal_CatalogoDocumento c on b.IdPortalCatalogoDocumento = c.IdPortalCatalogoDocumento
                                inner join Portal_FraccionDocumento d on a.IdFraccionDocumento = d.IdFraccionDocumento
                                inner join Portal_TrimestreDocumentoWeb f on a.IdTrimesteDocumentoWeb=f.IdTrimesteDocumentoWeb
                                inner join bdNovaDocumentacion.dbo.Portal_DocumentosWeb g on a.IdDatosDocumentoWeb=g.IdDatosDocumentoWeb";

            List<PortalArchivos> listaarchivosdocumentos = new List<PortalArchivos>();

            listaarchivosdocumentos = (List<PortalArchivos>)dp.connection.Query<PortalArchivos>(query);

            return listaarchivosdocumentos;


        }


      


        public static List<Portal_CampusPlanesEm> getCarrerasEm()
        {



            bdAriesEntities bd = new bdAriesEntities();
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query = @"select a.IdCampus,max(d.NombreLargo) CentroEducativo
                                ,b.IdPlanEstudio,b.Descripcion as Nombre
                                ,max(c.IdCarrera) as IdCarrera,max( b.Icono) as Icono
                                 from stCampusPlanes a
                                inner join ctPlanEstudio b on a.IdPlanEstudio=b.IdPlanEstudio
                                inner join ctCarrera c on b.IdCarrera=c.IdCarrera
                                inner join ctCampus d on a.IdCampus=d.IdCampus
                                where a.Vigente=1 and b.IdModalidadEstudio=2
                                group by a.IdCampus,b.IdPlanEstudio,b.Descripcion
                                order by a.IdCampus,B.Descripcion";

            List<Portal_CampusPlanesEm> planes = new List<Portal_CampusPlanesEm>();

            planes = (List<Portal_CampusPlanesEm>)dp.connection.Query<Portal_CampusPlanesEm>(query);
            return planes;
        }

        public static List<ListaEmsads> getCarrerasEmsad()
        {
            bdAriesEntities bd = new bdAriesEntities();
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query = @"select b.IdPlanEstudio
                                ,upper(b.Descripcion) Carrera
                                ,max(c.PerfilEgresado)PerfilEgresado,max(AmbitoLaboral)AmbitoLaboral 
                                ,max(b.FormacionParaTrabajo)FormacionParaTrabajo
                                ,max (b.Icono)Icono
                                from stCampusPlanes a
                                inner join ctPlanEstudio b on a.IdPlanEstudio=b.IdPlanEstudio
                                inner join ctCarrera c on b.IdCarrera=c.IdCarrera
                                where a.Vigente=1 and b.IdModalidadEstudio=2
                                group by b.IdPlanEstudio,b.Descripcion";

            List<ListaEmsads> listaarchivosdocumentos = new List<ListaEmsads>();

            listaarchivosdocumentos = (List<ListaEmsads>)dp.connection.Query<ListaEmsads>(query);

            return listaarchivosdocumentos;
            // return bd.ctCarrera.Where(t => t.Justificacion != null && t.Justificacion != "").OrderBy(o => o.Nombre).ToList();
        }
        public static List<ListaEmsads> getCarrerasEmsadId(Int32 id)
        {
            bdAriesEntities bd = new bdAriesEntities();
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query = @"select b.IdPlanEstudio,max (c.IdCarrera) IdCarrera
                                ,upper(b.Descripcion) Carrera
                                ,max(c.PerfilEgresado)PerfilEgresado,max(AmbitoLaboral)AmbitoLaboral 
                                ,max(b.FormacionParaTrabajo)FormacionParaTrabajo
                                ,max (b.Icono)Icono
                                from stCampusPlanes a
                                inner join ctPlanEstudio b on a.IdPlanEstudio=b.IdPlanEstudio
                                inner join ctCarrera c on b.IdCarrera=c.IdCarrera
                                where a.Vigente=1 and b.IdModalidadEstudio=2
                                group by b.IdPlanEstudio,b.Descripcion";

            List<ListaEmsads> listaarchivosdocumentos = new List<ListaEmsads>();

            listaarchivosdocumentos = (List<ListaEmsads>)dp.connection.Query<ListaEmsads>(query);

            return listaarchivosdocumentos.Where(z => z.IdPlanEstudio == id).ToList();
            // return bd.ctCarrera.Where(t => t.Justificacion != null && t.Justificacion != "").OrderBy(o => o.Nombre).ToList();
        }

        public static List<Catalogos_ctEstructuraOrganica> getCentrosEducativosEmsad()
        {
            bdNovaEntities bd = new bdNovaEntities();


            var centroemsad = from a in bd.Catalogos_ctEstructuraOrganica
                              from b in bd.vwCampus
                              where a.IdCampusEquivalencia == b.IdCampus && a.EsVigente == true
                              select a.EstructuraOrganica;

            List<Catalogos_ctEstructuraOrganica> listaemsad = bd.Catalogos_ctEstructuraOrganica.Where(f => centroemsad.Contains(f.EstructuraOrganica) && f.EstructuraOrganica.Contains("EMSAD N") && f.IdCampusEquivalencia != null).ToList();

            return listaemsad;


        }
   

        //obtener las carreras tecnicas de los campos o centros educativos
        public static List<Portal_CampusPlanes> getCarrerasTecnicasCampus()
        {
 
            bdAriesEntities bd = new bdAriesEntities();

            var carreras = from a in bd.stCampusPlanes
                           from b in bd.ctPlanEstudio
                           from c in bd.ctStatusPlan
                           from d in bd.ctCarrera
                           where
                            a.Vigente == true &&
                          ( a.IdPlanEstudio == b.IdPlanEstudio &&
                           b.IdStatusPlan == c.IdStatusPlan &&
                           b.IdCarrera == d.IdCarrera &&
                           c.Nombre.Equals("VIGENTE")) 
                          
                           group new { d, b, a } by new {d.Nombre, b.IdCarrera, a.IdCampus, d.Icono, a.Vigente} into grupo
                           select grupo.Key;

            List<Portal_CampusPlanes> planes = new List<Portal_CampusPlanes>();

            foreach (var item in carreras)
            {
                
                    planes.Add(new Portal_CampusPlanes() { Nombre = item.Nombre, IdCarrera = item.IdCarrera, IdCampus = item.IdCampus, Icono = item.Icono });
                
            }
            return planes;
        }


        //get team for view oferta educativa
        public static List<Convenios_stConvenioLaboralTrabajadorCategoria> getDirectoresShow()
        {
            bdNovaEntities bd = new bdNovaEntities();
            var plazas=bd.Plazas_stDistribucionPlazaCategoria.Where(w=>w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" A \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" B \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" C \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "DIRECTOR \"A\"" ||
                                                               w.Plazas_ctCategoria.Categoria == "DIRECTOR \"B\"" ||
                                                               w.Plazas_ctCategoria.Categoria == "DIRECTOR \"C\"").Select(v=> v.IdDistribucionPlazaCategoria).ToArray();


            List<Convenios_stConvenioLaboralTrabajadorCategoria> model = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => plazas.Contains(f.IdDistribucionPlazaCategoria)).ToList();
              
            return  model;
        }

        //obtener las carreras tecnicas con planes de estudio vigente
        public static List<ctCarrera> getCarrerasTecnicas()
        {
            bdAriesEntities bd = new bdAriesEntities();
            return bd.ctCarrera.Where(t=>t.Justificacion != null && t.Justificacion != "").OrderBy(o=>o.Nombre).ToList();
        }
        //obtener el nombre del director vigente

        public static string getNombreDirector()
        {
            bdNovaEntities bd = new bdNovaEntities();
            string t = bd.vwDatosAspirantesTrabajadores.Where(z => z.Categoria == "DIRECTOR GENERAL" && z.EstatusTrabajador == "ALTA").Select(b => b.Nombre + " " + b.ApellidoPaterno + " " + b.ApellidoMaterno).SingleOrDefault();
            return t;
        }
        //obtener las carreras técnias con el id
        public static List<ctCarrera> getCarrerasId(Int32 id)
        {
            bdAriesEntities bd = new bdAriesEntities();
            return bd.ctCarrera.Where(t => t.Justificacion != null && t.Justificacion != "" && t.IdCarrera == id).ToList();
        }

        public static List<PlanesEstudio> getPlanesId(Int32 id)
        {
            bdAriesEntities bd = new bdAriesEntities();
            bdAriesEntities bdAries = new bdAriesEntities();
            List<PlanesEstudio> planes = new List<PlanesEstudio>();
            Int32 planVigente = bdAries.ctPlanEstudio.Where(t => t.IdStatusPlan == t.ctStatusPlan.IdStatusPlan && t.ctStatusPlan.Nombre == "VIGENTE" && t.IdCarrera == id).OrderByDescending(o => o.IdPlanEstudio).Select(s => s.IdPlanEstudio).FirstOrDefault();
            var details = bdAries.stPlanEstudioAsignatura.Where(t => t.IdAsignatura == t.ctAsignatura.IdAsignatura && t.IdPlanEstudio == planVigente).OrderBy(o => new { o.IdValorCiclo, o.Orden }).ToList();

            foreach (var item in details)
            {
                PlanesEstudio lista = new PlanesEstudio();
                lista.IdValorCiclo = item.IdValorCiclo;
                lista.Orden = Convert.ToInt32(item.Orden);
                lista.ClaveAsignatura = item.ClaveAsignatura;
                lista.IdAsignatura = item.ctAsignatura.IdAsignatura;
                lista.Nombre = item.ctAsignatura.Nombre;
                lista.Creditos = item.ctAsignatura.Creditos;
                lista.Componente = item.ctAsignatura.ctTipoComponente.Nombre;
                planes.Add(lista);
            }

            return planes.ToList();
        }

        public static List<PlanesEstudio> getPlanesEmId(Int32 id)
        {
            bdAriesEntities bd = new bdAriesEntities();
            bdAriesEntities bdAries = new bdAriesEntities();
            List<PlanesEstudio> planes = new List<PlanesEstudio>();

            var details = bdAries.stPlanEstudioAsignatura.Where(t => t.IdAsignatura == t.ctAsignatura.IdAsignatura && t.IdPlanEstudio == id).OrderBy(o => new { o.IdValorCiclo, o.Orden }).ToList();

            foreach (var item in details)
            {
                PlanesEstudio lista = new PlanesEstudio();
                lista.IdValorCiclo = item.IdValorCiclo;
                lista.Orden = Convert.ToInt32(item.Orden);
                lista.ClaveAsignatura = item.ClaveAsignatura;
                lista.IdAsignatura = item.ctAsignatura.IdAsignatura;
                lista.Nombre = item.ctAsignatura.Nombre;
                lista.Creditos = item.ctAsignatura.Creditos;
                lista.Componente = item.ctAsignatura.ctTipoComponente.Nombre;
                planes.Add(lista);
            }

            return planes.ToList();
        }
        //get alumnos inscritos en el cecyte
        public static Int32 getAlumnosAltas()
        {
            bdAriesEntities bd = new bdAriesEntities();
            
            Int32 num = bd.ctAlumnos.Where(t => t.ctStatusAlumno.IdStatusAlumno == t.IdStatusAlumno && t.ctStatusAlumno.ctStatusAlumnoGrupal.IdStatusAlumnoGrupal == t.ctStatusAlumno.IdStatusAlumnoGrupal && t.ctStatusAlumno.ctStatusAlumnoGrupal.Nombre == "ALTAS").Count();
            return num;
                
        }

        public static Int32 getAlumnosPlantel(int cen)
        {
            bdAriesEntities bd = new bdAriesEntities();
            bdNovaEntities bd2 = new bdNovaEntities();
            var planes = bd.ctPlanEstudio.Where(t => t.IdModalidadEstudio == t.ctModalidadEstudio.IdModalidadEstudio && t.ctModalidadEstudio.Nombre == "PLANTEL").Select(b => b.IdPlanEstudio);
            var centro = bd2.vwCampus.Where(a => a.IdCampus == cen).Select(u => u.IdCampus);
            int total= bd.ctAlumnos.Where(t => planes.Contains(t.IdPlanEstudio) && t.IdCampus == cen && t.ctStatusAlumno.IdStatusAlumno == t.IdStatusAlumno && t.ctStatusAlumno.ctStatusAlumnoGrupal.IdStatusAlumnoGrupal == t.ctStatusAlumno.IdStatusAlumnoGrupal && t.ctStatusAlumno.ctStatusAlumnoGrupal.Nombre == "ALTAS"

                ).Count();
            return (total < 0) ? 0 : total;
        }

        public static Int32 getAlumnosEmsad(int cen3)
        {
            bdAriesEntities bd = new bdAriesEntities();
            var planes = bd.ctPlanEstudio.Where(t => t.IdModalidadEstudio == t.ctModalidadEstudio.IdModalidadEstudio && t.ctModalidadEstudio.Nombre == "EMSAD").Select(b => b.IdPlanEstudio);
            int total= bd.ctAlumnos.Where(t => planes.Contains(t.IdPlanEstudio) && t.IdCampus == cen3 && t.ctStatusAlumno.IdStatusAlumno == t.IdStatusAlumno && t.ctStatusAlumno.ctStatusAlumnoGrupal.IdStatusAlumnoGrupal == t.ctStatusAlumno.IdStatusAlumnoGrupal && t.ctStatusAlumno.ctStatusAlumnoGrupal.Nombre == "ALTAS"

                ).Count();
            return (total<0)?0:total;
        }

        public static int getAlumnosEgresadoEmsad(int cen4)
        {

            bdAriesEntities bd = new bdAriesEntities();
            var planes = bd.ctPlanEstudio.Where(t => t.IdModalidadEstudio == t.ctModalidadEstudio.IdModalidadEstudio && t.ctModalidadEstudio.Nombre == "EMSAD").Select(b => b.IdPlanEstudio);
            DateTime cicloanterior = new DateTime(DateTime.Now.Date.Year - 1, 01, 01);
            DateTime cicloactual = new DateTime(DateTime.Now.Year, 01, 01);
            var ciclo = bd.stCicloEscolar.Where(g => g.Inicio >= cicloanterior && g.Termino <= cicloactual).Select(b => b.IdCicloEscolar);
            return bd.ctAlumnos.Where(t => planes.Contains(t.IdPlanEstudio) && t.IdCampus == cen4 && ciclo.Contains(t.IdCicloEscolar) && t.ctStatusAlumno.IdStatusAlumnoGrupal == t.ctStatusAlumno.ctStatusAlumnoGrupal.IdStatusAlumnoGrupal &&
                t.ctStatusAlumno.ctStatusAlumnoGrupal.Nombre == "EGRESADOS").Count();
        }

        public static int getAlumnosEgresadoPlantel(int cen2)
        {

            bdAriesEntities bd = new bdAriesEntities();
            var planes = bd.ctPlanEstudio.Where(t => t.IdModalidadEstudio == t.ctModalidadEstudio.IdModalidadEstudio && t.ctModalidadEstudio.Nombre == "PLANTEL").Select(b => b.IdPlanEstudio);
            DateTime cicloanterior = new DateTime(DateTime.Now.Date.Year - 1, 01, 01);
            DateTime cicloactual = new DateTime(DateTime.Now.Year, 01, 01);
            var ciclo = bd.stCicloEscolar.Where(g => g.Inicio >= cicloanterior && g.Termino <= cicloactual).Select(b => b.IdCicloEscolar);
            return bd.ctAlumnos.Where(t => planes.Contains(t.IdPlanEstudio) && t.IdCampus == cen2 && ciclo.Contains(t.IdCicloEscolar) && t.ctStatusAlumno.IdStatusAlumnoGrupal == t.ctStatusAlumno.ctStatusAlumnoGrupal.IdStatusAlumnoGrupal &&
                t.ctStatusAlumno.ctStatusAlumnoGrupal.Nombre == "EGRESADOS").Count();
        }
        public static int getAlumnnosEgresados()
        {
            bdAriesEntities bd = new bdAriesEntities();

            DateTime cicloanterior = new DateTime(DateTime.Now.Date.Year - 1, 01, 01);
            DateTime cicloactual = new DateTime(DateTime.Now.Year, 01, 01);
            var ciclo = bd.stCicloEscolar.Where(g => g.Inicio >= cicloanterior && g.Termino <= cicloactual).Select(b => b.IdCicloEscolar);
            return bd.ctAlumnos.Where(t => ciclo.Contains(t.IdCicloEscolar) && t.ctStatusAlumno.IdStatusAlumnoGrupal == t.ctStatusAlumno.ctStatusAlumnoGrupal.IdStatusAlumnoGrupal &&
                t.ctStatusAlumno.ctStatusAlumnoGrupal.Nombre == "EGRESADOS").Count();

        }


        //=========================================================================================================================
        //==========================================*   LOS    *===================================================================
        //==========================================*  MÉTODOS *===================================================================
        //==========================================*   PARA   *===================================================================
        //==========================================* BUSQUEDA *===================================================================
        //=========================================================================================================================


        //get la  busqueda de las carreras tecnicas
        public static List<ctCarrera> getOfertaEductivaSearch(string search)
        {
            bdAriesEntities bd = new bdAriesEntities();
            return bd.ctCarrera.Where(t => (t.ctPlanEstudio.FirstOrDefault().ctStatusPlan.Nombre == "VIGENTE") &&
                                    (
                                            t.Nombre.Contains(search) ||
                                            t.Descripcion.Contains(search) ||
                                            t.Justificacion.Contains(search) ||
                                            t.PerfilEgresado.Contains(search) ||
                                            t.AmbitoLaboral.Contains(search)
                                      )
                                 ).OrderByDescending(o => o.ctPlanEstudio.FirstOrDefault().IdPlanEstudio)
                                .ToList();

        }


        //get la busqueda del directorio
        public static List<vwDatosAspirantesTrabajadores> getDirectorioSearch(string search)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.vwDatosAspirantesTrabajadores.Where(d => (
                ((d.RelacionLaboral == "MANDO MEDIO") && (d.Categoria == "DIRECTOR GENERAL" || d.Categoria == "DIRECTOR DE AREA" || d.Categoria == "SUBDIRECTOR DE AREA" || d.Categoria == "JEFE DE DEPARTAMENTO")) || 
                ((d.RelacionLaboral == "ADMINISTRATIVO") &&( d.Categoria == "RESPONSABLE DE CENTRO \" A \"" || d.Categoria == "RESPONSABLE DE CENTRO \" B \"" || d.Categoria == "RESPONSABLE DE CENTRO \" C \"" || d.Categoria == "DIRECTOR \"A\"" || d.Categoria == "DIRECTOR \"B\"" || d.Categoria == "DIRECTOR \"C\""))
                 ) && (d.Nombre.Contains(search) || d.ApellidoPaterno.Contains(search) || d.ApellidoMaterno.Contains(search) || d.Categoria.Contains(search) || d.EstructuraOrganica.Contains(search)) ).OrderBy(C => new { C.IdEstructuraOrganica, C.IdCategoria, C.Nombre, C.ApellidoPaterno, C.ApellidoMaterno }).ToList();

        }

        //get searh centros educativos
        public static List<Catalogos_ctEstructuraOrganica> getCentrosEducativosSearch(string search)
        {
            bdNovaEntities bd = new bdNovaEntities();

            return bd.Catalogos_ctEstructuraOrganica.Where(c =>
                (( c.EstructuraOrganica.Contains("PLANTEL NÚM") || c.EstructuraOrganica.Contains("EMSAD NÚM")) && (c.IdCampusEquivalencia != null)) &&
                (  c.EstructuraOrganica.Contains(search) || c.Direccion.Contains(search) || c.CorreoElectronico.Contains(search))
                 ).ToList();
        }



    }
}