﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;


namespace Nova.Models
{
    public class Portal
    {
        //mostrar slider
        public static List<Portal_Articulos> getArticulosSlider()
        {
            
            NoticiasSingleton noticias = NoticiasSingleton.Instance;
           
            return noticias.NoticiasVigentes.OrderByDescending(o=>o.IdArticulo).Take(5).ToList();
        }

        public static List<Portal_Articulos> getConvocatoriasSlider()
        {

            NoticiasSingleton noticias = NoticiasSingleton.Instance;

            return noticias.ConvocatoriasVigentes.OrderByDescending(o => o.IdArticulo).Take(5).ToList();
        }

        public static List<Portal_Articulos> getAvisosSlider()
        {

            NoticiasSingleton noticias = NoticiasSingleton.Instance;

            return noticias.AvisosVigentes.OrderByDescending(o => o.IdArticulo).Take(0).ToList();
        }


        //mostrar noticias individuales
        public static List<Portal_Articulos> getArticuloID(int id)
        {
            NoticiasSingleton noticias = NoticiasSingleton.Instance;

            return noticias.NoticiasVigentes.Where(a =>
                                                a.IdArticulo == id 
                                                 
                                                ).ToList();
        }

        //obtener toda la categoria de Noticias
        public static List<Portal_Articulos> getTipoNoticiasAll()
        {
            NoticiasSingleton noticias = NoticiasSingleton.Instance;
            return noticias.NoticiasVigentes;
        }

        //get number of pages for view noticias
        public static int getPagesNoticias(int tamanioPagina)
        {
            bdNovaEntities bd = new bdNovaEntities();

            int total = bd.Portal_Articulos.Where(c => c.Portal_TipoArticulo.TipoArticulo == "NOTICIAS" &&
                                                    c.Publicar == true
                                                    ).Count();
            int pages = (total + tamanioPagina) / tamanioPagina;
            return pages;
        }
        //get articles with paramether for pagination
        public static List<Portal_Articulos> getNoticiasAllPaginacion(int paginaActual, int tamanioPagina)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(c =>
                                                           (c.Portal_TipoArticulo.TipoArticulo == "NOTICIAS" &&
                                                            c.Publicar == true) && (c.FechaTermino == null || c.FechaTermino >= DateTime.Now)
                                                            ).OrderByDescending(o => o.IdArticulo).Skip((paginaActual - 1) * tamanioPagina).Take(tamanioPagina).ToList();
        }



        //obtener noticias por categoria
        public static List<Portal_ArticulosCategoria> getNoticiaCategoria(String tipo)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_ArticulosCategoria.Where(e=>
                                                        (e.Portal_Articulos.Publicar == true &&
                                                        e.Portal_Categoria.Categoria == tipo &&
                                                        e.Portal_Articulos.Portal_TipoArticulo.TipoArticulo == "NOTICIAS") &&
                                                        (e.Portal_Articulos.FechaTermino == null || e.Portal_Articulos.FechaTermino >= DateTime.Now)
                                                        ).ToList();
        }

        //get the articles whit type and datetime
        public static List<Portal_ArticulosCategoria> getNoticiaTipoFecha(String tipo, DateTime fecha)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return null;
        }
        //get all article of a Mounth and year
        public static List<Portal_Articulos> getNoticiasMesAnio(int anio, int mes)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(a =>
                                                (a.Portal_TipoArticulo.TipoArticulo == "NOTICIAS" &&
                                                a.Publicar == true &&
                                                a.FechaCreacion.Month == mes &&
                                                a.FechaCreacion.Year == anio) && 
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o => o.IdArticulo).ToList();
        }
        //get of first article of table categoria
        public static String getFirstCategoria()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Categoria.Select(j => j.Categoria).FirstOrDefault();
        }

        //obtener lista de noticias
        public static List<Portal_Articulos> getNoticiasAllComunicacion()
        {


            NoticiasSingleton noticias = NoticiasSingleton.Instance;

            return noticias.NoticiasVigentesComunicacionSocial.OrderByDescending(o => o.IdArticulo).ToList();
        }

        public static List<Portal_Articulos> getNoticiasAll()
        {
           

            NoticiasSingleton noticias = NoticiasSingleton.Instance;

            return noticias.NoticiasVigentes.OrderByDescending(o => o.IdArticulo).Take(4).ToList();
        }

        //obtener todos los tipos de Artículo
        public static List<Portal_Categoria> getAllCategoria()
        {


            NoticiasSingleton noticias = NoticiasSingleton.Instance;
            return noticias.Categorias;
        }

        //obtener todos los artículos de la categoría carreras técnicas
        public static List<Portal_Articulos> getArticulosCT()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(ct => 
                                                            ct.Portal_TipoArticulo.TipoArticulo == "CARRERAS TÉCNICAS" &&
                                                            ct.Publicar == true
                                                            ).ToList();

        }

        //get articles of carreras tecnicas for id
        public static List<Portal_Articulos> getCarrerasTecnicas(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(c=>
                                                        c.Publicar == true &&
                                                        c.Portal_TipoArticulo.TipoArticulo == "CARRERAS TÉCNICAS" &&
                                                        c.IdArticulo == id
                                                        ).ToList();
        }

        //get six avisos for show on index
        public static List<Portal_Articulos> getAvisosAll()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(a => 
                                                (a.Publicar == true && 
                                                a.Portal_TipoArticulo.TipoArticulo=="AVISOS") && 
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o=>o.IdArticulo).Take(6).ToList();
        }

        //GET AVISOS FOR ID, THIS IS SHOW IN VIEW AVISOS
        public static List<Portal_Articulos> getAvisosID(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(a =>
                                                (a.IdArticulo == id &&
                                                a.Portal_TipoArticulo.TipoArticulo == "AVISOS" &&
                                                a.Publicar == true) &&
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).ToList();
        }

        //get all avisos for show on view avisos in ringht of aside
        public static List<Portal_Articulos> getAllAvisos()
        {
            bdNovaEntities bd = new bdNovaEntities();
            
            return bd.Portal_Articulos.Where(a =>
                                                (a.Publicar == true &&
                                                a.Portal_TipoArticulo.TipoArticulo == "AVISOS" ) &&
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o => o.IdArticulo).ToList();
        }


        //get last one aviso
        public static List<Portal_Articulos> getAvisoLast()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(t => 
                                                (t.Portal_TipoArticulo.TipoArticulo == "AVISOS" &&
                                                t.Publicar == true) &&
                                                (t.FechaTermino == null || t.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(O=>O.IdArticulo).Take(1).ToList();

        }


        //saber si un aviso existe en anexos y contar cuantos anexos tiene
        public static int getCountAnexoArt(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_ArticulosAnexos.Where(a => a.IdArticulo == id).Count();
        }

        //obtener los anexos de un aviso
        public static List<Portal_ArticulosAnexos> getAnexoArt(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_ArticulosAnexos.Where(a=>a.IdArticulo == id).ToList();
        }

        public static List<Portal_Articulos> getConvocatoriaAll()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(c=>
                                                (c.Publicar==true && 
                                                c.Portal_TipoArticulo.TipoArticulo=="CONVOCATORIAS") &&
                                                (c.FechaTermino == null || c.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o=>o.IdArticulo).Take(6).ToList();
        }

        // get of the last one convocatoria
        public static List<Portal_Articulos> getConvLast()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(c => 
                                                (c.Portal_TipoArticulo.TipoArticulo == "CONVOCATORIAS" &&
                                                c.Publicar == true) &&
                                                (c.FechaTermino == null || c.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o=>o.IdArticulo).Take(1).ToList();
        }

        //obtener convocatorias
        public static List<Portal_Articulos> getConvocatoriasID(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(a =>
                                                (a.IdArticulo == id &&
                                                a.Portal_TipoArticulo.TipoArticulo == "CONVOCATORIAS" &&
                                                a.Publicar == true) &&
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).ToList();
        }
        //get all convocatories for show on view convocatorias in ringht of aside
        public static List<Portal_Articulos> getAllConv()
        {
            bdNovaEntities bd = new bdNovaEntities();

            return bd.Portal_Articulos.Where(a =>
                                                (a.Publicar == true &&
                                                a.Portal_TipoArticulo.TipoArticulo == "CONVOCATORIAS") &&
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o => o.IdArticulo).ToList();
        }
        //get all publicidad
        public static List<Portal_Articulos> getPublicidadAll()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(p => 
                                                (p.Portal_TipoArticulo.TipoArticulo == "PUBLICIDAD" && 
                                                p.Publicar == true ) &&
                                                (p.FechaTermino == null || p.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o=>o.IdArticulo).ToList();
        }

        //get of the publicidad the last one
        public static List<Portal_Articulos> getPublicidadLast()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(p => 
                                                (p.Portal_TipoArticulo.TipoArticulo == "PUBLICIDAD" &&
                                                p.Publicar == true) &&
                                                (p.FechaTermino == null || p.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o => o.IdArticulo).Take(1).ToList();
        }



        

        public static List<Portal_Articulos> getAllRevista()
        {
            bdNovaEntities bd = new bdNovaEntities();

           

            return bd.Portal_Articulos.Where(r =>
                                                (r.Portal_TipoArticulo.TipoArticulo == "REVISTA" &&
                                                r.Publicar == true) &&
                                                (r.FechaTermino == null || r.FechaTermino >= DateTime.Now)
                                                ).OrderByDescending(o=>o.IdArticulo).ToList();
        }


        public static List<Portal_ArticulosAnexos> getRevistas()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_ArticulosAnexos.Where(r =>
                                                        (r.Portal_Articulos.Portal_TipoArticulo.TipoArticulo == "REVISTA" &&
                                                        r.Portal_Articulos.Publicar == true) &&
                                                        (r.Portal_Articulos.FechaTermino == null || r.Portal_Articulos.FechaTermino >= DateTime.Now)
                                                        ).OrderByDescending(o => o.IdArticulo).ToList();
        }

        public static List<Portal_Articulos> getRevistasPublicer()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(t=>(t.Publicar == true && t.Portal_TipoArticulo.TipoArticulo == "REVISTA")&&(t.FechaTermino == null || t.FechaTermino >= DateTime.Now)).ToList();
        }

        //get ciclo escolar actual
        //public static List<ctCicloescolar> getCicloEscolarNow()
        //{

        //    bdAriesEntities bd = new bdAriesEntities();
        //    return bd.ctCicloescolar.Where(t => DateTime.Now >= t.PeriodoInicio && DateTime.Now <= t.PeriodoTermino).ToList();
        //}
        public static List<Portal_CicloEscolar> getCicloEscolarNow()
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_CicloEscolar.Where(t => DateTime.Now >= t.FechaInicioCiclo && DateTime.Now <= t.FechaTerminoCiclo).OrderByDescending(t => t.FechaInicioCiclo).ToList();
        }

        public static List<ctCicloescolar> getCicloEscolarVigente()
        {
            bdAriesEntities bd = new bdAriesEntities();
            return bd.ctCicloescolar.Where(t => DateTime.Now >= t.PeriodoInicio && DateTime.Now <= t.PeriodoTermino).OrderByDescending(t => t.PeriodoInicio).ToList();
        }



        //=========================================================================================================================
        //==========================================*   LOS    *===================================================================
        //==========================================*  MÉTODOS *===================================================================
        //==========================================*   PARA   *===================================================================
        //==========================================* BUSQUEDA *===================================================================
        //=========================================================================================================================

        //obtener búsqueda de todos los artículos mientras sea publicado
        public static List<Portal_Articulos> getNoticiasSearch(String search)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(s =>
                (s.Portal_TipoArticulo.TipoArticulo == "NOTICIAS" && s.Publicar == true)&&
                (s.NombreArticulo.Contains(search) || s.Descripcion.Contains(search) || s.Contenido.Contains(search))
                 ).ToList();

        }


        public static List<Portal_Articulos> getAvisosSearch(string search)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(t=>
                   (t.Portal_TipoArticulo.TipoArticulo == "AVISOS") && 
                   (t.NombreArticulo.Contains(search) ||t.Descripcion.Contains(search))
                    ).ToList();
        }

        public static List<Portal_Articulos> getConvocatoriasSearch(string search)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_Articulos.Where(t=>(t.Portal_TipoArticulo.TipoArticulo == "CONVOCATORIAS" && t.Publicar == true) && (
                                                  t.NombreArticulo.Contains(search) || t.Descripcion.Contains(search))
                                                  ).ToList();
        }


        //public static List<Portal_Articulos> getRevistaSearch(string search)
        //{
        //    bdNovaEntities bd = new bdNovaEntities();
        //    return bd.Portal_Articulos.Where(t=>t.Portal_TipoArticulo.TipoArticulo == "REVISTA" && t.Publicar == true &&
        //                                        t.NombreArticulo.Contains(search)).ToList();
        //}

        public static List<Portal_ArticulosAnexos> getRevistaSearch(string search)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Portal_ArticulosAnexos.Where(t => (t.Portal_Articulos.Portal_TipoArticulo.TipoArticulo == "REVISTA" && t.Portal_Articulos.Publicar == true)
                &&(t.Portal_Articulos.NombreArticulo.Contains(search) || t.NombreAnexo.Contains(search) || t.ArchivoUrl.Contains(search))
                ).ToList(); ;
        }

    }
}