﻿using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;

namespace Nova.Models 
{

    
        public class PrespuestoFederalEstatal
    {
        public static List<Poa_PrespuestoFederalEstatal> Prespuesto()
        {


            string query = @"select
q1.IdProyectos
,Año
,Numero
,IdConvenioLaboralTrabajadorCategoria
,Nombre
,ApellidoPaterno
,ApellidoMaterno
,Partida
,CapituloInterno
,q2.Presupuesto as TechoPresupuestal
       ,PresupuestoProgramado
 ,Estatal
 ,Federal
from
(SELECT
f.IdProyectos
, max(d.AñoMir) as Año
, max(f.Numero) as Numero
, max(d.IdConvenioLaboralTrabajadorCategoria)IdConvenioLaboralTrabajadorCategoria
, max(v.Nombre) as Nombre
, max(v.ApellidoPaterno) as ApellidoPaterno
, max(v.ApellidoMaterno) as ApellidoMaterno
, m.Partida
, m.CapituloInterno
       , sum(Total) as PresupuestoProgramado
 , 0.0 as Estatal
 , 0.0 as Federal


  FROM  Poa_Presupuesto a
  inner join Poa_Productos m on m.IdProductos = a.IdProductos
  inner join Poa_Calendario b on a.IdCalendario = b.IdCalendario
  inner join Poa_Indicadores c on c.IdIndicadores = b.IdIndicadores


  inner join Poa_Mir d on d.IdMir = c.IdMir
  inner join Convenios_stConvenioLaboralTrabajadorCategoria z on z.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador x on x.IdConvenioLaboralTrabajador = z.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador y on y.IdTrabajador = x.IdTrabajador
  inner join Kardex_ctDatosPersonales v on v.IdKardex = y.IdKardex
  inner join  Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
  inner join Poa_Proyectos f on f.IdProyectos = e.IdProyectos
  where d.AñoMir in (select Año from Poa_SistemaAñoVigente)
  group by f.IdProyectos,m.Partida,m.CapituloInterno ) as q1
  inner join (select presupuesto, IdProyectos from Poa_ProyectosAñoAreaPresupuesto tt  inner join
 Poa_ProyectosAño gg on tt.IdProyectosAño= gg.IdProyectosAño
 where gg.AñoProyectos in (select Año from Poa_SistemaAñoVigente)) as q2
 on q1.IdProyectos = q2.IdProyectos";


            DapperQuery dp = new DapperQuery("bdNovaEntities");

            List<Poa_PrespuestoFederalEstatal> elementos = new List<Poa_PrespuestoFederalEstatal>();

            elementos = (List<Poa_PrespuestoFederalEstatal>)dp.connection.Query<Poa_PrespuestoFederalEstatal>(query);

            dp.Close();

            return elementos;


        }
    }
}