﻿using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;
using System.Web.UI;
using DevExpress.Web;

namespace Nova.Models
{


    public class CalendarioObservacionTrimestralEstatal
    {
        public int IdPoaCalendarioTrimestralEstatal { get; set; }
        public int IdIndicadores { get; set; }
        public int IdPoaTrimestre { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string Observacion { get; set; }
        public System.DateTime FechaActualizacion { get; set; }

        public int Numero { get; set; }
    }

    public class CalendarioObservacionTrimestral
    {
        public int IdPoaCalendarioTrimestral { get; set; }
        public int IdIndicadores { get; set; }
        public int IdPoaTrimestre { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string Observacion { get; set; }
        public System.DateTime FechaActualizacion { get; set; }

        public int Numero { get; set; }
    }

    public class ViaticosPorMes
    {
        public int IdViaticosPasajes { get; set; }
        public string Descripcion { get; set; }
        public int Mes { get; set; }
    }


    public class AvancePorMes
    {
        public int IdIndicadores { get; set; }
        public int IdMes { get; set; }
        public decimal Valor { get; set; }
        public string Observacion { get; set; }
        public string CalendarioElemento { get; set; }
        public Nullable<int> IdIndicadorComponente { get; set; }

    }

    public class PrespuestoProyecto
    {
        public int IdProyectos { get; set; }
        public decimal Total { get; set; }
        public int Numero { get; set; }
        public string EstructuraOrganica { get; set; }
    }

    public partial class MetasEstatalActividadAño
    {
        public int IdEstructuraProgramaticaEstatalActividadAñoMetas { get; set; }
        public int IdEstructuraProgramaticaEstatalActividadAño { get; set; }
        public short IdMes { get; set; }
        public decimal Valor { get; set; }
        public int IdEstructuraProgramaticaEstatal { get; set; }
        public string CalendarioElemento { get; set; }
        public int IdProyectosEstatales { get; set; }


    }





    public class EstructuraProgramaticaEstatalMestas
    {


        public int IdEstructuraProgramaticaEstatal { get; set; }
        public int IdMir { get; set; }
        public int IdProyectosEstatales { get; set; }
        public decimal Presupuesto { get; set; }
        public short Año { get; set; }

        public int IdEstructuraProgramaticaEstatalActividadAño { get; set; }
        public string Actividad { get; set; }
        public string ProyectoEstatal { get; set; }
        public string Programa { get; set; }
        public string SubPrograma { get; set; }

        public int IdConvenioLaboralTrabajadorCategoriaResponsable { get; set; }


    }

    public class PoaCalendarioEstructura
    {
        public List<CalendarioIndicadores> CalendarioIndicadores { get; set; }
        public List<CalendarioElementosMeses> CalendarioElementosMeses { get; set; }
        public List<Poa_PresupuestoMeses> Poa_PresupuestoMeses { get; set; }
        public List<Poa_ViaticosPasajesMeses> Poa_ViaticosPasajesMeses { get; set; }
        public List<AvancePorMes> AvancePorMeses { get; set; }

        public List<AvancePorMes> ProgramacionPorMeses { get; set; }

        public List<PrespuestoProyecto> PrespuestoPorProyecto { get; set; }
        public List<PrespuestoProyecto> PrespuestoPorEjercidoProyecto { get; set; }


        public List<EstructuraProgramaticaEstatalMestas> MetasEstales { get; set; }

        public List<MetasEstatalActividadAño> Poa_EstructuraProgramaticaEstatalActividadAñoMetas { get; set; }

        public List<MetasEstatalesMeses> MetaEstatalesMeses { get; set; }


        public int NumberPages { get; set; }
        public int RecordsPerPage { get; set; }
        public int PageNumber { get; set; }
        public string Proyecto { get; set; }
        public string Area { get; set; }
        public string Usuario { get; set; }
        public string TipoElementoObjetivos { get; set; }
        public decimal PrespuestoTotal { get; set; }
        public decimal PrespuestoEjercido { get; set; }
        public decimal PrespuestoDisponible { get; set; }
        public int AñoVigente { get; set; }
    }






    public class Poa_ViaticosPasajesMeses
    {

        public int IdViaticosPasajes { get; set; }
        public int IdCalendario { get; set; }
        public int IdOrigenDestino { get; set; }
        public short NumeroVisitas { get; set; }
        public short Dias { get; set; }
        public decimal ImporteViaticos { get; set; }
        public decimal NumeroPersonas { get; set; }
        public decimal TotalViaticos { get; set; }
        public short IdTipoPasaje { get; set; }
        public decimal ImporteBoleto { get; set; }
        public decimal TotalPasaje { get; set; }
        public decimal ViajeRedondoPersona { get; set; }
        public int IdMes { get; set; }
        public int IdIndicadores { get; set; }
        public decimal Valor { get; set; }


    }



    public class Poa_PresupuestoMeses
    {
        public int IdPresupuesto { get; set; }
        public int CantidadProducto { get; set; }
        public short IdMes { get; set; }
        public int IdCalendario { get; set; }
        public int IdProductos { get; set; }
        public decimal PrecioProducto { get; set; }
        public decimal Total { get; set; }
        public int IdIndicadores { get; set; }
    }

    public class CalendarioIndicadores
    {
        //public int RowNumber { get; set; }
        public int IdIndicadores { get; set; }
        public int IdMir { get; set; }
        public int IdProyectoArbol { get; set; }
        public int IdProyectos { get; set; }

        public string ResumenNarrativo { get; set; }
        public string Proyecto { get; set; }
        public string AreaCreadora { get; set; }
        public string TipoElementoObjetivos { get; set; }

        public string NombreUsuarioArea { get; set; }
        public string ApellidoPaternoUsuarioArea { get; set; }
        public string ApellidoMaternoUsuarioArea { get; set; }

        public int IdConvenioLaboralTrabajadorCategoriaCreador { get; set; }


        public string Indicador { get; set; }
        public string FrecuenciaMedicion { get; set; }

        public decimal LineaBase { get; set; }
        public decimal LineaBaseDenominador { get; set; }
        public decimal LineaBaseNumerador { get; set; }
        public decimal MetaAnual { get; set; }
        public int MetaAnualDenominador { get; set; }
        public int MetaAnualNumerador { get; set; }

        public string NombreUsuarioResponsable { get; set; }
        public string ApellidoPaternoUsuarioResponsable { get; set; }
        public string ApellidoMaternoUsuarioResponsable { get; set; }
        public string AreaResponsable { get; set; }

        public int IdConvenioLaboralTrabajadorCategoriaResponsable { get; set; }



        public string SentidoIndicador { get; set; }

        public short OrdenElementoObjetivo { get; set; }


        public string DimensionIndicador { get; set; }

        public short Numero { get; set; }
        public string Denominador { get; set; }
        public string Numerador { get; set; }

        public bool PresupuestoCerrado { get; set; }
        public bool EsEditable { get; set; }

        public int IdPadreElementoObjetivos { get; set; }

        public Nullable<int> IdIndicadorComponente { get; set; }
        public string TipoIndicador { get; set; }

        public bool HabilitadoProgramado { get; set; }
        public bool HabilitadoRealizado { get; set; }
        public bool HabilitadoPresupuesto { get; set; }
        public bool HabilitadoAvance { get; set; }

        public bool EscomponenteConHijos { get; set; }

        public string claseiconoprogramado { get; set; }
        public string claseiconopresupuesto { get; set; }
        public string claseiconoavance { get; set; }
        public string claseiconorealizado { get; set; }

        public Nullable<bool> ExisteMetaEstatal { get; set; }
        public int IdEstructuraProgramaticaEstatal { get; set; }
        public int IdProyectosEstatales { get; set; }
        public int IdEstructuraProgramaticaEstatalActividadAño { get; set; }
        public int IdUsuarioResponsableMeta { get; set; }

        public string ActividadEstatal { get; set; }


        public Nullable<decimal> ProgramadoEne { get; set; }
        public Nullable<decimal> RealizadoEne { get; set; }
        public Nullable<decimal> PresupuestoEne { get; set; }
        public Nullable<decimal> AvanceEne { get; set; }
        public Nullable<decimal> MetaEstatalEne { get; set; }
        public Nullable<decimal> AvanceEstatalEne { get; set; }
        public Nullable<decimal> RealizadoEstatalEne { get; set; }
        public string ViaticosPasajesEne { get; set; }
        public Nullable<int> IdCalendarioProgEne { get; set; }
        public Nullable<int> IdCalendarioReaEne { get; set; }
        public Nullable<int> IdCalendarioPresEne { get; set; }
        public Nullable<int> IdCalendarioAvaEne { get; set; }
        public Nullable<int> IdCalendarioMetEne { get; set; }
        public Nullable<int> IdAvanceEstatalEne { get; set; }
        public Nullable<int> IdRealizadoEstatalEne { get; set; }
        public Nullable<int> IdViaticosEne { get; set; }
        public string ObservacionReaEne { get; set; }



        public Nullable<decimal> ProgramadoFeb { get; set; }
        public Nullable<decimal> RealizadoFeb { get; set; }
        public Nullable<decimal> PresupuestoFeb { get; set; }
        public Nullable<decimal> AvanceFeb { get; set; }
        public Nullable<decimal> MetaEstatalFeb { get; set; }
        public Nullable<decimal> AvanceEstatalFeb { get; set; }
        public Nullable<decimal> RealizadoEstatalFeb { get; set; }
        public string ViaticosPasajesFeb { get; set; }
        public Nullable<int> IdCalendarioProgFeb { get; set; }
        public Nullable<int> IdCalendarioReaFeb { get; set; }
        public Nullable<int> IdCalendarioPresFeb { get; set; }
        public Nullable<int> IdCalendarioAvaFeb { get; set; }
        public Nullable<int> IdCalendarioMetFeb { get; set; }
        public Nullable<int> IdAvanceEstatalFeb { get; set; }
        public Nullable<int> IdRealizadoEstatalFeb { get; set; }
        public Nullable<int> IdViaticosFeb { get; set; }
        public string ObservacionReaFeb { get; set; }

        public Nullable<decimal> ProgramadoMar { get; set; }
        public Nullable<decimal> RealizadoMar { get; set; }
        public Nullable<decimal> PresupuestoMar { get; set; }
        public Nullable<decimal> AvanceMar { get; set; }
        public Nullable<decimal> MetaEstatalMar { get; set; }
        public Nullable<decimal> AvanceEstatalMar { get; set; }
        public Nullable<decimal> RealizadoEstatalMar { get; set; }
        public string ViaticosPasajesMar { get; set; }
        public Nullable<int> IdCalendarioProgMar { get; set; }
        public Nullable<int> IdCalendarioReaMar { get; set; }
        public Nullable<int> IdCalendarioPresMar { get; set; }
        public Nullable<int> IdCalendarioAvaMar { get; set; }
        public Nullable<int> IdCalendarioMetMar { get; set; }
        public Nullable<int> IdAvanceEstatalMar { get; set; }
        public Nullable<int> IdRealizadoEstatalMar { get; set; }
        public Nullable<int> IdViaticosMar { get; set; }
        public string ObservacionReaMar { get; set; }

        public Nullable<decimal> ProgramadoAbr { get; set; }
        public Nullable<decimal> RealizadoAbr { get; set; }
        public Nullable<decimal> PresupuestoAbr { get; set; }
        public Nullable<decimal> AvanceAbr { get; set; }
        public Nullable<decimal> MetaEstatalAbr { get; set; }
        public Nullable<decimal> AvanceEstatalAbr { get; set; }
        public Nullable<decimal> RealizadoEstatalAbr { get; set; }
        public string ViaticosPasajesAbr { get; set; }
        public Nullable<int> IdCalendarioProgAbr { get; set; }
        public Nullable<int> IdCalendarioReaAbr { get; set; }
        public Nullable<int> IdCalendarioPresAbr { get; set; }
        public Nullable<int> IdCalendarioAvaAbr { get; set; }
        public Nullable<int> IdCalendarioMetAbr { get; set; }
        public Nullable<int> IdAvanceEstatalAbr { get; set; }
        public Nullable<int> IdRealizadoEstatalAbr { get; set; }
        public Nullable<int> IdViaticosAbr { get; set; }
        public string ObservacionReaAbr { get; set; }


        public Nullable<decimal> ProgramadoMay { get; set; }
        public Nullable<decimal> RealizadoMay { get; set; }
        public Nullable<decimal> PresupuestoMay { get; set; }
        public Nullable<decimal> AvanceMay { get; set; }
        public Nullable<decimal> MetaEstatalMay { get; set; }
        public Nullable<decimal> AvanceEstatalMay { get; set; }
        public Nullable<decimal> RealizadoEstatalMay { get; set; }
        public string ViaticosPasajesMay { get; set; }
        public Nullable<int> IdCalendarioProgMay { get; set; }
        public Nullable<int> IdCalendarioReaMay { get; set; }
        public Nullable<int> IdCalendarioPresMay { get; set; }
        public Nullable<int> IdCalendarioAvaMay { get; set; }
        public Nullable<int> IdCalendarioMetMay { get; set; }
        public Nullable<int> IdAvanceEstatalMay { get; set; }
        public Nullable<int> IdRealizadoEstatalMay { get; set; }
        public Nullable<int> IdViaticosMay { get; set; }
        public string ObservacionReaMay { get; set; }


        public Nullable<decimal> ProgramadoJun { get; set; }
        public Nullable<decimal> RealizadoJun { get; set; }
        public Nullable<decimal> PresupuestoJun { get; set; }
        public Nullable<decimal> AvanceJun { get; set; }
        public Nullable<decimal> MetaEstatalJun { get; set; }
        public Nullable<decimal> AvanceEstatalJun { get; set; }
        public Nullable<decimal> RealizadoEstatalJun { get; set; }
        public string ViaticosPasajesJun { get; set; }
        public Nullable<int> IdCalendarioProgJun { get; set; }
        public Nullable<int> IdCalendarioReaJun { get; set; }
        public Nullable<int> IdCalendarioPresJun { get; set; }
        public Nullable<int> IdCalendarioAvaJun { get; set; }
        public Nullable<int> IdCalendarioMetJun { get; set; }
        public Nullable<int> IdAvanceEstatalJun { get; set; }
        public Nullable<int> IdRealizadoEstatalJun { get; set; }
        public Nullable<int> IdViaticosJun { get; set; }
        public string ObservacionReaJun { get; set; }

        public Nullable<decimal> ProgramadoJul { get; set; }
        public Nullable<decimal> RealizadoJul { get; set; }
        public Nullable<decimal> PresupuestoJul { get; set; }
        public Nullable<decimal> AvanceJul { get; set; }
        public Nullable<decimal> MetaEstatalJul { get; set; }
        public Nullable<decimal> AvanceEstatalJul { get; set; }
        public Nullable<decimal> RealizadoEstatalJul { get; set; }
        public string ViaticosPasajesJul { get; set; }
        public Nullable<int> IdCalendarioProgJul { get; set; }
        public Nullable<int> IdCalendarioReaJul { get; set; }
        public Nullable<int> IdCalendarioPresJul { get; set; }
        public Nullable<int> IdCalendarioAvaJul { get; set; }
        public Nullable<int> IdCalendarioMetJul { get; set; }
        public Nullable<int> IdAvanceEstatalJul { get; set; }
        public Nullable<int> IdRealizadoEstatalJul { get; set; }
        public Nullable<int> IdViaticosJul { get; set; }
        public string ObservacionReaJul { get; set; }


        public Nullable<decimal> ProgramadoAgo { get; set; }
        public Nullable<decimal> RealizadoAgo { get; set; }
        public Nullable<decimal> PresupuestoAgo { get; set; }
        public Nullable<decimal> AvanceAgo { get; set; }
        public Nullable<decimal> MetaEstatalAgo { get; set; }
        public Nullable<decimal> AvanceEstatalAgo { get; set; }
        public Nullable<decimal> RealizadoEstatalAgo { get; set; }
        public string ViaticosPasajesAgo { get; set; }
        public Nullable<int> IdCalendarioProgAgo { get; set; }
        public Nullable<int> IdCalendarioReaAgo { get; set; }
        public Nullable<int> IdCalendarioPresAgo { get; set; }
        public Nullable<int> IdCalendarioAvaAgo { get; set; }
        public Nullable<int> IdCalendarioMetAgo { get; set; }
        public Nullable<int> IdAvanceEstatalAgo { get; set; }
        public Nullable<int> IdRealizadoEstatalAgo { get; set; }
        public Nullable<int> IdViaticosAgo { get; set; }
        public string ObservacionReaAgo { get; set; }


        public Nullable<decimal> ProgramadoSep { get; set; }
        public Nullable<decimal> RealizadoSep { get; set; }
        public Nullable<decimal> PresupuestoSep { get; set; }
        public Nullable<decimal> AvanceSep { get; set; }
        public Nullable<decimal> MetaEstatalSep { get; set; }
        public Nullable<decimal> AvanceEstatalSep { get; set; }
        public Nullable<decimal> RealizadoEstatalSep { get; set; }
        public string ViaticosPasajesSep { get; set; }
        public Nullable<int> IdCalendarioProgSep { get; set; }
        public Nullable<int> IdCalendarioReaSep { get; set; }
        public Nullable<int> IdCalendarioPresSep { get; set; }
        public Nullable<int> IdCalendarioAvaSep { get; set; }
        public Nullable<int> IdCalendarioMetSep { get; set; }
        public Nullable<int> IdAvanceEstatalSep { get; set; }
        public Nullable<int> IdRealizadoEstatalSep { get; set; }
        public Nullable<int> IdViaticosSep { get; set; }
        public string ObservacionReaSep { get; set; }


        public Nullable<decimal> ProgramadoOct { get; set; }
        public Nullable<decimal> RealizadoOct { get; set; }
        public Nullable<decimal> PresupuestoOct { get; set; }
        public Nullable<decimal> AvanceOct { get; set; }
        public Nullable<decimal> MetaEstatalOct { get; set; }
        public Nullable<decimal> AvanceEstatalOct { get; set; }
        public Nullable<decimal> RealizadoEstatalOct { get; set; }
        public string ViaticosPasajesOct { get; set; }
        public Nullable<int> IdCalendarioProgOct { get; set; }
        public Nullable<int> IdCalendarioReaOct { get; set; }
        public Nullable<int> IdCalendarioPresOct { get; set; }
        public Nullable<int> IdCalendarioAvaOct { get; set; }
        public Nullable<int> IdCalendarioMetOct { get; set; }
        public Nullable<int> IdAvanceEstatalOct { get; set; }
        public Nullable<int> IdRealizadoEstatalOct { get; set; }
        public Nullable<int> IdViaticosOct { get; set; }
        public string ObservacionReaOct { get; set; }


        public Nullable<decimal> ProgramadoNov { get; set; }
        public Nullable<decimal> RealizadoNov { get; set; }
        public Nullable<decimal> PresupuestoNov { get; set; }
        public Nullable<decimal> AvanceNov { get; set; }
        public Nullable<decimal> MetaEstatalNov { get; set; }
        public Nullable<decimal> AvanceEstatalNov { get; set; }
        public Nullable<decimal> RealizadoEstatalNov { get; set; }
        public string ViaticosPasajesNov { get; set; }
        public Nullable<int> IdCalendarioProgNov { get; set; }
        public Nullable<int> IdCalendarioReaNov { get; set; }
        public Nullable<int> IdCalendarioPresNov { get; set; }
        public Nullable<int> IdCalendarioAvaNov { get; set; }
        public Nullable<int> IdCalendarioMetNov { get; set; }
        public Nullable<int> IdAvanceEstatalNov { get; set; }
        public Nullable<int> IdRealizadoEstatalNov { get; set; }
        public Nullable<int> IdViaticosNov { get; set; }
        public string ObservacionReaNov { get; set; }

        public Nullable<decimal> ProgramadoDic { get; set; }
        public Nullable<decimal> RealizadoDic { get; set; }
        public Nullable<decimal> PresupuestoDic { get; set; }
        public Nullable<decimal> AvanceDic { get; set; }
        public Nullable<decimal> MetaEstatalDic { get; set; }
        public Nullable<decimal> AvanceEstatalDic { get; set; }
        public Nullable<decimal> RealizadoEstatalDic { get; set; }
        public string ViaticosPasajesDic { get; set; }
        public Nullable<int> IdCalendarioProgDic { get; set; }
        public Nullable<int> IdCalendarioReaDic { get; set; }
        public Nullable<int> IdCalendarioPresDic { get; set; }
        public Nullable<int> IdCalendarioAvaDic { get; set; }
        public Nullable<int> IdCalendarioMetDic { get; set; }
        public Nullable<int> IdAvanceEstatalDic { get; set; }
        public Nullable<int> IdRealizadoEstatalDic { get; set; }
        public Nullable<int> IdViaticosDic { get; set; }
        public string ObservacionReaDic { get; set; }



        public Nullable<int> IdPoaCalendarioTrimestral1 { get; set; }
        public Nullable<int> IdPoaCalendarioTrimestral2 { get; set; }
        public Nullable<int> IdPoaCalendarioTrimestral3 { get; set; }
        public Nullable<int> IdPoaCalendarioTrimestral4 { get; set; }
        public Nullable<int> IdPoaCalendarioAnual { get; set; }

        public string ObservacionTrimestre1 { get; set; }
        public string ObservacionTrimestre2 { get; set; }
        public string ObservacionTrimestre3 { get; set; }
        public string ObservacionTrimestre4 { get; set; }
        public string ObservacionAnual { get; set; }

   

        public Nullable<int> IdPoaCalendarioTrimestralEstatal1 { get; set; }
        public Nullable<int> IdPoaCalendarioTrimestralEstatal2 { get; set; }
        public Nullable<int> IdPoaCalendarioTrimestralEstatal3 { get; set; }
        public Nullable<int> IdPoaCalendarioTrimestralEstatal4 { get; set; }


        public string ObservacionTrimestreEstatal1 { get; set; }
        public string ObservacionTrimestreEstatal2 { get; set; }
        public string ObservacionTrimestreEstatal3 { get; set; }
        public string ObservacionTrimestreEstatal4 { get; set; }





        public int AñoVigente { get; set; }

        public string NombreCompletoUsuarioResponsable { get; set; }
    }

    public class MetasEstatalesMeses
    {

        public int IdEstructuraProgramaticaEstatal { get; set; }
        public int IdMir { get; set; }
        public int IdProyectosEstatales { get; set; }
        public decimal Presupuesto { get; set; }
        public int IdEstructuraProgramaticaEstatalActividadAñoMetas { get; set; }
        public int IdEstructuraProgramaticaEstatalActividadAño { get; set; }
        public int IdMes { get; set; }
        public decimal Valor { get; set; }

    }
    public class CalendarioElementosMeses
    {

        public int IdIndicadores { get; set; }
        public int IdCalendario { get; set; }
        public int IdMes { get; set; }
        public int IdCalendarioElemento { get; set; }


        public string CalendarioElemento { get; set; }
        public string Observacion { get; set; }
        public decimal Valor { get; set; }
        public string Mes { get; set; }



        public string NombreUsuarioResponsable { get; set; }
        public string ApellidoPaternoUsuarioResponsable { get; set; }
        public string ApellidoMaternoUsuarioResponsable { get; set; }
        public string AreaResponsable { get; set; }

        public int IdConvenioLaboralTrabajadorCategoriaResponsable { get; set; }



        public Nullable<int> IdIndicadorComponente { get; set; }


    }


    public class PoaCalendario
    {
        public static bool EsMandoMedio()
        {
            if (Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "MANDO MEDIO" || 1 == 1)
            {
                return true;
            }
            else
                return false;

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="nmes">Numero del Mes </param>
        /// <param name="mes">Nombre del Mes Abreviado (3)</param>
        /// <param name="FilaDev"></param>
        /// <returns></returns>
        public static string CrearFilaCalendario(string nmes, string mes, object FilaDev, string rol)
        {
            GridViewDataItemTemplateContainer container = (GridViewDataItemTemplateContainer)FilaDev;
            bool HabilitadoProgramado = (bool)DataBinder.Eval(container.DataItem, "HabilitadoProgramado");
            //string nmes = "1";
            string ProgramadoMes = "Programado" + mes;
            string PresupuestoMes = "Presupuesto" + mes;
            string AvanceMes = "Avance" + mes;

            string RealizadoMes = "Realizado" + mes;


            string ViaticosPasajesMes = "ViaticosPasajes" + mes;

            string MetaEstatalMes = "MetaEstatal" + mes;

            string IdCalendarioProgMes = "IdCalendarioProg" + mes;
            string IdCalendarioReaMes = "IdCalendarioRea" + mes;
            string IdViaticosMes = "IdViaticos" + mes;
            string IdCalendarioMetMes = "IdCalendarioMet" + mes;

            string IdCalendarioAvanceMes = "IdCalendarioAva" + mes;
            string ObservacionReaMes = "ObservacionRea" + mes;

            string AvanceEstatalMes = "AvanceEstatal" + mes;

            string IdAvanceEstatalMes = "IdAvanceEstatal" + mes;

            string RealizadoEstatalMes = "RealizadoEstatal" + mes;

            string IdRealizadoEstatalMes = "IdRealizadoEstatal" + mes;

            string html = @"<ul class='list-group'  >
                            <li class='list-group-item ' style='min-width:100px !important;' id='" + DataBinder.Eval(container.DataItem, "IdIndicadores") + @"-" + nmes + "'>";


            if (HabilitadoProgramado == false && DataBinder.Eval(container.DataItem, ProgramadoMes) != null)
            {
                html = html + "<span class='bold theme-font'>" + DataBinder.Eval(container.DataItem, ProgramadoMes).ToString() + "</span>";

            }
            else
            {
                if (DataBinder.Eval(container.DataItem, ProgramadoMes) != null)
                {
                    html = html + @"<button class='btn btn-default btn-xs dropdown-toggle' type='button' data-toggle='dropdown'>
                                        <span class='bold theme-font'>" + DataBinder.Eval(container.DataItem, ProgramadoMes) + @"</span> <i class='fa fa-angle-down'></i>
                                    </button>
                                    <ul class='dropdown-menu' role='menu'>
                                        <li>
                                            <a class='btneditprogramacion' data-id='" + DataBinder.Eval(container.DataItem, IdCalendarioProgMes) + @"' data-mes='" + nmes + "' data-anio='" + DataBinder.Eval(container.DataItem, "AñoVigente") + @"' data-resumen='" + DataBinder.Eval(container.DataItem, "ResumenNarrativo") + @"' data-proyecto='" + DataBinder.Eval(container.DataItem, "Proyecto") + @"' href='javascript:void(0);'>
                                                Editar
                                            </a>
                                        </li>
                                        <li>
                                            <a class='btndeleteprogramacion' data-id='" + DataBinder.Eval(container.DataItem, IdCalendarioProgMes) + @"' href='javascript:void(0);'>
                                                Eliminar
                                            </a>
                                        </li>
                                    </ul>";
                }
                else
                {
                    if ((bool)(DataBinder.Eval(container.DataItem, "EsEditable")))
                    {
                        html = html + @"<a class='btnaddprogramacion additemcalendar' data-id='" + DataBinder.Eval(container.DataItem, "IdIndicadores") + @"' data-mes='" + nmes + "' data-anio='" + DataBinder.Eval(container.DataItem, "AñoVigente") + @"' data-resumen='" + DataBinder.Eval(container.DataItem, "ResumenNarrativo") + @"' data-proyecto='" + DataBinder.Eval(container.DataItem, "Proyecto") + @"' href='javascript:void(0);'><i style='font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a>";
                    }
                }
            }

            html = html + "</li>";
            if (DataBinder.Eval(container.DataItem, "TipoElementoObjetivos ").ToString() == "Actividad")
            {
                string presupuestoid = DataBinder.Eval(container.DataItem, "IdIndicadores").ToString() + "-" + nmes + "";
                html = html + @"<li class='list-group-item' style='min-width:100px !important;' id='pres_" + presupuestoid + @"'>&nbsp;";
                if ((bool)DataBinder.Eval(container.DataItem, "HabilitadoPresupuesto ") == false)
                {
                    html = html + "<span class='bold theme-font'>" + DataBinder.Eval(container.DataItem, PresupuestoMes) + @"</span>";
                }
                else
                {
                    if (DataBinder.Eval(container.DataItem, PresupuestoMes) != null)
                    {
                        html = html + @"<button class='btn btn-default btn-xs dropdown-toggle' type='button' data-toggle='dropdown'>
                                            <span class='bold theme-font'>" + DataBinder.Eval(container.DataItem, PresupuestoMes) + @"</span> <i class='fa fa-angle-down'></i>
                                        </button>
                                        <ul class='dropdown-menu' role='menu'>
                                            <li>
                                                <a class='btnaddpresupuesto' data-id='" + DataBinder.Eval(container.DataItem, "IdIndicadores") + @"' data-mes='" + nmes + @"' href='javascript:void(0);'>
                                                    Editar
                                                </a>
                                            </li>
                                        </ul>";
                    }
                    else
                    {
                        html = html + "<a class='btnaddpresupuesto additemcalendar' data-id='" + DataBinder.Eval(container.DataItem, "IdIndicadores") + @"' data-mes='" + nmes + "' data-anio='" + DataBinder.Eval(container.DataItem, "AñoVigente") + @"' href='javascript:void(0);'><i style='font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a>";
                    }
                }
                html = html + "</li>";
            }

            html = html + @" <li class='list-group-item' style='min-width:100px !important;'>&nbsp;";
            if (DataBinder.Eval(container.DataItem, RealizadoMes) != null)
            {
                if (DataBinder.Eval(container.DataItem, RealizadoMes).ToString() == "0.00")
                {
                    //se suma cada mes hasta el actual
                    var acumuladoprogramado = 0M;
                    var acumuladorealizado = 0M;
                    //var acumuladoprogramado = (decimal)DataBinder.Eval(container.DataItem, ProgramadoMes) + (decimal)DataBinder.Eval(container.DataItem, "ProgramadoFeb");
                    //var acumuladorealizado = (decimal)DataBinder.Eval(container.DataItem, RealizadoMes) + (decimal)DataBinder.Eval(container.DataItem, "RealizadoFeb");
                    int hastames = Nova.Libraries.ConvertToInt.ConvertToInt32(nmes);
                    for (int imes = 1; imes <= hastames; imes++)
                    {
                        acumuladoprogramado = acumuladoprogramado + (decimal)DataBinder.Eval(container.DataItem, "Programado" + Libraries.Meses.NombreAbreviadoMayusculaPrimerLetra(imes));
                        acumuladorealizado = acumuladorealizado + (decimal)DataBinder.Eval(container.DataItem, "Realizado" + Libraries.Meses.NombreAbreviadoMayusculaPrimerLetra(imes));
                    }

                    if (acumuladoprogramado > acumuladorealizado)
                    {
                        html = html + " <strong class='tooltips' data-container='body' data-placement='top' data-original-title='Meta No Cumplida '><i style='color:orange;' class='fa fa-exclamation-triangle' aria-hidden='true'></i></strong>";
                    }

                }
            }

            var addPorcentaje = @"";
            if (DataBinder.Eval(container.DataItem, "TipoElementoObjetivos").ToString() != "Actividad")
            {
                addPorcentaje = @" %";
            }


            if ((bool)DataBinder.Eval(container.DataItem, "HabilitadoRealizado") == false)
            {
                if (DataBinder.Eval(container.DataItem, RealizadoMes) != null)
                {
                    html = html + "<span class='bold theme-font'>" + DataBinder.Eval(container.DataItem, RealizadoMes) + addPorcentaje + @"</span>";
                }
                else
                {
                    html = html + "<span class='bold theme-font'>" + DataBinder.Eval(container.DataItem, RealizadoMes) + @"</span>";
                }

            }
            else
            {
                if (DataBinder.Eval(container.DataItem, RealizadoMes) != null)
                {

                    html = html + @" <button class='btn btn-default btn-xs dropdown-toggle' type='button' data-toggle='dropdown'>

                                        <span class='bold '>" + DataBinder.Eval(container.DataItem, RealizadoMes) + addPorcentaje + @"</span> <i class='fa fa-angle-down'></i>
                                    </button>
                                    <ul class='dropdown-menu' role='menu'>
                                        <li>
                                            <a class='btneditavance' data-id='" + DataBinder.Eval(container.DataItem, IdCalendarioReaMes) + @"' data-mes='" + nmes + @"' data-anio='" + DataBinder.Eval(container.DataItem, "AñoVigente") + @"' data-resumen='" + DataBinder.Eval(container.DataItem, "ResumenNarrativo") + @"' data-proyecto='" + DataBinder.Eval(container.DataItem, "Proyecto") + @"' href='javascript:void(0);'>
                                                Editar
                                            </a>
                                        </li>
                                        <li>
                                            <a class='btndeleteavance' data-id='" + DataBinder.Eval(container.DataItem, IdCalendarioReaMes) + @"' href='javascript:void(0);'>
                                                Eliminar
                                            </a>
                                        </li>
                                    </ul>";
                }
                else
                {
                    html = html + "<a class='btnaddavance additemcalendar' data-id='" + DataBinder.Eval(container.DataItem, "IdIndicadores") + @"' data-mes='" + nmes + "' data-anio='" + DataBinder.Eval(container.DataItem, "AñoVigente") + @"' data-resumen='" + DataBinder.Eval(container.DataItem, "ResumenNarrativo") + @"' data-proyecto='" + DataBinder.Eval(container.DataItem, "Proyecto") + @"' href='javascript:void(0);'><i style='font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a>";
                }
            }
            html = html + @"</li>
                            <li class='list-group-item' style='min-width:100px !important;'>
                                &nbsp;";
            if (DataBinder.Eval(container.DataItem, IdCalendarioAvanceMes) != null)
            {
                html = html + "<span class='bold tooltips' data-container='body' data-placement='top' data-original-title='" + DataBinder.Eval(container.DataItem, ObservacionReaMes) + @"'>Anual<i class='fa fa-eye'></i></span>";
            }

            if (DataBinder.Eval(container.DataItem, AvanceMes) != null)
            {
                string colorrealizado = "style = color:green;";
                decimal PorcentajeAvanceMes = 0M;


                if (DataBinder.Eval(container.DataItem, ProgramadoMes) != null)
                    if ((decimal)DataBinder.Eval(container.DataItem, RealizadoMes) < (decimal)DataBinder.Eval(container.DataItem, ProgramadoMes))
                    { colorrealizado = "style=color:red;"; }
                if (DataBinder.Eval(container.DataItem, RealizadoMes) != null && DataBinder.Eval(container.DataItem, ProgramadoMes) != null)
                    if ((decimal)DataBinder.Eval(container.DataItem, RealizadoMes) >= 0M && (decimal)DataBinder.Eval(container.DataItem, ProgramadoMes) > 0M)
                        PorcentajeAvanceMes = ((decimal)DataBinder.Eval(container.DataItem, RealizadoMes) / (decimal)DataBinder.Eval(container.DataItem, ProgramadoMes)) * 100;
                html = html + " <span " + colorrealizado + "class='bold '>" + DataBinder.Eval(container.DataItem, AvanceMes) + @" %</span><br\>" +
                 @" Mes <i class='fa fa-eye'></i> <span " + colorrealizado + "class='bold '>" + Math.Round(PorcentajeAvanceMes, 2, MidpointRounding.AwayFromZero) + @" %</span><br\>";

            }
            else
            {
                string colorrealizado = "style = color:red;";
                decimal PorcentajeAvanceMes = 0M;
                decimal PAvanceMes = 0M;
                html = html + " <span " + colorrealizado + "class='bold '>" + Math.Round(PAvanceMes, 2, MidpointRounding.AwayFromZero) + @" %</span><br\>" +
                 @" <i class='fa fa-eye'></i> <span " + colorrealizado + "class='bold '>" + Math.Round(PorcentajeAvanceMes, 2, MidpointRounding.AwayFromZero) + @" %</span><br\>";

            }
            html = html + " </li>";

            if (DataBinder.Eval(container.DataItem, "TipoElementoObjetivos").ToString() == "Actividad")
            {

                html = html + " <li class='list-group-item' style='min-width:100px !important;'  id='viat_" + DataBinder.Eval(container.DataItem, "IdIndicadores") + @"-" + nmes + "'>&nbsp; ";

                if (DataBinder.Eval(container.DataItem, ViaticosPasajesMes) != null)
                {
                    var viaticosdatos = DataBinder.Eval(container.DataItem, ViaticosPasajesMes).ToString();
                    if (viaticosdatos != "")
                    {
                        string[] words = viaticosdatos.Split('|');
                        foreach (string word in words.Where(d => d.Trim() != ""))
                        {
                            string[] ViaticosPasajes = word.Split('@');

                            html = html + @" <div class='btn-group'>
                                            <a class='btn btn-default btn-xs' href='#' data-toggle='dropdown'>
                                                <span class='bold theme-font'>" + ViaticosPasajes[0] + @"</span> <i class='fa fa-angle-down'></i>
                                            </a>
                                            <ul class='dropdown-menu bottom-up'>
                                                <li>

                                                    <a class='btnviaticos' data-id='" + ViaticosPasajes[1] + @"' href='javascript:void(0);'>
                                                        <i class='fa fa-edit'></i>  Ver
                                                    </a>
                                                </li>";

                            if ((bool)DataBinder.Eval(container.DataItem, "HabilitadoPresupuesto"))
                            {
                                html = html + @" <li>
                                                            <a class='btn-vp-delete'  data-mes='" + nmes + @"' data-indicador='" + DataBinder.Eval(container.DataItem, "IdIndicadores") + @"' data-id='" + DataBinder.Eval(container.DataItem, IdViaticosMes) + @"'  href='javascript:void(0);'>
                                                                <i class='fa fa-trash-o'></i> Eliminar
                                                            </a>
                                                        </li>";
                            }

                            html = html + "</ul></div>";
                        }


                    }
                }

                if ((bool)DataBinder.Eval(container.DataItem, "HabilitadoPresupuesto"))
                {
                    html = html + "<a class='additemcalendar' href='javascript:addviaticos(" + DataBinder.Eval(container.DataItem, "IdIndicadores") + @", " + nmes + ");'><i style='font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a>";
                }

                html = html + "</li>";
            }


            if (DataBinder.Eval(container.DataItem, "TipoElementoObjetivos").ToString() == "Componente")
            {
                string elemento = DataBinder.Eval(container.DataItem, "Indicador").ToString();
                if (elemento == "% de mantenimiento a redes de Centros Educativos")
                {
                    var x = 10;
                }

                if (DataBinder.Eval(container.DataItem, "ExisteMetaEstatal") != null)
                {
                    string clasemetaadd = "additemmetaestatal";
                    string clasemetaedit = "edititemmetaestatal";

                    string clasemetaaddrealizado = "additemrealizadoestatal";
                    string clasemetaeditrealizado = "edititemrealizadoestatal";

                    string clasemetaeditavance = "additemavanceestatal";

                    if (rol != "Administrador")
                    {
                        if (DataBinder.Eval(container.DataItem, "IdUsuarioResponsableMeta").ToString() != Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria.ToString())
                        {
                            clasemetaadd = "sinacceso";
                            clasemetaedit = "sinacceso";

                            clasemetaaddrealizado = "sinacceso";
                            clasemetaeditrealizado = "sinacceso";
                        }
                    }




                    //if (rol!="Administrador" || (DataBinder.Eval(container.DataItem, "IdUsuarioResponsableMeta").ToString()  != Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria.ToString()))
                    //{
                    //    clasemetaadd = "sinacceso";
                    //    clasemetaedit = "sinacceso";

                    //    clasemetaaddrealizado = "sinacceso";
                    //    clasemetaeditrealizado = "sinacceso";

                    //    clasemetaeditavance = "sinacceso";

                    //}



                    html = html + "  <li class='list-group-item' style='min-width:100px !important;'>&nbsp;";

                    if (DataBinder.Eval(container.DataItem, MetaEstatalMes) == null)
                    {
                        html = html + "<a class='" + clasemetaadd + "' data-mes='" + nmes + "' data-id='" + DataBinder.Eval(container.DataItem, "IdEstructuraProgramaticaEstatalActividadAño") + @"'><i style='font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a><p style='margin:0px;'>&nbsp;</p>";
                    }
                    else
                    {
                        html = html + "  <a  class='" + clasemetaedit + "' data-mes='" + nmes + "' data-id='" + DataBinder.Eval(container.DataItem, IdCalendarioMetMes) + @"'>" + DataBinder.Eval(container.DataItem, MetaEstatalMes) + @"</a><p style='margin:0px;'>&nbsp;</p>";
                    }

                    html = html + "</li>";

                    html = html + "  <li class='list-group-item' style='min-width:100px !important;'>&nbsp;";

                    if (DataBinder.Eval(container.DataItem, RealizadoEstatalMes) == null)
                    {
                        html = html + "<a class='" + clasemetaaddrealizado + "' data-mes='" + nmes + "' data-id='" + DataBinder.Eval(container.DataItem, "IdEstructuraProgramaticaEstatalActividadAño") + @"'><i style='font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a>";
                    }
                    else
                    {
                        html = html + "  <a class='" + clasemetaeditrealizado + "' data-mes='" + nmes + "' data-id='" + DataBinder.Eval(container.DataItem, IdRealizadoEstatalMes) + @"'>" + DataBinder.Eval(container.DataItem, RealizadoEstatalMes) + @"</a>";
                    }

                    html = html + "</li>";

                    html = html + "  <li class='list-group-item' style='min-width:100px !important;'>&nbsp;";

                    if (DataBinder.Eval(container.DataItem, AvanceEstatalMes) == null)
                    {
                        html = html + "<a class='" + clasemetaeditavance + "' data-mes='" + nmes + "' data-id='" + DataBinder.Eval(container.DataItem, IdAvanceEstatalMes) + @"'></a>";
                    }
                    else
                    {
                        html = html + "  <span>" + DataBinder.Eval(container.DataItem, AvanceEstatalMes) + @" %</span>";
                        //html = html + "  <a class='edititemavanceestatal' data-mes='" + nmes + "' data-id='" + DataBinder.Eval(container.DataItem, IdAvanceEstatalMes) + @"'>" + DataBinder.Eval(container.DataItem, AvanceEstatalMes) + @"</a>";
                    }

                    html = html + "</li>";
                }
            }

            html = html + "</ul>";

            return html;
        }

        public static int AccesoAlCalendario()
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query2;

            query2 = @" SELECT Año from  Poa_SistemaAñoVigente";

            int añoviogente = dp.connection.ExecuteScalar<int>(query2);
            if (añoviogente == 0)
            {
                dp.Close();
                throw new ApplicationException("El Administrador del sistema no ha configurado el año vigente para el sistema.");
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            string query = @"select count(j.IdIndicadores) as Total
  FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol = b.IdProyectoArbol
  inner join Poa_Proyectos c on c.IdProyectos = a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos = a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador = g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex = h.IdKardex
  inner join Poa_Indicadores j on j.IdMir = b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador = j.IdFrecuenciaMedicionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador = d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador = g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex = h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica = d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador = j.IdSentidoIndicador
  where  b.añoMir =" + añoviogente + " and j.IdConvenioLaboralTrabajadorCategoria = " + idusuario;

            //DapperQuery dp = new DapperQuery("bdNovaEntities");



            int existe = dp.connection.ExecuteScalar<int>(query);


            dp.Close();

            //if (existe == 0)
            //{
            //    throw new ApplicationException("No tienes asignado ningún elemento para este proyecto.");
            //}
            return idusuario;
        }

        public static Poa_Calendario Save(int Id, short Mes, decimal Valor, bdNovaEntities basedatos)
        {
            var existe = basedatos.Poa_Calendario.Where(r => r.Poa_CalendarioElemento.CalendarioElemento.ToLower() == "viáticos y pasajes" && r.IdIndicadores == Id && r.IdMes == Mes).FirstOrDefault();

            if (existe == null)
            {
                Poa_Calendario calendario = new Poa_Calendario();
                calendario.IdIndicadores = Id;
                calendario.IdMes = Mes;
                calendario.IdCalendarioElemento = basedatos.Poa_CalendarioElemento.Where(r => r.CalendarioElemento.ToLower() == "viáticos y pasajes").FirstOrDefault().IdCalendarioElemento;
                calendario.Valor = Valor;

                basedatos.Poa_Calendario.Add(calendario);
                basedatos.SaveChanges();

                return calendario;
            }
            else
            {
                var model = basedatos.Poa_Calendario.Find(existe.IdCalendario);
                model.Valor = model.Valor + Valor;
                basedatos.Entry(model).State = System.Data.Entity.EntityState.Modified;
                basedatos.SaveChanges();


                return existe;
            }
        }
        public PoaCalendarioEstructura getCalendarioInidcadores(int idindicador, int añoSeleccionado, int pagenum, int RecordsPerPage, string filter = null, string rol = "")
        {

            
            string filtroAlimenta = string.Empty;

            string filtros = "";
            PoaCalendarioEstructura resultado = new PoaCalendarioEstructura();
            resultado.Usuario = rol;
            if (rol == "Administrador")
            {

                filtroAlimenta = " ResumenNarrativo not like '%ALIME%COMPO%' and ";
            }


            if (idindicador != 0)
            {
                filtros = " j.IdIndicadores=" + idindicador + " and ";
            }
            if (filter != null)
            {
                var campos = filter.Split(new string[] { "°" }, StringSplitOptions.None).Where(f => f.Trim().Length > 0).ToArray();
                string[] ArrayClaves = new string[campos.Count()];

                for (int i = 0; i < campos.Count(); i++)
                {
                    var datosinternos = campos[i].Split(new string[] { "|" }, StringSplitOptions.None).Where(f => f.Trim().Length > 0).ToArray();


                    switch (datosinternos[1])
                    {
                        case "Usuario":
                            filtros = filtros + " ( i2.Nombre like '%" + datosinternos[0] + "%' or  i2.ApellidoPaterno  like '%" + datosinternos[0] + "%'  or  i2.ApellidoMaterno  like ' % " + datosinternos[0] + " %') and ";
                            resultado.Usuario = datosinternos[0];
                            break;
                        case "Area":
                            filtros = filtros + " e.EstructuraOrganica like '%" + datosinternos[0] + "%' and ";
                            resultado.Area = datosinternos[0];
                            break;
                        case "Numero":
                            filtros = filtros + datosinternos[1] + " = " + datosinternos[0] + " and ";
                            resultado.Proyecto = datosinternos[0];
                            break;
                        case "TipoElementoObjetivos":
                            filtros = filtros + datosinternos[1] + " like '%" + datosinternos[0] + "%' and ";
                            resultado.TipoElementoObjetivos = datosinternos[0];
                            break;
                        default:

                            break;
                    }


                }
            }


            //para el caso de usuarios que NO sonadministradores
            if (rol != "Administrador")
            {
                var id = PoaCalendario.AccesoAlCalendario();

                if (rol == "Responsable")
                {
                    var idarea = Seguridad.Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;
                    filtros = filtros + " d2.IdEstructuraOrganica=" + idarea + " and ";
                }
                else
                    if (id > 0)
                { filtros = filtros + " j.IdConvenioLaboralTrabajadorCategoria =" + id + " and "; }

            }



            //BEGIN Region Modififcado
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;
            query = @" SELECT Año from  Poa_SistemaAñoVigente";
            int añoviogente = 0;

            if (añoSeleccionado != 0)
            {
                añoviogente = añoSeleccionado;
            }
            else
            {
                añoviogente = dp.connection.ExecuteScalar<int>(query);
            }
            //END Region Modififcado



            // añoviogente = 2000;

            query = $@" SELECT count(j.IdIndicadores) as total
          FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
  inner join Poa_MirEstatus ll on ll.IdMirEstatus=b.IdMirEstatus
  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
  inner join Poa_Indicadores j on j.IdMir=b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=j.IdFrecuenciaMedicionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador=j.IdSentidoIndicador
  where ll.EstatusMir='Indicadores Autorizados' and " + filtros + "  b.AñoMir=" + añoviogente;

            int totalrecords = dp.connection.ExecuteScalar<int>(query);


            int from = (pagenum * RecordsPerPage);
            int top = from;

            from = from - RecordsPerPage;





            query = $@"   SELECT    * from ( select top " + top + @"   
	j.IdIndicadores
	,b.IdMir, a.IdProyectoArbol
      ,a.IdProyectos
      ,b.ResumenNarrativo
      ,c.Proyecto
	,e.EstructuraOrganica as AreaCreadora  
	 	,f.TipoElementoObjetivos 
	,i.Nombre as NombreUsuarioArea ,i.ApellidoPaterno as ApellidoPaternoUsuarioArea,i.ApellidoMaterno as ApellidoMaternoUsuarioArea
	,a.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaCreador
	,j.Indicador
	,k.FrecuenciaMedicion,j.LineaBase,LineaBaseDenominador,LineaBaseNumerador,j.MetaAnual,j.MetaAnualDenominador,j.MetaAnualNumerador
	,i2.Nombre as NombreUsuarioResponsable ,i2.ApellidoPaterno as ApellidoPaternoUsuarioResponsable,i2.ApellidoMaterno as ApellidoMaternoUsuarioResponsable 
	,e2.EstructuraOrganica as AreaResponsable 
	,j.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaResponsable
    ,l.SentidoIndicador
,f.OrdenMir as OrdenElementoObjetivo,hh.DimensionIndicador,c.Numero
,j.Denominador,j.Numerador
,j.PresupuestoCerrado
,cast (1 as bit) EsEditable,a.IdPadreElementoObjetivos
,j.IdIndicadorComponente,tip.TipoIndicador
  FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol and a.AñoArbol=b.AñoMir
 inner join Poa_MirEstatus ll on ll.IdMirEstatus=b.IdMirEstatus
  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
  inner join Poa_Indicadores j on j.IdMir=b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=j.IdFrecuenciaMedicionIndicador
inner join Poa_DimensionIndicador hh on hh.IdDimensionIndicador=j.IdDimensionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador=j.IdSentidoIndicador
    inner join Poa_TipoIndicador tip on tip.IdTipoIndicador=j.IdTipoIndicador
  where ll.EstatusMir='Indicadores Autorizados' and  " + filtros + " b.AñoMir=" + añoviogente + @" 
  order by j.IdIndicadores
) a
 order by Numero,OrdenElementoObjetivo,AreaCreadora, NombreUsuarioResponsable ,ApellidoPaternoUsuarioResponsable";
           

            List<CalendarioIndicadores> elementos = new List<CalendarioIndicadores>();
            List<CalendarioIndicadores> elementostemporal = new List<CalendarioIndicadores>();

            List<CalendarioIndicadores> elementosComponentesPadres = new List<CalendarioIndicadores>();

            elementostemporal = (List<CalendarioIndicadores>)dp.connection.Query<CalendarioIndicadores>(query);


            query = @"SELECT IdPoaCalendarioTrimestral
      , a.IdIndicadores
      ,a.IdPoaTrimestre
      ,a.IdConvenioLaboralTrabajadorCategoria
      ,Observacion
      ,FechaActualizacion,d.Numero FROM  Poa_CalendarioObservacionTrimestral a
      inner join Poa_Indicadores b on b.IdIndicadores = a.IdIndicadores
      inner join Poa_Mir c on c.IdMir = b.IdMir
        inner join Poa_Trimestre d on d.IdPoaTrimestre=a.IdPoaTrimestre
      where c.AñoMir=" + añoviogente;

            List<CalendarioObservacionTrimestral> observacionestrimiestrales = (List<CalendarioObservacionTrimestral>)dp.connection.Query<CalendarioObservacionTrimestral>(query);



            query = @"SELECT IdPoaCalendarioTrimestralEstatal
      , a.IdIndicadores
      ,a.IdPoaTrimestre
      ,a.IdConvenioLaboralTrabajadorCategoria
      ,Observacion
      ,FechaActualizacion,d.Numero FROM  Poa_CalendarioObservacionTrimestralEstatal a
      inner join Poa_Indicadores b on b.IdIndicadores = a.IdIndicadores
      inner join Poa_Mir c on c.IdMir = b.IdMir
        inner join Poa_Trimestre d on d.IdPoaTrimestre=a.IdPoaTrimestre
      where c.AñoMir=" + añoviogente;

            List<CalendarioObservacionTrimestralEstatal> observacionestrimiestralesestatal = (List<CalendarioObservacionTrimestralEstatal>)dp.connection.Query<CalendarioObservacionTrimestralEstatal>(query);








            List<EstructuraProgramaticaEstatalMestas> Listametasestatales = new List<EstructuraProgramaticaEstatalMestas>();
            query = @"SELECT  a.IdEstructuraProgramaticaEstatal
      ,IdMir
      ,a.IdProyectosEstatales
      ,Presupuesto
      ,a.Año
      ,b.IdEstructuraProgramaticaEstatalActividadAño
      ,c.Actividad
      ,c.ProyectoEstatal
      ,c.Programa
      ,c.SubPrograma
        ,c.IdConvenioLaboralTrabajadorCategoriaResponsable
  FROM Poa_EstructuraProgramaticaEstatal a
  left join Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal 
  inner join Poa_ProyectosEstatales c on c.IdProyectosEstatales=a.IdProyectosEstatales
  where a.Año=" + añoviogente;
            Listametasestatales = (List<EstructuraProgramaticaEstatalMestas>)dp.connection.Query<EstructuraProgramaticaEstatalMestas>(query);


            query = @" SELECT IdEstructuraProgramaticaEstatalActividadAñoMetas
       , a.IdEstructuraProgramaticaEstatalActividadAño
      ,IdMes
      ,Valor
      ,b.IdEstructuraProgramaticaEstatal
,c.CalendarioElemento,y.IdProyectosEstatales
  FROM  Poa_EstructuraProgramaticaEstatalActividadAñoMetas a
  inner join Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatalActividadAño = b.IdEstructuraProgramaticaEstatalActividadAño
 inner join Poa_CalendarioElemento c on c.IdCalendarioElemento=a.IdCalendarioElemento
 inner join Poa_EstructuraProgramaticaEstatal x on x.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal
  left join Poa_ProyectosEstatales y on y.IdProyectosEstatales=x.IdProyectosEstatales
  where b.Año=" + añoviogente;

            List<MetasEstatalActividadAño> EstructuraProgramaticaEstatalActividadAñoMetas = new List<MetasEstatalActividadAño>();
            EstructuraProgramaticaEstatalActividadAñoMetas = (List<MetasEstatalActividadAño>)dp.connection.Query<MetasEstatalActividadAño>(query);


            resultado.Poa_EstructuraProgramaticaEstatalActividadAñoMetas = EstructuraProgramaticaEstatalActividadAñoMetas;

            String ids = String.Join(",", elementostemporal.Select(r => r.IdIndicadores));
            if (ids == "")
            { ids = "0"; }

            String idmirs = String.Join(",", elementostemporal.Select(r => r.IdMir));
            if (idmirs == "")
            { idmirs = "0"; }
            //busca sus componentes padres 
            if (rol == "Usuario")
            {


                String idpadres = String.Join(",", elementostemporal.Select(r => r.IdPadreElementoObjetivos));
                if (idpadres == "")
                { idpadres = "0"; }

                query = @"   SELECT    * from ( select top " + top + @"   
	j.IdIndicadores
	,b.IdMir, a.IdProyectoArbol
      ,a.IdProyectos
      ,b.ResumenNarrativo
      ,c.Proyecto
	,e.EstructuraOrganica as AreaCreadora  
	 	,f.TipoElementoObjetivos 
	,i.Nombre as NombreUsuarioArea ,i.ApellidoPaterno as ApellidoPaternoUsuarioArea,i.ApellidoMaterno as ApellidoMaternoUsuarioArea
	,a.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaCreador
	,j.Indicador
	,k.FrecuenciaMedicion,j.LineaBase,LineaBaseDenominador,LineaBaseNumerador,j.MetaAnual,j.MetaAnualDenominador,j.MetaAnualNumerador
	,i2.Nombre as NombreUsuarioResponsable ,i2.ApellidoPaterno as ApellidoPaternoUsuarioResponsable,i2.ApellidoMaterno as ApellidoMaternoUsuarioResponsable 
	,e2.EstructuraOrganica as AreaResponsable 
	,j.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaResponsable
    ,l.SentidoIndicador
,f.OrdenMir as OrdenElementoObjetivo,hh.DimensionIndicador,c.Numero
,j.Denominador,j.Numerador
,j.PresupuestoCerrado
,cast (0 as bit) EsEditable,a.IdPadreElementoObjetivos
  FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
 inner join Poa_MirEstatus ll on ll.IdMirEstatus=b.IdMirEstatus
  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
  inner join Poa_Indicadores j on j.IdMir=b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=j.IdFrecuenciaMedicionIndicador
inner join Poa_DimensionIndicador hh on hh.IdDimensionIndicador=j.IdDimensionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador=j.IdSentidoIndicador
  where ll.EstatusMir='Indicadores Autorizados' and  f.TipoElementoObjetivos='Componente' and b.IdMir not in(" + idmirs + ") and a.IdProyectoArbol in (" + idpadres + ") and  b.AñoMir=" + añoviogente + @" 
  order by j.IdIndicadores
) a
 order by Proyecto,OrdenElementoObjetivo,AreaCreadora, NombreUsuarioResponsable ,ApellidoPaternoUsuarioResponsable";
                elementosComponentesPadres = (List<CalendarioIndicadores>)dp.connection.Query<CalendarioIndicadores>(query);
                //elementosComponentesPadres.AddRange(elementostemporal);




            }


            elementos.AddRange(elementosComponentesPadres);
            elementos.AddRange(elementostemporal);


            query = @"select  b.IdIndicadores, IdCalendario,a.IdMes,a.IdCalendarioElemento,CalendarioElemento,a.Observacion,Valor ,Mes
  ,i2.Nombre as NombreUsuarioResponsable ,i2.ApellidoPaterno as ApellidoPaternoUsuarioResponsable,i2.ApellidoMaterno as ApellidoMaternoUsuarioResponsable 
	,e2.EstructuraOrganica as AreaResponsable 
	,b.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaResponsable,b.IdIndicadorComponente
  from Poa_Calendario a inner join 
  Poa_Indicadores b on a.IdIndicadores=b.IdIndicadores
  inner join Poa_Mir c on c.IdMir=b.IdMir
  inner join Poa_ProyectoArbol d on d.IdProyectoArbol=c.IdProyectoArbol
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=b.IdFrecuenciaMedicionIndicador
 inner join Poa_CalendarioElemento e on e.IdCalendarioElemento=a.IdCalendarioElemento
 inner join Catalogos_ctMes f on f.IdMes=a.IdMes
 inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
  where b.IdIndicadores in (" + ids + ")";

            List<CalendarioElementosMeses> elementosMeses = new List<CalendarioElementosMeses>();

            elementosMeses = (List<CalendarioElementosMeses>)dp.connection.Query<CalendarioElementosMeses>(query);



            query = @"select 
a.IdEstructuraProgramaticaEstatal
      ,a.IdMir
      ,IdProyectosEstatales
      ,Presupuesto     
      ,IdEstructuraProgramaticaEstatalActividadAñoMetas
      ,c.IdEstructuraProgramaticaEstatalActividadAño
      ,IdMes
      ,Valor
  FROM bdNova.dbo.Poa_EstructuraProgramaticaEstatal a inner join 
  Poa_EstructuraProgramaticaEstatalActividadAño b on a.IdEstructuraProgramaticaEstatal=b.IdEstructuraProgramaticaEstatal
  inner join Poa_EstructuraProgramaticaEstatalActividadAñoMetas c on c.IdEstructuraProgramaticaEstatalActividadAño=b.IdEstructuraProgramaticaEstatalActividadAño 
  inner join Poa_Mir d on d.Idmir=a.IdMir and b.Año=d.AñoMir
  where  a.IdMir in (" + idmirs + ")";

            //List<MetasEstatalesMeses> elementosMetasEstatalesMeses = new List<MetasEstatalesMeses>();

            resultado.MetaEstatalesMeses = (List<MetasEstatalesMeses>)dp.connection.Query<MetasEstatalesMeses>(query);



            query = @"select SUM(a.Valor) as Total,d.IdProyectos,MAX(d.Numero) as Numero,MAX(r.EstructuraOrganica) as EstructuraOrganica
  from Poa_Calendario a inner join 
  Poa_Indicadores b on a.IdIndicadores=b.IdIndicadores
 inner join Poa_CalendarioElemento e on e.IdCalendarioElemento=a.IdCalendarioElemento
 inner join Poa_Mir x on x.IdMir=b.IdMir
 inner join Convenios_stConvenioLaboralTrabajadorCategoria v on v.IdConvenioLaboralTrabajadorCategoria=x.IdConvenioLaboralTrabajadorCategoria
 inner join Poa_ProyectoArbol z on z.IdProyectoArbol=x.IdProyectoArbol
 inner join Poa_Proyectos d on d.IdProyectos=z.IdProyectos
 inner join Catalogos_ctEstructuraOrganica r on r.IdEstructuraOrganica=v.IdEstructuraOrganica
 
    where e.CalendarioElemento in ('Viáticos y pasajes','Presupuesto') and
b.IdIndicadores in (
 SELECT j.IdIndicadores as total
          FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
 inner join Poa_MirEstatus ll on ll.IdMirEstatus=b.IdMirEstatus
  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
  inner join Poa_Indicadores j on j.IdMir=b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=j.IdFrecuenciaMedicionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador=j.IdSentidoIndicador
  where  ll.EstatusMir='Indicadores Autorizados' and " + filtros + " + b.AñoMir =" + añoviogente + ")  group by d.IdProyectos,r.IdEstructuraOrganica order by 3";

            // int PresupuestoEjercido = dp.connection.ExecuteScalar<int>(query);

            decimal PresupuestoEjercido = 0;

            List<PrespuestoProyecto> presupuestoejercidoporproyecto = (List<PrespuestoProyecto>)dp.connection.Query<PrespuestoProyecto>(query);


            foreach (var item in presupuestoejercidoporproyecto)
            {
                PresupuestoEjercido = PresupuestoEjercido + item.Total;
            }




            query = @"select sum(Presupuesto) Total,d.IdProyectos
,MAX(d.Numero) as Numero,MAX(e.EstructuraOrganica) as EstructuraOrganica
 FROM Poa_ProyectosAñoAreaPresupuesto z inner join 
  Poa_ProyectosAño a on z.IdProyectosAño=a.IdProyectosAño
  inner join Poa_Proyectos d on d.IdProyectos=a.IdProyectos
  inner join Catalogos_ctEstructuraOrganica e on z.IdEstructuraOrganica=e.IdEstructuraOrganica
    where a.AñoProyectos="+ añoviogente + @" and e.IdEstructuraOrganica in (
SELECT e.IdEstructuraOrganica as total
          FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
inner join Poa_MirEstatus ll on ll.IdMirEstatus=b.IdMirEstatus
  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
  inner join Poa_Indicadores j on j.IdMir=b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=j.IdFrecuenciaMedicionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador=j.IdSentidoIndicador
where   ll.EstatusMir='Indicadores Autorizados' and " + filtros + " + b.AñoMir =" + añoviogente + ") group by d.IdProyectos,e.IdEstructuraOrganica order by 3";


            //int Totalpresupuesto = dp.connection.ExecuteScalar<int>(query);
            List<PrespuestoProyecto> presupuestoporproyecto = (List<PrespuestoProyecto>)dp.connection.Query<PrespuestoProyecto>(query);

            decimal Totalpresupuesto = 0;
            foreach (var item in presupuestoporproyecto)
            {
                Totalpresupuesto = Totalpresupuesto + item.Total;
            }

            //Totalpresupuesto = dp.connection.ExecuteScalar<int>(query);


            query = @"SELECT a.IdPresupuesto  
       ,  CantidadProducto  
       , a.IdMes  
        , a.IdCalendario  
       , IdProductos  
       , PrecioProducto  
       , Total  
       , IdIndicadores  
 FROM  Poa_Presupuesto a inner join Poa_Calendario b on
            a.IdCalendario = b.IdCalendario  
inner join Poa_CalendarioElemento e on e.IdCalendarioElemento=b.IdCalendarioElemento
    where e.CalendarioElemento ='Presupuesto' and
 b.IdIndicadores in (" + ids + ")";


            List<Poa_PresupuestoMeses> Poa_PresupuestoelementosMeses = (List<Poa_PresupuestoMeses>)dp.connection.Query<Poa_PresupuestoMeses>(query);


            query = @"SELECT IdViaticosPasajes
              , a.IdCalendario
                ,IdOrigenDestino
                ,NumeroVisitas
                ,Dias
                ,ImporteViaticos
                ,NumeroPersonas
                ,TotalViaticos
                ,IdTipoPasaje
                ,ImporteBoleto
                ,TotalPasaje
                ,ViajeRedondoPersona
                ,b.IdMes
                ,b.IdIndicadores
                ,b.Valor
            FROM  Poa_ViaticosPasajes a inner join Poa_Calendario b on
            a.IdCalendario = b.IdCalendario 
inner join Poa_CalendarioElemento e on e.IdCalendarioElemento=b.IdCalendarioElemento
    where e.CalendarioElemento ='Viáticos y pasajes' and
 b.IdIndicadores in (" + ids + ")";

            List<Poa_ViaticosPasajesMeses> Poa_ViaticosPasajesMeses = (List<Poa_ViaticosPasajesMeses>)dp.connection.Query<Poa_ViaticosPasajesMeses>(query);



            //determinar que estatus tiene cada jerarquia, para saber si esta habilitado o deshabilitado
            //y se pueda interactuar con el registro en la interfaz


            resultado.Poa_ViaticosPasajesMeses = Poa_ViaticosPasajesMeses;

            foreach (var item in elementos)
            {

                var calendarioprogramado = elementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores && e.CalendarioElemento == "Programado").ToList();
                //var calendariopresupuestado =Poa_PresupuestoelementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores ).ToList();

                var calendariopresupuestado = elementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores && e.CalendarioElemento == "Presupuesto").ToList();
                var calendarioavanzado = elementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores && e.CalendarioElemento == "Avance").ToList();
                var calendariorealizado = elementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores && e.CalendarioElemento == "Realizado").ToList();

                bool puedeprogramar = false;
                bool puedeavazar = false;
                bool puederealizar = false;
                bool puedepresupuestar = false;
                if (item.FrecuenciaMedicion == "Mensual")
                {
                    if (calendarioprogramado.Count < 12)
                    {
                        puedeprogramar = true;
                        puedeavazar = false;
                        puederealizar = false;
                        puedepresupuestar = false;
                    }
                    else
                    {
                        if (item.TipoElementoObjetivos == "Actividad")
                        {
                            if (calendariopresupuestado.Count < 20)
                            {
                                puedeprogramar = false;
                                puedepresupuestar = true;
                                puedeavazar = false;
                                puederealizar = false;

                                if (item.PresupuestoCerrado)
                                {
                                    puedepresupuestar = false;
                                    puederealizar = true;
                                }



                            }
                            else
                            {
                                if (calendariorealizado.Count < 12)
                                {
                                    //puedeprogramar = false;
                                    //puedeavazar = true;
                                    //puederealizar = false;
                                    //puedepresupuestar = false;

                                    puedeprogramar = false;
                                    puedeavazar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;



                                }
                            }
                        }
                        else
                        {
                            if (calendariorealizado.Count < 12)
                            {
                                puedeprogramar = false;
                                puedeavazar = false;
                                puederealizar = true;
                                puedepresupuestar = false;
                            }


                            else
                            {
                                if (calendarioavanzado.Count < 12)
                                {
                                    puedeprogramar = false;
                                    puedeavazar = true;
                                    //puederealizar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;
                                }
                            }
                        }
                    }

                }


                if (item.FrecuenciaMedicion == "Anual")
                {
                    if (calendarioprogramado.Count < 1)
                    {
                        puedeprogramar = true;
                        puedeavazar = false;
                        puederealizar = false;
                        puedepresupuestar = false;
                    }
                    else
                    {
                        if (item.TipoElementoObjetivos == "Actividad")
                        {
                            if (calendariopresupuestado.Count < 20)
                            {
                                puedeprogramar = false;
                                puedepresupuestar = true;
                                puedeavazar = false;
                                puederealizar = false;

                                if (item.PresupuestoCerrado)
                                {
                                    puedepresupuestar = false;
                                    puederealizar = true;
                                }



                            }
                            else
                            {
                                if (calendariorealizado.Count < 1)
                                {

                                    puedeprogramar = false;
                                    puedeavazar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;
                                }
                            }
                        }
                        else
                        {
                            if (calendariorealizado.Count < 1)
                            {
                                puedeprogramar = false;
                                puedeavazar = false;
                                puederealizar = true;
                                puedepresupuestar = false;
                            }


                            else
                            {
                                if (calendarioavanzado.Count < 1)
                                {
                                    puedeprogramar = false;
                                    puedeavazar = true;
                                    //puederealizar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;
                                }
                            }
                        }
                    }

                }

                if (item.FrecuenciaMedicion == "Semestral")
                {
                    if (calendarioprogramado.Count < 2)
                    {
                        puedeprogramar = true;
                        puedeavazar = false;
                        puederealizar = false;
                        puedepresupuestar = false;
                    }
                    else
                    {
                        if (item.TipoElementoObjetivos == "Actividad")
                        {
                            if (calendariopresupuestado.Count < 20)
                            {
                                puedeprogramar = false;
                                puedepresupuestar = true;
                                puedeavazar = false;
                                puederealizar = false;

                                if (item.PresupuestoCerrado)
                                {
                                    puedepresupuestar = false;
                                    puederealizar = true;
                                }




                            }
                            else
                            {
                                if (calendariorealizado.Count < 2)
                                {

                                    puedeprogramar = false;
                                    puedeavazar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;
                                }
                            }
                        }
                        else
                        {
                            if (calendariorealizado.Count < 2)
                            {
                                puedeprogramar = false;
                                puedeavazar = false;
                                puederealizar = true;
                                puedepresupuestar = false;
                            }


                            else
                            {
                                if (calendarioavanzado.Count < 2)
                                {
                                    puedeprogramar = false;
                                    puedeavazar = true;
                                    //puederealizar = false;
                                    puederealizar = true;

                                    puedepresupuestar = false;
                                }
                            }
                        }
                    }

                }

                if (item.FrecuenciaMedicion == "Bimestral")
                {
                    if (calendarioprogramado.Count < 6)
                    {
                        puedeprogramar = true;
                        puedeavazar = false;
                        puederealizar = false;
                        puedepresupuestar = false;
                    }
                    else
                    {
                        if (item.TipoElementoObjetivos == "Actividad")
                        {
                            if (calendariopresupuestado.Count < 20)
                            {
                                puedeprogramar = false;
                                puedepresupuestar = true;
                                puedeavazar = false;
                                puederealizar = false;
                                if (item.PresupuestoCerrado)
                                {
                                    puedepresupuestar = false;
                                    puederealizar = true;
                                }



                            }
                            else
                            {
                                if (calendariorealizado.Count < 6)
                                {

                                    puedeprogramar = false;
                                    puedeavazar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;
                                }
                            }
                        }
                        else
                        {
                            if (calendariorealizado.Count < 6)
                            {
                                puedeprogramar = false;
                                puedeavazar = false;
                                puederealizar = true;
                                puedepresupuestar = false;
                            }


                            else
                            {
                                if (calendarioavanzado.Count < 6)
                                {
                                    puedeprogramar = false;
                                    puedeavazar = true;
                                    //puederealizar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;
                                }
                            }
                        }
                    }

                }




                if (item.FrecuenciaMedicion == "Trimestral")
                {
                    if (calendarioprogramado.Count < 4)
                    {
                        puedeprogramar = true;
                        puedeavazar = false;
                        puederealizar = false;
                        puedepresupuestar = false;
                    }
                    else
                    {
                        if (item.TipoElementoObjetivos == "Actividad")
                        {
                            if (calendariopresupuestado.Count < 20)
                            {
                                puedeprogramar = false;
                                puedepresupuestar = true;
                                puedeavazar = false;
                                puederealizar = false;
                                if (item.PresupuestoCerrado)
                                {
                                    puedepresupuestar = false;
                                    puederealizar = true;
                                }



                            }
                            else
                            {
                                if (calendariorealizado.Count < 4)
                                {

                                    puedeprogramar = false;
                                    puedeavazar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;
                                }
                            }
                        }
                        else
                        {
                            if (calendariorealizado.Count < 4)
                            {
                                puedeprogramar = false;
                                puedeavazar = false;
                                puederealizar = true;
                                puedepresupuestar = false;
                            }


                            else
                            {
                                if (calendarioavanzado.Count < 4)
                                {
                                    puedeprogramar = false;
                                    puedeavazar = true;
                                    //puederealizar = false;
                                    puederealizar = true;
                                    puedepresupuestar = false;
                                }
                            }
                        }
                    }

                }








                item.HabilitadoProgramado = puedeprogramar;
                item.HabilitadoPresupuesto = puedepresupuestar;
                item.HabilitadoAvance = puedeavazar;
                item.HabilitadoRealizado = puederealizar;


            }


            query = @"select a.IdIndicadores,a.IdMes,Valor,Observacion, CalendarioElemento ,c.IdIndicadorComponente
from Poa_Calendario a left join
 Poa_CalendarioElemento b on a.IdCalendarioElemento = b.IdCalendarioElemento
 left join Poa_Indicadores c on a.IdIndicadores=c.IdIndicadores
  where(a.IdIndicadores   in (" + ids + @") and b.CalendarioElemento = 'Programado')
  or (a.IdIndicadores   in (" + ids + ") and b.CalendarioElemento = 'Realizado')";



            List<AvancePorMes> AvancePorMes = (List<AvancePorMes>)dp.connection.Query<AvancePorMes>(query);

            List<AvancePorMes> TotalesAvancePorMes = new List<AvancePorMes>();




            string[] pieces = ids.Split(new string[] { "," },
                                              StringSplitOptions.None);

            int[] array2 = new int[pieces.Count()];

            for (int i = 0; i < pieces.Count(); i++)
            {
                int idseleccionado = Convert.ToInt32(pieces[i]);
                var metasprogramadas = AvancePorMes.Where(t => t.IdIndicadores == idseleccionado && t.CalendarioElemento == "Programado").Sum(g => g.Valor);

                foreach (var metas in AvancePorMes.Where(t => t.IdIndicadores == idseleccionado && t.CalendarioElemento == "Realizado").ToList())
                {
                    var avances = AvancePorMes.Where(t => t.IdIndicadores == idseleccionado && t.CalendarioElemento == "Realizado" && t.IdMes <= metas.IdMes).Sum(g => g.Valor);

                    decimal total = 0;
                    if (metasprogramadas > 0)
                    {
                        total = Math.Round((avances * 100) / metasprogramadas, 2);
                    }
                    AvancePorMes TotalesAvance = new AvancePorMes();
                    TotalesAvance.Valor = total;
                    TotalesAvance.Observacion = metas.Observacion;
                    TotalesAvance.IdIndicadores = idseleccionado;
                    TotalesAvance.IdMes = metas.IdMes;
                    TotalesAvance.CalendarioElemento = "Realizado";
                    TotalesAvance.IdIndicadorComponente = metas.IdIndicadorComponente;
                    TotalesAvancePorMes.Add(TotalesAvance);
                }

            }


            //****************
            resultado.MetasEstales = Listametasestatales;
            resultado.AvancePorMeses = TotalesAvancePorMes;

            resultado.ProgramacionPorMeses = AvancePorMes.Where(t => t.CalendarioElemento == "Programado").ToList();


            foreach (var item in elementos)
            {
                item.AñoVigente = añoviogente;
                item.NombreCompletoUsuarioResponsable = item.NombreUsuarioResponsable + " " + item.ApellidoPaternoUsuarioResponsable + " " + item.ApellidoMaternoUsuarioResponsable;

                item.EscomponenteConHijos = false;
                if (item.TipoElementoObjetivos == "Componente")
                {
                    var tienehijos = elementos.Where(r => r.IdIndicadorComponente == item.IdIndicadores).ToList();
                    if (tienehijos.Count > 0)
                    {
                        item.EscomponenteConHijos = true;

                    }
                }


                item.claseiconoprogramado = "default";
                item.claseiconopresupuesto = "default";
                item.claseiconoavance = "default";
                item.claseiconorealizado = "default";


                if (item.EscomponenteConHijos)
                {
                    item.HabilitadoProgramado = false;
                    item.HabilitadoPresupuesto = false;
                    item.HabilitadoRealizado = false;
                    item.HabilitadoAvance = false;
                }

                if (item.PresupuestoCerrado)
                { item.HabilitadoPresupuesto = false; }

                if (item.HabilitadoProgramado == true)
                { item.claseiconoprogramado = "danger"; }


                if (item.HabilitadoPresupuesto == true)
                {
                    item.claseiconoprogramado = "success";
                    item.claseiconopresupuesto = "danger";
                }
                if (item.HabilitadoRealizado == true)
                {
                    item.claseiconoprogramado = "success";
                    item.claseiconopresupuesto = "success";
                    item.claseiconorealizado = "danger";
                }

                if (item.HabilitadoAvance == true)
                {
                    item.claseiconoprogramado = "success";
                    item.claseiconopresupuesto = "success";
                    item.claseiconorealizado = "success";
                    item.claseiconoavance = "success";
                }





                var observacionesporindicador = observacionestrimiestrales.Where(f => f.IdIndicadores == item.IdIndicadores).ToList();


                if (observacionesporindicador != null)
                {


                    for (int indicemes = 1; indicemes < 6; indicemes++)
                    {
                        var observacionesdeltrimestre = observacionesporindicador.Where(g => g.Numero == indicemes).FirstOrDefault();

                        if (observacionesdeltrimestre != null)
                            switch (indicemes)
                            {
                                case 1:
                                    item.ObservacionTrimestre1 = observacionesdeltrimestre.Observacion;
                                    item.IdPoaCalendarioTrimestral1 = observacionesdeltrimestre.IdPoaCalendarioTrimestral;

                                    break;
                                case 2:
                                    item.ObservacionTrimestre2 = observacionesdeltrimestre.Observacion;
                                    item.IdPoaCalendarioTrimestral2 = observacionesdeltrimestre.IdPoaCalendarioTrimestral;
                                    break;
                                case 3:
                                    item.ObservacionTrimestre3 = observacionesdeltrimestre.Observacion;
                                    item.IdPoaCalendarioTrimestral3 = observacionesdeltrimestre.IdPoaCalendarioTrimestral;
                                    break;
                                case 4:
                                    item.ObservacionTrimestre4 = observacionesdeltrimestre.Observacion;
                                    item.IdPoaCalendarioTrimestral4 = observacionesdeltrimestre.IdPoaCalendarioTrimestral;
                                    break;
                                case 5:
                                    item.ObservacionAnual = observacionesdeltrimestre.Observacion;
                                    item.IdPoaCalendarioAnual = observacionesdeltrimestre.IdPoaCalendarioTrimestral;
                                    break;
                            }
                    }
                }

         





                var observacionesporindicadorestatal = observacionestrimiestralesestatal.Where(f => f.IdIndicadores == item.IdIndicadores).ToList();


                if (observacionesporindicadorestatal != null)
                {


                    for (int indicemes = 1; indicemes < 5; indicemes++)
                    {
                        var observacionesdeltrimestreestatal = observacionesporindicadorestatal.Where(g => g.Numero == indicemes).FirstOrDefault();

                        if (observacionesdeltrimestreestatal != null)
                            switch (indicemes)
                            {
                                case 1:
                                    item.ObservacionTrimestreEstatal1 = observacionesdeltrimestreestatal.Observacion;
                                    item.IdPoaCalendarioTrimestralEstatal1 = observacionesdeltrimestreestatal.IdPoaCalendarioTrimestralEstatal;

                                    break;
                                case 2:
                                    item.ObservacionTrimestreEstatal2 = observacionesdeltrimestreestatal.Observacion;
                                    item.IdPoaCalendarioTrimestralEstatal2 = observacionesdeltrimestreestatal.IdPoaCalendarioTrimestralEstatal;
                                    break;
                                case 3:
                                    item.ObservacionTrimestreEstatal3 = observacionesdeltrimestreestatal.Observacion;
                                    item.IdPoaCalendarioTrimestralEstatal3 = observacionesdeltrimestreestatal.IdPoaCalendarioTrimestralEstatal;
                                    break;
                                case 4:
                                    item.ObservacionTrimestreEstatal4 = observacionesdeltrimestreestatal.Observacion;
                                    item.IdPoaCalendarioTrimestralEstatal4 = observacionesdeltrimestreestatal.IdPoaCalendarioTrimestralEstatal;
                                    break;
                            }
                    }
                }


                var metas = Listametasestatales.Where(d => d.IdMir == item.IdMir).FirstOrDefault();
                if (metas != null)
                {
                    item.ExisteMetaEstatal = true;
                    item.IdEstructuraProgramaticaEstatal = metas.IdEstructuraProgramaticaEstatal;
                    item.IdProyectosEstatales = metas.IdProyectosEstatales;
                    item.ActividadEstatal = metas.Actividad;
                    item.IdUsuarioResponsableMeta = metas.IdConvenioLaboralTrabajadorCategoriaResponsable;
                    item.IdEstructuraProgramaticaEstatalActividadAño = metas.IdEstructuraProgramaticaEstatalActividadAño;

                    for (int indicemes = 1; indicemes < 13; indicemes++)
                    {
                        var metaprogramada = EstructuraProgramaticaEstatalActividadAñoMetas.Where(d => d.IdProyectosEstatales == metas.IdProyectosEstatales && d.CalendarioElemento == "Programado" && d.IdMes == indicemes).FirstOrDefault();
                        if (metaprogramada != null)
                        {

                            switch (indicemes)
                            {
                                case 1:
                                    item.IdCalendarioMetEne = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalEne = metaprogramada.Valor;

                                    break;
                                case 2:
                                    item.IdCalendarioMetFeb = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalFeb = metaprogramada.Valor;
                                    break;
                                case 3:
                                    item.IdCalendarioMetMar = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalMar = metaprogramada.Valor;
                                    break;
                                case 4:
                                    item.IdCalendarioMetAbr = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalAbr = metaprogramada.Valor;
                                    break;
                                case 5:
                                    item.IdCalendarioMetMay = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalMay = metaprogramada.Valor;
                                    break;
                                case 6:
                                    item.IdCalendarioMetJun = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalJun = metaprogramada.Valor;
                                    break;

                                case 7:
                                    item.IdCalendarioMetJul = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalJul = metaprogramada.Valor;
                                    break;
                                case 8:
                                    item.IdCalendarioMetAgo = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalAgo = metaprogramada.Valor;
                                    break;
                                case 9:
                                    item.IdCalendarioMetSep = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalSep = metaprogramada.Valor;
                                    break;
                                case 10:
                                    item.IdCalendarioMetOct = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalOct = metaprogramada.Valor;
                                    break;

                                case 11:
                                    item.IdCalendarioMetNov = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalNov = metaprogramada.Valor;
                                    break;
                                case 12:
                                    item.IdCalendarioMetDic = metaprogramada.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.MetaEstatalDic = metaprogramada.Valor;
                                    break;
                            }
                        }

                        var avanceestatal = EstructuraProgramaticaEstatalActividadAñoMetas.Where(d => d.IdProyectosEstatales == metas.IdProyectosEstatales && d.CalendarioElemento == "Avance" && d.IdMes == indicemes).FirstOrDefault();
                        if (avanceestatal != null)
                        {

                            switch (indicemes)
                            {
                                case 1:
                                    item.IdAvanceEstatalEne = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalEne = avanceestatal.Valor;

                                    break;
                                case 2:
                                    item.IdAvanceEstatalFeb = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalFeb = avanceestatal.Valor;
                                    break;
                                case 3:
                                    item.IdAvanceEstatalMar = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalMar = avanceestatal.Valor;
                                    break;
                                case 4:
                                    item.IdAvanceEstatalAbr = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalAbr = avanceestatal.Valor;
                                    break;
                                case 5:
                                    item.IdAvanceEstatalMay = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalMay = avanceestatal.Valor;
                                    break;
                                case 6:
                                    item.IdAvanceEstatalJun = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalJun = avanceestatal.Valor;
                                    break;

                                case 7:
                                    item.IdAvanceEstatalJul = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalJul = avanceestatal.Valor;
                                    break;
                                case 8:
                                    item.IdAvanceEstatalAgo = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalAgo = avanceestatal.Valor;
                                    break;
                                case 9:
                                    item.IdAvanceEstatalSep = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalSep = avanceestatal.Valor;
                                    break;
                                case 10:
                                    item.IdAvanceEstatalOct = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalOct = avanceestatal.Valor;
                                    break;

                                case 11:
                                    item.IdAvanceEstatalNov = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalNov = avanceestatal.Valor;
                                    break;
                                case 12:
                                    item.IdAvanceEstatalDic = avanceestatal.IdEstructuraProgramaticaEstatal;
                                    item.AvanceEstatalDic = avanceestatal.Valor;
                                    break;
                            }
                        }

                        var realizadoestatal = EstructuraProgramaticaEstatalActividadAñoMetas.Where(d => d.IdProyectosEstatales == metas.IdProyectosEstatales && d.CalendarioElemento == "Realizado" && d.IdMes == indicemes).FirstOrDefault();
                        if (realizadoestatal != null)
                        {

                            switch (indicemes)
                            {
                                case 1:
                                    item.IdRealizadoEstatalEne = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalEne = realizadoestatal.Valor;

                                    break;
                                case 2:
                                    item.IdRealizadoEstatalFeb = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalFeb = realizadoestatal.Valor;
                                    break;
                                case 3:
                                    item.IdRealizadoEstatalMar = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalMar = realizadoestatal.Valor;
                                    break;
                                case 4:
                                    item.IdRealizadoEstatalAbr = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalAbr = realizadoestatal.Valor;
                                    break;
                                case 5:
                                    item.IdRealizadoEstatalMay = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalMay = realizadoestatal.Valor;
                                    break;
                                case 6:
                                    item.IdRealizadoEstatalJun = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalJun = realizadoestatal.Valor;
                                    break;

                                case 7:
                                    item.IdRealizadoEstatalJul = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalJul = realizadoestatal.Valor;
                                    break;
                                case 8:
                                    item.IdRealizadoEstatalAgo = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalAgo = realizadoestatal.Valor;
                                    break;
                                case 9:
                                    item.IdRealizadoEstatalSep = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalSep = realizadoestatal.Valor;
                                    break;
                                case 10:
                                    item.IdRealizadoEstatalOct = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalOct = realizadoestatal.Valor;
                                    break;

                                case 11:
                                    item.IdRealizadoEstatalNov = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalNov = realizadoestatal.Valor;
                                    break;
                                case 12:
                                    item.IdRealizadoEstatalDic = realizadoestatal.IdEstructuraProgramaticaEstatalActividadAñoMetas;
                                    item.RealizadoEstatalDic = realizadoestatal.Valor;
                                    break;
                            }
                        }
                    }
                }



                for (int indicemes = 1; indicemes < 13; indicemes++)
                {
                    //programado
                    var presupuestado = Poa_PresupuestoelementosMeses.Where(r => r.IdIndicadores == item.IdIndicadores && r.IdMes == indicemes).ToList();
                    if (presupuestado != null)
                    {
                        decimal presupuestocadena = presupuestado.Sum(f => f.Total);
                        if (presupuestocadena != 0)
                        {
                            switch (indicemes)
                            {
                                case 1:
                                    item.PresupuestoEne = presupuestocadena;
                                    item.IdCalendarioPresEne = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 2:
                                    item.PresupuestoFeb = presupuestocadena;
                                    item.IdCalendarioPresFeb = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 3:
                                    item.PresupuestoMar = presupuestocadena;
                                    item.IdCalendarioPresMar = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 4:
                                    item.PresupuestoAbr = presupuestocadena;
                                    item.IdCalendarioPresAbr = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 5:
                                    item.PresupuestoMay = presupuestocadena;
                                    item.IdCalendarioPresMay = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 6:
                                    item.PresupuestoJun = presupuestocadena;
                                    item.IdCalendarioPresJun = presupuestado.FirstOrDefault().IdCalendario;
                                    break;

                                case 7:
                                    item.PresupuestoJul = presupuestocadena;
                                    item.IdCalendarioPresJul = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 8:
                                    item.PresupuestoAgo = presupuestocadena;
                                    item.IdCalendarioPresAgo = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 9:
                                    item.PresupuestoSep = presupuestocadena;
                                    item.IdCalendarioPresSep = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 10:
                                    item.PresupuestoOct = presupuestocadena;
                                    item.IdCalendarioPresOct = presupuestado.FirstOrDefault().IdCalendario;
                                    break;

                                case 11:
                                    item.PresupuestoNov = presupuestocadena;
                                    item.IdCalendarioPresNov = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                                case 12:
                                    item.PresupuestoDic = presupuestocadena;
                                    item.IdCalendarioPresDic = presupuestado.FirstOrDefault().IdCalendario;
                                    break;
                            }

                        }
                    }

                }

                //programado


                for (int indicemes = 1; indicemes < 13; indicemes++)
                {
                    var viaticos = Poa_ViaticosPasajesMeses.Where(r => r.IdIndicadores == item.IdIndicadores && r.IdMes == indicemes).ToList();
                    if (viaticos.Sum(f => f.TotalPasaje + f.TotalViaticos) > 0)
                    {

                        foreach (var via in viaticos)
                        {
                            if ((via.TotalPasaje + via.TotalViaticos) > 0)
                            {
                                string viaticoscadena = "V: " + via.TotalViaticos.ToString() + " P: " + via.TotalPasaje.ToString();
                                //string viaticoscadena = "P: " + viaticos.Where(g => g.IdMes == indicemes).Sum(f => f.TotalPasaje).ToString() + " V: " + viaticos.Sum(f => f.TotalViaticos).ToString();




                                switch (indicemes)
                                {
                                    case 1:
                                        item.ViaticosPasajesEne = item.ViaticosPasajesEne + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosEne = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 2:
                                        item.ViaticosPasajesFeb = item.ViaticosPasajesFeb + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosFeb = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 3:
                                        item.ViaticosPasajesMar = item.ViaticosPasajesMar + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosMar = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 4:
                                        item.ViaticosPasajesAbr = item.ViaticosPasajesAbr + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosAbr = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 5:
                                        item.ViaticosPasajesMay = item.ViaticosPasajesMay + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosMay = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 6:
                                        item.ViaticosPasajesJun = item.ViaticosPasajesJun + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosJun = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;

                                    case 7:
                                        item.ViaticosPasajesJul = item.ViaticosPasajesJul + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosJul = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 8:
                                        item.ViaticosPasajesAgo = item.ViaticosPasajesAgo + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosAgo = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 9:
                                        item.ViaticosPasajesSep = item.ViaticosPasajesSep + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosSep = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 10:
                                        item.ViaticosPasajesOct = item.ViaticosPasajesOct + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosOct = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;

                                    case 11:
                                        item.ViaticosPasajesNov = item.ViaticosPasajesNov + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosNov = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                    case 12:
                                        item.ViaticosPasajesDic = item.ViaticosPasajesDic + viaticoscadena + "@" + via.IdViaticosPasajes.ToString() + "|";
                                        item.IdViaticosDic = viaticos.FirstOrDefault().IdViaticosPasajes;
                                        break;
                                }

                            }
                        }

                    }
                }

                for (int indicemes = 1; indicemes < 13; indicemes++)
                {


                    var programado = elementosMeses.Where(r => r.IdIndicadores == item.IdIndicadores && r.IdMes == indicemes && r.CalendarioElemento == "Programado").FirstOrDefault();
                    if (programado != null)
                    {

                        switch (indicemes)
                        {
                            case 1:
                                item.ProgramadoEne = programado.Valor;
                                item.IdCalendarioProgEne = programado.IdCalendario;
                                break;
                            case 2:
                                item.ProgramadoFeb = programado.Valor;
                                item.IdCalendarioProgFeb = programado.IdCalendario;
                                break;
                            case 3:
                                item.ProgramadoMar = programado.Valor;
                                item.IdCalendarioProgMar = programado.IdCalendario;
                                break;
                            case 4:
                                item.ProgramadoAbr = programado.Valor;
                                item.IdCalendarioProgAbr = programado.IdCalendario;
                                break;
                            case 5:
                                item.ProgramadoMay = programado.Valor;
                                item.IdCalendarioProgMay = programado.IdCalendario;
                                break;
                            case 6:
                                item.ProgramadoJun = programado.Valor;
                                item.IdCalendarioProgJun = programado.IdCalendario;
                                break;

                            case 7:
                                item.ProgramadoJul = programado.Valor;
                                item.IdCalendarioProgJul = programado.IdCalendario;
                                break;
                            case 8:
                                item.ProgramadoAgo = programado.Valor;
                                item.IdCalendarioProgAgo = programado.IdCalendario;

                                break;
                            case 9:
                                item.ProgramadoSep = programado.Valor;
                                item.IdCalendarioProgSep = programado.IdCalendario;
                                break;
                            case 10:
                                item.ProgramadoOct = programado.Valor;
                                item.IdCalendarioProgOct = programado.IdCalendario;
                                break;

                            case 11:
                                item.ProgramadoNov = programado.Valor;
                                item.IdCalendarioProgNov = programado.IdCalendario;
                                break;
                            case 12:
                                item.ProgramadoDic = programado.Valor;
                                item.IdCalendarioProgDic = programado.IdCalendario;
                                break;
                        }
                    }

                }

                //var realizado = Model.CalendarioElementosMeses.Where(r => r.IdIndicadores == item.IdIndicadores && r.IdMes == indicemes && r.CalendarioElemento == "Realizado").FirstOrDefault();
                //if (realizado != null)
                //{

                //}

                for (int indicemes = 1; indicemes < 13; indicemes++)
                {


                    var realizado = elementosMeses.Where(r => r.IdIndicadores == item.IdIndicadores && r.IdMes == indicemes && r.CalendarioElemento == "Realizado").FirstOrDefault();
                    if (realizado != null)
                    {

                        switch (indicemes)
                        {
                            case 1:
                                item.RealizadoEne = realizado.Valor;
                                item.IdCalendarioReaEne = realizado.IdCalendario;
                                item.ObservacionReaEne = realizado.Observacion;
                                break;
                            case 2:
                                item.RealizadoFeb = realizado.Valor;
                                item.IdCalendarioReaFeb = realizado.IdCalendario;
                                item.ObservacionReaFeb = realizado.Observacion;
                                break;
                            case 3:
                                item.RealizadoMar = realizado.Valor;
                                item.IdCalendarioReaMar = realizado.IdCalendario;
                                item.ObservacionReaMar = realizado.Observacion;
                                break;
                            case 4:
                                item.RealizadoAbr = realizado.Valor;
                                item.IdCalendarioReaAbr = realizado.IdCalendario;
                                item.ObservacionReaAbr = realizado.Observacion;
                                break;
                            case 5:
                                item.RealizadoMay = realizado.Valor;
                                item.IdCalendarioReaMay = realizado.IdCalendario;
                                item.ObservacionReaMay = realizado.Observacion;
                                break;
                            case 6:
                                item.RealizadoJun = realizado.Valor;
                                item.IdCalendarioReaJun = realizado.IdCalendario;
                                item.ObservacionReaJun = realizado.Observacion;
                                break;

                            case 7:
                                item.RealizadoJul = realizado.Valor;
                                item.IdCalendarioReaJul = realizado.IdCalendario;
                                item.ObservacionReaJul = realizado.Observacion;
                                break;
                            case 8:
                                item.RealizadoAgo = realizado.Valor;
                                item.IdCalendarioReaAgo = realizado.IdCalendario;
                                item.ObservacionReaAgo = realizado.Observacion;
                                break;
                            case 9:
                                item.RealizadoSep = realizado.Valor;
                                item.IdCalendarioReaSep = realizado.IdCalendario;
                                item.ObservacionReaSep = realizado.Observacion;
                                break;
                            case 10:
                                item.RealizadoOct = realizado.Valor;
                                item.IdCalendarioReaOct = realizado.IdCalendario;
                                item.ObservacionReaOct = realizado.Observacion;
                                break;

                            case 11:
                                item.RealizadoNov = realizado.Valor;
                                item.IdCalendarioReaNov = realizado.IdCalendario;
                                item.ObservacionReaNov = realizado.Observacion;
                                break;
                            case 12:
                                item.RealizadoDic = realizado.Valor;
                                item.IdCalendarioReaDic = realizado.IdCalendario;
                                item.ObservacionReaDic = realizado.Observacion;
                                break;
                        }
                    }

                }




                for (int indicemes = 1; indicemes < 13; indicemes++)
                {


                    var avance = resultado.AvancePorMeses.Where(r => r.IdIndicadores == item.IdIndicadores && r.IdMes == indicemes && r.CalendarioElemento == "Realizado").FirstOrDefault();
                    if (avance != null)
                    {

                        switch (indicemes)
                        {
                            case 1:
                                item.AvanceEne = avance.Valor;
                                item.IdCalendarioAvaEne = avance.IdIndicadores;
                                break;
                            case 2:
                                item.AvanceFeb = avance.Valor;
                                item.IdCalendarioAvaFeb = avance.IdIndicadores;
                                break;
                            case 3:
                                item.AvanceMar = avance.Valor;
                                item.IdCalendarioAvaMar = avance.IdIndicadores;
                                break;
                            case 4:
                                item.AvanceAbr = avance.Valor;
                                item.IdCalendarioAvaAbr = avance.IdIndicadores;
                                break;
                            case 5:
                                item.AvanceMay = avance.Valor;
                                item.IdCalendarioAvaMay = avance.IdIndicadores;
                                break;
                            case 6:
                                item.AvanceJun = avance.Valor;
                                item.IdCalendarioAvaJun = avance.IdIndicadores;
                                break;

                            case 7:
                                item.AvanceJul = avance.Valor;
                                item.IdCalendarioAvaJul = avance.IdIndicadores;
                                break;
                            case 8:
                                item.AvanceAgo = avance.Valor;
                                item.IdCalendarioAvaAgo = avance.IdIndicadores;

                                break;
                            case 9:
                                item.AvanceSep = avance.Valor;
                                item.IdCalendarioAvaSep = avance.IdIndicadores;
                                break;
                            case 10:
                                item.AvanceOct = avance.Valor;
                                item.IdCalendarioAvaOct = avance.IdIndicadores;
                                break;

                            case 11:
                                item.AvanceNov = avance.Valor;
                                item.IdCalendarioAvaNov = avance.IdIndicadores;
                                break;
                            case 12:
                                item.AvanceDic = avance.Valor;
                                item.IdCalendarioAvaDic = avance.IdIndicadores;
                                break;
                        }
                    }

                }

            }



            resultado.CalendarioIndicadores = elementos;
            resultado.CalendarioElementosMeses = elementosMeses;
            resultado.Poa_PresupuestoMeses = Poa_PresupuestoelementosMeses;
            resultado.PrespuestoTotal = Totalpresupuesto;
            resultado.PrespuestoEjercido = PresupuestoEjercido;
            resultado.PrespuestoDisponible = Totalpresupuesto - PresupuestoEjercido;
            resultado.AñoVigente = añoviogente;

            resultado.NumberPages = (int)Math.Round((double)(totalrecords / RecordsPerPage), 0);
            resultado.PageNumber = pagenum;
            resultado.RecordsPerPage = RecordsPerPage;

            resultado.PrespuestoPorProyecto = presupuestoporproyecto;
            resultado.PrespuestoPorEjercidoProyecto = presupuestoejercidoporproyecto;
            return resultado;
        }



        public static List<vwDatosAspirantesTrabajadores> InvolucradosPorProyecto(int proyecto, int año)
        {
            bdNovaEntities bd = new bdNovaEntities();
            //var trabajadores = bd.vwDatosAspirantesTrabajadores.Where(w => w.EstatusTrabajador == "ALTA" && w.RelacionLaboral == "MANDO MEDIO" && w.RestringirMenu == null && w.Categoria != "JEFE DE DEPARTAMENTO").ToList();
            var trabajadores = bd.vwDatosAspirantesTrabajadores.Where(w => w.EstatusTrabajador == "ALTA" && w.RestringirMenu == null && w.RelacionLaboral == "MANDO MEDIO").ToList();

            //var jefes = bd.vwDatosAspirantesTrabajadores.Where(w => w.EstatusTrabajador == "ALTA" && w.RelacionLaboral == "MANDO MEDIO" && w.RestringirMenu == null && w.Categoria == "JEFE DE DEPARTAMENTO" && (w.UbicacionFisica == "DEPARTAMENTO DE SISTEMAS, REDES Y SOPORTE TÉCNICO" || w.UbicacionFisica == "DEPARTAMENTO DE INFRAESTRUCTURA EDUCATIVA" || w.UbicacionFisica == "DEPARTAMENTO JURÍDICO")).ToList();
            //trabajadores.AddRange(jefes);
            List<vwDatosAspirantesTrabajadores> resultado = new List<vwDatosAspirantesTrabajadores>();
            List<int?> emples = new List<int?>();
            var aux = bd.Poa_ProyectosAñoAreasFirmas.Where(d => d.Poa_ProyectosAño.IdProyectos == proyecto && d.Poa_ProyectosAño.AñoProyectos == año).Select(t => t.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica).ToList();
            var empleados = bd.Catalogos_ctEstructuraOrganica.Where(x => aux.Contains(x.IdEstructuraOrganica)).Select(t => t.EstructuraOrganica).ToArray();
            var regresa = trabajadores.Where(t => empleados.Contains(t.UbicacionFisica)).OrderBy(f=>f.OrdenEstructuraOrganica).ThenBy(f => f.CURP).ToList();
            //switch (proyecto)

            //{
            //        case 1:        

            //        emples.Add(42);
            //        emples.Add(4191);
            //        emples.Add(3985);


            //    resultado=bd.vwDatosAspirantesTrabajadores.Where(t=>  emples.Contains(t.IdConvenioLaboralTrabajadorCategoria)).ToList();
            //    break;
            //        case 2:

            //    emples.Add(4190);
            //    emples.Add(4106);
            //    emples.Add(3459);
            //    emples.Add(3968);



            //    resultado = bd.vwDatosAspirantesTrabajadores.Where(t => emples.Contains(t.IdConvenioLaboralTrabajadorCategoria)).ToList();
            //    break;


            // case 3:

            //    emples.Add(3985);
            //    emples.Add(2973);


            //    resultado = bd.vwDatosAspirantesTrabajadores.Where(t => emples.Contains(t.IdConvenioLaboralTrabajadorCategoria)).ToList();
            //    break;


            // case 4:

            //    emples.Add(4190);
            //    emples.Add(4191);


            //    resultado = bd.vwDatosAspirantesTrabajadores.Where(t => emples.Contains(t.IdConvenioLaboralTrabajadorCategoria)).ToList();
            //    break;


            //case 5:

            //    emples.Add(367);
            //    emples.Add(42);


            //    resultado = bd.vwDatosAspirantesTrabajadores.Where(t => emples.Contains(t.IdConvenioLaboralTrabajadorCategoria)).ToList();
            //    break;

            //case 6:

            //    emples.Add(4190);
            //    emples.Add(4106);
            //    emples.Add(2973);
            //    emples.Add(3968);

            //    resultado = bd.vwDatosAspirantesTrabajadores.Where(t => emples.Contains(t.IdConvenioLaboralTrabajadorCategoria)).ToList();
            //    break;

            //case 7:

            //    emples.Add(4190);
            //    emples.Add(4106);
            //    emples.Add(3459);
            //    emples.Add(3985);

            //    resultado = bd.vwDatosAspirantesTrabajadores.Where(t => emples.Contains(t.IdConvenioLaboralTrabajadorCategoria)).ToList();
            //    break;
            //    }

            return regresa;

        }
    }
}