﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;

namespace Nova.Models
{
    [MetadataType(typeof(PercepcionesConcedidasMetaData))]
    public partial class Percepciones_stPercepcionesConcedidas
    {

    }

    public class PercepcionesConcedidasMetaData
    {
        [ScaffoldColumn(false)]
        public object IdPercepcionesConcedidas { get; set; }

        [Required]
        [Display(Name ="Trabajador")]
        [Range(0, Int32.MaxValue, ErrorMessage = "El valor para {0} no es válido")]
        public object IdTrabajador { get; set; }

        [Required]
        [Display(Name ="Percepción")]
        [Range(0, Int32.MaxValue, ErrorMessage = "El valor para {0} no es válido")]
        public object IdPercepcion { get; set; }

        [Required]
        [DataType(DataType.DateTime, ErrorMessage = "Tipo Datetime invalido")]
        [Display(Name ="Fecha Inicio")]
        public object FechaInicio { get; set; }

        [DataType(DataType.DateTime, ErrorMessage = "Tipo Datetime invalido")]
        [Display(Name = "Fecha Termino")]
        public object FechaTermino { get; set; }

        [ScaffoldColumn(false)]
        public object IdConvenioLaboralTrabajadorCategoriaMovimiento { get; set; }

        [ScaffoldColumn(false)]
        public object FechaMovimiento { get; set; }
    }

}