﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc.Html;
using System.Text;

namespace Nova.Models
{
    public partial class Procesos_ctProcesosActividad
    {
        public enum TipoMensaje
        { 
            error,
            info,
            warning,
            success
        }

        public class ctProcesosActividad
        {
            public short IdProcesosActividad { get; set; }
            public string ProcesoActividad { get; set; }
            public short IdProcesoActividadPadre { get; set; }
            public string CssClass { get; set; }
            public string MensajeAlerta { get; set; }
            public string MensajeError { get; set; }
            public string MensajeInformacion { get; set; }
            public string MensajeExito { get; set; }
            public string ControladorAccion { get; set; }
            public Nullable<short> AñoEjecucion { get; set; }
            public Nullable<short> MesEjecucion { get; set; }
            public Nullable<short> DiaEjecucion { get; set; }
            public bool EsMostrarEnPadre { get; set; }
            public Nullable<bool> EsCompletado { get; set; }
            public Nullable<bool> EsEjecutadoUnaVez { get; set; }
            public Nullable<short> Orden { get; set; }
        }


        public class ValidacionProcesosActividad
        {
            public short IdProcesosActividad { get; set; }
            public string ProcesoActividad { get; set; }
            public short IdProcesoActividadPadre { get; set; }
            public string ControladorAccion { get; set; }
            public string Mensaje { get; set; }
            public string ImagenHtml { get; set; }
            
            public bool Error { get; set; }
            public bool EsCompletado { get; set; }

            private TipoMensaje _tipoMensaje;

            public TipoMensaje tipoMensaje
            {
                get
                {
                    return _tipoMensaje;
                }
                set
                {
                    _tipoMensaje = value;

                    switch (_tipoMensaje)
                    {
                        case TipoMensaje.error:
                            ImagenHtml = System.Web.VirtualPathUtility.ToAbsolute("/App_Themes/Nova/img/icons/error.png");
                            break;
                        case TipoMensaje.info:
                            ImagenHtml = System.Web.VirtualPathUtility.ToAbsolute("/App_Themes/Nova/img/icons/info.png");
                            break;
                        case TipoMensaje.warning:
                            ImagenHtml = System.Web.VirtualPathUtility.ToAbsolute("/App_Themes/Nova/img/icons/warning.png");
                            break;
                        case TipoMensaje.success:
                            ImagenHtml = System.Web.VirtualPathUtility.ToAbsolute("/App_Themes/Nova/img/icons/success.png");
                            break;
                        default:
                            break;
                    }
                    
                }
            }

            public ValidacionProcesosActividad()
        {
            IdProcesosActividad =0;
            ProcesoActividad ="";
            IdProcesoActividadPadre =0;
            ControladorAccion = "javascript:void();";
            Mensaje="No se pudo validar la regla, consulte al administradior del sistema";
            
            Error =false;
            EsCompletado =false;
            tipoMensaje = TipoMensaje.warning;
        }
        }

        
        public static IEnumerable<ctProcesosActividad> getProcesosPadre()
        {
            bdNovaEntities bd = new bdNovaEntities();
            var  result =
                (from procesos in bd.Procesos_ctProcesosActividad
                 where procesos.IdProcesoActividadPadre == -1 orderby procesos.Orden

                 select new ctProcesosActividad
                 {
                     ProcesoActividad = procesos.ProcesoActividad,
                     IdProcesosActividad = procesos.IdProcesosActividad,
                     CssClass = procesos.CssClass,
                     MensajeAlerta = procesos.MensajeAlerta,
                     MensajeError = procesos.MensajeError,
                     MensajeInformacion = procesos.MensajeInformacion,
                     MensajeExito = procesos.MensajeExito,
                     ControladorAccion = procesos.ControladorAccion,
                     AñoEjecucion = procesos.AñoEjecucion,
                     MesEjecucion = procesos.MesEjecucion,
                     DiaEjecucion = procesos.DiaEjecucion,
                     EsMostrarEnPadre = procesos.EsMostrarEnPadre,
                     EsCompletado = procesos.EsCompletado == null ? false : procesos.EsCompletado,
                     EsEjecutadoUnaVez = procesos.EsEjecutadoUnaVez,
                     Orden=procesos.Orden
                 });

            return (IEnumerable<ctProcesosActividad>)result;


        }

        public static IEnumerable<ctProcesosActividad> getProcesosHijos(short idpadre)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var result =
                (from procesos in bd.Procesos_ctProcesosActividad
                 where procesos.IdProcesoActividadPadre == idpadre
                 orderby procesos.Orden

                 select new ctProcesosActividad
                 {
                    ProcesoActividad = procesos.ProcesoActividad,
                    IdProcesosActividad =procesos.IdProcesosActividad ,
                    ControladorAccion = procesos.ControladorAccion,
                    MensajeAlerta =procesos.MensajeAlerta ,
                    MensajeError =procesos.MensajeError,
                    MensajeInformacion =procesos.MensajeInformacion,
                    MensajeExito =procesos.MensajeExito,
                  
                    AñoEjecucion =procesos.AñoEjecucion,
                    MesEjecucion=procesos.MesEjecucion,
                    DiaEjecucion =procesos.DiaEjecucion,
                    EsMostrarEnPadre =procesos.EsMostrarEnPadre,
                    EsCompletado = procesos.EsCompletado == null ? false : procesos.EsCompletado,
                    EsEjecutadoUnaVez =procesos.EsEjecutadoUnaVez,
                    Orden = procesos.Orden
                 });

            return (IEnumerable<ctProcesosActividad>)result;


        }

        private static void createElementosMenu(ref string ResultHtmlpass ,short idpadre,short id,string ProcesoActividad,string lnksubmenu,bool escompletado,string controladoraccion)
        {
            string texto = "x";
            string spanTipoMensaje = "";
            string spanTipoMensaje2 = "";
            string contenido= "";

            string html_li_Id = "subli_lnkint_" + id.ToString();

            if (idpadre == 0)
            {
                html_li_Id = "li_lnkint_" + id.ToString();
            }
            

  ValidacionProcesosActividad validacion = new ValidacionProcesosActividad();
              

            if (escompletado)
            {
                texto = "F";
                if (idpadre == 0)
                {
                    validacion = getRegla(id, ProcesoActividad, controladoraccion);

                    if (validacion.Error)
                    {

                        //spanTipoMensaje = "<span class='infoBox " + validacion.tipoMensaje + "'>" + validacion.Mensaje + "</span>";
                     //   spanTipoMensaje = "<div><a id='lnkint_'" + id.ToString() + "  href='" + validacion.ControladorAccion + "' ><img class='tooltip' data-tooltiptext='" + validacion.Mensaje + "' src='" + validacion.ImagenHtml + "' alt='' original-title='' style='cursor: pointer;' ></a></div>";
                        spanTipoMensaje2 = "<div><a id='lnkint_" + id.ToString() + "'  href='" + validacion.ControladorAccion + "' target='_blank' ><img class='popovers' data-trigger='hover' data-placement='top' data-original-title='xxx' data-content='" + validacion.Mensaje + "' src='" + validacion.ImagenHtml + "' alt='' original-title='' style='cursor: pointer;' ></a></div>";
                    }
                }
            }
            else
            {
                validacion = getRegla(id, ProcesoActividad, controladoraccion);
                if (validacion.Error)
                {

                    //spanTipoMensaje = "<span class='infoBox " + validacion.tipoMensaje + "'>" + validacion.Mensaje + "</span>";
                   // spanTipoMensaje = "<div><a id='lnkint_'" + id.ToString() + "  href='" + validacion.ControladorAccion + "' ><img class='tooltip' data-tooltiptext='" + validacion.Mensaje + "' src='" + validacion.ImagenHtml + "' alt='' original-title='' style='cursor: pointer;' ></a></div>";
                    spanTipoMensaje2 = "<div><a id='lnkint_" + id.ToString() + "'  href='" + validacion.ControladorAccion + "' ><img class='popovers' data-trigger='hover' data-placement='top' data-original-title='xxx' data-content='" + validacion.Mensaje + "' src='" + validacion.ImagenHtml + "' alt='' original-title='' style='cursor: pointer;' ></a></div>";
                }
            }


            contenido = "<li id='" + html_li_Id + "'>";
            contenido = contenido + "<a id='lnk" + lnksubmenu + "' href='" + controladoraccion + "' target='_blank'  onclick='a_onClick(&#34;#" + html_li_Id + "&#34;,&#34;#" + lnksubmenu + "&#34;);'>";
            contenido = contenido + "<span class='ca-icon'>" + texto + "</span>";
            contenido = contenido + "<div class='ca-content'>";
            contenido = contenido + "<h2 class='ca-main'>" + ProcesoActividad + "</h2>";
            contenido = contenido + "<h3 class='ca-sub'>Iniciar el sistema</h3>";
            contenido = contenido + "</div>";
            contenido = contenido + "</a>";
            contenido = contenido + "<div class='divimgTooltip'>";
            contenido = contenido + spanTipoMensaje;
            contenido = contenido + spanTipoMensaje2;
            contenido = contenido + "</div>";
            contenido = contenido + "</li>";

            ResultHtmlpass = ResultHtmlpass + contenido;

            //ResultHtmlpass.Append("<li>");
            //ResultHtmlpass.Append("<a id='lnk" + lnksubmenu + "' href='javascript:void();'  onclick='a_onClick(this,&#34;#" + lnksubmenu + "&#34;);'>");
            //ResultHtmlpass.Append("<span class='ca-icon'>" + texto + "</span>");
            
            //ResultHtmlpass.Append("<div class='ca-content'>");
            //ResultHtmlpass.Append("<h2 class='ca-main'>" + ProcesoActividad + "</h2>");
            //ResultHtmlpass.Append("<h3 class='ca-sub'>Iniciar el sistema</h3>");
            //ResultHtmlpass.Append("<div class='divimgTooltip'>");
            //ResultHtmlpass.Append(spanTipoMensaje);
            //ResultHtmlpass.Append("</div>");
            //ResultHtmlpass.Append("</div>");
            //ResultHtmlpass.Append("</a>");
            //ResultHtmlpass.Append("</li>");
        }

        private static string createJqueryPadres(short id )
        {

             string ResultHtml="";
            ResultHtml="<script>";
            ResultHtml=ResultHtml+"$(document).ready(function () {";

            ResultHtml=ResultHtml+"$('#submenu" + id.ToString() + "').hide();});";
            ResultHtml = ResultHtml+"</script>";

            return ResultHtml;
        }

        public static string getMenuProcesosPadre()
        {
            var padres= getProcesosPadre();

            int numeroelemento = 5;
            int indice = 0;
            short[] arrayPadres= new short[5];

             string ResultHtml= "";


            
            foreach (var item in padres)
	            {
                    indice = indice + 1;

                    arrayPadres[indice - 1] = item.IdProcesosActividad;


                    if (indice == 1)
                    {

                        ResultHtml = ResultHtml+"<ul class='ca-menu'>";
                        
                    }

                
                    createElementosMenu(ref ResultHtml,item.IdProcesoActividadPadre,item.IdProcesosActividad, item.ProcesoActividad,"submenu"+item.IdProcesosActividad.ToString(),(bool)item.EsCompletado,item.ControladorAccion);

                

                    if (indice == numeroelemento)
                    {
                        indice = 0;
                      //  ResultHtml.AppendLine();



                        ResultHtml = ResultHtml+"</ul>";

                        ResultHtml = ResultHtml+(getMenuProcesosHijos(arrayPadres));
                        
                    }
   
                }
         return ResultHtml;
        
        }

        public static string getMenuProcesosHijos(short[] arrayPadres)
        {
            string ResultHtml = "";

            foreach (var hijo in arrayPadres)
            {

                ResultHtml=ResultHtml+createJqueryPadres(hijo);
           
            var hijos = getProcesosHijos(hijo);

            int numeroelemento = 5;
            int indice = 0;

         
            
            ResultHtml=ResultHtml+"   <div  style= ' clear:both;' ></div>";
            ResultHtml=ResultHtml+"<div  id='submenu"+hijo.ToString()+"' style=' margin:20px; width: 100%;height: 100%;position: relative; display:block;'  >";

            foreach (var item in hijos)
            {
                indice = indice + 1;
                if (indice == 1)
                {

                    ResultHtml = ResultHtml+"<ul class='ca-childmenu'>";
                }

                createElementosMenu(ref ResultHtml,item.IdProcesoActividadPadre,item.IdProcesosActividad, item.ProcesoActividad,"submenu"+item.IdProcesosActividad.ToString(),(bool)item.EsCompletado,item.ControladorAccion);

                if (indice == numeroelemento)
                {
                    indice = 0;
                    
                    ResultHtml=ResultHtml+"</ul>";

                }

            }
            ResultHtml = ResultHtml+"</div>";
            }

            return ResultHtml;


        }

        private static ValidacionProcesosActividad getRegla(short id, string actividad,string controladoraccion) {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();

            using (var dbprocesos = new bdNovaEntities())
            {

                switch (actividad)
                {
                    case "Catálogos":

                        proceso = reglaCatalogos(id);

                        break;

                    case "Instituciones Financieras":
                        proceso = reglaInstitucionFinanciera(id, controladoraccion);
                        break;

                    case "Estatus de Trabajadores":
                        proceso = reglaEstatusTrabajadores(dbprocesos, id, controladoraccion);
                        break;
                    case "Forma de Pago":
                        proceso = reglaFormaPago(dbprocesos, id, controladoraccion);
                        break;

                    case "Salario Mínimo":
                        proceso = reglaSalarioMinimo(dbprocesos, id, controladoraccion);
                        break;

                    case "Zonas de Salario Mínimo":
                        proceso = reglaZonasSalarioMinimo(dbprocesos, id, controladoraccion);
                        break;

                    case "Tipos de Crédito":
                        proceso = reglaTiposCredito(dbprocesos, id, controladoraccion);
                        break;


                    case "Tipo de Incidencia":
                        proceso = reglaTipoIncidencia(dbprocesos, id, controladoraccion);
                        break;
    
                        
                }

                if (proceso.EsCompletado)
                {


                    dbprocesos.Procesos_ctProcesosActividad.Find(id).EsCompletado = true;
                  //  dbprocesos.Entry(dbprocesos.Procesos_ctProcesosActividad).State = System.Data.System.Data.Entity.EntityState.Modified;
                    dbprocesos.SaveChanges();


                }

            }
            return proceso;

        }

        private static ValidacionProcesosActividad reglaCatalogos(short id)
        {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();

            bdNovaEntities bd = new bdNovaEntities();

            var query = (from catalogo in bd.Procesos_ctProcesosActividad
                         where catalogo.IdProcesoActividadPadre == id && (catalogo.EsCompletado == null || catalogo.EsCompletado==false)
                         select new
                         {
                             ProcesoActividad = catalogo.ProcesoActividad
                         }).FirstOrDefault();

            if (query != null)
            {
                if (query.ProcesoActividad != null)
                {
                    proceso.EsCompletado = false;
                    proceso.Error = true;
                    proceso.Mensaje = "Debe de completar el proceso  " + query.ProcesoActividad + " para poder continuar";
                    proceso.tipoMensaje = TipoMensaje.error;

                }
            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;
            }

            var query2 = (from catalogo in bd.Procesos_ctProcesosActividad
                          where catalogo.IdProcesoActividadPadre == id && (catalogo.DiaEjecucion != null )
                          select new
                          {
                              ProcesoActividad = catalogo.ProcesoActividad,
                              mensaje=catalogo.MensajeInformacion,
                              ControladorAccion=catalogo.ControladorAccion
                          }).FirstOrDefault();

            if (query2 != null)
            {
                if (query2.ProcesoActividad != null)
                {
                    proceso.EsCompletado = false;
                    proceso.Error = true;
                    proceso.Mensaje = " Debe de atender el siguiente proceso" + query2.ProcesoActividad + " para poder continuar";
                    proceso.tipoMensaje = TipoMensaje.warning;
                    proceso.ControladorAccion = query2.ControladorAccion;

                }
            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;
            }
                    return proceso;
        }

        private static ValidacionProcesosActividad reglaInstitucionFinanciera(short id,string controladoraccion)
        {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();

            bdNovaEntities bd = new bdNovaEntities();
            var query = (from catalogo in bd.Catalogos_ctInstitucionFinanciera
                         
                         select new
                         {
                             ProcesoActividad = catalogo.InstitucionFinanciera
                         }).FirstOrDefault();

            if (query == null)
            //if (query.InstitucionFinanciera != null)
            {
                proceso.EsCompletado = false;
                proceso.Error = true;
                proceso.Mensaje = "Debe de agregar un registro al menos para poder continuar";
                proceso.tipoMensaje = TipoMensaje.error;
                proceso.ControladorAccion = controladoraccion;


            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;
            }

            return proceso;
        }

        private static ValidacionProcesosActividad reglaEstatusTrabajadores( bdNovaEntities bdcontext, short id, string controladoraccion)
        {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();


            var query = bdcontext.Catalogos_ctInstitucionFinanciera.FirstOrDefault();

            if (query == null )
            //if (query.InstitucionFinanciera != null)
            {
                proceso.EsCompletado = false;
                proceso.Error = true;
                proceso.Mensaje = "Debe de agregar un registro al menos en EstatusTrabajadores para poder continuar";
                proceso.tipoMensaje = TipoMensaje.error;
                proceso.ControladorAccion = controladoraccion;


            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;


            }

            return proceso;
        }

        private static ValidacionProcesosActividad reglaFormaPago(bdNovaEntities bdcontext, short id, string controladoraccion)
        {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();


            var query = bdcontext.Catalogos_ctFormaDePago.FirstOrDefault();

            if (query == null)
            //if (query.InstitucionFinanciera != null)
            {
                proceso.EsCompletado = false;
                proceso.Error = true;
                proceso.Mensaje = "Debe de agregar un registro al menos en Formas De Pago para poder continuar";
                proceso.tipoMensaje = TipoMensaje.error;
                proceso.ControladorAccion = controladoraccion;


            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;


            }

            return proceso;
        }


        
            private static ValidacionProcesosActividad reglaZonasSalarioMinimo(bdNovaEntities bdcontext, short id, string controladoraccion)
        {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();


            var query = bdcontext.Catalogos_ctZonaSalarioMinimo.FirstOrDefault();

            if (query == null)
            //if (query.InstitucionFinanciera != null)
            {
                proceso.EsCompletado = false;
                proceso.Error = true;
                proceso.Mensaje = "Debe de agregar un registro al menos en Zonas Salario Mínimo para poder continuar";
                proceso.tipoMensaje = TipoMensaje.error;
                proceso.ControladorAccion = controladoraccion;


            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;


            }

            return proceso;
        }
        private static ValidacionProcesosActividad reglaSalarioMinimo(bdNovaEntities bdcontext, short id, string controladoraccion)
        {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();


            var query = bdcontext.Catalogos_ctSalarioMinimo.FirstOrDefault();

            if (query == null)
            //if (query.InstitucionFinanciera != null)
            {
                proceso.EsCompletado = false;
                proceso.Error = true;
                proceso.Mensaje = "Debe de agregar un registro al menos en Salario Mínimo para poder continuar";
                proceso.tipoMensaje = TipoMensaje.error;
                proceso.ControladorAccion = controladoraccion;


            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;


            }

            return proceso;
        }

        private static ValidacionProcesosActividad reglaTiposCredito(bdNovaEntities bdcontext, short id, string controladoraccion)
        {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();


            var query = bdcontext.Catalogos_ctTipoCredito.FirstOrDefault();

            if (query == null)
            //if (query.InstitucionFinanciera != null)
            {
                proceso.EsCompletado = false;
                proceso.Error = true;
                proceso.Mensaje = "Debe de agregar un registro al menos en Tipo de Credito para poder continuar";
                proceso.tipoMensaje = TipoMensaje.error;
                proceso.ControladorAccion = controladoraccion;


            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;


            }

            return proceso;
        }

        private static ValidacionProcesosActividad reglaTipoIncidencia(bdNovaEntities bdcontext, short id, string controladoraccion)
        {
            ValidacionProcesosActividad proceso = new ValidacionProcesosActividad();


            var query = bdcontext.Catalogos_ctTipoIncidencia.FirstOrDefault();

            if (query == null)
            //if (query.InstitucionFinanciera != null)
            {
                proceso.EsCompletado = false;
                proceso.Error = true;
                proceso.Mensaje = "Debe de agregar un registro al menos en Tipo de Incidencia para poder continuar";
                proceso.tipoMensaje = TipoMensaje.error;
                proceso.ControladorAccion = controladoraccion;


            }
            else
            {
                proceso.EsCompletado = true;
                proceso.Error = false;


            }

            return proceso;
        }

    }
}