﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Nomina
{
    public class NominaReportes
    {
    }
    public class AñosNomina
    {
        public int IdAño { get; set; }
        public int Año { get; set; }

    }
    public class MovimientoAdm
    {
        public int Ide { get; set; }
        public string Nombre { get; set; }
        public int Rembolso { get; set; }
        public int DiasDescuento { get; set; }
        public string Observaciones { get; set; }

    }
    public class CreditoTrabajador
    {
        public int IdCreditoTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Ide { get; set; }
        public string EstatusTrabajador { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public short IdTipoCredito { get; set; }

        public decimal VecesSalarioMinimo { get; set; }
        public decimal CuotaFija { get; set; }
        public decimal Porcentaje { get; set; }
        public DateTime FechaInicioCredito { get; set; }
        public DateTime FechaInicioDescuento { get; set; }
        public DateTime? FechaTermino { get; set; }
        public decimal ImporteCredito { get; set; }
        public short Parcialidades { get; set; }
        public decimal Saldo { get; set; }
        public short ParcialidadesPagadas { get; set; }
        public string NumeroCredito { get; set; }
        public string IdEmpleado { get; set; }
        public string NoFonacot { get; set; }
        public Boolean EsAplicado { get; set; }
        public Boolean EsParaDevolucion { get; set; }
        public Boolean EsYaDevuelto { get; set; }
        public short IdCreditoTrabajadorFactor { get; set; }

        public Boolean AjusteFactorAplicado { get; set; }
        public string TipoCredito        { get; set; }

        public short IdCreditoTipoDescuento { get; set; }
        public string CreditoTipoDescuento { get; set; }


    }
    public class PerDeduc
    {
        public string Concepto { get; set; }
        public decimal Importe { get; set; }
        public string Partida { get; set; }

        public Int64 CuentaTrabajadores { get; set; }
    }


    public class MovimientosPersonal
    {
        public int IdKardexSuplente { get; set; }
        public int IdKardexSuplido { get; set; }
        public string QUINCENA { get; set; }
        public string IDE    { get; set; }
        public string PLAZA  { get; set; }
        public string CURP   { get; set; }
        public string SUPLENTE { get; set; }
        public string SUPLIDO { get; set; }
        public string CATEGORIA  { get; set; }
        public string MOD { get; set; }
        public DateTime FECHAALTA            { get; set; }
        public DateTime FECHABAJA        { get; set; }
        public string OBSERVACIONES    { get; set; }
        public string ADSCRIPCION       { get; set; }
        public string LABORAFISICAMENTE { get; set; }
        public string RELACIONLABORAL { get; set; }
        public DateTime FECHAINICIO        { get; set; }
        public DateTime FECHATERMINO        { get; set; }

    }

    public class DeduccionesAdscripcion
    {
       
        public string RelacionConvenioLaboral { get; set; }
       
        public int IdModalidadEstudio { get; set; }

        public string ModalidadEstudio { get; set; }

        
        public string EstructuraOrganica { get; set; }

        public string Deduccion { get; set; }

        public decimal Importe { get; set; }


    }
     
        public class SaldosFinancierosPartidaEstructura
    {
        
            public string ConvenioLaboralTipo { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public string Concepto { get; set; }
        public string Partida { get; set; }
        public decimal C1 { get; set; }
        public decimal C2 { get; set; }
        public string perded { get; set; }

    }

    public class ProyectoConcepto
    {
        public List<PerDeduc> Percepciones{ get; set; }
        public List<PerDeduc> Deducciones { get; set; }

    }
    public class ConceptoImportesDevolucion
    {
        public string Concepto { get; set; }
        public decimal Tramitado { get; set; }
        public decimal Pagado { get; set; }
        public decimal Devolucion { get; set; }




    }

    public class ListaDevolucionesNomina
    {
        public string Nomina { get; set; }
        public string Trabajador { get; set; }
        public string Adscripcion { get; set; }
        public string Categoria { get; set; }
        public Decimal Monto { get; set; }
        public string Periodo { get; set; }
        public string Motivo { get; set; }
        public string EncuadreProgramatico { get; set; }

        public List<ConceptoImportesDevolucion> Devoluciones { get; set; }



    }

    public static class Reportes
    {
        
        public static List<SaldosFinancierosPartidaEstructura> SaldosFinancierosPartida(string fi, string ff, string convenio, string grupo,string idfin)
        {
            string condicion = "";
            
            condicion = "(CAST(b.FechaInicio as date) = CAST('" + fi + "' as date) AND CAST(b.FechaTermino as date) = CAST('" + ff + "' as date))" + "  and m.EstatusNomina <> 'CANCELADO' " + "  and i.idplantillagrupo =" + grupo;
            if (idfin!="0" && idfin!=null)            
            condicion = condicion + " and tp.IdConvenioLaboralTipo =" + convenio + " and fg.IdInstitucionFinancieraGrupo="+idfin ;
         else
                condicion = condicion + " and tp.IdConvenioLaboralTipo =" + convenio +" ";

//            case when MAX(E.Percepcion) like '%DEVOLUCIÓN%' THEN(SELECT dd.[CuentaContable] FROM[vwDeduccionesDevoluciones] dd where
//dd.[DeduccionConcepto] = MAX(e.Percepcion) + ' ' + MAX(c.Concepto)) else case when max(e.CuentaContable) IS not null then MAX(e.CuentaContable) else case when max(j.CuentaContable) IS not null then MAX(j.CuentaContable) else MAX(pt.PartidaGenerica) + MAX(pt.PartidaEspecifica) end end end as Partida

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            dp.connection.SetPropertyValue("TimeOut", 300);
            string queryper = @"select zz.ConvenioLaboralTipo, zz.ConvenioLaboral,''+zz.Partida as Partida,MAX(zz.Concepto) as Concepto, SUM(zz.c1) as c1,SUM(zz.c2) as c2,MAX(zz.perded) as perded from (
select * from (
                select max(ConvenioLaboralTipo) as ConvenioLaboralTipo,
case when max(l.ConvenioLaboral) = 'DEFINITIVO SPD' then 'BASE' else max(l.ConvenioLaboral) end as ConvenioLaboral
,case when MAX(E.Percepcion) like '%DEVOLUCIÓN%' THEN (SELECT dd.[CuentaContable] FROM  [vwDeduccionesDevoluciones] dd where 
dd.[DeduccionConcepto]=MAX(e.Percepcion)+' '+MAX(c.Concepto)) 
 else max(pt.PartidaGenerica)+max(pt.PartidaEspecifica) end as Partida
,case when pt.Partida IS null then MAX(e.Percepcion)+' '+MAX(c.Concepto)   else pt.Partida end  as Concepto
,case when eo.IdModalidadEstudio=0 or eo.IdModalidadEstudio=1 then SUM(c.Importe) end  as c1
, case when eo.IdModalidadEstudio=2 then  SUM(c.Importe) end as c2
 , 'P' as perded
from Nomina_stNominaTrabajador a
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Percepciones_stNominaTrabajadorPercepciones c on c.IdNominaTrabajador=a.IdNominaTrabajador
inner join Percepciones_stPlantillaNominaPercepciones d on d.IdPlantillaNominaPercepcion=c.IdPlantillaNominaPercepcion
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Percepciones_ctPercepcion e on e.IdPercepcion=d.IdPercepcion
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
left join Nomina_PartidasPercepciones g on g.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion
and g.Concepto=c.Concepto
left join Poa_Partidas pt on g.IdPartidas=pt.IdPartidas
left join vwNominaAjustesDevolucionesPercepciones j on j.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion and j.idnomina=b.IdNomina and a.IdNominaTrabajador=j.IdNominaTrabajador
and j.IdNominaTrabajadorPercepcion=c.IdNominaTrabajadorPercepcion
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
LEFT JOIN Kardex_stTrabajadorCuentas kt on kt.IdTrabajador=cl.IdTrabajador
left join Catalogos_ctInstitucionFinanciera fi on fi.IdInstitucionFinanciera=kt.IdInstitucionFinanciera
left join Catalogos_ctInstitucionFinancieraGrupo fg on fg.IdInstitucionFinancieraGrupo=fi.IdInstitucionFinancieraGrupo
where EstatusNominaGrupo ='PARA PAGO' 
and " + condicion + @" group by Partida,eo.IdModalidadEstudio  ) as xx
union all

select * from (

select max(ConvenioLaboralTipo) as ConvenioLaboralTipo,
case when max(ConvenioLaboral) = 'DEFINITIVO SPD' then 'BASE' else max(ConvenioLaboral) end as ConvenioLaboral
,case when Concepto like '%DIFERENCIA%' THEN (SELECT dd.[CuentaContable] FROM  [vwDeduccionesDiferencias] dd where  dd.[DeduccionConcepto]=Concepto )
else Partida end as Partida
,case when Concepto like '%DIFERENCIA%' THEN (SELECT dd.[Deduccion] FROM  [vwDeduccionesDiferencias] dd where  dd.[DeduccionConcepto]=Concepto )
else Concepto end as Concepto
,case when IdModalidadEstudio=0 or IdModalidadEstudio=1 tHEN 
SUM(c1) end  as c1
, case when IdModalidadEstudio=2 then  
SUM(c2)
 end  as c2
 , 'D' as perded
 from (
select IdModalidadEstudio, ConvenioLaboralTipo as ConvenioLaboralTipo,
case when (l.ConvenioLaboral) = 'DEFINITIVO SPD' then 'BASE' else max(l.ConvenioLaboral) end as ConvenioLaboral
,e.CuentaContable as Partida
,(e.Deduccion)+' '+(c.Concepto) as Concepto
,case when eo.IdModalidadEstudio=0 or eo.IdModalidadEstudio=1 then 
case when (e.Deduccion)='IMSS' THEN 
SUM(c.Importe)-isnull((SELECT sum(a1.Importe)
  FROM    Nomina_stNominaTrabajador x1 
    inner join [Deducciones_stNominaTrabajadorDeduccion]  z1 on z1.IdNominaTrabajador=x1.IdNominaTrabajador
  inner join [Deducciones_stNominaTrabajadorSubDeducciones] a1 on a1.IdNominaTrabajadorDeduccion=z1.IdNominaTrabajadorDeduccion
  inner join [Deducciones_ctSubDeduccion] b1 on a1.[IdSubDeduccion]=b1.[IdSubDeduccion]
  inner join [Deducciones_TipoSubDeduccion] c1 on c1.IdTipoSubDeduccion=b1.IdTipoSubDeduccion
  where X1.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  and x1.IdNominaTrabajador=a.IdNominaTrabajador and z1.IdNominaTrabajadorDeduccion=c.IdNominaTrabajadorDeduccion
    and b1.Concepto='CESANTÍA EN EDAD AVANZADA Y VEJEZ'
  and TipoSubDeduccion='OBRERO'),0)
 else SUM(c.Importe) end   end  as c1
, case when eo.IdModalidadEstudio=2 then  
case when (e.Deduccion)='IMSS' THEN 
SUM(c.Importe)-isnull((SELECT sum(a1.Importe)
  FROM    Nomina_stNominaTrabajador x1 
    inner join [Deducciones_stNominaTrabajadorDeduccion]  z1 on z1.IdNominaTrabajador=x1.IdNominaTrabajador
  inner join [Deducciones_stNominaTrabajadorSubDeducciones] a1 on a1.IdNominaTrabajadorDeduccion=z1.IdNominaTrabajadorDeduccion
  inner join [Deducciones_ctSubDeduccion] b1 on a1.[IdSubDeduccion]=b1.[IdSubDeduccion]
  inner join [Deducciones_TipoSubDeduccion] c1 on c1.IdTipoSubDeduccion=b1.IdTipoSubDeduccion
  where X1.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  and x1.IdNominaTrabajador=a.IdNominaTrabajador and z1.IdNominaTrabajadorDeduccion=c.IdNominaTrabajadorDeduccion
    and b1.Concepto='CESANTÍA EN EDAD AVANZADA Y VEJEZ'
  and TipoSubDeduccion='OBRERO'),0)
 else SUM(c.Importe)end  end  as c2
 , 'D' as perded
from Nomina_stNominaTrabajador a
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Deducciones_stNominaTrabajadorDeduccion c on c.IdNominaTrabajador=a.IdNominaTrabajador
inner join Deducciones_stPlantillaNominaDeducciones d on d.IdPlantillaNominaDeduccion=c.IdPlantillaNominaDeduccion
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Deducciones_ctDeduccion e on e.IdDeduccion=d.IdDeduccion
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
LEFT JOIN Kardex_stTrabajadorCuentas kt on kt.IdTrabajador=cl.IdTrabajador
left join Catalogos_ctInstitucionFinanciera fi on fi.IdInstitucionFinanciera=kt.IdInstitucionFinanciera
left join Catalogos_ctInstitucionFinancieraGrupo fg on fg.IdInstitucionFinancieraGrupo=fi.IdInstitucionFinancieraGrupo
where EstatusNominaGrupo ='PARA PAGO' and " + condicion + @"  group by ConvenioLaboralTipo,e.CuentaContable,a.IdConvenioLaboralTrabajadorCategoria,a.IdNominaTrabajador,c.IdNominaTrabajadorDeduccion,e.Deduccion,c.Concepto, eo.IdModalidadEstudio,l.ConvenioLaboral 
) as rr group by Partida, Concepto,IdModalidadEstudio

union all 
select max(ConvenioLaboralTipo) as ConvenioLaboralTipo,
case when max(l.ConvenioLaboral) = 'DEFINITIVO SPD' then 'BASE' else max(l.ConvenioLaboral) end as ConvenioLaboral
,e.CuentaContable as Partida
,max(b1.Concepto) as Concepto
,case when eo.IdModalidadEstudio=0 or eo.IdModalidadEstudio=1 tHEN 
SUM(a1.Importe) end  as c1
, case when eo.IdModalidadEstudio=2 then  
SUM(a1.Importe)
 end  as c2
 , 'D' as perded
from Nomina_stNominaTrabajador a
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Deducciones_stNominaTrabajadorDeduccion c on c.IdNominaTrabajador=a.IdNominaTrabajador
inner join [Deducciones_stNominaTrabajadorSubDeducciones] a1 on a1.IdNominaTrabajadorDeduccion=c.IdNominaTrabajadorDeduccion
  inner join [Deducciones_ctSubDeduccion] b1 on a1.[IdSubDeduccion]=b1.[IdSubDeduccion]
  inner join [Deducciones_TipoSubDeduccion] c1 on c1.IdTipoSubDeduccion=b1.IdTipoSubDeduccion
inner join Deducciones_stPlantillaNominaDeducciones d on d.IdPlantillaNominaDeduccion=c.IdPlantillaNominaDeduccion
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Deducciones_ctDeduccion e on e.IdDeduccion=d.IdDeduccion
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
LEFT JOIN Kardex_stTrabajadorCuentas kt on kt.IdTrabajador=cl.IdTrabajador
left join Catalogos_ctInstitucionFinanciera fi on fi.IdInstitucionFinanciera=kt.IdInstitucionFinanciera
left join Catalogos_ctInstitucionFinancieraGrupo fg on fg.IdInstitucionFinancieraGrupo=fi.IdInstitucionFinancieraGrupo
  where 
  b1.Concepto='CESANTÍA EN EDAD AVANZADA Y VEJEZ'
  and TipoSubDeduccion='OBRERO'
and EstatusNominaGrupo ='PARA PAGO' and " + condicion + @" group by e.CuentaContable,e.Deduccion,c.Concepto, eo.IdModalidadEstudio
) as yy 
 union all 
 select * from (
select max(ConvenioLaboralTipo) as ConvenioLaboralTipo,
case when max(l.ConvenioLaboral) = 'DEFINITIVO SPD' then 'BASE' else max(l.ConvenioLaboral) end as ConvenioLaboral
, tc.CuentaContable as Partida
, case when cn.EsAjuste=1 then 'AJUSTE '+ e.Deduccion+' '+emc.Empresa ELSE e.Deduccion+' '+emc.Empresa END as Concepto
,case when eo.IdModalidadEstudio=0 or eo.IdModalidadEstudio=1 then SUM(cn.Importe) end  as c1
, case when eo.IdModalidadEstudio=2 then  SUM(cn.Importe) end as c2
 , 'D' as perded
from Creditos_stNominaCreditoTrabajador cn
inner join Creditos_stCreditoTrabajador cr on cn.IdCreditoTrabajador=cr.IdCreditoTrabajador
inner join Catalogos_ctTipoCredito tc on tc.IdTipoCredito=cr.IdTipoCredito
inner join Catalogos_ctCreditosEmpresas emc on emc.IdCreditosEmpresas=tc.IdCreditosEmpresas
inner join Deducciones_ctDeduccion e on e.IdDeduccion=tc.IdDeduccion
inner join Nomina_stNominaTrabajador a on cn.IdNominaTrabajador=a.IdNominaTrabajador 
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
 inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
LEFT JOIN Kardex_stTrabajadorCuentas kt on kt.IdTrabajador=cl.IdTrabajador
left join Catalogos_ctInstitucionFinanciera fi on fi.IdInstitucionFinanciera=kt.IdInstitucionFinanciera
left join Catalogos_ctInstitucionFinancieraGrupo fg on fg.IdInstitucionFinancieraGrupo=fi.IdInstitucionFinancieraGrupo
where EstatusNominaGrupo ='PARA PAGO' and " + condicion + @"  group by tc.CuentaContable, e.Deduccion,emc.Empresa,cn.EsAjuste,eo.IdModalidadEstudio) as zz
 union all 
 select * from (
select max(ConvenioLaboralTipo) as ConvenioLaboralTipo,
case when max(l.ConvenioLaboral) = 'DEFINITIVO SPD' then 'BASE' else max(l.ConvenioLaboral) end as ConvenioLaboral
,e.CuentaContable as Partida
,max(cn.Concepto)+' '+max(tc.TipoPension)  as Concepto
,case when eo.IdModalidadEstudio=0 or eo.IdModalidadEstudio=1 then SUM(cn.Importe) end  as c1
, case when eo.IdModalidadEstudio=2 then  SUM(cn.Importe) end as c2
 , 'D' as perded
from Pensiones_stNominaPensionTrabajador cn
inner join Pensiones_stPensionesTrabajador cr on cn.IdPensionTrabajador=cr.IdPensionTrabajador
inner join Pensiones_ctTipoPension tc on tc.IdTipoPension=cr.IdTipoPension
inner join Deducciones_ctDeduccion e on e.IdDeduccion=tc.IdDeduccion
inner join Nomina_stNominaTrabajador a on cn.IdNominaTrabajador=a.IdNominaTrabajador
inner join  Nomina_stNomina b on a.IdNomina=b.IdNomina
inner join Nomina_ctPlantillaNomina i on i.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo ig on ig.IdPlantillaGrupo=i.IdPlantillaGrupo
inner join Nomina_stNominaTrabajadorEstatus m on m.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Convenios_stConvenioLaboralTrabajadorCategoria ct on a.IdConvenioLaboralTrabajadorCategoria=ct.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica eo on ct.IdEstructuraOrganica = eo.IdEstructuraOrganica
 inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=h.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo tp on tp.IdConvenioLaboralTipo=l.IdConvenioLaboralTipo
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Convenios_stConvenioLaboralTrabajador cl on cl.IdConvenioLaboralTrabajador=ct.IdConvenioLaboralTrabajador
LEFT JOIN Kardex_stTrabajadorCuentas kt on kt.IdTrabajador=cl.IdTrabajador
left join Catalogos_ctInstitucionFinanciera fi on fi.IdInstitucionFinanciera=kt.IdInstitucionFinanciera
left join Catalogos_ctInstitucionFinancieraGrupo fg on fg.IdInstitucionFinancieraGrupo=fi.IdInstitucionFinancieraGrupo
where EstatusNominaGrupo ='PARA PAGO' and " + condicion + @" group by e.CuentaContable,e.Deduccion,cn.Concepto,eo.IdModalidadEstudio) as pp)
 as zz   
group by ConvenioLaboralTipo, ConvenioLaboral,Partida,Concepto ORDER BY perded desc,Partida asc";

            //order by ConvenioLaboral,Partida";
            Dapper.SqlMapper.Settings.CommandTimeout = 300;
            List<SaldosFinancierosPartidaEstructura> concentrado = (List<SaldosFinancierosPartidaEstructura>)dp.connection.Query<SaldosFinancierosPartidaEstructura>(queryper);

            

            return concentrado;
        }

        public static List<CreditoTrabajador> GetCreditosVigentes()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"SELECT c.Nombre,c.ApellidoPaterno,c.ApellidoMaterno,c.IdTrabajador as Ide,EstatusTrabajador,C.RelacionConvenioLaboral, a.*,b.*,d.*
  FROM  [Creditos_stCreditoTrabajador] a
  inner join [Catalogos_ctTipoCredito] b on a.IdTipoCredito=b.IdTipoCredito
  inner join Creditos_ctCreditoTipoDescuento d on a.IdCreditoTipoDescuento=d.IdCreditoTipoDescuento
  inner join vwDatosAspirantesTrabajadores c on a.IdTrabajador=c.IdTrabajador
  where   c.RestringirMenu is null and c.EstatusTrabajador='ALTA'
 
  and (a.fechatermino is null or a.FechaTermino >GETDATE())";
            List<CreditoTrabajador> listat = (List<CreditoTrabajador>)dp.connection.Query<CreditoTrabajador>(query);
            dp.Close();
            return listat.ToList();

        }

        public static List<Quincena> GetQuincenaMesNomina()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select max(a.IdQuincenaMes) as IdQuincenaMes,a.QuincenaMes+'-'+max(b.Mes) as QuincenaMes from Catalogos_ctQuincenaMes a
            inner join Catalogos_ctMes b on a.IdMes = b.IdMes
            inner join Nomina_stNomina c on a.IdQuincenaMes=c.IdQuincenaMes
            group by a.QuincenaMes
            order by a.QuincenaMes";
            List<Quincena> listat = (List<Quincena>)dp.connection.Query<Quincena>(query);
            dp.Close();
            return listat.ToList();

        }
        public static List<Quincena> GetQuincenaMesParaNomina()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select max(a.IdQuincenaMes) as IdQuincenaMes,a.QuincenaMes+'-'+max(b.Mes) as QuincenaMes from Catalogos_ctQuincenaMes a
            inner join Catalogos_ctMes b on a.IdMes = b.IdMes
            inner join Nomina_stNomina c on a.IdQuincenaMes=c.IdQuincenaMes
            group by a.QuincenaMes
            order by a.QuincenaMes";
            List<Quincena> listat = (List<Quincena>)dp.connection.Query<Quincena>(query);
            dp.Close();
            return listat.ToList();

        }

        public static List<AñosNomina> GetAñosNomina()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"        select Año as IdAño, año from Nomina_stNomina
            group by Año";
            List<AñosNomina> listat = (List<AñosNomina>)dp.connection.Query<AñosNomina>(query);
            dp.Close();
            return listat.ToList();

        }

        public static List<AñosNomina> GetAñosParaNomina()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"        select Año as IdAño, año from Nomina_stNomina
            group by Año";
            List<AñosNomina> listat = (List<AñosNomina>)dp.connection.Query<AñosNomina>(query);
            dp.Close();
            return listat.ToList();

        }

    }
}