﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Nomina
{
    public class MemoriaCalculo
    {
        public int IDE { get; set; }
        public string NOMBRE { get; set; }
        public string CATEGORIA { get; set; }
        public string RELACIONLABORAL { get; set; }
        public string PROYECTO { get; set; }
        public string LABORAFISICAMENTE { get; set; }
        public int PARTIDA { get; set; }
        public string NOMBREPARTIDA { get; set; }
        public string Clave { get; set; }
        public string PERCEPCION { get; set; }
        public decimal IMPORTE { get; set; }

    }
    public class PartidaIde
    {
        public int PARTIDA { get; set; }
        public string NOMBREPARTIDA { get; set; }
        public int IDE { get; set; }
        public string NOMBRE { get; set; }
        public string CATEGORIA { get; set; }
        public string RELACIONLABORAL { get; set; }
        public string PROYECTO { get; set; }
        public string LABORAFISICAMENTE { get; set; }

    }
    public class PartidaPercepcion
    {
        public int PARTIDA { get; set; }
        public string PERCEPCION { get; set; }

    }

    public class NominaMemoria
    {
        public static List<MemoriaCalculo> GetMemoriaNomina (int id)
            {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"
select i.IdTrabajador as IDE,i.ApellidoPaterno+' '+i.ApellidoMaterno+' '+i.Nombre as NOMBRE
,I.Categoria AS CATEGORIA,i.RelacionLaboral as RELACIONLABORAL
,j.EstructuraProgramatica as PROYECTO
,i.UbicacionFisica as LABORAFISICAMENTE
,h.PartidaGenerica+h.PartidaEspecifica as PARTIDA
,H.Partida AS NOMBREPARTIDA
,k.Clave
,k.Percepcion AS PERCEPCION
,e.Importe AS IMPORTE
from Nomina_stNomina a
inner join Nomina_ctPlantillaNomina c on a.IdPlantillaNomina=c.IdPlantillaNomina
inner join Nomina_ctTipoNomina b on b.IdTipoNomina=c.IdTipoNomina
inner join Nomina_stNominaTrabajador d on a.IdNomina = d.IdNomina
inner join Percepciones_stNominaTrabajadorPercepciones e on d.IdNominaTrabajador=e.IdNominaTrabajador
inner join Percepciones_stPlantillaNominaPercepciones f on f.IdPlantillaNominaPercepcion=e.IdPlantillaNominaPercepcion
inner join Percepciones_ctPercepcion k on f.IdPercepcion=k.IdPercepcion
inner join Nomina_PartidasPercepciones g on f.IdPlantillaNominaPercepcion=g.IdPlantillaNominaPercepcion
inner join Poa_Partidas h on g.IdPartidas=h.IdPartidas -- and a.Año=h.Año
left join vwDatosAspirantesTrabajadoresHistorial i on d.IdConvenioLaboralTrabajadorCategoria=i.IdConvenioLaboralTrabajadorCategoria
left join Catalogos_ctEstructuraOrganica j on i.IdEstructuraOrganica=j.IdEstructuraOrganica
where a.IdNomina="+ id + " and a.EsCerrada=1 order by PARTIDA,IDE,PERCEPCION "; 

            List<MemoriaCalculo> listat = (List<MemoriaCalculo>)dp.connection.Query<MemoriaCalculo>(query);
            dp.Close();
            return listat.ToList();

        }
    }
}