﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Nomina
{
    public class NominaHelper
    {
        /// <summary>
        /// Método para obtener la quincena anterior. 
        /// Si es la quincena 1, regresa la quincena 24 del año anterior.
        /// </summary>
        /// <param name="quincenaActual">Número de la quincena actual (1 a 24).</param>
        /// <param name="anioActual">Año actual.</param>
        /// <returns>Una tupla con el número de la quincena anterior y el año correspondiente.</returns>
        public (int quincenaAnterior, int anioAnterior) ObtenerQuincenaAnterior(int quincenaActual, int anioActual)
        {
            int quincenaAnterior;
            int anioAnterior = anioActual;

            // Si la quincena es mayor a 1, solo restamos 1
            if (quincenaActual > 1)
            {
                quincenaAnterior = quincenaActual - 1;
            }
            else
            {
                // Si es quincena 1, entonces es la quincena 24 del año anterior
                quincenaAnterior = 24;
                anioAnterior = anioActual - 1;
            }

            return (quincenaAnterior, anioAnterior);
        }
    }

}