﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    [MetadataType(typeof(MstComentariosTicketMetaData))]
    public partial class Mst_ComentariosTicket
    {
    }
    public class MstComentariosTicketMetaData
    {
        public object IdComentarioMv { get; set; }

        [Required(ErrorMessage ="El campo Comentario es requerido")]
        public object Comentario { get; set; }

        public object FechaComentarioMv { get; set; }

        [Display(Name ="Público")]
        public object Publico { get; set; }
        public object IdUsuarioComentarioMv { get; set; }
        public object IdTicket { get; set; }

        [Display(Name ="Proceso")]
        [Required(ErrorMessage ="El campo Proceso es requerido.")]
        [Range(1, Int16.MaxValue, ErrorMessage = "El valor {0} no es válido para Proceso En Existencia")]
        public object IdProcesoAtencionTicket { get; set; }

        [Display(Name ="Prioridad")]
        [Required(ErrorMessage ="El campo Prioridad es requerido.")]
        [Range(1, Int16.MaxValue, ErrorMessage = "El valor {0} no es válido para Prioridad En Existencia")]
        public object IdPrioridadTicket { get; set; }

        [Display(Name ="Estatus")]
        [Required(ErrorMessage ="El campo Estatus es requerido.")]
        [Range(1, Int16.MaxValue, ErrorMessage = "El valor {0} no es válido para Estatus En Existencia")]
        public object IdEstatusTicket { get; set; }

        [Display(Name ="Usuario")]
        [Required(ErrorMessage ="El campo Usuario es requerido.")]
        [Range(1, Int16.MaxValue, ErrorMessage = "El valor {0} no es válido para Usuario En Existencia")]
        public object IdUsuarioAsignado { get; set; }
    }

}