﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    [MetadataType(typeof(MstSolucionMetaData))]
    public partial class Mst_SolucionReporte
    {
    }

    public class MstSolucionMetaData
    {
        public object IdSolucionReporte { get; set; }

        [Display(Name ="Solución")] 
        [Required(ErrorMessage ="El campo Solución es requerido.")]
        public object SolucionReporte { get; set; }

        [Display(Name ="Fecha")]
        public object FechaSolucion { get; set; }

        [Display(Name ="Tipo Solución")]
        [Required(ErrorMessage ="El campo Tipo Solución es requerido.")]
        [Range(1, Int16.MaxValue, ErrorMessage = "El valor {0} no es válido para Tipo En Existencia")]
        public object IdTipoSolucion { get; set; }

        [Display(Name ="Reporte")]
        public object IdReporte { get; set; }

        [Display(Name ="Usuario")]
        public object IdConvenioLaboralTrabajadorCategoria { get; set; }
    }

}