﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;

namespace Nova.Models
{
    [MetadataType(typeof(MstEstructuraOrganicaProveedorInternetMetaData))]
    public partial class Mst_EstructuraOrganicaProveedorInternet
    {
    }

    public class MstEstructuraOrganicaProveedorInternetMetaData
    {
        public int IdEstructuraOrganicaProveedorInternet { get; set; }

        [Required]
        [Display(Name ="Proveedor de Internet")]
        [Range(1,Int32.MaxValue,ErrorMessage ="El valor para {0} no es válido")]
        public int IdProveedorTipoServicio { get; set; }

        [Required]
        [Display(Name ="Tipo de Internet")]
        [Range(1,Int32.MaxValue,ErrorMessage ="El valor para {0} no es válido")]
        public int IdTipoInternet { get; set; }

        [Required]
        public int Velocidad { get; set; }

        [Required]
        [Display(Name ="Costo Mensual")]
        public decimal CostoMensual { get; set; }

        [Required]
        [Display(Name ="Fecha Inicio")]
        [DataType(DataType.Date)]
        public System.DateTime FechaInicio { get; set; }

        [Required]
        [Display(Name = "Fecha Término")]
        [DataType(DataType.Date)]
        public System.DateTime FechaTermino { get; set; }

        [Required]
        [Display(Name ="Estructura Orgánica")]
        [Range(1,Int32.MaxValue, ErrorMessage ="El valor para {0} no es válido")]
        public short IdEstructuraOrganica { get; set; }
    }

}