﻿using System;
using System.ComponentModel.DataAnnotations;


namespace Nova.Models
{
    [MetadataType(typeof(MstModeloEquipoComputoMetaData))]
    public partial class Mst_ModeloEquipoComputo
    {
    }
    public class MstModeloEquipoComputoMetaData
    {
        [Display(Name ="Modelo Equipo")]
        [Required(ErrorMessage = "Campo Modelo es requerido")]
        [MinLength(3, ErrorMessage = "Ingrese más de {1} caracteres")]
        public object ModeloEquipoComputo { get; set; }

        [Display(Name ="Marca Equipo")]
        [Required(ErrorMessage = "Campo Marca es requerido")]
        [Range(1, Int16.MaxValue, ErrorMessage = "El valor {0} no es válido para Marca en Existencia")]
        public object IdMarcaEquipoComputo { get; set; }

        //[Display(Name = "Tipo Equipo")]
        //[Required(ErrorMessage = "Campo Tipo es requerido")]
        //[Range(1, Int16.MaxValue, ErrorMessage = "El valor {0} no es válido para Tipo en Existencia")]
        //public object TipoEquipoComputo { get; set; }
    }

}