﻿using System;
using System.ComponentModel.DataAnnotations;


namespace Nova.Models
{
    [MetadataType(typeof(MstMarcaEquipoComputoMetaData))]
    public partial class Mst_MarcaEquipoComputo
    {
    }
    public class MstMarcaEquipoComputoMetaData
    {
        [Display(Name ="Marca Equipo")]
        [Required(ErrorMessage = "Campo Marca es requerido")]
        [MinLength(3, ErrorMessage = "Ingrese más de {1} caracteres")]
        public object MarcaEquipoComputo { get; set; }

        [Display(Name ="Tipo Equipo")]
        [Required(ErrorMessage = "Campo Tipo es requerido")]
        [Range(1, Int16.MaxValue, ErrorMessage = "El valor {0} no es válido para Tipo en Existencia")]
        public object IdTipoEquipoComputo { get; set; }
    }
}