﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public partial class MaterialDidactico_stTrabajadorAsignatura
    {
        public static IEnumerable ObtenAsignaturas()
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.MaterialDidactico_Asignaturas.Select(h =>

                new
                {
                    h.IdAsignatura,
                    Asignatura = h.Asignatura,
                    Modal = h.MaterialDidactico_Modalidad.Modalidad,
                }).OrderBy(s =>s.Asignatura).ToList().Select(h =>
                    new
                    {
                        h.IdAsignatura,
                        Asignatura = h.Asignatura + "(" + h.Modal + ")"
                    });


        }
        public static IEnumerable ObtenTrabajadores()
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.Kardex_ctTrabajador.Select(h =>

                new
                {
                    h.IdTrabajador,
                    Nombre = h.Kardex_ctDatosPersonales.Nombre + " "+ h.Kardex_ctDatosPersonales.ApellidoPaterno + " " +h.Kardex_ctDatosPersonales.ApellidoMaterno,
                }).OrderBy(s => s.Nombre).ToList().Select(h =>
                    new
                    {
                        h.IdTrabajador,
                        Trabajador = h.Nombre 
                    });


        }

    }
}