﻿using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using Nova.Models;
namespace Nova.Models
{

    [MetadataType(typeof(Kardex_ctDatosPersonalesMetaData))]
    public partial class Kardex_ctDatosPersonales
    {



    }


    public class Kardex_ctDatosPersonalesMetaData
    {
        // [RequiredIf("Nombre","", ErrorMessage = "Debes de especificar el Nombre")]

        [Required]
        [StringLength(18, MinimumLength = 16)]
        //LOML020605MOCPRZA0
        [RegularExpression(@"[A-Z]{4}[0-9]{6}[HM][A-Z0-9]{5,7}$", ErrorMessage = "el formato debe de ser : AAAA999999AAAAAAAA")]
        public object CURP { get; set; }

        [Required]
        public object Nombre { get; set; }

        [Required]
        public object ApellidoPaterno { get; set; }

        [Required]
        public object ApellidoMaterno { get; set; }

        [Required]
        public object Sexo { get; set; }

        [Required]
        [StringLength(13, MinimumLength = 10)]
        //[RegularExpression(@"[A-Z]{4}[0-9]{6}[A-Z]{0,3}", ErrorMessage = "el formato debe de ser : AAAA999999[AAA]")]
        public object RFC { get; set; }

        [Required]
        public object Calle { get; set; }

        [Required]
        public object Colonia { get; set; }

        [Required]
        public object IdTipoSangre { get; set; }

        //[Required]
        public object CorreoElectronico { get; set; }

        [Required(ErrorMessage = "Debe de especificar una localidad de vivienda")]
        public object IdMunicipioVive { get; set; }


        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        public object NumeroInterior { get; set; }

        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        public object NumeroExterior { get; set; }



        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        //[StringLength(10, MinimumLength = 10)]
        public object TelefonoCelular { get; set; }

        //[StringLength(10, MinimumLength = 10)]
        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        public object Telefono { get; set; }


        [StringLength(3, ErrorMessage = "Máximo 3 caracteres")]
        public object Letra { get; set; }



        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        //[StringLength(10, MinimumLength = 10)]
        public object NSS { get; set; }


        [StringLength(maximumLength:150,ErrorMessage ="{0} no puede exceder de 150 caractéres.")]
        public object Padecimientos { get; set; }

        [StringLength(maximumLength: 150, ErrorMessage = "{0} no puede exceder de 150 caractéres.")]
        public object Alergias { get; set; }

        [Required(ErrorMessage = "Debe de especificar un correo electrónico")]
        public object CorreoElectronicoCFDI { get; set; }


        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        public object CodigoPostalCFDI { get; set; }


    }
}