﻿using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using Nova.Models;
namespace Nova.Models
{

    [MetadataType(typeof(Kardex_stDatosFamiliaresMetaData))]
    public partial class Kardex_stDatosFamiliares
    {



    }

    public class Kardex_stDatosFamiliaresMetaData
    {
        // [RequiredIf("Nombre","", ErrorMessage = "Debes de especificar el Nombre")]

     
        [Required]
        public object Nombre { get; set; }

        [Required]
        public object ApellidoPaterno { get; set; }

        [Required]
        public object ApellidoMaterno { get; set; }

        [Required]
        public object Sexo { get; set; }

        [Required]
        public object EstadoCivil { get; set; }



        [Required]
        public object Calle { get; set; }

        [Required]
        public object Colonia { get; set; }

        
        [Required]
        [RegularExpression(@"^[1-9][0-9]*$", ErrorMessage = "Debe de seleccionar una localidad")]
        public object IdLocalidadDomicilio { get; set; }

        [Required]
        [RegularExpression(@"^[1-9][0-9]*$", ErrorMessage = "El valor debe de ser mas grande que 0")]
        

        public object CodigoPostal{ get; set; }


        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        public object NumeroInterior { get; set; }

  
        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        public object NumeroExterior { get; set; }



        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        [StringLength(10, MinimumLength = 10)]
        public object TelefonoCelular { get; set; }

        [StringLength(10, MinimumLength = 10)]
        [RegularExpression(@"^\d+$", ErrorMessage = "Solo números son permitidos")]
        public object TelefonoParticular { get; set; }


        [StringLength(3, ErrorMessage = "Máximo 3 caracteres")]
        public object Letra { get; set; }










    }
}