﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.IncidenciaPermiso
{
    using Dapper;
    using Nova.Libraries;
    using System;

    public class TrabajadoresHorasTrabajadas
    {
        public int? IdTrabajador { get; set; }
        public string Fecha { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Categoria { get; set; }
        public string UbicacionFisica { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        //public string Incidencias { get; set; }
        public int MinutosTotalTrabajados { get; set; }
        public int HorasTrabajadas { get; set; }
        //public int MinutosExtras { get; set; }

        public List<TrabajadoresHorasTrabajadas> ObtenHorasTrabajadas(DateTime fi, DateTime ff,int idubicacionfisica=0)
        {
            DapperQuery dp1 = new DapperQuery("bdNovaEntities");
            string idubicacion = "";

            if (idubicacionfisica > 0)
                idubicacion = $" and b.IdEstructuraOrganicaFisica={idubicacionfisica} ";
            string sql = $@"DECLARE @FechaInicio DATE = '{fi.ToString("yyyyMMdd")}';
DECLARE @FechaFin DATE = '{ff.ToString("yyyyMMdd")}';
WITH DatosAsistencia AS (
    SELECT 
        IdTrabajador,
        CAST(FechaAsistencia AS DATE) AS Fecha,
        MIN(FechaAsistencia) AS PrimerRegistro,
        MAX(FechaAsistencia) AS UltimoRegistro
    FROM  [Nomina_RelojChecadorAsistencia]
    WHERE FechaAsistencia >= @FechaInicio
        AND FechaAsistencia < DATEADD(DAY, 1, @FechaFin) and EsProcesada=1
    GROUP BY IdTrabajador, CAST(FechaAsistencia AS DATE)
)
SELECT * FROM (
    SELECT 
        b.nombre, b.apellidopaterno, b.apellidomaterno,
        a.IdTrabajador, categoria, conveniolaboral, idmodalidadestudio, RelacionLaboral,
        a.Fecha, b.IdEstructuraOrganicaFisica,
        DATEDIFF(HOUR, PrimerRegistro, UltimoRegistro) AS HorasTrabajadas,
        DATEDIFF(MINUTE, PrimerRegistro, UltimoRegistro) % 60 AS MinutosTotalTrabajados,
        b.ubicacionfisica,
        tienefalta = (
            SELECT TOP 1 IdTrabajador 
            FROM [IncidenciaPermiso_stIncidenciaTrabajador] xx
            INNER JOIN vwDatosAspirantesTrabajadoreshistorial cc ON xx.[IdConvenioLaboralTrabajadorCategoria] = cc.[IdConvenioLaboralTrabajadorCategoria]
            INNER JOIN Catalogos_ctTipoIncidencia dd ON dd.IdTipoIncidencia = xx.IdTipoIncidencia
            WHERE cc.IdTrabajador = a.IdTrabajador
                AND CAST(xx.FechaInicio AS DATE) = CAST( a.Fecha As   DATE)
         
        )
    FROM DatosAsistencia a
    INNER JOIN vwDatosAspirantesTrabajadores b ON b.IdTrabajador = a.IdTrabajador
    WHERE b.EsPlazaBase = 1 
        AND conveniolaboral <> 'MANDO MEDIO Y SUPERIOR' and Categoria<>'VIGILANTE'
and RelacionLaboral='ADMINISTRATIVO'
        {idubicacion}
        AND DATEPART(WEEKDAY, a.Fecha) BETWEEN 1 AND 5 -- Solo de lunes (2) a viernes (6)
    --AND IdModalidadEstudio = 0 
and b.IdTrabajador not in (
	SELECT  c1.IdTrabajador
  FROM [Nomina_RelojChecadorLibre]  a1
  inner join Convenios_stConvenioLaboralTrabajadorCategoria b1 on a1.IdConvenioLaboralTrabajadorCategoria=b1.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador c1 on c1.IdConvenioLaboralTrabajador=b1.IdConvenioLaboralTrabajador
  where a1.EsExima=0
	)
) AS q 
WHERE q.HorasTrabajadas < 7 AND tienefalta IS NULL
ORDER BY IdTrabajador, Fecha;";
            List<TrabajadoresHorasTrabajadas> model = (List<TrabajadoresHorasTrabajadas>)dp1.connection.Query<TrabajadoresHorasTrabajadas>(sql);
            //List<ListaRayaTrabajadores> ListaDatos = (List<ListaRayaTrabajadores>)dp.connection.Query<ListaRayaTrabajadores>("spNominaPercpecionesDeduccionesLista", p, null, true, 0, System.Data.CommandType.StoredProcedure);
            dp1.Close();
            return model;
        }
    }

   
}