﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.IncidenciaPermiso
{
    public class ProcesoStatusHelper
    {
        public bool IsRevisado { get; private set; }
        public bool IsAutorizado { get; private set; }
        public bool IsCerrado { get; private set; }

        public ProcesoStatusHelper(List<IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus> procesos)
        {
            IsRevisado = procesos.Any(p => p.IdProcesosEstatus == (int)IncidenciasProcesosEstatus.REVISADO);
            IsAutorizado = procesos.Any(p => p.IdProcesosEstatus == (int)IncidenciasProcesosEstatus.AUTORIZADO);
            IsCerrado = procesos.Any(p => p.IdProcesosEstatus == (int)IncidenciasProcesosEstatus.CERRADO);
        }

        public string GetStatusClass(bool isActive)
        {
            return isActive ? "m--font-success" : "m--font-secondary";
        }
    }
}