﻿using DevExpress.Office.Utils;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;
using Nova.Libraries;
using Nova.Models.Sindicato;
using Nova.Controllers;

namespace Nova.Models
{

    public class MovimientoPersonal
    {
        public Int64 IdSuplenciaSolicitud { get; set; }
        public Int64 IdSuplenciaSolicitudPadre { get; set; }
        public DateTime Suplencia_FechaInicio { get; set; }
        public DateTime Suplencia_FechaTermino { get; set; }
        public string CicloEscolar { get; set; }
        public string FolioOficio { get; set; }
        public int PersonalLicencia_IdKardex { get; set; }
		public int PersonalSuplente_IdKardex { get; set; }
        public string PersonalLicencia_NombreCompleto { get; set; }
        public string PersonalSuplente_NombreCompleto { get; set; }
        public string TipoSuplencia { get; set; }
        public string PlazaActual { get; set; }
        public string PlazaAnterior { get; set; }
        public string PlazaCubierta { get; set; }
      
       
        public DateTime Incidencia_FechaInicio { get; set; }
        public DateTime Incidencia_FechaTermino { get; set; }

        public string Incidencia { get; set; }
    
        public int NumeroConvenios { get; set; }
		public DateTime FechaInicioConvenio { get; set; }

        public static List<MovimientoPersonal> GetMovimientosPersonal(string FechaInicial, string FechaTermino) 
        {
            List <MovimientoPersonal> movimientosPersonal = new List <MovimientoPersonal>();
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            //if (string.IsNullOrEmpty(filtro))
            //{
            //    filtro = @"(cast (a.FechaInicio as date) <= cast(GETDATE() as date) and cast (a.FechaTermino as date) >= cast(GETDATE() as date))";
            //}
            //else {
            //    var fecha = filtro.Split('*');
            //    filtro = $@"(cast (a.FechaInicio as date) <= cast('{fecha[0]}' as date) and cast (a.FechaTermino as date) >= cast('{fecha[1]}' as date))";
            //}

            string filtro = $@"(cast (a.FechaInicio as date) >= cast('{FechaInicial}' as date) and (a.FechaTermino is null or cast (a.FechaTermino as date) <= cast('{FechaTermino}' as date)))";
            string query=
                    $@"  

                      select d.IdKardex,count(a.FechaInicio) as NumeroConvenios
	                    ,cast(max(a.FechaInicio) as date) as FechaInicioConvenio
	                    into #ConveniosTrabajadorCategoria
	                    from Convenios_stConvenioLaboralTrabajadorCategoria a
	                    inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
	                    inner join Kardex_ctTrabajador c on c.IdTrabajador=b.IdTrabajador
	                    inner join Kardex_ctDatosPersonales d on d.IdKardex=c.IdKardex
	                    group by d.IdKardex
	                    order by 1

                    select a.IdSuplenciaSolicitud
                        ,IdSuplenciaSolicitudPadre
                            ,cast (a.FechaInicio as date) as Suplencia_FechaInicio
                            ,cast(a.FechaTermino as date) as Suplencia_FechaTermino
                            ,a.CicloEscolar
                            ,a.FolioOficio
                            ,d.IdKardex as PersonalLicencia_IdKardex
                            ,PersonalLicencia_NombreCompleto=isnull(d.ApellidoPaterno+space(1)+d.ApellidoMaterno+space(1)+d.Nombre,'NO APLICA')
                            ,e.IdKardex as PersonalSuplente_IdKardex
                            ,PersonalSuplente_NombreCompleto=e.ApellidoPaterno+space(1)+e.ApellidoMaterno+space(1)+e.Nombre
                            ,g.TipoSuplencia
                            ,PlazaActual= case when b.IdConvenioLaboralTrabajadorCategoria is null then 'NO APLICA'
                            else (select DatosPlaza='CATEGORÍA: ' + c.Categoria collate MODERN_SPANISH_CI_AS+' ; ADSCRIPCIÓN: '+d.EstructuraOrganica collate MODERN_SPANISH_CI_AS
                            +' ; UBICACIÓN_FISICA: '+ e.EstructuraOrganica collate MODERN_SPANISH_CI_AS
                            from Convenios_stConvenioLaboralTrabajadorCategoria a
                            inner join Plazas_stDistribucionPlazaCategoria bb on a.IdDistribucionPlazaCategoria=bb.IdDistribucionPlazaCategoria
                            inner join Plazas_ctCategoria c on c.IdCategoria=bb.IdCategoria
                            inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica=bb.IdEstructuraOrganica
                            inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=a.IdEstructuraOrganica
                            where a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria) end
                            ,PlazaAnterior= case when b.IdConvenioLaboralTrabajadorCategoriaAnterior is null then 'NO APLICA'
                            else (select DatosPlaza='CATEGORÍA: ' + c.Categoria collate MODERN_SPANISH_CI_AS+' ; ADSCRIPCIÓN: '+d.EstructuraOrganica collate MODERN_SPANISH_CI_AS
                            +' ; UBICACIÓN_FISICA: '+ e.EstructuraOrganica collate MODERN_SPANISH_CI_AS
                            from Convenios_stConvenioLaboralTrabajadorCategoria a
                            inner join Plazas_stDistribucionPlazaCategoria bb on a.IdDistribucionPlazaCategoria=bb.IdDistribucionPlazaCategoria
                            inner join Plazas_ctCategoria c on c.IdCategoria=bb.IdCategoria
                            inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica=bb.IdEstructuraOrganica
                            inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=a.IdEstructuraOrganica
                            where a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoriaAnterior) end
                            ,PlazaCubierta= case when b.IdConvenioLaboralTrabajadorCategoriaCubierto is null then 'NO APLICA'
                            else (select DatosPlaza='CATEGORÍA: ' + c.Categoria collate MODERN_SPANISH_CI_AS+' ; ADSCRIPCIÓN: '+d.EstructuraOrganica collate MODERN_SPANISH_CI_AS
                            +' ; UBICACIÓN_FISICA: '+ e.EstructuraOrganica collate MODERN_SPANISH_CI_AS
                            from Convenios_stConvenioLaboralTrabajadorCategoria a
                            inner join Plazas_stDistribucionPlazaCategoria bb on a.IdDistribucionPlazaCategoria=bb.IdDistribucionPlazaCategoria
                            inner join Plazas_ctCategoria c on c.IdCategoria=bb.IdCategoria
                            inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica=bb.IdEstructuraOrganica
                            inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=a.IdEstructuraOrganica
                            where a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoriaCubierto) end
                            ,cast(f.FechaInicio as date) Incidencia_FechaInicio
                            ,cast(f.FechaTermino as date) Incidencia_FechaTermino
                            ,isnull(h.Incidencia,'SIN DATOS') as Incidencia
                            ,i.NumeroConvenios
							,cast(i.FechaInicioConvenio as date) as FechaInicioConvenio
                            from Nomina_SuplenciasSolicitudes a
                            left join Convenios_SuplenciasControl b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
                            left join IncidenciaPermiso_stIncidenciaTrabajador c on c.IdIncidenciaTrabajador=b.IdIncidenciaTrabajador
                            left join Kardex_ctDatosPersonales d on d.IdKardex=a.IdKardexSuplido
                            inner join Kardex_ctDatosPersonales e on e.IdKardex=a.IdKardexSuplente
                            left join IncidenciaPermiso_stIncidenciaTrabajador f on f.IdIncidenciaTrabajador=a.IdIncidenciaTrabajador
                            left join Nomina_SuplenciaTipo g on g.IdTipoSuplencia=a.IdTipoSuplencia  
                            left join Catalogos_ctTipoIncidencia h on h.IdTipoIncidencia=f.IdTipoIncidencia
                            inner join #ConveniosTrabajadorCategoria i on i.IdKardex=a.IdKardexSuplente
                            where a.EsAtendida=1 and {filtro}
                            order by 1 desc,2 desc";
                            try
                            {
                                movimientosPersonal = (List<MovimientoPersonal>) dp.connection.Query<MovimientoPersonal>(query);
                                dp.Close();
                            }
                            catch (Exception e)
                            {

                                throw new Exception(ExceptionExtensions.GetOriginalException(e).Message);
            }


            return movimientosPersonal;
        }

         
    }

     
}