﻿using Dapper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public class LicenciasPermisos
    {
        public int Ide { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Categoria { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string EstatusTrabajador { get; set; }
        public string EstructuraOrganica { get; set; }
        public string EstructuraOrganicaPadre { get; set; }
        public string EstructuraOrganicaPadrePlaza { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string Incidencia { get; set; }
        public string Estatus { get; set; }

        public Boolean HayTraslape(IncidenciaPermiso_stIncidenciaTrabajador idcltc)
        {
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, a.IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion,  
                                      Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador a
                                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia 
                                     where  IdConvenioLaboralTrabajadorCategoria=" + idcltc.IdConvenioLaboralTrabajadorCategoria.ToString() + " and (  b.IdTipoIncidenciaPermiso=5)"; ;
            var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
            dp.Close();
            Boolean Traslape = incidencias.Any(e =>
                   (idcltc.FechaInicio <= e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino <= e.FechaTermino) ||
                   (idcltc.FechaInicio == e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino <= e.FechaTermino) ||
                   (idcltc.FechaInicio <= e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino == e.FechaTermino) ||
                   (idcltc.FechaInicio >= e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino >= e.FechaTermino) ||
                   (idcltc.FechaInicio == e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino == e.FechaTermino) ||
                   (idcltc.FechaInicio >= e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino <= e.FechaTermino) ||
                   (idcltc.FechaInicio <= e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino >= e.FechaTermino) ||
                   (idcltc.FechaInicio == e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino >= e.FechaTermino) ||
                   (idcltc.FechaInicio >= e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino >= e.FechaInicio && idcltc.FechaTermino == e.FechaTermino) ||
                   (idcltc.FechaInicio >= e.FechaInicio && idcltc.FechaInicio <= e.FechaTermino && idcltc.FechaTermino == null) ||
                   (e.FechaTermino == null)
                   );
            return Traslape;
        }
        public Boolean HayTraslapeComision(int idks, int idcltc, DateTime fi, DateTime ff,int idts=0)
        {
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string condicion = "";
            if (idts==7)
                condicion = " b.Incidencia<>'LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA' and  b.Incidencia<>'COMISIÓN POR CAMBIO DE NÓMINA' and ";
            else
                if (idts == 17)
                condicion = " b.Incidencia<>'LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA' and ";

            string query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, a.IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion,  
                                      Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador a
                                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia 
                                     where  "+ condicion + " IdConvenioLaboralTrabajadorCategoria=" + idcltc.ToString() + " and (b.IdTipoIncidenciaPermiso=2 or b.IdTipoIncidenciaPermiso=4 or b.IdTipoIncidenciaPermiso=10)"; ;
            var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
            Boolean Traslape = incidencias.Any(e =>
                   (fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
                   (fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
                   (fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
                   (fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
                   (fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
                   (fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
                   (fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
                   (fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
                   (fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
                   (fi >= e.FechaInicio && fi <= e.FechaTermino && ff == null) ||
                   (e.FechaTermino == null)
                   );
            if (Traslape == false)
            {
                query = @"selecT * from Nomina_SuplenciasSolicitudes
                                     where  idkardexsuplente=" + idks.ToString() + " and esatendida=0"; ;
                var solicitudes = (List<Nomina_SuplenciasSolicitudes>)dp.connection.Query<Nomina_SuplenciasSolicitudes>(query);

                Traslape = solicitudes.Any(e =>
  (fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
  (fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
  (fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
  (fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
  (fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
  (fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
  (fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
  (fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
  (fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
  (fi >= e.FechaInicio && fi <= e.FechaTermino && ff == null) ||
  (e.FechaTermino == null)
  );

            }
            dp.Close();

            return Traslape;
        }
        public Boolean HayTraslapeLicencia(int idks, DateTime fi, DateTime ff,int idts=0)
        {
            string condicion = "";
            if (idts == 7)
                condicion = " idtiposuplencia<>17 and  ";

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string query = "";
            Boolean Traslape = false;
            query = @"selecT * from Nomina_SuplenciasSolicitudes
                                     where  "+ condicion + " idkardexsuplido=" + idks.ToString() + " and esatendida=0"; ;
            var solicitudes = (List<Nomina_SuplenciasSolicitudes>)dp.connection.Query<Nomina_SuplenciasSolicitudes>(query);

            Traslape = solicitudes.Any(e =>
(fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
(fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
(fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
(fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
(fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
(fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
(fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
(fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
(fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
(fi >= e.FechaInicio && fi <= e.FechaTermino && ff == null) ||
(e.FechaTermino == null)
);

            dp.Close();

            return Traslape;
        }

        public Boolean HayTraslapeContratosHistorial(int idks, DateTime fi, DateTime ff, int idts = 0)
        {
            

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string query = "";
            Boolean Traslape = false;
            query = @"selecT * from [vwDatosAspirantesTrabajadoresHistorial]
                                     where   idkardex=" + idks.ToString() +" and estatustrabajador<>'ASPIRANTE'"  ;
            var solicitudes = (List<vwDatosAspirantesTrabajadoresHistorial>)dp.connection.Query<vwDatosAspirantesTrabajadoresHistorial>(query);

            Traslape = solicitudes.Any(e =>
(fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
(fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
(fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
(fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
(fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
(fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff <= e.FechaTermino) ||
(fi <= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
(fi == e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff >= e.FechaTermino) ||
(fi >= e.FechaInicio && fi <= e.FechaTermino && ff >= e.FechaInicio && ff == e.FechaTermino) ||
(fi >= e.FechaInicio && fi <= e.FechaTermino && ff == null) ||
(e.FechaTermino == null)
);

            dp.Close();

            return Traslape;
        }
    }
}