﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.IncidenciaPermiso
{
    public class RelojChecadorAsistencia
    {
        public int IdTrabajador { get; set; }

        public int FieldIgnore { get; set; }
        public int IdwVerifyMode { get; set; }
        public int IdwInOutMode { get; set; }
        public DateTime FechaAsistencia { get; set; }
        public int Workcode { get; set; }
    }


    public class Justificaciones
    {
        public List<IncidicenciasporAplicar> getIncidencias(string genero, short idarea, short rellab, short idt, string fi, string ft, short idreloj)
        {
            DateTime fechainicio = DateTime.Parse(fi);
            DateTime fechatermino = DateTime.Parse(ft);

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string qTrabajadores, qIncidencias, condicion;

            condicion = " and ";

            if (genero != "0")
            { condicion = condicion + $"  t.sexo='{genero}' "; }

            if (idarea > 0)
            {
                //if (condicion != "")
                //{
                //    condicion = condicion + " and ";
                //}
                if (condicion != " and ")
                    condicion = condicion + $" and t.IdEstructuraOrganicaFisica={idarea} ";
                else
                    condicion = condicion + $"  t.IdEstructuraOrganicaFisica={idarea} ";
            }



            if (rellab > 0)
            {
                if (condicion != " and ")
                {
                    condicion = condicion + " and ";
                    condicion = condicion + $"  t.IdConvenioLaboral={rellab} ";
                }
                else
                    condicion = condicion + $"   t.IdConvenioLaboral={rellab} ";
            }

            if (idreloj > 0)
            {
                if (condicion != " and ")
                    condicion = condicion + $@"  and t.IdEstructuraOrganicaFisica in ( SELECT b.IdEstructuraOrganica
  FROM Nomina_RelojChecadorAreas a
  inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas=b.IdRelojChecadorAreas
where   a.IdRelojChecadorAreas={idreloj} ) ";
                else
                    condicion = $@" and t.IdEstructuraOrganicaFisica in ( SELECT b.IdEstructuraOrganica
  FROM Nomina_RelojChecadorAreas a
  inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas=b.IdRelojChecadorAreas
where a.IdRelojChecadorAreas={idreloj} ) ";

            }

            if (idt > 0)
            {
                if (condicion == " and ")
                    condicion = condicion + $"  t.Idtrabajador={idt} ";
                else
                    condicion = condicion + $"  and t.Idtrabajador={idt} ";

            }

            if (condicion == " and ")
            { condicion = ""; }

            qIncidencias = $@" SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.IdModalidadEstudio, t.ConvenioLaboral  ,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica,t.IdEstructuraOrganicaPadre,t.EstructuraOrganicaPadre,
					t.RelacionLaboral,
					hor.Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE  CONVERT(varchar, t.Fechainicio , 112) <='{fechainicio.ToString("yyyyMMdd")}' and c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                    and Autorizo=0 and EsFaltaDirecta=0
                    and  CONVERT(varchar, a.FechaInicio , 112) >= '{fechainicio.ToString("yyyyMMdd")}' and  CONVERT(varchar, a.FechaInicio , 112)  <='{fechatermino.ToString("yyyyMMdd")}'   and a.IdIncidenciaTrabajador not in (
					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
					  and  CONVERT(varchar, a.FechaInicio , 112) >= '{fechainicio.ToString("yyyyMMdd")}' and  CONVERT(varchar, a.FechaInicio , 112) <='{fechatermino.ToString("yyyyMMdd")}' ) 
                        {condicion}
                    order by t.IdEstructuraOrganicaFisica ASC";

            List<IncidicenciasporAplicar> t = (List<IncidicenciasporAplicar>)dp.connection.Query<IncidicenciasporAplicar>(qIncidencias);

            return t;
        }
    }
}