﻿using Dapper;
using DevExpress.CodeParser;
using DevExpress.DataProcessing.InMemoryDataProcessor;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DocumentFormat.OpenXml.Bibliography;
using DocumentFormat.OpenXml.Office2010.Excel;
using Nova.Libraries;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;
using Nova.Models.AsignarPlaza;

namespace Nova.Models
{
    public class vwDatosAspirantesTrabajadoresAsistencias : vwDatosAspirantesTrabajadores
    {
        public bool? LibreMonitoreo { get; set; }
    }
    public class SaldosIncidenciasIncapacidades
    {
        public int IdIncidenciasSaldos { get; set; }
        public int IdTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string Incidencia { get; set; }

        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string Categoria { get; set; }
        public string UbicacionFisica { get; set; }
        public decimal Saldo { get; set; }
        public decimal Total { get; set; }

    }

    public class IndicenciasGlobales
    {
        public int IdEstructuraOrganica { get; set; }

        public string TipoCentro { get; set; }
        public string Departamento { get; set; }
        public string PerteneceA { get; set; }
        public int TotalFaltas { get; set; }
        public int TotalFaltasJustificadas { get; set; }
        public int TotalRetardos { get; set; }
        public int TotalRetardosJustificados { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string AñoQuincenaNomina { get; set; }
        public int ctaAñoNomina { get; set; }        
 

    }

    public class PrimaDominical
    {
        public int IdEstructuraOrganica { get; set; }

        public string TipoCentro { get; set; }
        public string Departamento { get; set; }
        public string PerteneceA { get; set; }
        public int TotalFaltas { get; set; }
        public int TotalFaltasJustificadas { get; set; }
        public int TotalRetardos { get; set; }
        public int TotalRetardosJustificados { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string AñoQuincenaNomina { get; set; }
        public int ctaAñoNomina { get; set; }


    }


    public class PrimaDominicalTrabajadores
    {
        public int TotalFaltas { get; set; }
        public string IdIncidenciaTrabajador { get; set; }
        public int IdModalidadEstudio { get; set; }
        public int IdTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ConvenioLaboral { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Sexo { get; set; }
        public string UbicacionFisica { get; set; }
        public string Incidencia { get; set; }
        public DateTime Fecha { get; set; }
        public string Observaciones { get; set; }
        public int Horas { get; set; }
        public int IdEstructuraOrganicaFisica { get; set; }
        public int IdEstructuraOrganicaPadre { get; set; }
        public string EstructuraOrganicaPadre { get; set; }
        public string RelacionLaboral { get; set; }
        public string Horario { get; set; }
        public string HorarioEspecial { get; set; }




    }

    public class IncidenciasDiasEconomicos
    {
        public int IdEstructuraOrganica { get; set; }
        public int IdEstructuraOrganicaPadre { get; set; }
        public int IdTrabajador { get; set; }
        public int IdModalidadEstudio { get; set; }
        public string Departamento { get; set; }
        public string UbicacionFisica { get; set; }
        public string EstructuraOrganicaPadre { get; set; }
        public string PerteneceA { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public string Enero { get; set; }
        public string Febrero { get; set; }
        public string Marzo { get; set; }
        public string Abril { get; set; }
        public string Mayo { get; set; }
        public string Junio { get; set; }
        public string Julio { get; set; }
        public string Agosto { get; set; }
        public string Septiembre { get; set; }
        public string Octubre { get; set; }
        public string Noviembre { get; set; }
        public string Diciembre { get; set; }
        public string Total { get; set; }




    }

    public class IncidicenciasporAplicar
    {
        public int TotalFaltas { get; set; }
        public string IdIncidenciaTrabajador { get; set; }
        public int IdModalidadEstudio { get; set; }
        public int IdTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ConvenioLaboral { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Sexo { get; set; }
        public string UbicacionFisica { get; set; }
        public string Incidencia { get; set; }
        public DateTime Fecha { get; set; }
        public string Observaciones { get; set; }
        public int Horas { get; set; }
        public int IdEstructuraOrganicaFisica { get; set; }
        public int IdEstructuraOrganicaPadre { get; set; }
        public string EstructuraOrganicaPadre { get; set; }
        public string RelacionLaboral { get; set; }
        public string Horario { get; set; }
        public string HorarioEspecial { get; set; }


    }

    public class TotalFaltas
    {
        
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Sexo { get; set; }
        public string UbicacionFisica { get; set; }
        public string Incidencia { get; set; }
        public DateTime Fecha { get; set; }
        public string Observaciones { get; set; }
        public int Horas { get; set; }
        public int IdEstructuraOrganicaFisica { get; set; }


    }
  
    public class IndicenciasConcentrado
    {
        [Key]
        public int IdIncidenciaTrabajador { get; set; }

        public int IdTrabajador { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public int Horas { get; set; }
        public string Nombre { get; set; }
        public string Categoria { get; set; }
        public string UbicacionFisica { get; set; }
        public string IdEstructuraOrganicaFisica { get; set; }
        public DateTime FechaInicio { get; set; }

        public Boolean EsFaltaDirecta { get; set; }


        public string Incidencia { get; set; }

        public string TipoIncidenciaPermiso { get; set; }

        public int IdEstructuraOrganica { get; set; }


        public string Registro { get; set; }
        public string EstructuraOrganica { get; set; }
        public string QuincenaParaNomina { get; set; }
        public string AñoParaNomina { get; set; }

        public int Año { get; set; }
        public int Mes { get; set; }
        public int Qna { get; set; }

    }

    public class AsistenciasTrabajador
    {
        [Key]
        public long IdRelojChecadorAsistencia { get; set; }
        public int IdTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Categoria { get; set; }
        public string UbicacionFisica { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public string EstatusTrabajador { get; set; }
        public DateTime FechaAsistencia { get; set; }

        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public bool Autorizo { get; set; }
        public string NombreJustifico { get; set; }

        public string ApellidoPaternoJustifico { get; set; }
        public string ApellidoMaternoJustifico { get; set; }
        public string NombreAutorizo { get; set; }
        public string ApellidoPaternoAutorizo { get; set; }
        public string ApellidoMaternoAutorizo { get; set; }

        public int IdIncidenciaTrabajador { get; set; }
        public string IncidenciaJustificacion { get; set; }
        public string Nomenclatura { get; set; }
        public string Color { get; set; }
        public DateTime FechaJustificacion { get; set; }
        public DateTime FechaAutorizacion { get; set; }
        public string Incidencia { get; set; }
        public string NomenclaturaIncidencia { get; set; }
        public string ColorIncidencia { get; set; }
        public string NombreMes { get; set; }
        public string Mes { get; set; }
        public string Anio { get; set; }
        public string Horas { get; set; }


    }
    //public class Años
    //{
    //    public string IncidenciaJustificacion { get; set; }
    //    public string Nomenclatura { get; set; }
    //    public string Nomenclatura { get; set; }

    //}
    public class PermisosArea
    {
        public int idarea { get; set; }
        public DateTime fi { get; set; }
        public DateTime ff { get; set; }
    }
    public class LeyendasReporte
    {
        public string Incidencia { get; set; }
        public string Nomenclatura { get; set; }
    }

    public class TrabajadoresPermisos
    {
        public int Id { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Permiso { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
    }

    public class Años
    {
        public int IdAño { get; set; }
        public int Año { get; set; }

    }
    public class Quincena
    {
        public short IdQuincenaMes { get; set; }
        public string QuincenaMes { get; set; }

    }
    public class Pase
    {
        public DateTime Dia { get; set; }
        public System.TimeSpan TiempoFuera { get; set; }

    }
    public class Prima
    {
        public DateTime Dia { get; set; }

    }
    public class Falta
    {
        public DateTime Dia { get; set; }
        public short Horas { get; set; }


    }

    public class AreasUsuario
    {
        public int IdEstructuraOrganica { get; set; }
        public string EstructuraOrganica { get; set; }
        //        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
    }

    public class AsistencasDelTrabajador
    {
        public int? IdTrabajador { get; set; }
        public DateTime Hora { get; set; }
        public string EstructuraOrganica { get; set; }
    }

    public class Nomina_RelojChecadorAsistenciaEstructura : Nomina_RelojChecadorAsistencia
    {
        public string EstructuraOrganica { get; set; }
    }
    public class IncidenciaTrabajador
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public Int64 IdIncidenciaTrabajador { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public int Horas { get; set; }
        public System.TimeSpan TiempoFuera { get; set; }

        public int IdTrabajador { get; set; }
        public string Trabajador { get; set; }
        public int DiasHorasIncidencia { get; set; }
        public int DiasEconomicos { get; set; }
        public Boolean EsJustificacionExtemporanea { get; set; }
        public string QuienAutorizo { get; set; }
        public string QuienJustifico { get; set; }
        public string QuienRegistro { get; set; }
        public string Incidencia { get; set; }
        public string Nomenclatura { get; set; }
        public string Color { get; set; }
        public string IncidenciaJustico { get; set; }
        public string NomenclaturaJustifico { get; set; }
        public string ColorJustifico { get; set; }
        public int IdNominaTrabajador { get; set; }
        public string EstructuraOrganica { get; set; }
        public string Categoria { get; set; }
        public string Observaciones { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public Boolean EsAplicada { get; set; }
        public Boolean Autorizo { get; set; }
        public string DescripcionJustificacion { get; set; }
        public DateTime FechaAutorizacion { get; set; }
        public DateTime FechaCreacion { get; set; }
        public DateTime FechaJustificacion { get; set; }
        public int IdIncidenciaJustificacion { get; set; }
        public Boolean EsCancelada { get; set; }
        public Boolean EsCerrada { get; set; }
        public string CURP { get; set; }
        public Boolean EsFaltaDirecta { get; set; }

        public Nullable <DateTime> FechaTerminoConvenio { get; set; }
        public int IdModalidadEstudio { get; set; }
        public string QuincenaParaNomina { get; set; }


    }
    public class VistaIncidenciaTrabajador
    {
        public int Id { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string Trabajador { get; set; }
        public string Categoria { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public Nullable  <DateTime> Ftc{ get; set; }
        public Nullable<DateTime> FechaInicioContrato { get; set; }
        public int IdModalidadEstudio { get; set; }
        public bool? LibreMonitoreo { get; set; }
        public string Estatus { get; set; }

        public int D1 { get; set; }
        public int D2 { get; set; }
        public int D3 { get; set; }
        public int D4 { get; set; }
        public int D5 { get; set; }
        public int D6 { get; set; }
        public int D7 { get; set; }
        public int D8 { get; set; }
        public int D9 { get; set; }
        public int D10 { get; set; }
        public int D11 { get; set; }
        public int D12 { get; set; }
        public int D13 { get; set; }
        public int D14 { get; set; }
        public int D15 { get; set; }
        public int D16 { get; set; }

        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia1 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia2 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia3 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia4 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia5 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia6 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia7 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia8 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia9 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia10 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia11 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia12 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia13 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia14 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia15 { get; set; }
        public List<AsistencasDelTrabajador> AsistencasDelTrabajadorDia16 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia1 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia2 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia3 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia4 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia5 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia6 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia7 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia8 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia9 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia10 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia11 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia12 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia13 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia14 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia15 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia16 { get; set; }
        public int Faltas { get; set; }
        public int DiasEconomicos { get; set; }
        public Boolean PuntualidadAsistencia { get; set; }
        public string Observaciones { get; set; }

    }
    public class EstructuraIncidencias
    {
        public List<VistaIncidenciaTrabajador> InicidenciasTrabajadores { get; set; }
    }

    public partial class IncidenciaPermiso_stIncidenciaTrabajador
    {
        public static List<Incidencia_ctJustificacion> getTipoJustificacion()
        {
            bdNovaEntities db = new bdNovaEntities();

            List<Incidencia_ctJustificacion> listajustificacion = db.Incidencia_ctJustificacion.Where(z => z.IncidenciaJustificacion != "OMISIÓN DE SALIDA" && z.IncidenciaJustificacion != "OMISIÓN DE ENTRADA").ToList();

            return listajustificacion;
        }

        public static List<Catalogos_ctTipoIncidencia> getTipoIncidencia()
        {
            bdNovaEntities db = new bdNovaEntities();

            return (List<Catalogos_ctTipoIncidencia>)db.Catalogos_ctTipoIncidencia.ToList();
        }

        public static List<TotalFaltas> getTotalFaltas(string fip, string ftp, int IdEstructura)
        {
            List<TotalFaltas> m = new List<TotalFaltas>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {
                u = $@"SELECT t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES')
                    and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'
                    and  t.IdEstructuraOrganicaFisica= {IdEstructura} and cast(t.FechaInicio as DATE)  <= '{fi}'";
                m = (List<TotalFaltas>)dp.connection.Query<TotalFaltas>(u);
            }
            return m;
        }

        public static List<TotalFaltas> getTotalFaltasJustificadas(string fip, string ftp, int IdEstructura)
        {
            List<TotalFaltas> m = new List<TotalFaltas>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {
                u = $@"SELECT t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica
                     FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                     inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                     and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                      and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'
                    and  t.IdEstructuraOrganicaFisica= {IdEstructura} and cast(t.FechaInicio as DATE)  <= '{fi}'";
                m = (List<TotalFaltas>)dp.connection.Query<TotalFaltas>(u);

            }
            return m;
        }


        public static List<TotalFaltas> getFaltasporAplicar(string fip, string ftp, int IdEstructura)
        {
            List<TotalFaltas> m = new List<TotalFaltas>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {
                u = $@"SELECT t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'
                    and  t.IdEstructuraOrganicaFisica= {IdEstructura} and cast(t.FechaInicio as DATE)  <= '{fi}' and a.IdIncidenciaTrabajador not in (


					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                       and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'
                    and  t.IdEstructuraOrganicaFisica= {IdEstructura} and cast(t.FechaInicio as DATE)  <= '{fi}')";
                m = (List<TotalFaltas>)dp.connection.Query<TotalFaltas>(u);
            }
            return m;
        }

        public static List<IncidicenciasporAplicar> getIncidenciasporAplicar(string fip, string ftp)
        {
            List<IncidicenciasporAplicar> m = new List<IncidicenciasporAplicar>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {


                u = $@" 

(Select count(IdTrabajador) as TotalFaltas,
					   IdTrabajador,
					   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
                       max (IdModalidadEstudio) as IdModalidadEstudio , 
					   max( ConvenioLaboral) as ConvenioLaboral, 
					   max (Nombre) as Nombre,
					   max (ApellidoPaterno) as ApellidoPaterno,
					   max (ApellidoMaterno) as ApellidoMaterno,
					   max (Sexo) as Sexo , 
					   max (UbicacionFisica) as UbicacionFisica, 
					   max (Incidencia) as Incidencia, 
					   max (Fecha) as Fecha, 
					   max (Observaciones) as Observaciones , 
					   max (Horas) as Horas ,
					   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (RelacionLaboral)as RelacionLaboral ,
					max (Horario) as Horario,
					max (HorarioEspecial) as HorarioEspecial
					from
                    ( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,
					   a.IdIncidenciaTrabajador,                      
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                
					and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio= 0 and cast(t.FechaInicio as DATE)  <= '{fi}'
                    --and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and t.IdModalidadEstudio= 0 
                    --and  t.ConvenioLaboral in ('CONFIANZA','CONTRATO')

                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador )					
					union
						(SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador, 
					   max (a.IdIncidenciaTrabajador) LasIdIncidenciaTrabajador,
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
				     FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
					 FROM  Nomina_HorariosConvenioConfiguracion a
					 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
					 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
		
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio= 0
					   --and  t.ConvenioLaboral in ('CONFIANZA','CONTRATO')
					 group by  t.IdTrabajador, a.IdIncidenciaTrabajador	)) x
					   where x.IdIncidenciaTrabajador not in (


					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio= 0    )  )  z
					 where Incidencia IN  ( 'FALTA POR DÍA', 'FALTA POR HORAS', 'FALTA POR RETARDOS', 'FALTA HORAS CLUB')
					  
					  group by z.IdTrabajador, z.Incidencia, z.Fecha
					)
					union 
					(
					select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial from(
		select * from (			(Select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial
										from
					( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador,
										   a.IdIncidenciaTrabajador,  
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,              
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
					  
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
													  FROM  Nomina_HorariosConvenioConfiguracion a
													  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
													  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES') 
               
										--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <=  '{ft}'  and t.IdModalidadEstudio= 0 and cast(t.FechaInicio as DATE)  <= '{fi}'
                                        and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and t.IdModalidadEstudio= 0 										
                                        and a.EsCerrada=0   --and  t.ConvenioLaboral in ('CONFIANZA','CONTRATO')
										group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio )					
										union
											(SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador, 
										   max (a.IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,   
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
										 FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
										 FROM  Nomina_HorariosConvenioConfiguracion a
										 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
										 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
										and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio= 0 and a.EsCerrada=0
										  --and  t.ConvenioLaboral in ('CONFIANZA','CONTRATO')
										 group by  t.IdTrabajador, a.IdIncidenciaTrabajador,a.FechaInicio	)) x
										   where x.FaltaRetardoTrabajador not in (

										SELECT cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar) as Dato
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA' )					
										 and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio= 0   ) )  z
										  group by z.IdTrabajador, z.IdIncidenciaTrabajador )) w

										     where w.IdIncidenciaTrabajador not in (
												SELECT a.IdIncidenciaTrabajador
												FROM IncidenciaPermiso_stIncidenciaTrabajador  a
												 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
												 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
												 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
												 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
												 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'VACACIONES') 
												  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
													and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio= 0    ))  y
													group by y.IdTrabajador
												HAVING COUNT(TotalFaltas) > 2
					                            )

 ";




                //           (Select count(IdTrabajador) as TotalFaltas,
                //   IdTrabajador,
                //   max(IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
                //                  max(IdModalidadEstudio) as IdModalidadEstudio , 
                //   max(ConvenioLaboral) as ConvenioLaboral, 
                //   max(Nombre) as Nombre,
                //   max(ApellidoPaterno) as ApellidoPaterno,
                //   max(ApellidoMaterno) as ApellidoMaterno,
                //   max(Sexo) as Sexo , 
                //   max(UbicacionFisica) as UbicacionFisica, 
                //   max(Incidencia) as Incidencia, 
                //   max(Fecha) as Fecha, 
                //   max(Observaciones) as Observaciones , 
                //   max(Horas) as Horas ,
                //   max(IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
                //   max(IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
                //   max(EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
                //max(RelacionLaboral) as RelacionLaboral ,
                //max(Horario) as Horario,
                //max(HorarioEspecial) as HorarioEspecial

                //               from
                //               (select * from((SELECT count(t.IdTrabajador) as TotalFaltas,
                //                  t.IdTrabajador,
                //                  a.IdIncidenciaTrabajador,
                //                  max(t.IdModalidadEstudio) as IdModalidadEstudio, max(t.ConvenioLaboral) as ConvenioLaboral,
                //                  max(t.Nombre) as Nombre,
                //                  max(t.ApellidoPaterno) as ApellidoPaterno,
                //                  max(t.ApellidoMaterno) as ApellidoMaterno,
                //                  max(t.Sexo) as Sexo,
                //                  max(t.UbicacionFisica) as UbicacionFisica,
                //                  max(b.Incidencia) as Incidencia,
                //                  max(a.FechaInicio) as Fecha,
                //                  max(a.Observaciones) as Observaciones,
                //                  max(a.Horas) as Horas,
                //                  max(t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
                //                  max(t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
                //                  max(t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
                //               max(t.RelacionLaboral) as RelacionLaboral,
                //               max(hor.Horario) as Horario, (SELECT  top 1

                //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

                //                 FROM  Nomina_HorariosEspeciales h

                //                 where h.Dia = 1 and  h.idtrabajador = t.idtrabajador) as HorarioEspecial
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                //               inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //               inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //               inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //               INNER JOIN Incidencia_ctJustificacion J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //               left join(SELECT    max(cast(a.Entrada as nvarchar(5))) + '-' + max(cast(a.salida as nvarchar(5))) as Horario, a.IdRelacionConvenioLaboral

                //                             FROM  Nomina_HorariosConvenioConfiguracion a

                //                             inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

                //                             group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral
                //               WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')


                //               and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio = 0 and cast(t.FechaInicio as DATE) <= '{fi}'



                //               group by  t.IdTrabajador, a.IdIncidenciaTrabajador)

                //               union
                //                   (SELECT count(t.IdTrabajador) as TotalFaltas,
                //                  t.IdTrabajador,
                //                  max(a.IdIncidenciaTrabajador) LasIdIncidenciaTrabajador,
                //                  max(t.IdModalidadEstudio) as IdModalidadEstudio, max(t.ConvenioLaboral) as ConvenioLaboral,
                //                  max(t.Nombre) as Nombre,
                //                  max(t.ApellidoPaterno) as ApellidoPaterno,
                //                  max(t.ApellidoMaterno) as ApellidoMaterno,
                //                  max(t.Sexo) as Sexo,
                //                  max(t.UbicacionFisica) as UbicacionFisica,
                //                  max(b.Incidencia) as Incidencia,
                //                  max(a.FechaInicio) as Fecha,
                //                  max(a.Observaciones) as Observaciones,
                //                  max(a.Horas) as Horas,
                //                  max(t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
                //                  max(t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
                //                  max(t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
                //               max(t.RelacionLaboral) as RelacionLaboral,
                //               max(hor.Horario) as Horario, (SELECT  top 1

                //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

                //                 FROM  Nomina_HorariosEspeciales h

                //                 where h.Dia = 1 and  h.idtrabajador = t.idtrabajador) as HorarioEspecial


                //                FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                INNER JOIN[Incidencia_ctJustificacion] J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) + '-' + max(cast(a.salida as nvarchar(5))) as Horario, a.IdRelacionConvenioLaboral

                //                FROM  Nomina_HorariosConvenioConfiguracion a

                //                inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

                //                group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral

                //                WHERE c.TipoIncidenciaPermiso in('RETARDOS')


                //                and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio = 0

                //                group by  t.IdTrabajador, a.IdIncidenciaTrabajador )) x
                //                  where x.IdIncidenciaTrabajador not in (


                //               SELECT a.IdIncidenciaTrabajador
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador a

                //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')

                //                 and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
                //                and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio = 0 ) )  z
                //                 where Incidencia IN  ('FALTA POR DÍA', 'FALTA POR HORAS', 'FALTA POR RETARDOS', 'FALTA HORAS CLUB')
                //  group by z.IdTrabajador, z.Incidencia, z.Fecha
                //)
                //union
                //               (
                //               select count(IdTrabajador) as TotalFaltas,
                //                                      IdTrabajador,
                //                                      max(IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
                //                                      max(IdModalidadEstudio) as IdModalidadEstudio,
                //                                      max(ConvenioLaboral) as ConvenioLaboral,
                //                                      max(Nombre) as Nombre,
                //                                      max(ApellidoPaterno) as ApellidoPaterno,
                //                                      max(ApellidoMaterno) as ApellidoMaterno,
                //                                      max(Sexo) as Sexo,
                //                                      max(UbicacionFisica) as UbicacionFisica,
                //                                      max(Incidencia) as Incidencia,
                //                                      max(Fecha) as Fecha,
                //                                      max(Observaciones) as Observaciones,
                //                                      max(Horas) as Horas,
                //                                      max(IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
                //                                      max(IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
                //                                      max(EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
                //                                   max(RelacionLaboral) as RelacionLaboral,
                //                                   max(Horario) as Horario,
                //                                   max(HorarioEspecial) as HorarioEspecial from(
                //   select * from((Select count(IdTrabajador) as TotalFaltas,
                //                                      IdTrabajador,
                //                                      max(IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
                //                                      max(IdModalidadEstudio) as IdModalidadEstudio,
                //                                      max(ConvenioLaboral) as ConvenioLaboral,
                //                                      max(Nombre) as Nombre,
                //                                      max(ApellidoPaterno) as ApellidoPaterno,
                //                                      max(ApellidoMaterno) as ApellidoMaterno,
                //                                      max(Sexo) as Sexo,
                //                                      max(UbicacionFisica) as UbicacionFisica,
                //                                      max(Incidencia) as Incidencia,
                //                                      max(Fecha) as Fecha,
                //                                      max(Observaciones) as Observaciones,
                //                                      max(Horas) as Horas,
                //                                      max(IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
                //                                      max(IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
                //                                      max(EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
                //                                   max(RelacionLaboral) as RelacionLaboral,
                //                                   max(Horario) as Horario,
                //                                   max(HorarioEspecial) as HorarioEspecial

                //                                   from
                //               (select * from((SELECT count(t.IdTrabajador) as TotalFaltas,
                //                                      t.IdTrabajador,
                //                                      a.IdIncidenciaTrabajador,
                //                                      (cast(t.IdTrabajador as varchar) + '-' + cast((cast(a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,
                //                                      max(t.IdModalidadEstudio) as IdModalidadEstudio, max(t.ConvenioLaboral) as ConvenioLaboral,
                //                                      max(t.Nombre) as Nombre,
                //                                      max(t.ApellidoPaterno) as ApellidoPaterno,
                //                                      max(t.ApellidoMaterno) as ApellidoMaterno,
                //                                      max(t.Sexo) as Sexo,
                //                                      max(t.UbicacionFisica) as UbicacionFisica,
                //                                      max(b.Incidencia) as Incidencia,
                //                                      max(a.FechaInicio) as Fecha,

                //                                      max(a.Observaciones) as Observaciones,
                //                                      max(a.Horas) as Horas,
                //                                      max(t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
                //                                      max(t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
                //                                      max(t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
                //                                   max(t.RelacionLaboral) as RelacionLaboral,
                //                                   max(hor.Horario) as Horario, (SELECT  top 1

                //                                         max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

                //                                     FROM  Nomina_HorariosEspeciales h

                //                                     where h.Dia = 1 and  h.idtrabajador = t.idtrabajador) as HorarioEspecial

                //                                   FROM IncidenciaPermiso_stIncidenciaTrabajador  a

                //                                   inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                                   inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                                   inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                                   INNER JOIN Incidencia_ctJustificacion J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                                   left join(SELECT    max(cast(a.Entrada as nvarchar(5))) + '-' + max(cast(a.salida as nvarchar(5))) as Horario, a.IdRelacionConvenioLaboral

                //                                                 FROM  Nomina_HorariosConvenioConfiguracion a

                //                                                 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

                //                                                 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral

                //                                   WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES')


                //                                   and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}'  and t.IdModalidadEstudio = 0 and cast(t.FechaInicio as DATE) <= '{fi}'

                //                                   and a.EsCerrada = 0

                //                                   group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio)

                //                                   union
                //                                       (SELECT count(t.IdTrabajador) as TotalFaltas,
                //                                      t.IdTrabajador,
                //                                      max(a.IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
                //                                      (cast(t.IdTrabajador as varchar) + '-' + cast((cast(a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,
                //                                      max(t.IdModalidadEstudio) as IdModalidadEstudio, max(t.ConvenioLaboral) as ConvenioLaboral,
                //                                      max(t.Nombre) as Nombre,
                //                                      max(t.ApellidoPaterno) as ApellidoPaterno,
                //                                      max(t.ApellidoMaterno) as ApellidoMaterno,
                //                                      max(t.Sexo) as Sexo,
                //                                      max(t.UbicacionFisica) as UbicacionFisica,
                //                                      max(b.Incidencia) as Incidencia,
                //                                      max(a.FechaInicio) as Fecha,
                //                                      max(a.Observaciones) as Observaciones,
                //                                      max(a.Horas) as Horas,
                //                                      max(t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
                //                                      max(t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
                //                                      max(t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,

                //                                   max(t.RelacionLaboral) as RelacionLaboral,
                //                                   max(hor.Horario) as Horario, (SELECT  top 1

                //                                         max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

                //                                     FROM  Nomina_HorariosEspeciales h

                //                                     where h.Dia = 1 and  h.idtrabajador = t.idtrabajador) as HorarioEspecial


                //                                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a

                //                                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                                    INNER JOIN[Incidencia_ctJustificacion] J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                                    inner join(SELECT    max(cast(a.Entrada as nvarchar(5))) + '-' + max(cast(a.salida as nvarchar(5))) as Horario, a.IdRelacionConvenioLaboral

                //                                    FROM  Nomina_HorariosConvenioConfiguracion a

                //                                    inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

                //                                    group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral

                //                                    WHERE c.TipoIncidenciaPermiso in('RETARDOS')

                //                                   and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio = 0 and a.EsCerrada = 0

                //                                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio)) x

                //                                      where x.FaltaRetardoTrabajador not in (

                //                                   SELECT cast(t.IdTrabajador as varchar) + '-' + cast((cast(a.FechaInicio as DATE)) as varchar) as Dato

                //                                   FROM IncidenciaPermiso_stIncidenciaTrabajador  a

                //                                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                                    INNER JOIN Incidencia_ctJustificacion J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')

                //                                    and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio = 0) )  z
                //                                     group by z.IdTrabajador, z.IdIncidenciaTrabajador )) w

                //                                        where w.IdIncidenciaTrabajador not in (
                //                                           SELECT a.IdIncidenciaTrabajador
                //                                           FROM IncidenciaPermiso_stIncidenciaTrabajador a

                //                                            inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                                            inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                                            inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                                            INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                                            WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES')

                //                                             and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
                //								and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio = 0 ))  y
                //                                                group by y.IdTrabajador
                //                                            HAVING COUNT(TotalFaltas) > 2
                //                            )









                m = (List<IncidicenciasporAplicar>)dp.connection.Query<IncidicenciasporAplicar>(u);
            }
            return m;

            //       SELECT t.IdTrabajador, t.IdModalidadEstudio , t.ConvenioLaboral, t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica,t.IdEstructuraOrganicaPadre,t.EstructuraOrganicaPadre,
            //t.RelacionLaboral,
            //hor.Horario,(SELECT  top 1

            //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

            //                 FROM Nomina_HorariosEspeciales h
            //                 where h.Dia = 1 and h.idtrabajador = t.idtrabajador)  as HorarioEspecial
            //               FROM IncidenciaPermiso_stIncidenciaTrabajador  a
            //               inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
            //               inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
            //               inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
            //               INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

            //               inner join(SELECT max(cast(a.Entrada as nvarchar(5))) +'-' + max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
            //                             FROM  Nomina_HorariosConvenioConfiguracion a

            //                             inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

            //                             group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral
            //               WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')
            //               and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' and t.IdModalidadEstudio = 0  and a.IdIncidenciaTrabajador not in (


            //               SELECT a.IdIncidenciaTrabajador
            //               FROM IncidenciaPermiso_stIncidenciaTrabajador a

            //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

            //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

            //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

            //                INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

            //                WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')

            //                 and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
            //  and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' and t.IdModalidadEstudio = 0 )
            //               order by t.IdEstructuraOrganicaFisica ASC



            //       select* from((SELECT count(t.IdTrabajador)as TotalFaltas,
            //   t.IdTrabajador,
            //   a.IdIncidenciaTrabajador,                      
            //                  max(t.IdModalidadEstudio) as IdModalidadEstudio , max(t.ConvenioLaboral) as ConvenioLaboral, 
            //   max(t.Nombre) as Nombre,
            //   max(t.ApellidoPaterno) as ApellidoPaterno,
            //   max(t.ApellidoMaterno) as ApellidoMaterno,
            //   max(t.Sexo) as Sexo , 
            //   max(t.UbicacionFisica) as UbicacionFisica, 
            //   max(b.Incidencia) as Incidencia, 
            //   max(a.FechaInicio) as Fecha, 
            //   max(a.Observaciones) as Observaciones , 
            //   max(a.Horas) as Horas ,
            //   max(t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
            //   max(t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
            //   max(t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
            //max(t.RelacionLaboral) as RelacionLaboral ,
            //max(hor.Horario) as Horario,(SELECT  top 1

            //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

            //                 FROM Nomina_HorariosEspeciales h
            //                 where h.Dia = 1 and h.idtrabajador = t.idtrabajador)  as HorarioEspecial
            //               FROM IncidenciaPermiso_stIncidenciaTrabajador  a
            //               inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
            //               inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
            //               inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
            //               INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

            //               inner join(SELECT max(cast(a.Entrada as nvarchar(5))) +'-' + max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
            //                             FROM  Nomina_HorariosConvenioConfiguracion a

            //                             inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

            //                             group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral
            //               WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')
            //               and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' and t.IdModalidadEstudio = 0  and t.fechainicio <= '{fi}'

            //               group by  t.IdTrabajador, a.IdIncidenciaTrabajador )					
            //union
            //               (SELECT count(t.IdTrabajador) as TotalFaltas,
            //                  t.IdTrabajador,
            //                  max(a.IdIncidenciaTrabajador) asIdIncidenciaTrabajador,
            //                  max(t.IdModalidadEstudio) as IdModalidadEstudio, max(t.ConvenioLaboral) as ConvenioLaboral,
            //                  max(t.Nombre) as Nombre,
            //                  max(t.ApellidoPaterno) as ApellidoPaterno,
            //                  max(t.ApellidoMaterno) as ApellidoMaterno,
            //                  max(t.Sexo) as Sexo,
            //                  max(t.UbicacionFisica) as UbicacionFisica,
            //                  max(b.Incidencia) as Incidencia,
            //                  max(a.FechaInicio) as Fecha,
            //                  max(a.Observaciones) as Observaciones,
            //                  max(a.Horas) as Horas,
            //                  max(t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
            //                  max(t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
            //                  max(t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
            //               max(t.RelacionLaboral) as RelacionLaboral,
            //               max(hor.Horario) as Horario, (SELECT  top 1

            //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

            //                 FROM  Nomina_HorariosEspeciales h

            //                 where h.Dia = 1 and  h.idtrabajador = t.idtrabajador) as HorarioEspecial



            //                FROM IncidenciaPermiso_stIncidenciaTrabajador  a
            //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
            //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
            //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
            //                INNER JOIN[Incidencia_ctJustificacion] J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

            //                inner join(SELECT max(cast(a.Entrada as nvarchar(5))) +'-' + max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
            //                             FROM  Nomina_HorariosConvenioConfiguracion a

            //                             inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

            //                             group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral
            //                WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IdIncidenciaJustificacion > 0 and a.Autorizo = 1 and t.IdModalidadEstudio = 0


            //                 and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}'
            //                  group by  t.IdTrabajador
            //                  having count(t.IdTrabajador) > 2)) x
            //                  where x.IdIncidenciaTrabajador not in (


            //               SELECT a.IdIncidenciaTrabajador
            //               FROM IncidenciaPermiso_stIncidenciaTrabajador a

            //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

            //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

            //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

            //                INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

            //                WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')

            //                 and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
            //  and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' and t.IdModalidadEstudio = 0 )
            //                order by  x.TotalFaltas, x.IdEstructuraOrganicaFisica ASC

        }

        public static List<IncidicenciasporAplicar> getIncidenciasporAplicarCentro(string fip, string ftp)
        {
            List<IncidicenciasporAplicar> m = new List<IncidicenciasporAplicar>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {
                u = $@"
(Select count(IdTrabajador) as TotalFaltas,
					   IdTrabajador,
					   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
                       max (IdModalidadEstudio) as IdModalidadEstudio , 
					   max( ConvenioLaboral) as ConvenioLaboral, 
					   max (Nombre) as Nombre,
					   max (ApellidoPaterno) as ApellidoPaterno,
					   max (ApellidoMaterno) as ApellidoMaterno,
					   max (Sexo) as Sexo , 
					   max (UbicacionFisica) as UbicacionFisica, 
					   max (Incidencia) as Incidencia, 
					   max (Fecha) as Fecha, 
					   max (Observaciones) as Observaciones , 
					   max (Horas) as Horas ,
					   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (RelacionLaboral)as RelacionLaboral ,
					max (Horario) as Horario,
					max (HorarioEspecial) as HorarioEspecial
					from
                    ( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,
					   a.IdIncidenciaTrabajador,                      
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                
					--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) and cast(t.FechaInicio as DATE)  <= '{fi}'
                     and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and t.IdModalidadEstudio in (1,2) 

                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador )					
					union
						(SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador, 
					   max (a.IdIncidenciaTrabajador) LasIdIncidenciaTrabajador,
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
				     FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
					 FROM  Nomina_HorariosConvenioConfiguracion a
					 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
					 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
		
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2)
					 group by  t.IdTrabajador, a.IdIncidenciaTrabajador	)) x
					   where x.IdIncidenciaTrabajador not in (


					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2)) )  z
					 where Incidencia IN  ( 'FALTA POR DÍA', 'FALTA POR HORAS', 'FALTA POR RETARDOS', 'FALTA HORAS CLUB')
					  group by z.IdTrabajador, z.Incidencia, z.Fecha
					)
					union 
					(
					select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial from(
		select * from (			(Select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial
										from
					( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador,
										   a.IdIncidenciaTrabajador,  
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,              
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
					  
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
													  FROM  Nomina_HorariosConvenioConfiguracion a
													  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
													  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES') 
               
										--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <=  '{ft}'  and t.IdModalidadEstudio in (1,2) and cast(t.FechaInicio as DATE)  <= '{fi}'
                                        and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and t.IdModalidadEstudio in (1,2)
										and a.EsCerrada=0
										group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio )					
										union
											(SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador, 
										   max (a.IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,   
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
										 FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
										 FROM  Nomina_HorariosConvenioConfiguracion a
										 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
										 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
										and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) and a.EsCerrada=0
										 group by  t.IdTrabajador, a.IdIncidenciaTrabajador,a.FechaInicio	)) x
										   where x.FaltaRetardoTrabajador not in (

										SELECT cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar) as Dato
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA' )					
										 and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) ) )  z
										  group by z.IdTrabajador, z.IdIncidenciaTrabajador )) w

										     where w.IdIncidenciaTrabajador not in (
												SELECT a.IdIncidenciaTrabajador
												FROM IncidenciaPermiso_stIncidenciaTrabajador  a
												 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
												 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
												 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
												 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
												 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'VACACIONES') 
												  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
													and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) ))  y
													group by y.IdTrabajador
												HAVING COUNT(TotalFaltas) > 2
					                            )

";


                m = (List<IncidicenciasporAplicar>)dp.connection.Query<IncidicenciasporAplicar>(u);
            }
            return m;
        }

        public static List<IncidicenciasporAplicar> getIncidenciasporAplicarMesa(string fip, string ftp)
        {
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<IncidicenciasporAplicar> m = new List<IncidicenciasporAplicar>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {


                u = $@" 

 select * 
 into #TrabajadoresFaltas
from ( 
(Select count(IdTrabajador) as TotalFaltas,
					   IdTrabajador,
					   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
                       max (IdModalidadEstudio) as IdModalidadEstudio , 
					   max( ConvenioLaboral) as ConvenioLaboral, 
					   max (Nombre) as Nombre,
					   max (ApellidoPaterno) as ApellidoPaterno,
					   max (ApellidoMaterno) as ApellidoMaterno,
					   max (Sexo) as Sexo , 
					   max (UbicacionFisica) as UbicacionFisica, 
					   max (Incidencia) as Incidencia, 
					   max (Fecha) as Fecha, 
					   max (Observaciones) as Observaciones , 
					   max (Horas) as Horas ,
					   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (RelacionLaboral)as RelacionLaboral ,
					max (Horario) as Horario,
					max (HorarioEspecial) as HorarioEspecial
					from
                    ( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,
					   a.IdIncidenciaTrabajador,                      
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                
					--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) and cast(t.FechaInicio as DATE)  <= '{fi}'
                     and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and t.IdModalidadEstudio in (1,2)

                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador )					
					union
						(SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador, 
					   max (a.IdIncidenciaTrabajador) LasIdIncidenciaTrabajador,
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
				     FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
					 FROM  Nomina_HorariosConvenioConfiguracion a
					 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
					 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
		
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2)
					 group by  t.IdTrabajador, a.IdIncidenciaTrabajador	)) x
					   where x.IdIncidenciaTrabajador not in (


					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) ) )  z
					 where Incidencia IN  ( 'FALTA POR DÍA', 'FALTA POR HORAS', 'FALTA POR RETARDOS', 'FALTA HORAS CLUB')
					  group by z.IdTrabajador, z.Incidencia, z.Fecha
					)
					union 
					(
					select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial from(
		select * from (			(Select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial
										from
					( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador,
										   a.IdIncidenciaTrabajador,  
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,              
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
					  
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
													  FROM  Nomina_HorariosConvenioConfiguracion a
													  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
													  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES') 
               
										--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <=  '{ft}'  and t.IdModalidadEstudio in (1,2) and cast(t.FechaInicio as DATE)  <= '{fi}'
                                         and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and t.IdModalidadEstudio in (1,2)
										and a.EsCerrada=0
										group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio )					
										union
											(SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador, 
										   max (a.IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,   
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
										 FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
										 FROM  Nomina_HorariosConvenioConfiguracion a
										 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
										 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
										and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) and a.EsCerrada=0
										 group by  t.IdTrabajador, a.IdIncidenciaTrabajador,a.FechaInicio	)) x
										   where x.FaltaRetardoTrabajador not in (

										SELECT cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar) as Dato
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA' )					
										 and cast(a.FechaInicio as DATE) >= '20230501' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) ) )  z
										  group by z.IdTrabajador, z.IdIncidenciaTrabajador )) w

										     where w.IdIncidenciaTrabajador not in (
												SELECT a.IdIncidenciaTrabajador
												FROM IncidenciaPermiso_stIncidenciaTrabajador  a
												 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
												 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
												 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
												 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
												 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'VACACIONES') 
												  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
													and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio in (1,2) ))  y
													group by y.IdTrabajador
												HAVING COUNT(TotalFaltas) > 2
					                            )) as zz


	                                Select * from #TrabajadoresFaltas a
								   			 inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
									inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
									inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
									where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) p on a.IdEstructuraOrganicaFisica  = p.IdEstructuraOrganica


									





 ";
                m = (List<IncidicenciasporAplicar>)dp.connection.Query<IncidicenciasporAplicar>(u);
            }
            return m;



        }


        public static List<IndicenciasGlobales> getIncidenciasGlobales(string fip, string ftp)
        {
            List<IndicenciasGlobales> m = new List<IndicenciasGlobales>();



            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";


            if (fip != null)
            {

                DateTime fil = DateTime.Parse(fip);
                string fi = fil.ToString("yyyMMdd");
                DateTime ftl = DateTime.Parse(ftp);
                string ft = ftl.ToString("yyyMMdd");
                u = $@"
select * 

from ( SELECT  [IdEstructuraOrganica], a.IdEstructuraOrganicaPadre
                         ,case when IdModalidadEstudio=0 then 'OFICINAS CENTRALES' ELSE
                           CASE WHEN IdModalidadEstudio=1 THEN 'PLANTELES' ELSE 'EMSADS' END END AS TipoCentro
                          ,[EstructuraOrganica] as Departamento
                          ,(select [EstructuraOrganica] FROM [bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica=a.IdEstructuraOrganicaPadre) as PerteneceA
                          ,x.TotalFaltasJustificadas
                          ,w.TotalFaltas
                          ,z.TotalRetardos
                          ,y.TotalRetardosJustificados
                          ,w.AñoQuincenaNomina 
                          ,w.ctaAñoNomina 
	                     
                      FROM [Catalogos_ctEstructuraOrganica] a
                        left join ( SELECT count(t.IdTrabajador)as TotalFaltas,t.IdEstructuraOrganicaFisica,
                       sum(case when AñoParaNomina is not null then 1 else 0 end) as ctaAñoNomina,
                       max(case when AñoParaNomina is not null then cast(AñoParaNomina as nvarchar(8))+'-'+cast(QuincenaParaNomina as nvarchar(8)) else '' end) as AñoQuincenaNomina
                        
                                                           FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES')
 
                       and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'  and cast(t.FechaInicio as DATE)  <= '{fi}'
                        --and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}')    
                       group by 
                        t.IdEstructuraOrganicaFisica) as w on w.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                       left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalFaltasJustificadas,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                      and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                    and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}' 
                       group by t.IdEstructuraOrganicaFisica) as x on x.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                       left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardos,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     WHERE c.TipoIncidenciaPermiso in('RETARDOS')  
                             and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}' 
                       group by t.IdEstructuraOrganicaFisica) as z on z.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
  
                      left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardosJustificados,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     WHERE c.TipoIncidenciaPermiso in('RETARDOS')  
                     and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                              and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'   
                       group by t.IdEstructuraOrganicaFisica) as y on y.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]where a.EsVigente=1  
                      ) as qq where qq.TotalFaltas is not null and qq.TipoCentro in ('OFICINAS CENTRALES')
                    order by qq.IdEstructuraOrganicaPadre
                ";


                //select* from(SELECT[IdEstructuraOrganica]
                //         ,case when IdModalidadEstudio = 0 then 'OFICINAS CENTRALES' ELSE
                //CASE WHEN IdModalidadEstudio = 1 THEN 'PLANTELES' ELSE 'EMSADS' END END AS TipoCentro
                //          ,[EstructuraOrganica] as Departamento
                //          ,(select[EstructuraOrganica] FROM[bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica = a.IdEstructuraOrganicaPadre) as PerteneceA
                //          ,x.TotalFaltasJustificadas
                //          ,w.TotalFaltas
                //          ,z.TotalRetardos
                //          ,y.TotalRetardosJustificados
                //      FROM[Catalogos_ctEstructuraOrganica] a
                //        left join(SELECT count(t.IdTrabajador) as TotalFaltas, t.IdEstructuraOrganicaFisica
                //                                           FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                //     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //     INNER JOIN[Incidencia_ctJustificacion] J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion
                //     WHERE c.TipoIncidenciaPermiso in ('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')
                //      and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}'
                //       group by
                //        t.IdEstructuraOrganicaFisica) as w on w.IdEstructuraOrganicaFisica =[IdEstructuraOrganica]
                //       left join(SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalFaltasJustificadas,t.IdEstructuraOrganicaFisica
                //                        FROM IncidenciaPermiso_stIncidenciaTrabajador a
                //     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //     INNER JOIN[Incidencia_ctJustificacion] J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion
                //     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')
                //      and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
                //      and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}'
                //       group by t.IdEstructuraOrganicaFisica) as x on x.IdEstructuraOrganicaFisica =[IdEstructuraOrganica]
                //       left join(SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardos,t.IdEstructuraOrganicaFisica
                //                        FROM IncidenciaPermiso_stIncidenciaTrabajador a
                //     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //     WHERE c.TipoIncidenciaPermiso in('RETARDOS')
                //      and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}'
                //       group by t.IdEstructuraOrganicaFisica) as z on z.IdEstructuraOrganicaFisica =[IdEstructuraOrganica]


                //      left join(SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardosJustificados,t.IdEstructuraOrganicaFisica
                //                        FROM IncidenciaPermiso_stIncidenciaTrabajador a
                //     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //     WHERE c.TipoIncidenciaPermiso in('RETARDOS')
                //     and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
                //      and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}'
                //       group by t.IdEstructuraOrganicaFisica) as y on y.IdEstructuraOrganicaFisica =[IdEstructuraOrganica]where a.EsVigente = 1
                //      ) as qq where qq.TotalFaltas is not null

                m = (List<IndicenciasGlobales>)dp.connection.Query<IndicenciasGlobales>(u);
            }
            return m;
        }

        public static List<IndicenciasGlobales> getIncidenciasGlobalesCentro(string fip, string ftp)
        {
            List<IndicenciasGlobales> m = new List<IndicenciasGlobales>();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fip != null)
            {
                DateTime fil = DateTime.Parse(fip);
                string fi = fil.ToString("yyyMMdd");
                DateTime ftl = DateTime.Parse(ftp);
                string ft = ftl.ToString("yyyMMdd");
                u = $@"select * 

from ( SELECT  [IdEstructuraOrganica], a.IdEstructuraOrganicaPadre
                         ,case when IdModalidadEstudio=0 then 'OFICINAS CENTRALES' ELSE
                           CASE WHEN IdModalidadEstudio=1 THEN 'PLANTELES' ELSE 'EMSADS' END END AS TipoCentro
                          ,[EstructuraOrganica] as Departamento
                          ,(select [EstructuraOrganica] FROM [bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica=a.IdEstructuraOrganicaPadre) as PerteneceA
                          ,x.TotalFaltasJustificadas
                          ,w.TotalFaltas
                          ,z.TotalRetardos
                          ,y.TotalRetardosJustificados
                          ,w.AñoQuincenaNomina 
                          ,w.ctaAñoNomina 
	                     
                      FROM [Catalogos_ctEstructuraOrganica] a
                        left join ( SELECT count(t.IdTrabajador)as TotalFaltas,t.IdEstructuraOrganicaFisica,
                       sum(case when AñoParaNomina is not null then 1 else 0 end) as ctaAñoNomina,
                       max(case when AñoParaNomina is not null then cast(AñoParaNomina as nvarchar(8))+'-'+cast(QuincenaParaNomina as nvarchar(8)) else '' end) as AñoQuincenaNomina
                        
                                                           FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES')
                      --and  cast(a.FechaInicio as DATE) >= '{fi}' and  cast(a.FechaInicio as DATE)  <= '{ft}' and  cast(t.FechaInicio as DATE) <= '{fi}' 
                        and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}')    
                       group by 
                        t.IdEstructuraOrganicaFisica) as w on w.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                       left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalFaltasJustificadas,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                      and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                      and  cast(a.FechaInicio as DATE) >= '{fi}' and  cast(a.FechaInicio as DATE)  <='{ft}' 
                       group by t.IdEstructuraOrganicaFisica) as x on x.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                       left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardos,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     WHERE c.TipoIncidenciaPermiso in('RETARDOS')  
                      and  cast(a.FechaInicio as DATE) >= '{fi}' and  cast(a.FechaInicio as DATE)  <='{ft}' 
                       group by t.IdEstructuraOrganicaFisica) as z on z.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
  
                      left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardosJustificados,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     WHERE c.TipoIncidenciaPermiso in('RETARDOS')  
                     and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                      and  cast(a.FechaInicio as DATE) >= '{fi}' and   cast(a.FechaInicio as DATE)  <='{ft}'   
                       group by t.IdEstructuraOrganicaFisica) as y on y.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]where a.EsVigente=1  
                      ) as qq where qq.TotalFaltas is not null and qq.TipoCentro in ('EMSADS','PLANTELES')
                    order by qq.IdEstructuraOrganicaPadre 
                ";



                m = (List<IndicenciasGlobales>)dp.connection.Query<IndicenciasGlobales>(u);
            }
            return m;
        }


        public static List<IndicenciasGlobales> getIncidenciasGlobalesCentro(string fip, string ftp, string depa)
        {
            List<IndicenciasGlobales> m = new List<IndicenciasGlobales>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";

            if (fi != null)
            {
                u = $@"select * from ( SELECT  [IdEstructuraOrganica]
                         ,case when IdModalidadEstudio=0 then 'OFICINAS CENTRALES' ELSE
                           CASE WHEN IdModalidadEstudio=1 THEN 'PLANTELES' ELSE 'EMSADS' END END AS TipoCentro
                          ,[EstructuraOrganica] as Departamento
                          ,(select [EstructuraOrganica] FROM [bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica=a.IdEstructuraOrganicaPadre) as PerteneceA
                          ,x.TotalFaltasJustificadas
                          ,w.TotalFaltas
                          ,z.TotalRetardos
                          ,y.TotalRetardosJustificados
                      FROM [Catalogos_ctEstructuraOrganica] a
                        left join ( SELECT count(t.IdTrabajador)as TotalFaltas,t.IdEstructuraOrganicaFisica
                                                           FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES')
                      --and a.FechaInicio >= '{fi}' and a.FechaInicio  <='{ft}' and t.fechainicio <= '{fi}'
                        and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}')     
                       group by 
                        t.IdEstructuraOrganicaFisica) as w on w.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                       left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalFaltasJustificadas,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                      and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                      and a.FechaInicio >= '{fi}' and a.FechaInicio  <='{ft}' and t.fechainicio <= '{fi}'
                       group by t.IdEstructuraOrganicaFisica) as x on x.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                       left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardos,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     WHERE c.TipoIncidenciaPermiso in('RETARDOS')  
                      and a.FechaInicio >= '{fi}' and a.FechaInicio  <='{ft}'  and t.fechainicio <= '{fi}'
                       group by t.IdEstructuraOrganicaFisica) as z on z.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
  
                      left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardosJustificados,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     WHERE c.TipoIncidenciaPermiso in('RETARDOS')  
                     and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                      and a.FechaInicio >= '{fi}' and a.FechaInicio  <='{ft}' and t.fechainicio <= '{fi}'  
                       group by t.IdEstructuraOrganicaFisica) as y on y.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]where a.EsVigente=1  
                      ) as qq where qq.TotalFaltas is not null and qq.Departamento='{depa}' and t.fechainicio <= '{fi}'";

                m = (List<IndicenciasGlobales>)dp.connection.Query<IndicenciasGlobales>(u);
            }
            return m;
        }

        public static List<IndicenciasGlobales> getIncidenciasGlobalesMesa(string fip, string ftp)
        {
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<IndicenciasGlobales> m = new List<IndicenciasGlobales>();



            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";


            if (fip != null)
            {

                DateTime fil = DateTime.Parse(fip);
                string fi = fil.ToString("yyyMMdd");
                DateTime ftl = DateTime.Parse(ftp);
                string ft = ftl.ToString("yyyMMdd");
                u = $@"
select * 

from ( SELECT  [IdEstructuraOrganica], a.IdEstructuraOrganicaPadre
                         ,case when IdModalidadEstudio=0 then 'OFICINAS CENTRALES' ELSE
                           CASE WHEN IdModalidadEstudio=1 THEN 'PLANTELES' ELSE 'EMSADS' END END AS TipoCentro
                          ,[EstructuraOrganica] as Departamento
                          ,(select [EstructuraOrganica] FROM [bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica=a.IdEstructuraOrganicaPadre) as PerteneceA
                          ,x.TotalFaltasJustificadas
                          ,w.TotalFaltas
                          ,z.TotalRetardos
                          ,y.TotalRetardosJustificados
                          ,w.AñoQuincenaNomina 
                          ,w.ctaAñoNomina 
	                     
                      FROM [Catalogos_ctEstructuraOrganica] a
                        left join ( SELECT count(t.IdTrabajador)as TotalFaltas,t.IdEstructuraOrganicaFisica,
                       sum(case when AñoParaNomina is not null then 1 else 0 end) as ctaAñoNomina,
                       max(case when AñoParaNomina is not null then cast(AñoParaNomina as nvarchar(8))+'-'+cast(QuincenaParaNomina as nvarchar(8)) else '' end) as AñoQuincenaNomina
                        
                                                           FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES')
 
                        --and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'  and cast(t.FechaInicio as DATE)  <= '{fi}'
                        and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}')    
                       group by 
                        t.IdEstructuraOrganicaFisica) as w on w.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                       left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalFaltasJustificadas,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                      and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                    and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}' 
                       group by t.IdEstructuraOrganicaFisica) as x on x.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                       left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardos,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     WHERE c.TipoIncidenciaPermiso in('RETARDOS')  
                             and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}' 
                       group by t.IdEstructuraOrganicaFisica) as z on z.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
  
                      left join ( SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as TotalRetardosJustificados,t.IdEstructuraOrganicaFisica
                                        FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     WHERE c.TipoIncidenciaPermiso in('RETARDOS')  
                     and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                              and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'   
                       group by t.IdEstructuraOrganicaFisica) as y on y.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]where a.EsVigente=1  
                      )   as qq

					  inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
									inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
									inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
									where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) p on qq.IdEstructuraOrganica = p.IdEstructuraOrganica
					  
					  
					  
					 where qq.TotalFaltas is not null 



                    order by qq.IdEstructuraOrganicaPadre


                ";



                m = (List<IndicenciasGlobales>)dp.connection.Query<IndicenciasGlobales>(u);
            }
            return m;
        }


        public static List<IncidicenciasporAplicar> getIncidenciasDepartamento(string fip, string ftp, string depa)
        {
            List<IncidicenciasporAplicar> m = new List<IncidicenciasporAplicar>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {
                u = $@"
(Select count(IdTrabajador) as TotalFaltas,
					   IdTrabajador,
					   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
                       max (IdModalidadEstudio) as IdModalidadEstudio , 
					   max( ConvenioLaboral) as ConvenioLaboral, 
					   max (Nombre) as Nombre,
					   max (ApellidoPaterno) as ApellidoPaterno,
					   max (ApellidoMaterno) as ApellidoMaterno,
					   max (Sexo) as Sexo , 
					   max (UbicacionFisica) as UbicacionFisica, 
					   max (Incidencia) as Incidencia, 
					   max (Fecha) as Fecha, 
					   max (Observaciones) as Observaciones , 
					   max (Horas) as Horas ,
					   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (RelacionLaboral)as RelacionLaboral ,
					max (Horario) as Horario,
					max (HorarioEspecial) as HorarioEspecial
					from
                    ( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,
					   a.IdIncidenciaTrabajador,                      
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                
					--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio= 0 and cast(t.FechaInicio as DATE)  <= '{fi}'
                    and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio= 0

                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador )					
					union
						(SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador, 
					   max (a.IdIncidenciaTrabajador) LasIdIncidenciaTrabajador,
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
				     FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
					 FROM  Nomina_HorariosConvenioConfiguracion a
					 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
					 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
		
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio= 0
					 group by  t.IdTrabajador, a.IdIncidenciaTrabajador	)) x
					   where x.IdIncidenciaTrabajador not in (


					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio= 0 ) )  z
					 where Incidencia IN  ( 'FALTA POR DÍA', 'FALTA POR HORAS', 'FALTA POR RETARDOS', 'FALTA HORAS CLUB')
					  group by z.IdTrabajador, z.Incidencia, z.Fecha
					)
					union 
					(
					select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial from(
		select * from (			(Select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial
										from
					( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador,
										   a.IdIncidenciaTrabajador,  
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,              
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
					  
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
													  FROM  Nomina_HorariosConvenioConfiguracion a
													  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
													  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES') 
               
										--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <=  '{ft}' and Ubicacionfisica = '{depa}'  and t.IdModalidadEstudio= 0 and cast(t.FechaInicio as DATE)  <= '{fi}'
                                        and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio= 0										
                                        and a.EsCerrada=0
										group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio )					
										union
											(SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador, 
										   max (a.IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,   
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
										 FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
										 FROM  Nomina_HorariosConvenioConfiguracion a
										 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
										 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
										and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio= 0 and a.EsCerrada=0
										 group by  t.IdTrabajador, a.IdIncidenciaTrabajador,a.FechaInicio	)) x
										   where x.FaltaRetardoTrabajador not in (

										SELECT cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar) as Dato
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA' )					
										 and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio= 0 ) )  z
										  group by z.IdTrabajador, z.IdIncidenciaTrabajador )) w

										     where w.IdIncidenciaTrabajador not in (
												SELECT a.IdIncidenciaTrabajador
												FROM IncidenciaPermiso_stIncidenciaTrabajador  a
												 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
												 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
												 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
												 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
												 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'VACACIONES') 
												  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
													and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio= 0 ))  y
													group by y.IdTrabajador
												HAVING COUNT(TotalFaltas) > 2
					                            )
 ";


                //           SELECT t.IdTrabajador, t.IdModalidadEstudio,  t.ConvenioLaboral,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica,t.IdEstructuraOrganicaPadre,t.EstructuraOrganicaPadre,
                //t.RelacionLaboral,
                //hor.Horario,(SELECT  top 1

                //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

                //                 FROM Nomina_HorariosEspeciales h
                //                 where h.Dia = 1 and h.idtrabajador = t.idtrabajador)  as HorarioEspecial
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                //               inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //               inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //               inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //               INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //               inner join(SELECT max(cast(a.Entrada as nvarchar(5))) +'-' + max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
                //                             FROM  Nomina_HorariosConvenioConfiguracion a

                //                             inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

                //                             group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral
                //               WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')
                //               and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' and Ubicacionfisica = '{depa}'  and a.IdIncidenciaTrabajador not in (


                //               SELECT a.IdIncidenciaTrabajador
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador a

                //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')

                //                 and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
                //  and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' ) and Ubicacionfisica = '{depa}'
                //               order by t.IdEstructuraOrganicaFisica ASC

                m = (List<IncidicenciasporAplicar>)dp.connection.Query<IncidicenciasporAplicar>(u);
            }
            return m;
        }
        public static List<IncidicenciasporAplicar> getIncidenciasDireccion(string fip, string ftp, string dir)
        {
            List<IncidicenciasporAplicar> m = new List<IncidicenciasporAplicar>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {
                u = $@"

(Select count(IdTrabajador) as TotalFaltas,
					   IdTrabajador,
					   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
                       max (IdModalidadEstudio) as IdModalidadEstudio , 
					   max( ConvenioLaboral) as ConvenioLaboral, 
					   max (Nombre) as Nombre,
					   max (ApellidoPaterno) as ApellidoPaterno,
					   max (ApellidoMaterno) as ApellidoMaterno,
					   max (Sexo) as Sexo , 
					   max (UbicacionFisica) as UbicacionFisica, 
					   max (Incidencia) as Incidencia, 
					   max (Fecha) as Fecha, 
					   max (Observaciones) as Observaciones , 
					   max (Horas) as Horas ,
					   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (RelacionLaboral)as RelacionLaboral ,
					max (Horario) as Horario,
					max (HorarioEspecial) as HorarioEspecial
					from
                    ( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,
					   a.IdIncidenciaTrabajador,                      
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                
					--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio= 0 and cast(t.FechaInicio as DATE)  <= '{fi}'
                    and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and Ubicacionfisica = '{dir}' and t.IdModalidadEstudio= 0

                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador )					
					union
						(SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador, 
					   max (a.IdIncidenciaTrabajador) LasIdIncidenciaTrabajador,
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
				     FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
					 FROM  Nomina_HorariosConvenioConfiguracion a
					 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
					 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
		
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio= 0
					 group by  t.IdTrabajador, a.IdIncidenciaTrabajador	)) x
					   where x.IdIncidenciaTrabajador not in (


					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio= 0 ) )  z
					 where Incidencia IN  ( 'FALTA POR DÍA', 'FALTA POR HORAS', 'FALTA POR RETARDOS', 'FALTA HORAS CLUB')
					  group by z.IdTrabajador, z.Incidencia, z.Fecha
					)
					union 
					(
					select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial from(
		select * from (			(Select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial
										from
					( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador,
										   a.IdIncidenciaTrabajador,  
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,              
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
					  
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
													  FROM  Nomina_HorariosConvenioConfiguracion a
													  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
													  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES') 
               
										--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <=  '{ft}' and t.EstructuraOrganicaPadre = '{dir}'  and t.IdModalidadEstudio= 0 and cast(t.FechaInicio as DATE)  <= '{fi}'
										and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and Ubicacionfisica = '{dir}' and t.IdModalidadEstudio= 0
                                        and a.EsCerrada=0
										group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio )					
										union
											(SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador, 
										   max (a.IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,   
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
										 FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
										 FROM  Nomina_HorariosConvenioConfiguracion a
										 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
										 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
										and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio= 0 and a.EsCerrada=0
										 group by  t.IdTrabajador, a.IdIncidenciaTrabajador,a.FechaInicio	)) x
										   where x.FaltaRetardoTrabajador not in (

										SELECT cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar) as Dato
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA' )					
										 and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio= 0 ) )  z
										  group by z.IdTrabajador, z.IdIncidenciaTrabajador )) w

										     where w.IdIncidenciaTrabajador not in (
												SELECT a.IdIncidenciaTrabajador
												FROM IncidenciaPermiso_stIncidenciaTrabajador  a
												 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
												 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
												 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
												 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
												 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'VACACIONES') 
												  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
													and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio= 0 ))  y
													group by y.IdTrabajador
												HAVING COUNT(TotalFaltas) > 2
					                            )

 ";


                //           SELECT t.IdTrabajador, t.IdModalidadEstudio ,  t.ConvenioLaboral,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica,t.IdEstructuraOrganicaPadre,t.EstructuraOrganicaPadre,
                //t.RelacionLaboral,
                //hor.Horario,(SELECT  top 1

                //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

                //                 FROM Nomina_HorariosEspeciales h
                //                 where h.Dia = 1 and h.idtrabajador = t.idtrabajador)  as HorarioEspecial
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                //               inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //               inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //               inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //               INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //               inner join(SELECT max(cast(a.Entrada as nvarchar(5))) +'-' + max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
                //                             FROM  Nomina_HorariosConvenioConfiguracion a

                //                             inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

                //                             group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral
                //               WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')
                //               and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio = { idmodalidad}
                //           and a.IdIncidenciaTrabajador not in (


                //               SELECT a.IdIncidenciaTrabajador
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador a

                //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')

                //                 and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
                //  and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' ) and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio = { idmodalidad}
                //           order by t.IdEstructuraOrganicaFisica ASC


                m = (List<IncidicenciasporAplicar>)dp.connection.Query<IncidicenciasporAplicar>(u);
            }
            return m;
        }


        public static List<IncidicenciasporAplicar> getIncidenciasDepartamentoCentro(string fip, string ftp, string depa)
        {
            List<IncidicenciasporAplicar> m = new List<IncidicenciasporAplicar>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {
                u = $@"
(Select count(IdTrabajador) as TotalFaltas,
					   IdTrabajador,
					   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
                       max (IdModalidadEstudio) as IdModalidadEstudio , 
					   max( ConvenioLaboral) as ConvenioLaboral, 
					   max (Nombre) as Nombre,
					   max (ApellidoPaterno) as ApellidoPaterno,
					   max (ApellidoMaterno) as ApellidoMaterno,
					   max (Sexo) as Sexo , 
					   max (UbicacionFisica) as UbicacionFisica, 
					   max (Incidencia) as Incidencia, 
					   max (Fecha) as Fecha, 
					   max (Observaciones) as Observaciones , 
					   max (Horas) as Horas ,
					   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (RelacionLaboral)as RelacionLaboral ,
					max (Horario) as Horario,
					max (HorarioEspecial) as HorarioEspecial
					from
                    ( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,
					   a.IdIncidenciaTrabajador,                      
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                
					--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio in (1,2) and cast(t.FechaInicio as DATE)  <= '{fi}'
                    and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio in (1,2)

                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador )					
					union
						(SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador, 
					   max (a.IdIncidenciaTrabajador) LasIdIncidenciaTrabajador,
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
				     FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
					 FROM  Nomina_HorariosConvenioConfiguracion a
					 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
					 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
		
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio in (1,2)
					 group by  t.IdTrabajador, a.IdIncidenciaTrabajador	)) x
					   where x.IdIncidenciaTrabajador not in (


					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio in (1,2) ) )  z
					 where Incidencia IN  ( 'FALTA POR DÍA', 'FALTA POR HORAS', 'FALTA POR RETARDOS', 'FALTA HORAS CLUB')
					  group by z.IdTrabajador, z.Incidencia, z.Fecha
					)
					union 
					(
					select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial from(
		select * from (			(Select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial
										from
					( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador,
										   a.IdIncidenciaTrabajador,  
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,              
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
					  
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
													  FROM  Nomina_HorariosConvenioConfiguracion a
													  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
													  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES') 
               
										--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <=  '{ft}' and Ubicacionfisica = '{depa}'  and t.IdModalidadEstudio in (1,2) and cast(t.FechaInicio as DATE)  <= '{fi}'
										and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio in (1,2)
                                        and a.EsCerrada=0
										group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio )					
										union
											(SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador, 
										   max (a.IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,   
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
										 FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
										 FROM  Nomina_HorariosConvenioConfiguracion a
										 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
										 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
										and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio in (1,2) and a.EsCerrada=0
										 group by  t.IdTrabajador, a.IdIncidenciaTrabajador,a.FechaInicio	)) x
										   where x.FaltaRetardoTrabajador not in (

										SELECT cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar) as Dato
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA' )					
										 and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio in (1,2) ) )  z
										  group by z.IdTrabajador, z.IdIncidenciaTrabajador )) w

										     where w.IdIncidenciaTrabajador not in (
												SELECT a.IdIncidenciaTrabajador
												FROM IncidenciaPermiso_stIncidenciaTrabajador  a
												 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
												 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
												 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
												 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
												 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'VACACIONES') 
												  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
													and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and Ubicacionfisica = '{depa}' and t.IdModalidadEstudio in (1,2) ))  y
													group by y.IdTrabajador
												HAVING COUNT(TotalFaltas) > 2
					                            )
 ";


                //           SELECT t.IdTrabajador, t.IdModalidadEstudio,  t.ConvenioLaboral,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica,t.IdEstructuraOrganicaPadre,t.EstructuraOrganicaPadre,
                //t.RelacionLaboral,
                //hor.Horario,(SELECT  top 1

                //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

                //                 FROM Nomina_HorariosEspeciales h
                //                 where h.Dia = 1 and h.idtrabajador = t.idtrabajador)  as HorarioEspecial
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                //               inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //               inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //               inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //               INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //               inner join(SELECT max(cast(a.Entrada as nvarchar(5))) +'-' + max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
                //                             FROM  Nomina_HorariosConvenioConfiguracion a

                //                             inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

                //                             group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral
                //               WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')
                //               and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' and Ubicacionfisica = '{depa}'  and a.IdIncidenciaTrabajador not in (


                //               SELECT a.IdIncidenciaTrabajador
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador a

                //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')

                //                 and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
                //  and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' ) and Ubicacionfisica = '{depa}'
                //               order by t.IdEstructuraOrganicaFisica ASC

                m = (List<IncidicenciasporAplicar>)dp.connection.Query<IncidicenciasporAplicar>(u);
            }
            return m;
        }
        public static List<IncidicenciasporAplicar> getIncidenciasDireccionCentro(string fip, string ftp, string dir)
        {
            List<IncidicenciasporAplicar> m = new List<IncidicenciasporAplicar>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {
                u = $@"

(Select count(IdTrabajador) as TotalFaltas,
					   IdTrabajador,
					   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
                       max (IdModalidadEstudio) as IdModalidadEstudio , 
					   max( ConvenioLaboral) as ConvenioLaboral, 
					   max (Nombre) as Nombre,
					   max (ApellidoPaterno) as ApellidoPaterno,
					   max (ApellidoMaterno) as ApellidoMaterno,
					   max (Sexo) as Sexo , 
					   max (UbicacionFisica) as UbicacionFisica, 
					   max (Incidencia) as Incidencia, 
					   max (Fecha) as Fecha, 
					   max (Observaciones) as Observaciones , 
					   max (Horas) as Horas ,
					   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (RelacionLaboral)as RelacionLaboral ,
					max (Horario) as Horario,
					max (HorarioEspecial) as HorarioEspecial
					from
                    ( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,
					   a.IdIncidenciaTrabajador,                      
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
                
					--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio in (1,2) and cast(t.FechaInicio as DATE)  <= '{fi}'
                    and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and Ubicacionfisica = '{dir}' and t.IdModalidadEstudio in (1,2)

                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador )					
					union
						(SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador, 
					   max (a.IdIncidenciaTrabajador) LasIdIncidenciaTrabajador,
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
				     FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
					 FROM  Nomina_HorariosConvenioConfiguracion a
					 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
					 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
		
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio in (1,2)
					 group by  t.IdTrabajador, a.IdIncidenciaTrabajador	)) x
					   where x.IdIncidenciaTrabajador not in (


					SELECT a.IdIncidenciaTrabajador
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
					 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
					 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
					 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
					 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'SUSPENSIÓN DE LABORES','VACACIONES') 
					  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
                     and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio in (1,2) ) )  z
					 where Incidencia IN  ( 'FALTA POR DÍA', 'FALTA POR HORAS', 'FALTA POR RETARDOS', 'FALTA HORAS CLUB')
					  group by z.IdTrabajador, z.Incidencia, z.Fecha
					)
					union 
					(
					select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial from(
		select * from (			(Select count(IdTrabajador) as TotalFaltas,
										   IdTrabajador,
										   max (IdIncidenciaTrabajador) as IdIncidenciaTrabajador,                      
										   max (IdModalidadEstudio) as IdModalidadEstudio , 
										   max( ConvenioLaboral) as ConvenioLaboral, 
										   max (Nombre) as Nombre,
										   max (ApellidoPaterno) as ApellidoPaterno,
										   max (ApellidoMaterno) as ApellidoMaterno,
										   max (Sexo) as Sexo , 
										   max (UbicacionFisica) as UbicacionFisica, 
										   max (Incidencia) as Incidencia, 
										   max (Fecha) as Fecha, 
										   max (Observaciones) as Observaciones , 
										   max (Horas) as Horas ,
										   max (IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (RelacionLaboral)as RelacionLaboral ,
										max (Horario) as Horario,
										max (HorarioEspecial) as HorarioEspecial
										from
					( select * from ((SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador,
										   a.IdIncidenciaTrabajador,  
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,              
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
					  
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
													  FROM  Nomina_HorariosConvenioConfiguracion a
													  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
													  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										WHERE c.TipoIncidenciaPermiso in('RETARDOS')  AND J.IncidenciaJustificacion not IN('VACACIONES') 
               
										--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <=  '{ft}' and t.EstructuraOrganicaPadre = '{dir}'  and t.IdModalidadEstudio in (1,2) and cast(t.FechaInicio as DATE)  <= '{fi}'
										and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') and Ubicacionfisica = '{dir}' and t.IdModalidadEstudio in (1,2)
                                        and a.EsCerrada=0
										group by  t.IdTrabajador, a.IdIncidenciaTrabajador, a.FechaInicio )					
										union
											(SELECT count(t.IdTrabajador)as TotalFaltas,
										   t.IdTrabajador, 
										   max (a.IdIncidenciaTrabajador) as IdIncidenciaTrabajador,
										   (cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar)) as FaltaRetardoTrabajador,   
										   max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
										   max (t.Nombre) as Nombre,
										   max (t.ApellidoPaterno) as ApellidoPaterno,
										   max (t.ApellidoMaterno) as ApellidoMaterno,
										   max (t.Sexo) as Sexo , 
										   max (t.UbicacionFisica) as UbicacionFisica, 
										   max (b.Incidencia) as Incidencia, 
										   max (a.FechaInicio) as Fecha, 
										   max (a.Observaciones) as Observaciones , 
										   max (a.Horas) as Horas ,
										   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
										   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
										   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   
										max (t.RelacionLaboral)as RelacionLaboral ,
										max (hor.Horario) as Horario,(SELECT  top 1
											  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
										  FROM  Nomina_HorariosEspeciales h
										  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  
										 FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
										 FROM  Nomina_HorariosConvenioConfiguracion a
										 inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
										 group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
										 WHERE c.TipoIncidenciaPermiso in('RETARDOS') 
										and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio in (1,2) and a.EsCerrada=0
										 group by  t.IdTrabajador, a.IdIncidenciaTrabajador,a.FechaInicio	)) x
										   where x.FaltaRetardoTrabajador not in (

										SELECT cast (t.IdTrabajador as varchar) + '-' + cast (( cast (a.FechaInicio as DATE)) as varchar) as Dato
										FROM IncidenciaPermiso_stIncidenciaTrabajador  a
										 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA' )					
										 and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio in (1,2) ) )  z
										  group by z.IdTrabajador, z.IdIncidenciaTrabajador )) w

										     where w.IdIncidenciaTrabajador not in (
												SELECT a.IdIncidenciaTrabajador
												FROM IncidenciaPermiso_stIncidenciaTrabajador  a
												 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
												 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
												 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
												 INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
												 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS')  AND J.IncidenciaJustificacion not IN( 'VACACIONES') 
												  and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) ) 
													and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio in (1,2) ))  y
													group by y.IdTrabajador
												HAVING COUNT(TotalFaltas) > 2
					                            )

 ";


                //           SELECT t.IdTrabajador, t.IdModalidadEstudio ,  t.ConvenioLaboral,t.Nombre,t.ApellidoPaterno,t.ApellidoMaterno,t.Sexo, t.UbicacionFisica, b.Incidencia, a.FechaInicio as Fecha, a.Observaciones , a.Horas ,t.IdEstructuraOrganicaFisica,t.IdEstructuraOrganicaPadre,t.EstructuraOrganicaPadre,
                //t.RelacionLaboral,
                //hor.Horario,(SELECT  top 1

                //                     max(cast(h.Entrada as nvarchar(5))) + '-' + max(cast(h.salida as nvarchar(5))) as Horario

                //                 FROM Nomina_HorariosEspeciales h
                //                 where h.Dia = 1 and h.idtrabajador = t.idtrabajador)  as HorarioEspecial
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                //               inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //               inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                //               inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                //               INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //               inner join(SELECT max(cast(a.Entrada as nvarchar(5))) +'-' + max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
                //                             FROM  Nomina_HorariosConvenioConfiguracion a

                //                             inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral = b.IdRelacionConvenioLaboral

                //                             group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral = hor.IdRelacionConvenioLaboral
                //               WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')
                //               and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio = { idmodalidad}
                //           and a.IdIncidenciaTrabajador not in (


                //               SELECT a.IdIncidenciaTrabajador
                //               FROM IncidenciaPermiso_stIncidenciaTrabajador a

                //                inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia

                //                inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso

                //                inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                //                INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion = A.IdIncidenciaJustificacion

                //                WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion not IN('SUSPENSIÓN DE LABORES', 'VACACIONES')

                //                 and((Autorizo = 1 and a.IdIncidenciaJustificacion > 0) ) 
                //  and a.FechaInicio >= '{fi}' and a.FechaInicio <= '{ft}' ) and t.EstructuraOrganicaPadre = '{dir}' and t.IdModalidadEstudio = { idmodalidad}
                //           order by t.IdEstructuraOrganicaFisica ASC


                m = (List<IncidicenciasporAplicar>)dp.connection.Query<IncidicenciasporAplicar>(u);
            }
            return m;
        }

        public static List<IncidenciasDiasEconomicos> getIncidenciasDiasEconomicos(string year, string relacionlaboral, string modalidad)
        {
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;

            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.RelacionLaboral ='" + relacionlaboral + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.RelacionLaboral ='" + relacionlaboral + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "'";
                }
                //Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "'";

            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.RelacionLaboral ='" + relacionlaboral + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.RelacionLaboral ='" + relacionlaboral + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "'";
                }

            }




            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";

            if (year != null)
            {
                u = $@"select * from ( SELECT  [IdEstructuraOrganica], a.IdEstructuraOrganicaPadre, x.IdModalidadEstudio
                                          
                                              ,[EstructuraOrganica] as Departamento
                                              ,(select [EstructuraOrganica] FROM [bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica=a.IdEstructuraOrganicaPadre) as PerteneceA
											  ,x.RelacionLaboral                          
						                      ,x.Enero
						                      ,x.Febrero
						                      ,x.Marzo
						                      ,x.Abril
						                      ,x.Mayo
						                      ,x.Junio
						                      ,x.Julio
						                      ,x.Agosto
						                      ,x.Septiembre
						                      ,x.Octubre
						                      ,x.Noviembre
						                      ,x.Diciembre
                                              ,x.Total 
											                   
                                          FROM [Catalogos_ctEstructuraOrganica] a                       
							                       inner join (select  y.IdEstructuraOrganicaFisica,
											                     SUM(CASE WHEN y.Mes = 1 THEN DiasEconomicos ELSE 0 END) AS Enero,
											                     SUM(CASE WHEN y.Mes = 2 THEN DiasEconomicos ELSE 0 END) AS Febrero,
											                     SUM(CASE WHEN y.Mes = 3 THEN DiasEconomicos ELSE 0 END) AS Marzo,
											                     SUM(CASE WHEN y.Mes = 4 THEN DiasEconomicos ELSE 0 END) AS Abril, 
											                     SUM(CASE WHEN y.Mes = 5 THEN DiasEconomicos ELSE 0 END) AS Mayo,
											                     SUM(CASE WHEN y.Mes = 6 THEN DiasEconomicos ELSE 0 END) AS Junio,
											                     SUM(CASE WHEN y.Mes = 7 THEN DiasEconomicos ELSE 0 END) AS Julio,
											                     SUM(CASE WHEN y.Mes = 8 THEN DiasEconomicos ELSE 0 END) AS Agosto,
											                     SUM(CASE WHEN y.Mes = 9 THEN DiasEconomicos ELSE 0 END) AS Septiembre,
											                     SUM(CASE WHEN y.Mes = 10 THEN DiasEconomicos ELSE 0 END) AS Octubre,
											                     SUM(CASE WHEN y.Mes = 11 THEN DiasEconomicos ELSE 0 END) AS Noviembre,
											                     SUM(CASE WHEN y.Mes = 12 THEN DiasEconomicos ELSE 0 END) AS Diciembre ,
                                                                 SUM (DiasEconomicos) AS Total,
																 y.RelacionLaboral,y.IdModalidadEstudio
											                    from (SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as DiasEconomicos,t.IdEstructuraOrganicaFisica
											                    , MONTH(a.FechaInicio) as Mes
																, t.RelacionLaboral, t.IdModalidadEstudio
											                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
											                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
											                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
											                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
											                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
											                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion IN('DÍA ECONÓMICO') 
											                     and ((a.IdIncidenciaJustificacion>0) ) 
											                     " + Filtro + @" 
											                     group by t.IdEstructuraOrganicaFisica , MONTH(a.FechaInicio),t.RelacionLaboral , t.IdModalidadEstudio) as y
							                       group by   y.IdEstructuraOrganicaFisica,y.RelacionLaboral , y.IdModalidadEstudio) as x on x.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]) as qq 
							                      
							                       order by qq.IdEstructuraOrganicaPadre
                ";



                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }
            return m;
        }

        public static List<IncidenciasDiasEconomicos> getIncidenciasDiasEconomicosMesas(string year, string relacionlaboral, string modalidad)
        {
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;

            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.RelacionLaboral ='" + relacionlaboral + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.RelacionLaboral ='" + relacionlaboral + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "'";
                }
                //Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "'";

            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.RelacionLaboral ='" + relacionlaboral + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.RelacionLaboral ='" + relacionlaboral + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "'";
                }

            }




            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";

            if (year != null)
            {
                u = $@"	select * from ( SELECT  [IdEstructuraOrganica], a.IdEstructuraOrganicaPadre, x.IdModalidadEstudio
                                          
                                              ,[EstructuraOrganica] as Departamento
                                              ,(select [EstructuraOrganica] FROM [bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica=a.IdEstructuraOrganicaPadre) as PerteneceA
											  ,x.RelacionLaboral                          
						                      ,x.Enero
						                      ,x.Febrero
						                      ,x.Marzo
						                      ,x.Abril
						                      ,x.Mayo
						                      ,x.Junio
						                      ,x.Julio
						                      ,x.Agosto
						                      ,x.Septiembre
						                      ,x.Octubre
						                      ,x.Noviembre
						                      ,x.Diciembre 
                                              ,x.Total 
											                   
                                          FROM [Catalogos_ctEstructuraOrganica] a                       
							                       inner join (select  y.IdEstructuraOrganicaFisica,
											                     SUM(CASE WHEN y.Mes = 1 THEN DiasEconomicos ELSE 0 END) AS Enero,
											                     SUM(CASE WHEN y.Mes = 2 THEN DiasEconomicos ELSE 0 END) AS Febrero,
											                     SUM(CASE WHEN y.Mes = 3 THEN DiasEconomicos ELSE 0 END) AS Marzo,
											                     SUM(CASE WHEN y.Mes = 4 THEN DiasEconomicos ELSE 0 END) AS Abril, 
											                     SUM(CASE WHEN y.Mes = 5 THEN DiasEconomicos ELSE 0 END) AS Mayo,
											                     SUM(CASE WHEN y.Mes = 6 THEN DiasEconomicos ELSE 0 END) AS Junio,
											                     SUM(CASE WHEN y.Mes = 7 THEN DiasEconomicos ELSE 0 END) AS Julio,
											                     SUM(CASE WHEN y.Mes = 8 THEN DiasEconomicos ELSE 0 END) AS Agosto,
											                     SUM(CASE WHEN y.Mes = 9 THEN DiasEconomicos ELSE 0 END) AS Septiembre,
											                     SUM(CASE WHEN y.Mes = 10 THEN DiasEconomicos ELSE 0 END) AS Octubre,
											                     SUM(CASE WHEN y.Mes = 11 THEN DiasEconomicos ELSE 0 END) AS Noviembre,
											                     SUM(CASE WHEN y.Mes = 12 THEN DiasEconomicos ELSE 0 END) AS Diciembre ,
                                                                 SUM (DiasEconomicos) AS Total,
																 y.RelacionLaboral,y.IdModalidadEstudio
											                    from (SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as DiasEconomicos,t.IdEstructuraOrganicaFisica
											                    , MONTH(a.FechaInicio) as Mes
																, t.RelacionLaboral, t.IdModalidadEstudio
											                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
											                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
											                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
											                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
											                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
																 inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																					inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																					inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																					where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) p on t.IdEstructuraOrganicaFisica  = p.IdEstructuraOrganica
											                     WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion IN('DÍA ECONÓMICO') 
											                     and ((a.IdIncidenciaJustificacion>0) )
																 " + Filtro + @" 
											                     group by t.IdEstructuraOrganicaFisica , MONTH(a.FechaInicio),t.RelacionLaboral , t.IdModalidadEstudio) as y
							                       group by   y.IdEstructuraOrganicaFisica,y.RelacionLaboral , y.IdModalidadEstudio) as x on x.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]) as qq 
							                      
							                       order by qq.IdEstructuraOrganicaPadre

                ";

                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }
            return m;
        }






        public static List<IncidenciasDiasEconomicos> getIncidenciasDiasEconomicosTrabajadores(string year, string relacionlaboral, string modalidad)
        {
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;

            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.RelacionLaboral ='" + relacionlaboral + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.RelacionLaboral ='" + relacionlaboral + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "'";
                }
                //Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "'";

            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.RelacionLaboral ='" + relacionlaboral + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.RelacionLaboral ='" + relacionlaboral + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "'";
                }

            }




            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";

            if (year != null)
            {
                u = $@"SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,					                         
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   max (t.RelacionLaboral)as RelacionLaboral ,
					   max (hor.Horario) as Horario,(SELECT  top 1
					   max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  ,max (zz.Enero) as Enero
					  ,max (zz.Febrero) as Febrero
					  ,max (zz.Marzo) as Marzo
					  ,max (zz.Abril) as Abril
					  ,max (zz.Mayo) as Mayo
					  ,max (zz.Junio) as Junio
					  ,max (zz.Julio) as Julio
					  ,max (zz.Agosto) as Agosto
					  ,max (zz.Septiembre) as Septiembre
					  ,max (zz.Octubre) as Octubre
					  ,max (zz.Noviembre) as Noviembre
					  ,max (zz.Diciembre) as Diciembre
                    ,max (Total) as Total
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria					
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					inner join (select  y.IdTrabajador,
											 SUM(CASE WHEN y.Mes = 1 THEN DiasEconomicos ELSE 0 END) AS Enero,
											 SUM(CASE WHEN y.Mes = 2 THEN DiasEconomicos ELSE 0 END) AS Febrero,
											 SUM(CASE WHEN y.Mes = 3 THEN DiasEconomicos ELSE 0 END) AS Marzo,
											 SUM(CASE WHEN y.Mes = 4 THEN DiasEconomicos ELSE 0 END) AS Abril, 
											 SUM(CASE WHEN y.Mes = 5 THEN DiasEconomicos ELSE 0 END) AS Mayo,
											 SUM(CASE WHEN y.Mes = 6 THEN DiasEconomicos ELSE 0 END) AS Junio,
											 SUM(CASE WHEN y.Mes = 7 THEN DiasEconomicos ELSE 0 END) AS Julio,
											 SUM(CASE WHEN y.Mes = 8 THEN DiasEconomicos ELSE 0 END) AS Agosto,
											 SUM(CASE WHEN y.Mes = 9 THEN DiasEconomicos ELSE 0 END) AS Septiembre,
											 SUM(CASE WHEN y.Mes = 10 THEN DiasEconomicos ELSE 0 END) AS Octubre,
											 SUM(CASE WHEN y.Mes = 11 THEN DiasEconomicos ELSE 0 END) AS Noviembre,
											 SUM(CASE WHEN y.Mes = 12 THEN DiasEconomicos ELSE 0 END) AS Diciembre,
                                             SUM (DiasEconomicos) AS Total 
											from (SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as DiasEconomicos,t.IdTrabajador
											,MONTH(a.FechaInicio) as Mes
											FROM IncidenciaPermiso_stIncidenciaTrabajador  a
											 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
											 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
											 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
											 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
											 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion IN('DÍA ECONÓMICO') 
					   					     and (( a.IdIncidenciaJustificacion>0) ) 
											 and YEAR(a.FechaInicio) = '{year}'  
											 group by t.IdTrabajador , MONTH(a.FechaInicio) ) as y
											 group by   y.IdTrabajador) as zz on  zz.IdTrabajador= t.IdTrabajador
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion IN( 'DÍA ECONÓMICO') 
					and ((a.IdIncidenciaJustificacion>0) ) 
					 " + Filtro + @" 
					group by  t.IdTrabajador 
                    order by UbicacionFisica
                ";



                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }
            return m;
        }

        public static List<IncidenciasDiasEconomicos> getIncidenciasDiasEconomicosTrabajadoresMesas(string year, string relacionlaboral, string modalidad)
        {
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;

            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.RelacionLaboral ='" + relacionlaboral + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "' and t.RelacionLaboral ='" + relacionlaboral + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "'";
                }
                //Filtro = "and YEAR(a.FechaInicio) ='" + yearnow + "'";

            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.RelacionLaboral ='" + relacionlaboral + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.IdModalidadEstudio= '" + modalidad + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "' and t.RelacionLaboral ='" + relacionlaboral + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "and YEAR(a.FechaInicio) ='" + year + "'";
                }

            }

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";

            if (year != null)
            {
                u = $@"SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,					                         
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					   max (t.RelacionLaboral)as RelacionLaboral ,
					   max (hor.Horario) as Horario,(SELECT  top 1
					   max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial
					  ,max (zz.Enero) as Enero
					  ,max (zz.Febrero) as Febrero
					  ,max (zz.Marzo) as Marzo
					  ,max (zz.Abril) as Abril
					  ,max (zz.Mayo) as Mayo
					  ,max (zz.Junio) as Junio
					  ,max (zz.Julio) as Julio
					  ,max (zz.Agosto) as Agosto
					  ,max (zz.Septiembre) as Septiembre
					  ,max (zz.Octubre) as Octubre
					  ,max (zz.Noviembre) as Noviembre
					  ,max (zz.Diciembre) as Diciembre
                        ,max (Total) as Total
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria					
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					inner join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
					inner join (select  y.IdTrabajador,
											 SUM(CASE WHEN y.Mes = 1 THEN DiasEconomicos ELSE 0 END) AS Enero,
											 SUM(CASE WHEN y.Mes = 2 THEN DiasEconomicos ELSE 0 END) AS Febrero,
											 SUM(CASE WHEN y.Mes = 3 THEN DiasEconomicos ELSE 0 END) AS Marzo,
											 SUM(CASE WHEN y.Mes = 4 THEN DiasEconomicos ELSE 0 END) AS Abril, 
											 SUM(CASE WHEN y.Mes = 5 THEN DiasEconomicos ELSE 0 END) AS Mayo,
											 SUM(CASE WHEN y.Mes = 6 THEN DiasEconomicos ELSE 0 END) AS Junio,
											 SUM(CASE WHEN y.Mes = 7 THEN DiasEconomicos ELSE 0 END) AS Julio,
											 SUM(CASE WHEN y.Mes = 8 THEN DiasEconomicos ELSE 0 END) AS Agosto,
											 SUM(CASE WHEN y.Mes = 9 THEN DiasEconomicos ELSE 0 END) AS Septiembre,
											 SUM(CASE WHEN y.Mes = 10 THEN DiasEconomicos ELSE 0 END) AS Octubre,
											 SUM(CASE WHEN y.Mes = 11 THEN DiasEconomicos ELSE 0 END) AS Noviembre,
											 SUM(CASE WHEN y.Mes = 12 THEN DiasEconomicos ELSE 0 END) AS Diciembre,
                                             SUM (DiasEconomicos) AS Total 
											from (SELECT count(a.IdConvenioLaboralTrabajadorCategoria)as DiasEconomicos,t.IdTrabajador
											,MONTH(a.FechaInicio) as Mes
											FROM IncidenciaPermiso_stIncidenciaTrabajador  a
											 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
											 inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
											 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
											 INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
											  inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																					inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																					inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																					where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) p on t.IdEstructuraOrganicaFisica  = p.IdEstructuraOrganica
											 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion IN('DÍA ECONÓMICO') 
					   					     and (( a.IdIncidenciaJustificacion>0) ) 
											 and YEAR(a.FechaInicio) = '{year}' 
											 group by t.IdTrabajador , MONTH(a.FechaInicio) ) as y
											 group by   y.IdTrabajador) as zz on  zz.IdTrabajador= t.IdTrabajador
                    WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion IN( 'DÍA ECONÓMICO') 
					and ((a.IdIncidenciaJustificacion>0) ) 
				    " + Filtro + @" 
					group by  t.IdTrabajador 
                    order by UbicacionFisica
                ";

                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }
            return m;
        }




        public static List<IncidenciasDiasEconomicos> getIncidenciasPuntualidadAsistencia(string year, string relacionlaboral, string modalidad, string periodo)
        {
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;

            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }

                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') ";
                }

            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }

            }




            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";

            if (year != null)
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {
                    u = $@"
                   select 
				max (s.IdModalidadEstudio) as IdModalidadEstudio,
				g.EstructuraOrganica as Departamento,
				max (q.EstructuraOrganica) as PerteneceA,
				
				max (z.Enero) as Enero,
				max (z.Febrero) as Febrero,
				max (z.Marzo) as Marzo,
				max (z.Abril) as Abril,
				max (z.Mayo) as Mayo,
				max (z.Junio) as Junio,
				max (z.Julio) as Julio,
				max (z.Agosto) as Agosto,
				max (z.Septiembre) as Septiembre,
				max (z.Octubre) as Octubre,
				max (z.Noviembre) as Noviembre,
				max (z.Diciembre) as Diciembre

				from  Convenios_stConvenioLaboralTrabajadorCategoria a
						INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
						INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
						INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
						INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
						INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
						INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
						INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
						INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
						INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
						INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
						INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio
				inner join 

					(
								select UbicacionFisica
							,sum((case when Enero > 0 then 1 else 0 end)) Enero
							,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
							,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
							,sum((case when Abril > 0 then 1 else 0 end)) Abril
							,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
							,sum((case when Junio > 0 then 1 else 0 end)) Junio
							,sum((case when Julio > 0 then 1 else 0 end)) Julio
							,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
							,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
							,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
							,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
							,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
							from (

							select  
								w.UbicacionFisica , 
							w.IdConvenioLaboralTrabajadorCategoria,
								max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
								max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
								max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
								max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
								max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
								max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio,
								max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
								max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
								max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
								max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
								max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
								max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
								from 
									(
										select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
										  from (  (
												SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
													INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
													INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
													INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
													INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
													INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
													INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
													INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
													INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
													INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
													INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
													INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
													INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
													INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
													WHERE
													j.IdIncidenciaJustificacion = 0
													AND YEAR(j.FechaInicio) = '{year}'
													AND l.Incidencia LIKE '%RETARDO%'
													AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
												
													
													GROUP BY
													b.IdTrabajador,
													a.IdConvenioLaboralTrabajadorCategoria,
													g.EstructuraOrganica,
													MONTH(j.FechaInicio)
										  )

										union 

										  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND l.Incidencia LIKE '%FALTA%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
												
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
										   )
												)  y
												group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
										) w
										
										group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
										
										group by x.UbicacionFisica) z on g.EstructuraOrganica = z.UbicacionFisica 
										" + Filtro + @"
								--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
								group by g.EstructuraOrganica
                ";
                }
                else
                {

                    u = $@"   select 
				max (s.IdModalidadEstudio) as IdModalidadEstudio,
				g.EstructuraOrganica as Departamento,
				max (q.EstructuraOrganica) as PerteneceA,
				
				max (z.Enero) as Enero,
				max (z.Febrero) as Febrero,
				max (z.Marzo) as Marzo,
				max (z.Abril) as Abril,
				max (z.Mayo) as Mayo,
				max (z.Junio) as Junio,
				max (z.Julio) as Julio,
				max (z.Agosto) as Agosto,
				max (z.Septiembre) as Septiembre,
				max (z.Octubre) as Octubre,
				max (z.Noviembre) as Noviembre,
				max (z.Diciembre) as Diciembre

				from  Convenios_stConvenioLaboralTrabajadorCategoria a
						INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
						INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
						INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
						INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
						INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
						INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
						INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
						INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
						INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
						INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
						INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio
				inner join 

					(
								select UbicacionFisica
							,sum((case when Enero > 0 then 1 else 0 end)) Enero
							,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
							,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
							,sum((case when Abril > 0 then 1 else 0 end)) Abril
							,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
							,sum((case when Junio > 0 then 1 else 0 end)) Junio
							,sum((case when Julio > 0 then 1 else 0 end)) Julio
							,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
							,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
							,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
							,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
							,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
							from (

							select  
								w.UbicacionFisica , 
							w.IdConvenioLaboralTrabajadorCategoria,
								max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
								max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
								max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
								max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
								max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
								max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio,
								max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
								max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
								max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
								max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
								max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
								max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
								from 
									(
										select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
										  from (  (
												SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
													INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
													INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
													INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
													INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
													INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
													INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
													INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
													INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
													INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
													INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
													INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
													INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
													INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
													WHERE
													j.IdIncidenciaJustificacion = 0
													AND YEAR(j.FechaInicio) = '{year}'
													AND l.Incidencia LIKE '%RETARDO%'
													AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
													AND r.RelacionLaboral = '{relacionlaboral}'
													
													GROUP BY
													b.IdTrabajador,
													a.IdConvenioLaboralTrabajadorCategoria,
													g.EstructuraOrganica,
													MONTH(j.FechaInicio)
										  )

										union 

										  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND l.Incidencia LIKE '%FALTA%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
												AND r.RelacionLaboral = '{relacionlaboral}'
												
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
										   )
												)  y
												group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
										) w
										
										group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
										
										group by x.UbicacionFisica) z on g.EstructuraOrganica = z.UbicacionFisica 
										" + Filtro + @"
								--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
								group by g.EstructuraOrganica


                ";

                }




                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }


            return m;
        }



        public static List<IncidenciasDiasEconomicos> getIncidenciasPuntualidadAsistenciaTrabajadores(string year, string relacionlaboral, string modalidad, string periodo)
        {
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;


            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }

                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') ";
                }

            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }

            }






            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";


            if (year != null && (periodo == null || periodo == "ANUAL"))
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {


                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						,sum((case when Enero > 0 then 1 else 0 end)) Enero
						,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
						,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
						,sum((case when Abril > 0 then 1 else 0 end)) Abril
						,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
						,sum((case when Junio > 0 then 1 else 0 end)) Junio
						,sum((case when Julio > 0 then 1 else 0 end)) Julio
						,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
						,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
						,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
						,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
						,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
							max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
							max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
							max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
							max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
							max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio,
							max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
							max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
							max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
							max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
							max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
							max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
                else
                {

                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						,sum((case when Enero > 0 then 1 else 0 end)) Enero
						,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
						,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
						,sum((case when Abril > 0 then 1 else 0 end)) Abril
						,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
						,sum((case when Junio > 0 then 1 else 0 end)) Junio
						,sum((case when Julio > 0 then 1 else 0 end)) Julio
						,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
						,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
						,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
						,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
						,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
							max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
							max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
							max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
							max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
							max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio,
							max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
							max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
							max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
							max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
							max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
							max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
                                                AND r.RelacionLaboral = '{relacionlaboral}'
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											AND r.RelacionLaboral = '{relacionlaboral}'
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
            }
            if (year != null && periodo == "PRIMER")
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {


                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                 
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END 
                    
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						,sum((case when Enero > 0 then 1 else 0 end)) Enero
						,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
						,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
						,sum((case when Abril > 0 then 1 else 0 end)) Abril
						,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
						,sum((case when Junio > 0 then 1 else 0 end)) Junio
					
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
							max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
							max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
							max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
							max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
							max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio
							
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND MONTH(j.FechaInicio) in ('1','2','3','4','5','6')
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND MONTH(j.FechaInicio) in ('1','2','3','4','5','6')
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
                else
                {

                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                   
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						,sum((case when Enero > 0 then 1 else 0 end)) Enero
						,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
						,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
						,sum((case when Abril > 0 then 1 else 0 end)) Abril
						,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
						,sum((case when Junio > 0 then 1 else 0 end)) Junio
			
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
							max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
							max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
							max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
							max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
							max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio
							
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
											    AND MONTH(j.FechaInicio) in ('1','2','3','4','5','6')
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
                                                AND r.RelacionLaboral = '{relacionlaboral}'
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND MONTH(j.FechaInicio) in ('1','2','3','4','5','6')
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											AND r.RelacionLaboral = '{relacionlaboral}'
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
            }

            if (year != null && periodo == "SEGUNDO")
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {


                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						
						,sum((case when Julio > 0 then 1 else 0 end)) Julio
						,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
						,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
						,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
						,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
						,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							
							max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
							max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
							max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
							max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
							max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
							max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND MONTH(j.FechaInicio) in ('7','8','9','10','11','12')
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND MONTH(j.FechaInicio) in ('7','8','9','10','11','12')
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
                else
                {

                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						
						,sum((case when Julio > 0 then 1 else 0 end)) Julio
						,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
						,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
						,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
						,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
						,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							
							max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
							max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
							max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
							max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
							max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
							max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND MONTH(j.FechaInicio) in ('7','8','9','10','11','12')
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
                                                AND r.RelacionLaboral = '{relacionlaboral}'
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND MONTH(j.FechaInicio) in ('7','8','9','10','11','12')
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											AND r.RelacionLaboral = '{relacionlaboral}'
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
            }

            return m;
        }


        public static List<IncidenciasDiasEconomicos> getPuntualidadAsistenciaTrabajadoresTotal(string year, string relacionlaboral, string modalidad, string periodo, string Estructura)
        {
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;

            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') and g.EstructuraOrganica =' " + Estructura + " '";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') and g.EstructuraOrganica = '" + Estructura + "'";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') and g.EstructuraOrganica = '" + Estructura + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') and g.EstructuraOrganica = '" + Estructura + "' ";
                }


            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') and g.EstructuraOrganica = '" + Estructura + "' ";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') and g.EstructuraOrganica = '" + Estructura + "' ";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') and g.EstructuraOrganica = '" + Estructura + "' ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') and g.EstructuraOrganica = '" + Estructura + "' ";
                }


            }

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";


            if (year != null && (periodo == null || periodo == "ANUAL"))
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {
                    u = $@"                   SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
                    max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    g.EstructuraOrganica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
                    INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio
                LEFT JOIN (
                     SELECT
                        y.IdTrabajador,
						y.IdConvenioLaboralTrabajadorCategoria,
                        y.UbicacionFisica,
                        MAX(CASE WHEN y.Mes = 1 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Enero,
                        MAX(CASE WHEN y.Mes = 2 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Febrero,
                        MAX(CASE WHEN y.Mes = 3 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Marzo,
                        MAX(CASE WHEN y.Mes = 4 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Abril,
                        MAX(CASE WHEN y.Mes = 5 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Mayo,
                        MAX(CASE WHEN y.Mes = 6 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Junio,
                        MAX(CASE WHEN y.Mes = 7 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Julio,
                        MAX(CASE WHEN y.Mes = 8 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Agosto,
                        MAX(CASE WHEN y.Mes = 9 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Septiembre,
                        MAX(CASE WHEN y.Mes = 10 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Octubre,
                        MAX(CASE WHEN y.Mes = 11 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Noviembre,
                        MAX(CASE WHEN y.Mes = 12 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Diciembre
                    FROM (
                        (
                            
								SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
								INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
								INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
								INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
								INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
								INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
								INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
								INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
								INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
								INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
								INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
								INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
								INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
								WHERE
								j.IdIncidenciaJustificacion = 0
                                AND YEAR(j.FechaInicio) = '{year}'
                                AND l.Incidencia LIKE '%RETARDO%'
                                AND p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')
								--and d.IdTrabajador=2911 
								GROUP BY
                                b.IdTrabajador,
								a.IdConvenioLaboralTrabajadorCategoria,
                                g.EstructuraOrganica,
                                MONTH(j.FechaInicio)
                        )
                        UNION
                        (
                          		SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
								INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
								INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
								INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
								INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
								INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
								INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
								INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
								INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
								INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
								INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
								INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
								INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
								WHERE
								j.IdIncidenciaJustificacion = 0
                                AND YEAR(j.FechaInicio) = '{year}'
                                AND l.Incidencia LIKE '%FALTA%'
                                AND p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')
								--and d.IdTrabajador=2911 
								GROUP BY
                                b.IdTrabajador,
								a.IdConvenioLaboralTrabajadorCategoria,
                                g.EstructuraOrganica,
                                MONTH(j.FechaInicio)
								
                        )
                    ) y
                    GROUP BY
                        y.IdTrabajador,
						y.IdConvenioLaboralTrabajadorCategoria,
                        y.UbicacionFisica
                ) w ON b.IdTrabajador = w.IdTrabajador AND g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
                " + Filtro + @" 
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";

                }
                else
                {
                    u = $@"                   SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
                    max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    g.EstructuraOrganica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
                    INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio
                LEFT JOIN (
                     SELECT
                        y.IdTrabajador,
						y.IdConvenioLaboralTrabajadorCategoria,
                        y.UbicacionFisica,
                        MAX(CASE WHEN y.Mes = 1 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Enero,
                        MAX(CASE WHEN y.Mes = 2 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Febrero,
                        MAX(CASE WHEN y.Mes = 3 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Marzo,
                        MAX(CASE WHEN y.Mes = 4 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Abril,
                        MAX(CASE WHEN y.Mes = 5 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Mayo,
                        MAX(CASE WHEN y.Mes = 6 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Junio,
                        MAX(CASE WHEN y.Mes = 7 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Julio,
                        MAX(CASE WHEN y.Mes = 8 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Agosto,
                        MAX(CASE WHEN y.Mes = 9 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Septiembre,
                        MAX(CASE WHEN y.Mes = 10 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Octubre,
                        MAX(CASE WHEN y.Mes = 11 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Noviembre,
                        MAX(CASE WHEN y.Mes = 12 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Diciembre
                    FROM (
                        (
                            
								SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
								INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
								INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
								INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
								INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
								INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
								INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
								INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
								INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
								INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
								INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
								INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
								INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
							    INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
								WHERE
								j.IdIncidenciaJustificacion = 0
                                AND YEAR(j.FechaInicio) = '{year}'
                                AND l.Incidencia LIKE '%RETARDO%'
                                AND p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')
								AND r.RelacionLaboral = '{relacionlaboral}'
								--and d.IdTrabajador=2911 
								GROUP BY
                                b.IdTrabajador,
								a.IdConvenioLaboralTrabajadorCategoria,
                                g.EstructuraOrganica,
                                MONTH(j.FechaInicio)
                        )
                        UNION
                        (
                          		SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
								INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
								INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
								INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
								INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
								INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
								INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
								INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
								INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
								INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
								INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
								INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
								INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
								INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
								WHERE
								j.IdIncidenciaJustificacion = 0
                                AND YEAR(j.FechaInicio) = '{year}'
                                AND l.Incidencia LIKE '%FALTA%'
                                AND p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')
								AND r.RelacionLaboral = '{relacionlaboral}'
								--and d.IdTrabajador=2911 
								GROUP BY
                                b.IdTrabajador,
								a.IdConvenioLaboralTrabajadorCategoria,
                                g.EstructuraOrganica,
                                MONTH(j.FechaInicio)
								
                        )
                    ) y
                    GROUP BY
                        y.IdTrabajador,
						y.IdConvenioLaboralTrabajadorCategoria,
                        y.UbicacionFisica
                ) w ON b.IdTrabajador = w.IdTrabajador AND g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
                " + Filtro + @" 
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";

                }



                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }

            if (year != null && periodo == "PRIMER")
            {

                u = $@"
SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    g.EstructuraOrganica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                    
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                   
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (
                     SELECT
                        y.IdTrabajador,
						y.IdConvenioLaboralTrabajadorCategoria,
                        y.UbicacionFisica,
                        MAX(CASE WHEN y.Mes = 1 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Enero,
                        MAX(CASE WHEN y.Mes = 2 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Febrero,
                        MAX(CASE WHEN y.Mes = 3 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Marzo,
                        MAX(CASE WHEN y.Mes = 4 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Abril,
                        MAX(CASE WHEN y.Mes = 5 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Mayo,
                        MAX(CASE WHEN y.Mes = 6 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Junio
                        
                    FROM (
                        (
                            
								SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
								INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
								INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
								INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
								INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
								INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
								INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
								INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
								INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
								INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
								INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
								INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
								INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
								WHERE
								j.IdIncidenciaJustificacion = 0
                                AND YEAR(j.FechaInicio) = '{year}'
                                and MONTH(j.FechaInicio)in ('1','2','3','4','5','6')
                                AND l.Incidencia LIKE '%RETARDO%'
                                AND p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')
								--and d.IdTrabajador=2911 
								GROUP BY
                                b.IdTrabajador,
								a.IdConvenioLaboralTrabajadorCategoria,
                                g.EstructuraOrganica,
                                MONTH(j.FechaInicio)
                        )
                        UNION
                        (
                          		SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
								INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
								INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
								INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
								INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
								INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
								INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
								INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
								INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
								INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
								INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
								INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
								INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
								WHERE
								j.IdIncidenciaJustificacion = 0
                                AND YEAR(j.FechaInicio) = '{year}'
                                 and MONTH(j.FechaInicio)in ('1','2','3','4','5','6')
                                AND l.Incidencia LIKE '%FALTA%'
                                AND p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')
								--and d.IdTrabajador=2911 
								GROUP BY
                                b.IdTrabajador,
								a.IdConvenioLaboralTrabajadorCategoria,
                                g.EstructuraOrganica,
                                MONTH(j.FechaInicio)
								
                        )
                    ) y
                    GROUP BY
                        y.IdTrabajador,
						y.IdConvenioLaboralTrabajadorCategoria,
                        y.UbicacionFisica
                ) w ON b.IdTrabajador = w.IdTrabajador AND g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
                " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica


                ";



                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }
            if (year != null && periodo == "SEGUNDO")
            {

                u = $@"                        SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
                    max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    g.EstructuraOrganica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
                    INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio
                LEFT JOIN (
                     SELECT
                        y.IdTrabajador,
						y.IdConvenioLaboralTrabajadorCategoria,
                        y.UbicacionFisica,
                       
                        MAX(CASE WHEN y.Mes = 7 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Julio,
                        MAX(CASE WHEN y.Mes = 8 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Agosto,
                        MAX(CASE WHEN y.Mes = 9 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Septiembre,
                        MAX(CASE WHEN y.Mes = 10 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Octubre,
                        MAX(CASE WHEN y.Mes = 11 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Noviembre,
                        MAX(CASE WHEN y.Mes = 12 THEN CASE WHEN Faltas > 0 THEN 1 ELSE 0 END ELSE 0 END) AS Diciembre
                    FROM (
                        (
                            
								SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
								INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
								INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
								INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
								INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
								INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
								INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
								INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
								INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
								INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
								INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
								INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
								INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
								WHERE
								j.IdIncidenciaJustificacion = 0
                                AND YEAR(j.FechaInicio) = '{year}'
                                and MONTH(j.FechaInicio)in ('7','8','9','10','11','12')
                                AND l.Incidencia LIKE '%RETARDO%'
                                AND p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')
								--and d.IdTrabajador=2911 
								GROUP BY
                                b.IdTrabajador,
								a.IdConvenioLaboralTrabajadorCategoria,
                                g.EstructuraOrganica,
                                MONTH(j.FechaInicio)
                        )
                        UNION
                        (
                          		SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
								INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
								INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
								INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
								INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
								INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
								INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
								INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
								INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
								INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
								INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
								INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
								INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
								WHERE
								j.IdIncidenciaJustificacion = 0
                                AND YEAR(j.FechaInicio) = '{year}'
                                and MONTH(j.FechaInicio)in ('7','8','9','10','11','12')
                                AND l.Incidencia LIKE '%FALTA%'
                                AND p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')
								--and d.IdTrabajador=2911 
								GROUP BY
                                b.IdTrabajador,
								a.IdConvenioLaboralTrabajadorCategoria,
                                g.EstructuraOrganica,
                                MONTH(j.FechaInicio)
								
                        )
                    ) y
                    GROUP BY
                        y.IdTrabajador,
						y.IdConvenioLaboralTrabajadorCategoria,
                        y.UbicacionFisica
                ) w ON b.IdTrabajador = w.IdTrabajador AND g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
                " + Filtro + @" 
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica 


                ";



                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }

            return m;
        }





        public static List<IncidenciasDiasEconomicos> getIncidenciasPuntualidadAsistenciaMesas(string year, string relacionlaboral, string modalidad, string periodo)
        {
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;



            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }

                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') ";
                }

            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }

            }


            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";

            if (year != null)
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {
                    u = $@"       select 
				max (s.IdModalidadEstudio) as IdModalidadEstudio,
				g.EstructuraOrganica as Departamento,
				max (q.EstructuraOrganica) as PerteneceA,
				
				max (z.Enero) as Enero,
				max (z.Febrero) as Febrero,
				max (z.Marzo) as Marzo,
				max (z.Abril) as Abril,
				max (z.Mayo) as Mayo,
				max (z.Junio) as Junio,
				max (z.Julio) as Julio,
				max (z.Agosto) as Agosto,
				max (z.Septiembre) as Septiembre,
				max (z.Octubre) as Octubre,
				max (z.Noviembre) as Noviembre,
				max (z.Diciembre) as Diciembre

				from  Convenios_stConvenioLaboralTrabajadorCategoria a
						INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
						INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
						INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
						INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
						INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
						INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
						INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
						INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
						INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
						INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
						INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio
				inner join 

					(
								select UbicacionFisica
							,sum((case when Enero > 0 then 1 else 0 end)) Enero
							,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
							,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
							,sum((case when Abril > 0 then 1 else 0 end)) Abril
							,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
							,sum((case when Junio > 0 then 1 else 0 end)) Junio
							,sum((case when Julio > 0 then 1 else 0 end)) Julio
							,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
							,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
							,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
							,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
							,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
							from (

							select  
								w.UbicacionFisica , 
							w.IdConvenioLaboralTrabajadorCategoria,
								max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
								max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
								max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
								max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
								max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
								max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio,
								max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
								max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
								max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
								max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
								max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
								max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
								from 
									(
										select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
										  from (  (
												SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
													INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
													INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
													INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
													INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
													INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
													INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
													INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
													INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
													INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
													INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
													INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
													INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
													INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
													WHERE
													j.IdIncidenciaJustificacion = 0
													AND YEAR(j.FechaInicio) = '{year}'
													AND l.Incidencia LIKE '%RETARDO%'
													AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
												
													
													GROUP BY
													b.IdTrabajador,
													a.IdConvenioLaboralTrabajadorCategoria,
													g.EstructuraOrganica,
													MONTH(j.FechaInicio)
										  )

										union 

										  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND l.Incidencia LIKE '%FALTA%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
												
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
										   )
												)  y
												group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
										) w
										
										group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
										
										group by x.UbicacionFisica) z on g.EstructuraOrganica = z.UbicacionFisica 

										inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																		inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																		inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																		where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) t on g.EstructuraOrganica  = t.EstructuraOrganica
										
								
								
								" + Filtro + @" 
								--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
								group by g.EstructuraOrganica


                ";

                }
                else
                {

                    u = $@"     select 
				max (s.IdModalidadEstudio) as IdModalidadEstudio,
				g.EstructuraOrganica as Departamento,
				max (q.EstructuraOrganica) as PerteneceA,
				
				max (z.Enero) as Enero,
				max (z.Febrero) as Febrero,
				max (z.Marzo) as Marzo,
				max (z.Abril) as Abril,
				max (z.Mayo) as Mayo,
				max (z.Junio) as Junio,
				max (z.Julio) as Julio,
				max (z.Agosto) as Agosto,
				max (z.Septiembre) as Septiembre,
				max (z.Octubre) as Octubre,
				max (z.Noviembre) as Noviembre,
				max (z.Diciembre) as Diciembre

				from  Convenios_stConvenioLaboralTrabajadorCategoria a
						INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
						INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
						INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
						INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
						INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
						INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
						INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
						INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
						INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
						INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
						INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio
				inner join 

					(
								select UbicacionFisica
							,sum((case when Enero > 0 then 1 else 0 end)) Enero
							,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
							,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
							,sum((case when Abril > 0 then 1 else 0 end)) Abril
							,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
							,sum((case when Junio > 0 then 1 else 0 end)) Junio
							,sum((case when Julio > 0 then 1 else 0 end)) Julio
							,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
							,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
							,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
							,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
							,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
							from (

							select  
								w.UbicacionFisica , 
							w.IdConvenioLaboralTrabajadorCategoria,
								max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
								max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
								max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
								max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
								max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
								max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio,
								max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
								max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
								max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
								max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
								max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
								max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
								from 
									(
										select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
										  from (  (
												SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
													INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
													INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
													INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
													INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
													INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
													INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
													INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
													INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
													INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
													INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
													INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
													INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
													INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
													WHERE
													j.IdIncidenciaJustificacion = 0
													AND YEAR(j.FechaInicio) = '{year}'
													AND l.Incidencia LIKE '%RETARDO%'
													AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
													AND r.RelacionLaboral = '{relacionlaboral}'
													
													GROUP BY
													b.IdTrabajador,
													a.IdConvenioLaboralTrabajadorCategoria,
													g.EstructuraOrganica,
													MONTH(j.FechaInicio)
										  )

										union 

										  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND l.Incidencia LIKE '%FALTA%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
												AND r.RelacionLaboral = '{relacionlaboral}'
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
										   )
												)  y
												group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
										) w
										
										group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
										
										group by x.UbicacionFisica) z on g.EstructuraOrganica = z.UbicacionFisica 

										inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																		inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																		inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																		where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) t on g.EstructuraOrganica  = t.EstructuraOrganica
										
								
								
								" + Filtro + @" 
								--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
								group by g.EstructuraOrganica


                ";




                }

                m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
            }



            return m;
        }

        public static List<IncidenciasDiasEconomicos> getIncidenciasPuntualidadAsistenciaTrabajadoresMesas(string year, string relacionlaboral, string modalidad, string periodo)
        {
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<IncidenciasDiasEconomicos> m = new List<IncidenciasDiasEconomicos>();

            string yearnow = Convert.ToString(DateTime.Now.Year);
            string Filtro = string.Empty;

            if (year == "")
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }

                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') ";
                }

            }
            else
            {
                if (relacionlaboral != "" && modalidad != "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral == "" && modalidad != "")
                {
                    Filtro = "where s.IdModalidadEstudio= '" + modalidad + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }
                else if (relacionlaboral != "" && modalidad == "")
                {
                    Filtro = "where r.RelacionLaboral ='" + relacionlaboral + "' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') ";
                }
                else if (relacionlaboral == "" && modalidad == "")
                {
                    Filtro = "where p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD')";
                }

            }




            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string u = "";

            if (year != null && (periodo == null || periodo == "ANUAL"))
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {


                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						,sum((case when Enero > 0 then 1 else 0 end)) Enero
						,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
						,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
						,sum((case when Abril > 0 then 1 else 0 end)) Abril
						,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
						,sum((case when Junio > 0 then 1 else 0 end)) Junio
						,sum((case when Julio > 0 then 1 else 0 end)) Julio
						,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
						,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
						,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
						,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
						,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
							max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
							max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
							max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
							max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
							max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio,
							max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
							max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
							max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
							max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
							max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
							max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
				inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																		inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																		inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																		where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) t on g.EstructuraOrganica  = t.EstructuraOrganica
		
               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
                else
                {

                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						,sum((case when Enero > 0 then 1 else 0 end)) Enero
						,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
						,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
						,sum((case when Abril > 0 then 1 else 0 end)) Abril
						,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
						,sum((case when Junio > 0 then 1 else 0 end)) Junio
						,sum((case when Julio > 0 then 1 else 0 end)) Julio
						,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
						,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
						,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
						,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
						,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
							max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
							max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
							max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
							max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
							max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio,
							max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
							max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
							max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
							max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
							max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
							max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
                                                AND r.RelacionLaboral = '{relacionlaboral}'
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											AND r.RelacionLaboral = '{relacionlaboral}'
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
				inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																		inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																		inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																		where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) t on g.EstructuraOrganica  = t.EstructuraOrganica
               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
            }

            if (year != null && periodo == "PRIMER")
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {


                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                 
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END 
                    
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						,sum((case when Enero > 0 then 1 else 0 end)) Enero
						,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
						,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
						,sum((case when Abril > 0 then 1 else 0 end)) Abril
						,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
						,sum((case when Junio > 0 then 1 else 0 end)) Junio
					
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
							max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
							max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
							max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
							max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
							max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio
							
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND MONTH(j.FechaInicio) in ('1','2','3','4','5','6')
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND MONTH(j.FechaInicio) in ('1','2','3','4','5','6')
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
				inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																		inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																		inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																		where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) t on g.EstructuraOrganica  = t.EstructuraOrganica

               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
                else
                {

                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    MAX(w.Enero) AS Enero,
                    MAX(w.Febrero) AS Febrero,
                    MAX(w.Marzo) AS Marzo,
                    MAX(w.Abril) AS Abril,
                    MAX(w.Mayo) AS Mayo,
                    MAX(w.Junio) AS Junio,
                   
                    -- Contar los ceros total
                    SUM(
                    CASE
                        WHEN w.Enero = 0 OR w.Enero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Febrero = 0 OR w.Febrero IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Marzo = 0 OR w.Marzo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Abril = 0 OR w.Abril IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Mayo = 0 OR w.Mayo IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Junio = 0 OR w.Junio IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						,sum((case when Enero > 0 then 1 else 0 end)) Enero
						,sum((case when Febrero > 0 then 1 else 0 end)) Febrero
						,sum((case when Marzo > 0 then 1 else 0 end)) Marzo
						,sum((case when Abril > 0 then 1 else 0 end)) Abril
						,sum((case when Mayo > 0 then 1 else 0 end)) Mayo
						,sum((case when Junio > 0 then 1 else 0 end)) Junio
			
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							max(CASE WHEN w.Mes = 1 THEN  Trabajadores ELSE 0 END) AS Enero,
							max(CASE WHEN w.Mes = 2 THEN  Trabajadores ELSE 0 END) AS Febrero,
							max(CASE WHEN w.Mes = 3 THEN  Trabajadores ELSE 0 END) AS Marzo,
							max(CASE WHEN w.Mes = 4 THEN  Trabajadores ELSE 0 END) AS Abril,
							max(CASE WHEN w.Mes = 5 THEN  Trabajadores ELSE 0 END) AS Mayo,
							max(CASE WHEN w.Mes = 6 THEN  Trabajadores ELSE 0 END) AS Junio
							
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
											    AND MONTH(j.FechaInicio) in ('1','2','3','4','5','6')
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
                                                AND r.RelacionLaboral = '{relacionlaboral}'
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND MONTH(j.FechaInicio) in ('1','2','3','4','5','6')
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											AND r.RelacionLaboral = '{relacionlaboral}'
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
				inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																		inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																		inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																		where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) t on g.EstructuraOrganica  = t.EstructuraOrganica

               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
            }

            if (year != null && periodo == "SEGUNDO")
            {
                if (relacionlaboral == "" && (modalidad == "" || modalidad != ""))
                {


                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						
						,sum((case when Julio > 0 then 1 else 0 end)) Julio
						,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
						,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
						,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
						,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
						,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							
							max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
							max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
							max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
							max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
							max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
							max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND MONTH(j.FechaInicio) in ('7','8','9','10','11','12')
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND MONTH(j.FechaInicio) in ('7','8','9','10','11','12')
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
				inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																		inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																		inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																		where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) t on g.EstructuraOrganica  = t.EstructuraOrganica

               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
                else
                {

                    u = $@"SELECT
                    b.IdTrabajador,
					a.IdConvenioLaboralTrabajadorCategoria,
					 max (s.IdModalidadEstudio) as IdModalidadEstudio,
                    MAX(p.ConvenioLaboral) AS ConvenioLaboral,
                    MAX(f.Nombre) AS Nombre,
                    MAX(f.ApellidoPaterno) AS ApellidoPaterno,
                    MAX(f.ApellidoMaterno) AS ApellidoMaterno,
                    MAX(f.Sexo) AS Sexo,
                    (g.EstructuraOrganica) as UbicacionFisica,
                    MAX(g.IdEstructuraOrganica) AS IdEstructuraOrganicaFisica,
                    MAX(g.IdEstructuraOrganicaPadre) AS IdEstructuraOrganicaPadre,
                    MAX(q.EstructuraOrganica) AS PerteneceA,
                    MAX(r.RelacionLaboral) AS RelacionLaboral,
                    
                    MAX(w.Julio) AS Julio,
                    MAX(w.Agosto) AS Agosto,
                    MAX(w.Septiembre) AS Septiembre,
                    MAX(w.Octubre) AS Octubre,
                    MAX(w.Noviembre) AS Noviembre,
                    MAX(w.Diciembre) AS Diciembre,
                    -- Contar los ceros total
                    SUM(
                    
                    CASE
                        WHEN w.Julio = 0 OR w.Julio IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Agosto = 0 OR w.Agosto IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Septiembre = 0 OR w.Septiembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Octubre = 0 OR w.Octubre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Noviembre = 0 OR w.Noviembre IS NULL THEN 1
                        ELSE 0
                    END +
                    CASE
                        WHEN w.Diciembre = 0 OR w.Diciembre IS NULL THEN 1
                        ELSE 0
                    END
                ) AS Total
                FROM
                    Convenios_stConvenioLaboralTrabajadorCategoria a
					INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
					INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
					INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
					INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
					INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
					INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
					INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
					INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
					INNER JOIN Catalogos_ctEstructuraOrganica q ON g.IdEstructuraOrganicaPadre=q.IdEstructuraOrganica
					INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
					INNER JOIN Catalogos_ctModalidadEstudio s ON s.IdModalidadEstudio=g.IdModalidadEstudio


                LEFT JOIN (select UbicacionFisica,
				IdConvenioLaboralTrabajadorCategoria
						
						,sum((case when Julio > 0 then 1 else 0 end)) Julio
						,sum((case when Agosto > 0 then 1 else 0 end)) Agosto
						,sum((case when Septiembre > 0 then 1 else 0 end)) Septiembre
						,sum((case when Octubre > 0 then 1 else 0 end)) Octubre
						,sum((case when Noviembre > 0 then 1 else 0 end)) Noviembre
						,sum((case when Diciembre > 0 then 1 else 0 end)) Diciembre
						from (

						select  
							w.UbicacionFisica , 
						w.IdConvenioLaboralTrabajadorCategoria,
							
							max(CASE WHEN w.Mes = 7 THEN  Trabajadores ELSE 0 END) AS Julio,
							max(CASE WHEN w.Mes = 8 THEN  Trabajadores ELSE 0 END) AS Agosto,
							max(CASE WHEN w.Mes = 9 THEN  Trabajadores ELSE 0 END) AS Septiembre,
							max(CASE WHEN w.Mes = 10 THEN Trabajadores ELSE 0 END) AS Octubre,
							max(CASE WHEN w.Mes = 11 THEN  Trabajadores ELSE 0 END) AS Noviembre,
							max(CASE WHEN w.Mes = 12 THEN  Trabajadores ELSE 0 END) AS Diciembre	
							from 
								(
									select y.UbicacionFisica,y.IdConvenioLaboralTrabajadorCategoria, y.Mes,  count (y.IdTrabajador) as Trabajadores
									  from (  (
											SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
												INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
												INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
												INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
												INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
												INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
												INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
												INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
												INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
												INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
												INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
												INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
												INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
												INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
												WHERE
												j.IdIncidenciaJustificacion = 0
												AND YEAR(j.FechaInicio) = '{year}'
												AND MONTH(j.FechaInicio) in ('7','8','9','10','11','12')
												AND l.Incidencia LIKE '%RETARDO%'
												AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
                                                AND r.RelacionLaboral = '{relacionlaboral}'
											
												
												GROUP BY
												b.IdTrabajador,
												a.IdConvenioLaboralTrabajadorCategoria,
												g.EstructuraOrganica,
												MONTH(j.FechaInicio)
									  )

									union 

									  (SELECT g.EstructuraOrganica AS UbicacionFisica, COUNT (a.IdConvenioLaboralTrabajadorCategoria) AS Faltas, b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,MONTH (j.FechaInicio) AS Mes  from Convenios_stConvenioLaboralTrabajadorCategoria a
											INNER JOIN Convenios_stConvenioLaboralTrabajador b ON a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
											INNER JOIN Plazas_stDistribucionPlazaCategoria c ON a.IdDistribucionPlazaCategoria = c.IdDistribucionPlazaCategoria
											INNER JOIN Kardex_ctTrabajador d ON b.IdTrabajador = d.IdTrabajador
											INNER JOIN Kardex_ctDatosPersonales f ON d.IdKardex=f.IdKardex
											INNER JOIN Catalogos_ctEstructuraOrganica g ON g.IdEstructuraOrganica=a.IdEstructuraOrganica
											INNER JOIN Catalogos_ctEstructuraOrganica h ON h.IdEstructuraOrganica=c.IdEstructuraOrganica
											INNER JOIN IncidenciaPermiso_stIncidenciaTrabajador j ON a.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
											INNER JOIN Nomina_RelojChecadorAreasEstructuraOrganica k ON a.IdEstructuraOrganica = k.IdEstructuraOrganica
											INNER JOIN Catalogos_ctTipoIncidencia l ON j.IdTipoIncidencia = l.IdTipoIncidencia
											INNER JOIN Plazas_ctCategoria m ON  c.IdCategoria = m.IdCategoria
											INNER JOIN Convenios_stRelacionConvenioLaboral n ON n.IdRelacionConvenioLaboral=m.IdRelacionConvenioLaboral
											INNER JOIN Catalogos_ctConvenioLaboral p ON n.IdConvenioLaboral=p.IdConvenioLaboral
											INNER JOIN Catalogos_ctRelacionLaboral r ON r.IdRelacionLaboral=n.IdRelacionLaboral
											WHERE
											j.IdIncidenciaJustificacion = 0
											AND YEAR(j.FechaInicio) = '{year}'
											AND MONTH(j.FechaInicio) in ('7','8','9','10','11','12')
											AND l.Incidencia LIKE '%FALTA%'
											AND p.ConvenioLaboral in ('BASE','DEFINITIVO SPD')
											AND r.RelacionLaboral = '{relacionlaboral}'
											
											GROUP BY
											b.IdTrabajador,
											a.IdConvenioLaboralTrabajadorCategoria,
											g.EstructuraOrganica,
											MONTH(j.FechaInicio)
									   )
											)  y
											group by y.UbicacionFisica, y.IdConvenioLaboralTrabajadorCategoria, y.Mes
									) w
									
									group by w.UbicacionFisica,w.IdConvenioLaboralTrabajadorCategoria) x
									
									group by x.UbicacionFisica, x.IdConvenioLaboralTrabajadorCategoria
           
                ) w ON  g.EstructuraOrganica = w.UbicacionFisica and a.IdConvenioLaboralTrabajadorCategoria= w.IdConvenioLaboralTrabajadorCategoria
				inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
																		inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
																		inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
																		where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) t on g.EstructuraOrganica  = t.EstructuraOrganica

               " + Filtro + @"
					--where  p.ConvenioLaboral = 'BASE'   and b.IdTrabajador = 2911
					--where r.RelacionLaboral ='DOCENTE' and s.IdModalidadEstudio= '1' and p.ConvenioLaboral  in ('BASE','DEFINITIVO SPD') 
                GROUP BY
                    b.IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria, g.EstructuraOrganica
                ";



                    m = (List<IncidenciasDiasEconomicos>)dp.connection.Query<IncidenciasDiasEconomicos>(u);
                }
            }
            return m;
        }





        public static List<PrimaDominical> getIncidenciasPrimaDominical(string fip, string ftp)
        {

            List<PrimaDominical> m = new List<PrimaDominical>();





            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";


            if (fip != null)
            {

                DateTime fil = DateTime.Parse(fip);
                string fi = fil.ToString("yyyMMdd");
                DateTime ftl = DateTime.Parse(ftp);
                string ft = ftl.ToString("yyyMMdd");
                u = $@"
				select * 

from ( SELECT  [IdEstructuraOrganica], a.IdEstructuraOrganicaPadre
                         ,case when IdModalidadEstudio=0 then 'OFICINAS CENTRALES' ELSE
                           CASE WHEN IdModalidadEstudio=1 THEN 'PLANTELES' ELSE 'EMSADS' END END AS TipoCentro
                          ,[EstructuraOrganica] as Departamento
                          ,(select [EstructuraOrganica] FROM [bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica=a.IdEstructuraOrganicaPadre) as PerteneceA
                         
                          ,w.TotalFaltas
                     
                          ,w.AñoQuincenaNomina 
                          ,w.ctaAñoNomina 
	                     
                      FROM [Catalogos_ctEstructuraOrganica] a
                        left join ( SELECT count(t.IdTrabajador)as TotalFaltas,t.IdEstructuraOrganicaFisica,
                       sum(case when AñoParaNomina is not null then 1 else 0 end) as ctaAñoNomina,
                       max(case when AñoParaNomina is not null then cast(AñoParaNomina as nvarchar(8))+'-'+cast(QuincenaParaNomina as nvarchar(8)) else '' end) as AñoQuincenaNomina
                        
                                                           FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                     inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                      inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                     inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                     INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                     WHERE c.TipoIncidenciaPermiso in('PERCEPCION')  AND b.Incidencia IN( 'PRIMA DOMINICAL')
 
                       -- and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'  and cast(t.FechaInicio as DATE)  <= '{fi}'
                       and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}')   
                          --and(a.FechaInicio <= '20230831' OR a.FechaInicio <= DATEADD(YEAR, -2, '20230831')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '20230815') 
					    and ((Autorizo=1) )     
                       group by 
                        t.IdEstructuraOrganicaFisica) as w on w.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                     
                   
                      ) as qq where qq.TotalFaltas is not null 
					  --and qq.TipoCentro in ('OFICINAS CENTRALES')
                    order by qq.IdEstructuraOrganicaPadre
                ";



                m = (List<PrimaDominical>)dp.connection.Query<PrimaDominical>(u);
            }
            return m;
        }


        public static List<PrimaDominical> getIncidenciasPrimaDominicalMesas(string fip, string ftp)
        {
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PrimaDominical> m = new List<PrimaDominical>();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";


            if (fip != null)
            {

                DateTime fil = DateTime.Parse(fip);
                string fi = fil.ToString("yyyMMdd");
                DateTime ftl = DateTime.Parse(ftp);
                string ft = ftl.ToString("yyyMMdd");
                u = $@"
				select * 
                    from ( SELECT  [IdEstructuraOrganica], a.IdEstructuraOrganicaPadre
                             ,case when IdModalidadEstudio=0 then 'OFICINAS CENTRALES' ELSE
                               CASE WHEN IdModalidadEstudio=1 THEN 'PLANTELES' ELSE 'EMSADS' END END AS TipoCentro
                              ,[EstructuraOrganica] as Departamento
                              ,(select [EstructuraOrganica] FROM [bdNova].[dbo].[Catalogos_ctEstructuraOrganica]x where x.IdEstructuraOrganica=a.IdEstructuraOrganicaPadre) as PerteneceA                         
                              ,w.TotalFaltas
                     
                              ,w.AñoQuincenaNomina 
                              ,w.ctaAñoNomina 
	                     
                          FROM [Catalogos_ctEstructuraOrganica] a
                            left join ( SELECT count(t.IdTrabajador)as TotalFaltas,t.IdEstructuraOrganicaFisica,
                           sum(case when AñoParaNomina is not null then 1 else 0 end) as ctaAñoNomina,
                           max(case when AñoParaNomina is not null then cast(AñoParaNomina as nvarchar(8))+'-'+cast(QuincenaParaNomina as nvarchar(8)) else '' end) as AñoQuincenaNomina
                        
                                                               FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                         inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                         inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                         inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                         INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
                         WHERE c.TipoIncidenciaPermiso in('PERCEPCION')  AND b.Incidencia IN( 'PRIMA DOMINICAL')
 
                          -- and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <='{ft}'  and cast(t.FechaInicio as DATE)  <= '{fi}'
                          and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}')   
                          --and(a.FechaInicio <= '20230831' OR a.FechaInicio <= DATEADD(YEAR, -2, '20230831')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '20230815') 
					      and ((Autorizo=1) )     
                          group by 
                          t.IdEstructuraOrganicaFisica) as w on w.IdEstructuraOrganicaFisica=[IdEstructuraOrganica]
                                      
                          ) as qq 
					      inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
					      inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
					      inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
					      where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) p on qq.IdEstructuraOrganica = p.IdEstructuraOrganica
                          --where a.IdConvenioLaboralTrabajadorCategoria = 8640) p on qq.IdEstructuraOrganica = p.IdEstructuraOrganica
					
                        where qq.TotalFaltas is not null 
					    --and qq.TipoCentro in ('OFICINAS CENTRALES')
                        order by qq.IdEstructuraOrganicaPadre
                ";



                m = (List<PrimaDominical>)dp.connection.Query<PrimaDominical>(u);
            }
            return m;
        }

        public static List<PrimaDominicalTrabajadores> getIncidenciasPrimaDominicalTrabajadores(string fip, string ftp)
        {
            List<PrimaDominicalTrabajadores> m = new List<PrimaDominicalTrabajadores>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {


                u = $@" 

SELECT count(t.IdTrabajador)as TotalFaltas,
					   t.IdTrabajador,
					   a.IdIncidenciaTrabajador,                      
                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					   max (t.Nombre) as Nombre,
					   max (t.ApellidoPaterno) as ApellidoPaterno,
					   max (t.ApellidoMaterno) as ApellidoMaterno,
					   max (t.Sexo) as Sexo , 
					   max (t.UbicacionFisica) as UbicacionFisica, 
					   max (b.Incidencia) as Incidencia, 
					   max (a.FechaInicio) as Fecha, 
					   max (a.Observaciones) as Observaciones , 
					   max (a.Horas) as Horas ,
					   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					max (t.RelacionLaboral)as RelacionLaboral ,
					max (hor.Horario) as Horario,(SELECT  top 1
						  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					  FROM  Nomina_HorariosEspeciales h
					  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								  FROM  Nomina_HorariosConvenioConfiguracion a
								  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
                    WHERE c.TipoIncidenciaPermiso in('PERCEPCION')  AND b.Incidencia  IN( 'PRIMA DOMINICAL')
					and ((Autorizo=1) )
                
					--and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio= 0 and cast(t.FechaInicio as DATE)  <= '{fi}'
                    --and(a.FechaInicio <= '20230831' OR a.FechaInicio <= DATEADD(YEAR, -2, '20230831')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '20230815') 
		      and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') 
			--and t.IdModalidadEstudio= 0 
                    --and  t.ConvenioLaboral in ('CONFIANZA','CONTRATO')

                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador

 ";










                m = (List<PrimaDominicalTrabajadores>)dp.connection.Query<PrimaDominicalTrabajadores>(u);
            }
            return m;






        }

        public static List<PrimaDominicalTrabajadores> getIncidenciasPrimaDominicalTrabajadoresMesas(string fip, string ftp)
        {
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PrimaDominicalTrabajadores> m = new List<PrimaDominicalTrabajadores>();
            DateTime fil = DateTime.Parse(fip);
            string fi = fil.ToString("yyyMMdd");
            DateTime ftl = DateTime.Parse(ftp);
            string ft = ftl.ToString("yyyMMdd");
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";

            if (fi != null)
            {


                u = $@" 

                SELECT count(t.IdTrabajador)as TotalFaltas,
					                   t.IdTrabajador,
					                   a.IdIncidenciaTrabajador,                      
                                       max (t.IdModalidadEstudio) as IdModalidadEstudio , max( t.ConvenioLaboral) as ConvenioLaboral, 
					                   max (t.Nombre) as Nombre,
					                   max (t.ApellidoPaterno) as ApellidoPaterno,
					                   max (t.ApellidoMaterno) as ApellidoMaterno,
					                   max (t.Sexo) as Sexo , 
					                   max (t.UbicacionFisica) as UbicacionFisica, 
					                   max (b.Incidencia) as Incidencia, 
					                   max (a.FechaInicio) as Fecha, 
					                   max (a.Observaciones) as Observaciones , 
					                   max (a.Horas) as Horas ,
					                   max (t.IdEstructuraOrganicaFisica) as IdEstructuraOrganicaFisica,
					                   max (t.IdEstructuraOrganicaPadre) as IdEstructuraOrganicaPadre,
					                   max (t.EstructuraOrganicaPadre) as EstructuraOrganicaPadre,
					                max (t.RelacionLaboral)as RelacionLaboral ,
					                max (hor.Horario) as Horario,(SELECT  top 1
						                  max(cast(h.Entrada as nvarchar(5))) +'-'+max(cast(h.salida as nvarchar(5))) as Horario
					                  FROM  Nomina_HorariosEspeciales h
					                  where h.Dia=1 and  h.idtrabajador=t.idtrabajador)  as HorarioEspecial					  
                                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
                                    inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
                                    inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
                                    inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                                    INNER JOIN Incidencia_ctJustificacion J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
					                left join (SELECT    max(cast(a.Entrada as nvarchar(5))) +'-'+max(cast(a.salida as nvarchar(5))) as Horario,a.IdRelacionConvenioLaboral
								                  FROM  Nomina_HorariosConvenioConfiguracion a
								                  inner join  Convenios_stRelacionConvenioLaboral b on a.IdRelacionConvenioLaboral=b.IdRelacionConvenioLaboral
								                  group by a.IdRelacionConvenioLaboral) as hor on t.IdRelacionConvenioLaboral=hor.IdRelacionConvenioLaboral
									inner join (select c.IdEstructuraOrganica,c.EstructuraOrganica,a.IdConvenioLaboralTrabajadorCategoria from Nomina_RelojChecadorControlUsuarios  a
										 inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas= b.IdRelojChecadorAreas
										 inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
										 where a.IdConvenioLaboralTrabajadorCategoria = {idconveniolaboraltrabajadorcategoria}) p on t.IdEstructuraOrganicaFisica = p.IdEstructuraOrganica

                                    WHERE c.TipoIncidenciaPermiso in('PERCEPCION')  AND b.Incidencia  IN( 'PRIMA DOMINICAL')
					                and ((Autorizo=1) )
                
					                --and cast(a.FechaInicio as DATE) >= '{fi}' and cast(a.FechaInicio as DATE) <= '{ft}' and t.IdModalidadEstudio= 0 and cast(t.FechaInicio as DATE)  <= '{fi}'
                                    --and(a.FechaInicio <= '20230831' OR a.FechaInicio <= DATEADD(YEAR, -2, '20230831')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '20230815') 
		                     and(a.FechaInicio <= '{ft}' OR a.FechaInicio <= DATEADD(YEAR, -2, '{ft}')) AND(a.FechaTermino IS NULL OR a.FechaTermino >= '{fi}') 
			                --and t.IdModalidadEstudio= 0 
                                    --and  t.ConvenioLaboral in ('CONFIANZA','CONTRATO')

                                    group by  t.IdTrabajador, a.IdIncidenciaTrabajador

                 ";

                m = (List<PrimaDominicalTrabajadores>)dp.connection.Query<PrimaDominicalTrabajadores>(u);
            }
            return m;

        }
        public static Resultados ValidaContratosComision(int IdTrabajador, int idcltc, DateTime fi)
        {
            Resultados rs = new Resultados();

            bdNovaEntities db = new bdNovaEntities();
            var comisiondatostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.Where(q => q.IdTrabajador == IdTrabajador
               && q.FechaTermino.Value.Year == fi.Year && q.FechaTermino.Value.Month >= fi.Month && q.IdConvenioLaboralTrabajadorCategoria != idcltc
               //&& q.FechaTermino.Value.Month== falta.Dia.Month
               ).OrderByDescending(q => q.FechaTermino).FirstOrDefault();
            if (comisiondatostrabajador != null)
            {
                if (fi <= comisiondatostrabajador.FechaTermino)
                {
                    rs.IsValid = false;
                    rs.Messsage = $"Ha una comsión para este trabajador con fecha de término {comisiondatostrabajador.FechaTermino} , por favor seleccione el contrato correcto para poder agregar la incidecia para esta fecha {fi}";

                }
                else
                    rs.IsValid = true;
            }
            else
                rs.IsValid = true;


            return rs;
        }

        public static List<IndicenciasConcentrado> getIncidenciasPorMesa(int id=0)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";
            if (id > 0)
            {
                u = @"select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso,QuincenaParaNomina,AñoParaNomina
,year(a.FechaInicio) as Año,month(a.FechaInicio) as Mes, case when day(a.FechaInicio)<16 then 1 ELSE 2 END  as Qna
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA','RETARDOS')  
 and EsCerrada=1 AND EsAplicada=0 and ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 ) 
) as uno
                    inner join (
                    SELECT  a.IdConvenioLaboralTrabajadorCategoria,q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                    where a.IdConvenioLaboralTrabajadorCategoria=" + id + @"
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica 
UNION ALL   
  
                    
                    select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso,QuincenaParaNomina,AñoParaNomina,year(a.FechaInicio) as Año,month(a.FechaInicio) as Mes, case when day(a.FechaInicio)<16 then 1 ELSE 2 END  as Qna
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('PERCEPCION') 
 and 
EsAplicada=0 and (Autorizo=1 and a.IdIncidenciaJustificacion>0 or (Autorizo=1 and EsFaltaDirecta=1 ))
 ) as uno
                    inner join (
                    SELECT  a.IdConvenioLaboralTrabajadorCategoria,q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                    where a.IdConvenioLaboralTrabajadorCategoria=" + id + @"
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica ";
            }
            else
            {

                u = @"select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso,QuincenaParaNomina,AñoParaNomina
,year(a.FechaInicio) as Año,month(a.FechaInicio) as Mes, case when day(a.FechaInicio)<16 then 1 ELSE 2 END  as Qna
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA','RETARDOS')  
  and EsAplicada=0 and ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 ) 
) as uno
                    inner join (
                    SELECT  a.IdConvenioLaboralTrabajadorCategoria,q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                    
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica 
UNION ALL   
  
                    
                    select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso,QuincenaParaNomina,AñoParaNomina,year(a.FechaInicio) as Año,month(a.FechaInicio) as Mes, case when day(a.FechaInicio)<16 then 1 ELSE 2 END  as Qna
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('PERCEPCION') 
 and 
EsAplicada=0 and (Autorizo=1 and a.IdIncidenciaJustificacion>0 or (Autorizo=1 and EsFaltaDirecta=1 ))
) as uno
                    inner join (
                    SELECT  a.IdConvenioLaboralTrabajadorCategoria,q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                   
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica ";
            }

            List<IndicenciasConcentrado> model = (List<IndicenciasConcentrado>)dp.connection.Query<IndicenciasConcentrado>(u);

             return model;
        }
        public static IEnumerable getConveniosLaborales(int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
                 .Select(g => new { g.IdConvenioLaboralTrabajador, g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral, g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral }).ToList();
        }
        public static string getConvenioLaboral(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
                .Select(g => g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral).SingleOrDefault();

        }

        public static string getCategoria(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
                .Select(g => g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria).SingleOrDefault();

        }
        public static List<Años> GetAñosAsistencia()
        {
            bdNovaEntities db = new bdNovaEntities();
            List<Años> ListaAños = new List<Años>();
            //var laños = db.Nomina_RelojChecadorAsistencia.GroupBy(x => x.FechaAsistencia.Year).Select(y => new { año = y.Key }).ToList();
            var laños = db.Nomina_stNomina.GroupBy(x => x.FechaInicio.Year).Select(y => new { año = y.Key }).OrderByDescending(y=> y.año).ToList();

            short i = 1;
            foreach (var item in laños)
            {
                Años unaño = new Años();
                unaño.IdAño = System.Convert.ToInt32(item.año);

                unaño.Año = item.año;
                ListaAños.Add(unaño);
            }
            return ListaAños;
        }
        public static List<AreasUsuario> GetAreasAdmin()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select c.IdEstructuraOrganica,max(d.EstructuraOrganica) as EstructuraOrganica from Nomina_RelojChecadorAreas a 
            left join Nomina_RelojChecadorControlUsuarios b
            on a.IdRelojChecadorAreas = b.IdRelojChecadorAreas
            left join Nomina_RelojChecadorAreasEstructuraOrganica c on c.idrelojchecadorareas=a.IdRelojChecadorAreas
            left join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
            group by c.IdEstructuraOrganica";
            List<AreasUsuario> listat = (List<AreasUsuario>)dp.connection.Query<AreasUsuario>(query);
            dp.Close();
            return listat.ToList();

        }

        public static List<AreasUsuario> GetAreasUsuario(int idcltc)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select c.IdEstructuraOrganica,max(d.EstructuraOrganica) as EstructuraOrganica  from Nomina_RelojChecadorAreas a 
            left join Nomina_RelojChecadorControlUsuarios b
            on a.IdRelojChecadorAreas = b.IdRelojChecadorAreas
            left join Nomina_RelojChecadorAreasEstructuraOrganica c on c.idrelojchecadorareas=a.IdRelojChecadorAreas
            left join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
            where b.IdConvenioLaboralTrabajadorCategoria=" + idcltc + " group by c.IdEstructuraOrganica";
            List<AreasUsuario> listat = (List<AreasUsuario>)dp.connection.Query<AreasUsuario>(query);
            dp.Close();
            return listat.ToList();

        }
        public static List<AreasUsuario> GetAreaDirector(int idcltc)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select b.IdEstructuraOrganica,b.EstructuraOrganica from Convenios_stConvenioLaboralTrabajadorCategoria a 
            inner join Catalogos_ctEstructuraOrganica b
            on a.IdEstructuraOrganica= b.IdEstructuraOrganica
            where a.IdConvenioLaboralTrabajadorCategoria=" + idcltc + "";
            List<AreasUsuario> listat = (List<AreasUsuario>)dp.connection.Query<AreasUsuario>(query);
            dp.Close();
            return listat.ToList();

        }

        public static List<Quincena> GetQuincenaMes()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select a.IdQuincenaMes,a.QuincenaMes+'-'+b.Mes as QuincenaMes from Catalogos_ctQuincenaMes a
            inner join Catalogos_ctMes b on a.IdMes = b.IdMes
            order by a.QuincenaMes";
            List<Quincena> listat = (List<Quincena>)dp.connection.Query<Quincena>(query);
            dp.Close();
            return listat.ToList();

        }
        public static List<Incidencia_ctJustificacion> GetLeyendas()
        {
            List<Incidencia_ctJustificacion> leyendas = new List<Incidencia_ctJustificacion>();
            Incidencia_ctJustificacion jus = new Incidencia_ctJustificacion();
            jus.IdIncidenciaJustificacion = 1;
            jus.Color = "#FFFFFF";
            jus.IncidenciaJustificacion = "CERRADA";
            jus.Nomenclatura = "RR";
            leyendas.Add(jus);

            Incidencia_ctJustificacion jus2 = new Incidencia_ctJustificacion();
            jus2.IdIncidenciaJustificacion = 2;
            jus2.Color = "#FFFFFF";
            jus2.IncidenciaJustificacion = "AUTORIZADA";
            jus2.Nomenclatura = "AA";
            leyendas.Add(jus2);

            Incidencia_ctJustificacion jus3 = new Incidencia_ctJustificacion();
            jus3.IdIncidenciaJustificacion = 3;
            jus3.Color = "#FFFFFF";
            jus3.IncidenciaJustificacion = "NO AUTORIZADA";
            jus3.Nomenclatura = "NN";
            leyendas.Add(jus3);

            Incidencia_ctJustificacion jus4 = new Incidencia_ctJustificacion();
            jus4.IdIncidenciaJustificacion = 4;
            jus4.Color = "#FFFFFF";
            jus4.IncidenciaJustificacion = "DEVOLUCIÓN";
            jus4.Nomenclatura = "DE";
            leyendas.Add(jus4);
            return leyendas;

        }

        public static List<IncidenciaTrabajador> GetIncidencias(int aaaa, short idestructura, short idqm)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select a.IdIncidenciaTrabajador,a.FechaInicio,a.FechaTermino,a.Horas,d.IdTrabajador,e.Nombre+' '+e.ApellidoPaterno+' '+e.ApellidoMaterno as Trabajador
,CASE WHEN j.RelacionLaboral='DOCENTE' then a.Horas else DATEDIFF(day, b.FechaInicio,a.FechaTermino) end as DiasHorasIncidencia
,CASE WHEN k.Incidencia='DÍAS ECONÓMICOS' then DATEDIFF(day, b.FechaInicio,a.FechaTermino) ELSE 0 end DiasEconomicos
,a.Observaciones,j.RelacionLaboral,a.EsAplicada,a.Autorizo,a.DescripcionJustificacion,a.EsJustificacionExtemporanea
,a.FechaAutorizacion,a.FechaCreacion,a.FechaJustificacion,ka.Nombre+' '+ka.ApellidoPaterno+' '+ka.ApellidoMaterno as QuienAutorizo
,kj.Nombre+' '+kj.ApellidoPaterno+' '+kj.ApellidoMaterno as QuienJustifico
,kr.Nombre+' '+kr.ApellidoPaterno+' '+kr.ApellidoMaterno as QuienRegistro
,dj.Incidencia as IncidenciaJustico,dj.Nomenclatura as NomenclaturaJustifico,dj.Color ColorJustifico
,a.IdNominaTrabajador,k.Incidencia,k.Nomenclatura,k.Color,f.EstructuraOrganica
from IncidenciaPermiso_stIncidenciaTrabajador a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador d on d.IdTrabajador = c.IdTrabajador
inner join Kardex_ctDatosPersonales e on d.IdKardex= e.IdKardex
inner join Catalogos_ctEstructuraOrganica f on b.IdEstructuraOrganica =f.IdEstructuraOrganica
inner join Plazas_stDistribucionPlazaCategoria g on b.IdDistribucionPlazaCategoria=g.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria h on g.IdCategoria=h.IdCategoria
inner join Convenios_stRelacionConvenioLaboral i on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctRelacionLaboral j on i.IdRelacionLaboral=j.IdRelacionLaboral
inner join Catalogos_ctTipoIncidencia k on a.IdTipoIncidencia=k.IdTipoIncidencia
--Autorizo
left join Convenios_stConvenioLaboralTrabajadorCategoria ca on a.IdConvenioLaboralTrabajadorCategoriaAutorizo=ca.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador la on la.IdConvenioLaboralTrabajador= ca.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador ta on ta.IdTrabajador=la.IdTrabajador
left join Kardex_ctDatosPersonales ka on ka.IdKardex = ta.IdKardex
--Justifico
left join Convenios_stConvenioLaboralTrabajadorCategoria cj on a.IdConvenioLaboralTrabajadorCategoriaJustifico=cj.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador lj on lj.IdConvenioLaboralTrabajador= cj.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador tj on tj.IdTrabajador=lj.IdTrabajador
left join Kardex_ctDatosPersonales kj on kj.IdKardex = tj.IdKardex
--Registro
left join Convenios_stConvenioLaboralTrabajadorCategoria cr on a.IdConvenioLaboralTrabajadorCategoriaRegistro=cr.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador lr on lr.IdConvenioLaboralTrabajador= cr.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador tr on tr.IdTrabajador=lr.IdTrabajador
left join Kardex_ctDatosPersonales kr on kr.IdKardex = tr.IdKardex
--Incidencia Justificación
left join Incidencia_ctJustificacion ij on ij.IdIncidenciaJustificacion = a.IdIncidenciaJustificacion
left join Catalogos_ctTipoIncidencia dj on dj.IdTipoIncidencia=ij.IdTipoIncidencia
where b.IdEstructuraOrganica=" + idestructura + " and YEAR(a.FechaInicio)=" + aaaa + " 2018 and k.IdTipoIncidenciaPermiso=3";
            List<IncidenciaTrabajador> listat = (List<IncidenciaTrabajador>)dp.connection.Query<IncidenciaTrabajador>(query);
            dp.Close();
            return listat.ToList();

        }


        public static string ObtenerPrimerasLetras(string frase)
        {
            string resultado = new string(frase.Split(' ')
                                       .Where(palabra => !string.IsNullOrEmpty(palabra) && palabra.ToLower() != "de")
                                       .Select(palabra => palabra[0])
                                       .ToArray());

            return resultado;
        }

        public static List<AsistenciasTrabajador> getAsistencias(string fi = null, string ff = null, string areas = null, string id = null, string nom= null)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            List<AsistenciasTrabajador> AsistenciasTrabajador = new List<AsistenciasTrabajador>();
            string condicion = "";
            if (fi != null)
                condicion = "  CAST(a.FechaAsistencia  as date) >= CAST('" + fi + "'  as date) and CAST(a.FechaAsistencia  as date) <= CAST('" + ff + "'  as date)";

            if (areas != null)
                if (areas != "")
                    if (condicion != "")
                        condicion = condicion + "  and z.UbicacionFisica in (" + areas + ") ";
                    else
                        condicion = condicion + "  z.UbicacionFisica in (" + areas + ") ";


            if (id != null)
                if (id != "")
                    if (condicion != "")
                        condicion = condicion + "  and a.IdTrabajador =" + id;
                    else
                        condicion = condicion + "  a.IdTrabajador =" + id;

            if (nom != null)
                if (nom != "")
                    if (condicion != "")
                        condicion = condicion + "  and (z.nombre like '%" + nom+ "%' or z.ApellidoPaterno like '%"+nom+ "%' or z.ApellidoMaterno like '%" + nom + "%'  or (z.Nombre+z.ApellidoPaterno+z.ApellidoMaterno like '%"+ nom.Replace(" ","") +"%') ) ";
                    else
                        condicion = condicion + "   (z.nombre like '%" + nom + "%' or z.ApellidoPaterno like '%" + nom + "%' or z.ApellidoMaterno like '%" + nom + "%' or (z.Nombre+z.ApellidoPaterno+z.ApellidoMaterno like '%" + nom.Replace(" ", "") + "%') ) ";

            string query = @"select 
a.IdTrabajador,z.Nombre,z.ApellidoPaterno,z.ApellidoMaterno
,z.Categoria,  z.UbicacionFisica,z.RelacionLaboral,z.ConvenioLaboral,z.EstatusTrabajador
,a.FechaAsistencia,e.FechaInicio,e.FechaTermino,Autorizo,
w.Nombre as NombreJustifico,w.ApellidoPaterno as ApellidoPaternoJustifico,w.ApellidoMaterno as ApellidoMaternoJustifico
,x.Nombre as NombreAutorizo,x.ApellidoPaterno as ApellidoPaternoAutorizo,x.ApellidoMaterno as ApellidoMaternoAutorizo
,e.IdIncidenciaTrabajador,q.IncidenciaJustificacion,q.Nomenclatura,q.Color
,e.FechaJustificacion,e.FechaAutorizacion
,s.Incidencia,s.Nomenclatura as NomenclaturaIncidencia,s.Color ColorIncidencia
,h.Mes NombreMes,Month(a.FechaAsistencia) as Mes,YEAR(a.FechaAsistencia) as anio
from Nomina_RelojChecadorAsistencia a
inner join vwDatosAspirantesTrabajadores z on a.IdTrabajador=z.IdTrabajador
left join IncidenciaPermiso_stIncidenciaTrabajador e 
on e.IdConvenioLaboralTrabajadorCategoria=z.IdConvenioLaboralTrabajadorCategoria
and  CONVERT(varchar, a.FechaAsistencia, 23)=CONVERT(varchar, e.FechaInicio , 23)
and CONVERT(varchar, a.FechaAsistencia, 23)=CONVERT(varchar, e.FechaTermino, 23)
left join vwDatosAspirantesTrabajadores w on w.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoriaJustifico
left join vwDatosAspirantesTrabajadores x on x.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoriaAutorizo
left join Incidencia_ctJustificacion q on q.IdIncidenciaJustificacion=e.IdIncidenciaJustificacion
left join Catalogos_ctTipoIncidencia s on s.IdTipoIncidencia=e.IdTipoIncidencia
left join Catalogos_ctMes h on h.IdMes=Month( a.FechaAsistencia)
where " + condicion + " order by z.UbicacionFisica,a.IdTrabajador, a.FechaAsistencia desc";
            AsistenciasTrabajador = (List<AsistenciasTrabajador>)dp.connection.Query<AsistenciasTrabajador>(query);

            dp.Close();
            //bdNovaEntities db = new bdNovaEntities();
            return AsistenciasTrabajador;
            //return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
            //    .Select(g => g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria).SingleOrDefault();

        }
        public static List<AsistenciasTrabajador> getAsistencias(int id, string fi = null, string ff = null)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            List<AsistenciasTrabajador> AsistenciasTrabajador = new List<AsistenciasTrabajador>();
            string condicion = "";
            if (fi != null)
                condicion = " and CAST(a.FechaAsistencia  as date) >= CAST('" + fi + "'  as date) and CAST(a.FechaAsistencia  as date) <= CAST('" + ff + "'  as date)";

            string query = @"select 
a.IdTrabajador,z.Nombre,z.ApellidoPaterno,z.ApellidoMaterno
,z.Categoria,  z.UbicacionFisica,z.RelacionLaboral,z.ConvenioLaboral,z.EstatusTrabajador
,a.FechaAsistencia,e.FechaInicio,e.FechaTermino,Autorizo,
w.Nombre as NombreJustifico,w.ApellidoPaterno as ApellidoPaternoJustifico,w.ApellidoMaterno as ApellidoMaternoJustifico
,x.Nombre as NombreAutorizo,x.ApellidoPaterno as ApellidoPaternoAutorizo,x.ApellidoMaterno as ApellidoMaternoAutorizo
,e.IdIncidenciaTrabajador,q.IncidenciaJustificacion,q.Nomenclatura,q.Color
,e.FechaJustificacion,e.FechaAutorizacion
,s.Incidencia,s.Nomenclatura as NomenclaturaIncidencia,s.Color ColorIncidencia
,h.Mes NombreMes,Month(a.FechaAsistencia) as Mes,YEAR(a.FechaAsistencia) as anio
,case when e.Horas is null then 0 else e.Horas end Horas
from Nomina_RelojChecadorAsistencia a
inner join vwDatosAspirantesTrabajadores z on a.IdTrabajador=z.IdTrabajador
left join IncidenciaPermiso_stIncidenciaTrabajador e 
on e.IdConvenioLaboralTrabajadorCategoria=z.IdConvenioLaboralTrabajadorCategoria
and a.FechaAsistencia=e.FechaInicio and a.FechaAsistencia=e.FechaTermino
left join vwDatosAspirantesTrabajadores w on w.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoriaJustifico
left join vwDatosAspirantesTrabajadores x on x.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoriaAutorizo
left join Incidencia_ctJustificacion q on q.IdIncidenciaJustificacion=e.IdIncidenciaJustificacion
left join Catalogos_ctTipoIncidencia s on s.IdTipoIncidencia=e.IdTipoIncidencia
left join Catalogos_ctMes h on h.IdMes=Month( a.FechaAsistencia)
where  z.RestringirMenu is null and a.IdTrabajador=" + id.ToString() + condicion + " order by a.FechaAsistencia desc";
            AsistenciasTrabajador = (List<AsistenciasTrabajador>)dp.connection.Query<AsistenciasTrabajador>(query);

            dp.Close();
            //bdNovaEntities db = new bdNovaEntities();
            return AsistenciasTrabajador;
            //return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
            //    .Select(g => g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria).SingleOrDefault();

        }

    }

}