﻿using DevExpress.Web.Internal;
using Nova.Models.AsignarPlaza;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.IncidenciaPermiso
{
    public enum IncidenciasProcesosEstatus
    {
        REVISADO = 1,
        AUTORIZADO = 2,
        CERRADO = 3
    }

    public class IncidenciaPermisoTrabajadorProcesoEstatus
    {
        private bdNovaEntities db = new bdNovaEntities();

        // Método estático para obtener la quincena
        public static string ObtenerQuincena(DateTime fecha)
        {
            int mes = fecha.Month;
            int dia = fecha.Day;
            int quincena = ((mes - 1) * 2) + (dia > 15 ? 2 : 1);
            return quincena.ToString("D2");
        }

        public List<IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus> ObtenerDatos(long? idEstructuraOrganica, 
              string quincena, int año)
        {
            List<IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus> datos = new List<IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus>();
            datos=db.IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus.Where(
                a => a.Quincena == quincena && a.Año == año && a.IdEstructuraOrganica == idEstructuraOrganica
                ).ToList();

            return datos;

        }
            public Resultados GuardaEstatus(long? idEstructuraOrganica, int idConvenioLaboralTrabajadorCategoria,
              string quincena, int año, IncidenciasProcesosEstatus idProcesosEstatus,string qnaparanonmina=null,int añonomina=0)
        {
            Resultados r = new Resultados();
            int idproceso = (int)idProcesosEstatus;
            var existe = db.IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus.FirstOrDefault(
                a => a.Quincena == quincena && a.Año == año && a.IdEstructuraOrganica == idEstructuraOrganica
                && a.IdProcesosEstatus == idproceso);
            if (existe == null)
            {
                IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus model = new IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus
                {
                    IdEstructuraOrganica = idEstructuraOrganica,
                    IdConvenioLaboralTrabajadorCategoria = idConvenioLaboralTrabajadorCategoria,
                    Fecha = DateTime.Now,
                    Quincena = quincena,
                    QuincenaParaNomina = qnaparanonmina,
                    Año = año,
                    AñoParaNomina = añonomina == 0 ? null : (int?)añonomina,
                    IdProcesosEstatus = idproceso
                };
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus.Add(model);
                    db.SaveChanges();
                    r.Messsage = "Proceso actualizado correctamente";
                    r.IsValid = true;
                }
                catch (Exception e)
                {
                    r.IsValid = false;
                    r.Messsage = ExceptionExtensions.GetOriginalException(e).Message;
                    // all changes will be rolled back
                }
            }
            return r;
        }
    }
}