﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;



using System.Data.Entity;

using System.Collections;

namespace Nova.Models.EliminarPlantillas
{
    public class EliminarPlantillas
    {
        static bdNovaEntities db = new bdNovaEntities();

        public static List<Nomina_ctPlantillaNomina> GetNombrePlantilla()
        {
            return (from Plantilla in db.Nomina_ctPlantillaNomina select Plantilla).ToList();
        }
        public static List<Catalogos_ctMes> GetNombreMes()
        {
            return (from Mes in db.Catalogos_ctMes select Mes).ToList();
        }
        public static List<Catalogos_ctQuincenaMes> GetNombreQna()
        {
            return (from QuincenaMes in db.Catalogos_ctQuincenaMes select QuincenaMes).ToList();
        }

        public static List<Configuracion_stIsrGrupo> GetIsrGrupo()
        {
            return (from IsrGrupo in db.Configuracion_stIsrGrupo select IsrGrupo).ToList();
        }

        public static IEnumerable GetNombreQna2()
        {
            bdNovaEntities db = new bdNovaEntities();

            return (from a in db.Catalogos_ctMes
                    join b in db.Catalogos_ctQuincenaMes on a.IdMes equals b.IdMes
                     select new
                    {
                        IdQuincenaMes = b.QuincenaMes
                    }
                    ).ToList();

        }

        public static IEnumerable GetPlantillasPrueba()
        {
            bdNovaEntities db = new bdNovaEntities();

            return (from a in db.Nomina_stNomina
                    join b in db.Nomina_ctPlantillaNomina on a.IdPlantillaNomina equals b.IdPlantillaNomina
                    select new
                    {
                        PlantillaPrueba = b.EsPlantillaPrueba,
                        a.IdPlantillaNomina,
                        a.Año,
                        a.IdNomina,
                        a.FechaInicio,
                        a.FechaTermino,
                        a.IdMesGeneracion,
                        a.IdQuincenaMes,
                        a.AliasNomina,
                        a.EsCerrada,
                        a.IdIsrGrupo
                    }
                    ).Where (a=> a.PlantillaPrueba.Equals(true)).ToList();

        }

        public static List<Nomina_stNomina> GetEliminaNomina(DbSet<Nomina_stNomina> Nomina, int IdNomina)
        {
            return Nomina.Where(s => s.IdNomina == IdNomina).ToList();
        }

        public static List<Nomina_ctPlantillaNomina> GetEliminaPlantilla(DbSet<Nomina_ctPlantillaNomina> PlantillaNomina, int IdPlantillaNomina)
        {
            return PlantillaNomina.Where(s => s.IdPlantillaNomina == IdPlantillaNomina).ToList();
        }

        public static List<Nomina_stNominaTrabajador> GetEliminaNominaTrabajador(DbSet<Nomina_stNominaTrabajador> NominaTrabajador, int IdNomina)
        {
            return NominaTrabajador.Where(s => s.IdNomina == IdNomina).ToList();
        }

        public static IEnumerable GetEliminaNominaTrabajador2()
        {
            bdNovaEntities db = new bdNovaEntities();

            return (from a in db.Nomina_stNomina
                    join b in db.Nomina_stNominaTrabajador on a.IdNomina equals b.IdNomina
                    select new
                    {
                         IdNominaTrabajador = b.IdNominaTrabajador,
                         IdNomina= b.IdNomina,
                         IdConvenioLaboralTrabajadorCategoria= b.IdConvenioLaboralTrabajadorCategoria,
                         SueldoNeto= b.SueldoNeto,
                         IdFormaDePago= b.IdFormaDePago,
                        IdInstitucionFinanciera= b.IdInstitucionFinanciera,
                        CuentaBancaria=b.CuentaBancaria,
                        HorasTrabajadas= b.HorasTrabajadas,
                        HorasTrabajasExcedentes= b.HorasTrabajasExcedentes,
                        CostoPorHora= b.CostoPorHora,
                        CostoPorHoraExcedente= b.CostoPorHoraExcedente,
                        SalarioBruto= b.SalarioBruto,
                        DiasEfectivosLaborados= b.DiasEfectivosLaborados,
                        SalarioDiarioEfectivo= b.SalarioDiarioEfectivo,
                        SalarioDiarioEfectivoExcente= b.SalarioDiarioEfectivoExcente,
                        HorasEfectivasDeTrabajo= b.HorasEfectivasDeTrabajo,
                        EsDevolucion= b.EsDevolucion

                    }
                    ).ToList();

        }

        //public static int GetPlantillaNomina(int IdNomina)
        //{

        //    var IdPlantillaNomina = (from a in db.Nomina_stNomina
        //                             where a.IdNomina == IdNomina
        //                             select new { IdPlantillaNomina = a.IdPlantillaNomina }).SingleOrDefault().IdPlantillaNomina;


        //    return IdPlantillaNomina;
        //}

        //1 Creditos
        public static IEnumerable GetCreditos(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            
            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;
            
            
            var NominaTrabajador = from IdNomTra in db.Nomina_stNominaTrabajador

                                   where Nomina.Contains(IdNomTra.IdNomina)

                                   select IdNomTra.IdNominaTrabajador;                                         
                      
            
            var Credito = from IdCreditos in db.Creditos_stNominaCreditoTrabajador

                          where NominaTrabajador.Contains(IdCreditos.IdNominaTrabajador)
                          
                          select IdCreditos.IdNominaCreditoTrabajador;


            return Credito.ToList();
            
            
        }

        //2 Deducciones
        public static IEnumerable GetDeducciones(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;

            var NominaTrabajador = from IdNomTra in db.Nomina_stNominaTrabajador

                                   where Nomina.Contains(IdNomTra.IdNomina)

                                   select IdNomTra.IdNominaTrabajador;


            var Deducciones = from IdDeducciones in db.Deducciones_stNominaTrabajadorDeduccion

                              where NominaTrabajador.Contains(IdDeducciones.IdNominaTrabajador)

                              select IdDeducciones.IdNominaTrabajadorDeduccion;


            return Deducciones.ToList();


        }

        //3 Incidencias
        public static IEnumerable GetIncidencias(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;

            var NominaTrabajador = from IdNomTra in db.Nomina_stNominaTrabajador

                                   where Nomina.Contains(IdNomTra.IdNomina)

                                   select IdNomTra.IdNominaTrabajador;


            var Incidencias = from IdIncidencias in db.Incidencias_stNominaTrabajadorIncidenciaDeduccion

                              where NominaTrabajador.Contains(IdIncidencias.IdNominaTrabajador)

                              select IdIncidencias.IdNominaTrabajadorIncidenciaDeduccion;


            return Incidencias.ToList();


        }

        //4 Pensiones
        public static IEnumerable GetPensiones(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;

            var NominaTrabajador = from IdNomTra in db.Nomina_stNominaTrabajador

                                   where Nomina.Contains(IdNomTra.IdNomina)

                                   select IdNomTra.IdNominaTrabajador;


            var Pensiones = from IdPensiones in db.Pensiones_stNominaPensionTrabajador

                            where NominaTrabajador.Contains(IdPensiones.IdNominaTrabajador)

                            select IdPensiones.IdNominaPensionTrabajador;


            return Pensiones.ToList();


        }

        //5 Percepciones
        public static IEnumerable GetPercepciones(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;

            var NominaTrabajador = from IdNomTra in db.Nomina_stNominaTrabajador

                                   where Nomina.Contains(IdNomTra.IdNomina)

                                   select IdNomTra.IdNominaTrabajador;


            var Percepciones = from IdPercepciones in db.Percepciones_stNominaTrabajadorPercepciones

                               where NominaTrabajador.Contains(IdPercepciones.IdNominaTrabajador)

                               select IdPercepciones.IdNominaTrabajadorPercepcion;


            return Percepciones.ToList();


        }

        //6 Percepciones Personalizadas
        public static IEnumerable GetPercepcionesPerso(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;

            var NominaTrabajador = from IdNomTra in db.Nomina_stNominaTrabajador

                                   where Nomina.Contains(IdNomTra.IdNomina)

                                   select IdNomTra.IdNominaTrabajador;


            var PercepcionesPerso = from IdPercepcionesPerso in db.Percepciones_stNominaTrabajadorPercepcionesPersonalizadas

                                    where NominaTrabajador.Contains(IdPercepcionesPerso.IdNominaTrabajador)

                                    select IdPercepcionesPerso.IdNominaTrabajadorPercepcionesPersonalizadas;


            return PercepcionesPerso.ToList();


        }

        //7 Suplencias
        public static IEnumerable GetSuplencias(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;

            var NominaTrabajador = from IdNomTra in db.Nomina_stNominaTrabajador

                                   where Nomina.Contains(IdNomTra.IdNomina)

                                   select IdNomTra.IdNominaTrabajador;


            var Suplencias = from IdSuplencias in db.Suplencia_stNominaTrabajadorSuplente

                             where NominaTrabajador.Contains(IdSuplencias.IdNominaTrabajador)

                             select IdSuplencias.IdNominaTrabajadorSuplente;


            return Suplencias.ToList();


        }

        // 8 PercepcionesCalendarizadas
        public static IEnumerable GetPercepcionesCalen(int id
            )
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdPlantillaNomina;

            

            var PercepcionesCalen = from IdPercepcionesCalen in db.Percepciones_stPercepcionesCalendarizadas

                                    where Nomina.Contains(IdPercepcionesCalen.IdPlantillaNomina)

                                    select IdPercepcionesCalen.IdPercepcionCalendarizada;
            
            return PercepcionesCalen.ToList();


        }
        // 9 Plantillas Deducciones
        public static IEnumerable GetPlantillaDeducciones(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdPlantillaNomina;

            var PlantillaDeducciones = from IdPlantillaDeducciones in db.Deducciones_stPlantillaNominaDeducciones

                                       where Nomina.Contains(IdPlantillaDeducciones.IdPlantillaNomina)

                                       select IdPlantillaDeducciones.IdPlantillaNominaDeduccion;

            return PlantillaDeducciones.ToList();


        }

        // 10 Plantillas percepciones
        public static IEnumerable GetPlantillaPercepciones(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdPlantillaNomina;

            var PlantillaPercepciones = from IdPlantillaPercepciones in db.Percepciones_stPlantillaNominaPercepciones

                                        where Nomina.Contains(IdPlantillaPercepciones.IdPlantillaNomina)

                                        select IdPlantillaPercepciones.IdPlantillaNominaPercepcion;

            return PlantillaPercepciones.ToList();


        }

        //11 Nomina Trabajador
        public static IEnumerable GetNominaTrabajador(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;

            var NominaTrabajador = from IdNomTra in db.Nomina_stNominaTrabajador

                                   where Nomina.Contains(IdNomTra.IdNomina)

                                   select IdNomTra.IdNominaTrabajador;
            return NominaTrabajador.ToList();


        }

        //12 Nomina 
        public static IEnumerable GetNomina(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdNomina;

      
            return Nomina.ToList();


        }

        //13 Plantilla Nomina 
        public static IEnumerable GetPlantillaNomina(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            var Nomina = from IdNom in db.Nomina_stNomina
                         where IdNom.IdNomina == id
                         select IdNom.IdPlantillaNomina;

            var Plantilla = from IdPlNom in db.Nomina_ctPlantillaNomina
                            where Nomina.Contains(IdPlNom.IdPlantillaNomina)                            
                            select IdPlNom.IdPlantillaNomina;

            return Plantilla.ToList();


        }



    }
}