﻿using Nova.Models;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Libraries;
using Dapper;
using System.Text;
using System.Drawing;
using System.Threading;

namespace Nova.Models
{


     public class HorarioAlumnosSeleccionados
    {


        public long IdHorarioAlumno { get; set; }
        public DateTime Fecha { get; set; }
        public string Seleccionado { get; set; }
    }

    public class DocentesHorarios
    {
        public int IdHorario { get; set; }
        public short IdCicloEscolar { get; set; }
        public short IdPlanEstudioAsignatura { get; set; }
        public short IdGrupoCampus { get; set; }
        public short IdEmpleado { get; set; }
        public short IdCurso { get; set; }
        public bool Autorizado { get; set; }
        public short IdReglamento { get; set; }
        public string PlanEstudio { get; set; }
          public string Asignatura { get; set; }
              public string Carrera { get; set; }
              public string AreaConocimiento { get; set; }
              public string TipoComponente { get; set; }
              public string CicloEscolar { get; set; }
              public string Campus { get; set; }
              public string Grupo { get; set; }

              public string Curso { get; set; }
              public short IdValorCiclo { get; set; }
              public short OrdenAsignatura { get; set; }
              public string url { get; set; }
        



    }

    public class AlumnosPorHorario
    {
        public long IdHorario { get; set; }
        public long IdHorarioAlumno { get; set; }
        public string Curp { get; set; }
        public string Nombre { get; set; }
        public string ApPaterno { get; set; }
        public string ApMaterno { get; set; }
     
        public short IdCicloEscolar { get; set; }
        public short IdPlanEstudioAsignatura { get; set; }
        public short IdGrupoCampus { get; set; }
        public short IdEmpleado { get; set; }
        public short IdCurso { get; set; }
        public bool Autorizado { get; set; }
        public short IdReglamento { get; set; }
        public string PlanEstudio { get; set; }
        public string Asignatura { get; set; }
        public string Carrera { get; set; }
        public string AreaConocimiento { get; set; }
        public string TipoComponente { get; set; }
        public string CicloEscolar { get; set; }
        public string Campus { get; set; }
        public string Grupo { get; set; }

        public string Curso { get; set; }
        public short IdValorCiclo { get; set; }
        public short OrdenAsignatura { get; set; }
        




    }

    public class Docentes
    {



            public static string EncryptpUrl(long id,string superusuario)
            {
                TSHAK.Components.SecureQueryString objStrT = new TSHAK.Components.SecureQueryString(new byte[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 8 });
                StringBuilder retURL = new StringBuilder(255);

                objStrT.Add("IdHorario", id.ToString());
                objStrT.Add("SuperUsuario", superusuario);
                objStrT.ExpireTime = DateTime.Now.AddMinutes(20);

                
              return objStrT.ToString();
            }




            public static List<AlumnosPorHorario> AlumnosPorHorario(int id)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string query;

            query = @"select a.IdHorario,z.IdHorarioAlumno,z.Curp, x.Nombre,x.ApPaterno,x.ApMaterno,
a.IdCicloEscolar,a.IdPlanEstudioAsignatura,a.IdGrupoCampus,a.IdEmpleado,a.IdCurso,a.Autorizado,a.IdReglamento
,d.Nombre as PlanEstudio,e.Nombre as Asignatura,h.Nombre as Carrera
,f.Nombre as AreaConocimiento,g.Nombre as TipoComponente,j.Nombre as CicloEscolar,l.NombreLargo as Campus,m.Nombre as Grupo
,o.Nombre as Curso,c.IdValorCiclo,c.Orden as OrdenAsignatura
from stHorario a 
inner join ctpersonal b on a.IdEmpleado=b.IdEmpleado
inner join stPlanEstudioAsignatura c on a.IdPlanEstudioAsignatura=c.IdPlanEstudioAsignatura
inner join ctPlanEstudio d on d.IdPlanEstudio=c.IdPlanEstudio
inner join ctAsignatura e on e.IdAsignatura=c.IdAsignatura
inner join ctCarrera h on h.IdCarrera=d.IdCarrera
inner join Acreditacion_ctReglamento n on n.IdReglamento=a.IdReglamento
inner join ctAreaConocimiento f on f.IdAreaConocimiento=e.IdAreaConocimiento
inner join ctTipoComponente g on g.IdTipoComponente=e.IdTipoComponente
inner join ctCicloescolar j on j.IdCicloEscolar=a.IdCicloEscolar 
inner join ctGrupoCampus k on k.IdGrupoCampus=a.IdGrupoCampus
inner join ctCampus l on l.idcampus=k.IdCampus
inner join ctGrupoNombre m on m.IdGrupoNombre=k.IdGrupoNombre
inner join Acreditacion_ctCurso o on o.IdCurso=a.IdCurso
inner join stHorarioAlumno z on z.IdHorario=a.IdHorario
inner join ctAlumnos x on x.Curp=z.Curp and x.Matricula=z.Matricula
where a.Autorizado=1 and a.IdHorario=" + id + " order by x.ApPaterno,x.ApMaterno,x.Nombre";




            var t = (List<AlumnosPorHorario>)dp.connection.Query<AlumnosPorHorario>(query);

            
            dp.Close();
            return t;

        }


            public static List<stHorarioAlumnoAsistencia> AsistenciasAlumnosPorHorario(int id)
            {
                DapperQuery dp = new DapperQuery("bdAriesEntities");

                string query;

                query = @"select b.IdHorarioAlumnoAsistencia, z.IdHorarioAlumno,b.Fecha,IdJustificada
from stHorario a 
 inner join stHorarioAlumno z on z.IdHorario=a.IdHorario
 left join stHorarioAlumnoAsistencia b on b.IdHorarioAlumno=z.IdHorarioAlumno
where a.Autorizado=1 and a.IdHorario=" + id ;




                var t = (List<stHorarioAlumnoAsistencia>)dp.connection.Query<stHorarioAlumnoAsistencia>(query);


                dp.Close();
                return t;

            }



        public static List<DocentesHorarios> Horarios(int id)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string query;

            query = @"select a.IdHorario,a.IdCicloEscolar,a.IdPlanEstudioAsignatura,a.IdGrupoCampus,a.IdEmpleado,a.IdCurso,a.Autorizado,a.IdReglamento
,d.Nombre as PlanEstudio,e.Nombre as Asignatura,h.Nombre as Carrera
,f.Nombre as AreaConocimiento,g.Nombre as TipoComponente,j.Nombre as CicloEscolar,l.NombreLargo as Campus,m.Nombre as Grupo
,o.Nombre as Curso,c.IdValorCiclo,c.Orden as OrdenAsignatura,'' as Url
 from stHorario a 
inner join ctpersonal b on a.IdEmpleado=b.IdEmpleado
inner join stPlanEstudioAsignatura c on a.IdPlanEstudioAsignatura=c.IdPlanEstudioAsignatura
inner join ctPlanEstudio d on d.IdPlanEstudio=c.IdPlanEstudio
inner join ctAsignatura e on e.IdAsignatura=c.IdAsignatura
inner join ctCarrera h on h.IdCarrera=d.IdCarrera
inner join Acreditacion_ctReglamento n on n.IdReglamento=a.IdReglamento
inner join ctAreaConocimiento f on f.IdAreaConocimiento=e.IdAreaConocimiento
inner join ctTipoComponente g on g.IdTipoComponente=e.IdTipoComponente
inner join ctCicloescolar j on j.IdCicloEscolar=a.IdCicloEscolar 
inner join ctGrupoCampus k on k.IdGrupoCampus=a.IdGrupoCampus
inner join ctCampus l on l.idcampus=k.IdCampus
inner join ctGrupoNombre m on m.IdGrupoNombre=k.IdGrupoNombre
inner join Acreditacion_ctCurso o on o.IdCurso=a.IdCurso
where a.Autorizado=1 and a.IdEmpleado=" + id + " order by a.IdCicloEscolar desc,c.Orden";




            var t = (List<DocentesHorarios>)dp.connection.Query<DocentesHorarios>(query);

            foreach (var item in t)
            {
 
     item.url = EncryptpUrl(item.IdHorario,"false");
            }
            dp.Close();
            return t;

        }


        public static bool GrabarAsistencia(long id, List<HorarioAlumnosSeleccionados> alumnos)
        {
            bool regresa = true;
            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string query="";

           // string joined = string.Join(",", alumnos.Where(r=> r.Seleccionado=="0" ).Select(f=> f.IdHorarioAlumno));

            foreach (var item in alumnos)
            {

                query = query +@"delete from stHorarioAlumnoAsistencia
where IdHorarioAlumno=" + item.IdHorarioAlumno + " and fecha='" + item.Fecha.ToString("yyyy-MM-dd") + "' ;";
            }

            string queryDos = "";

            foreach (var item in alumnos.Where(v => v.Seleccionado == "1"))
            {

                queryDos = queryDos + @"insert into stHorarioAlumnoAsistencia (IdHorarioAlumno,Fecha,IdJustificada) values(" + item.IdHorarioAlumno + " ,'" + item.Fecha.ToString("yyyy-MM-dd") + "',0);";
            }

            try
            {
                var y = dp.connection.Execute(query);
                var t = dp.connection.Execute(queryDos);
            }
            catch (Exception ex)
            {

                regresa = false;
            }

            dp.Close();
            return false;
            
         

        }

    }
}