﻿using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using Nova.Validation;


namespace Nova.Models
{

    [MetadataType(typeof(Creditos_stCreditoTrabajadorMetaData))]
    public partial class Creditos_stCreditoTrabajador
    {



    }


    public class Creditos_stCreditoTrabajadorMetaData
    {
        // [RequiredIf("Nombre","", ErrorMessage = "Debes de especificar el Nombre")]

        //[DateGreaterThan("FechaInicioCredito", "La Fecha de Termino debe de ser mayor o igual a la fecha de inicio del credito")]
        //public object FechaTermino { get; set; }

        //[DateGreaterThan("FechaInicioCredito", "La Fecha de inicio del Descuento debe de ser mayor o igual a la fecha de inicio del credito")]
        //public object FechaInicioDescuento { get; set; }

        [RegularExpression(@"^[0-9]{1,4}([\.\,][0-9]{1,2})?$", ErrorMessage = "El formato debe de ser : 9999.99")]
        public object VecesSalarioMinimo { get; set; }

        [RegularExpression(@"^[0-9]{1,6}([\.\,][0-9]{1,2})?$", ErrorMessage = "El formato debe de ser : 999999.99")]
        public object CuotaFija { get; set; }

        [RegularExpression(@"^[0-9]{1,3}([\.\,][0-9]{1,2})?$", ErrorMessage = "El formato debe de ser : 999.99")]
        public object Porcentaje  { get; set; }

        [Required]
        [RegularExpression(@"^[0-9]{1,6}([\.\,][0-9]{1,2})?$", ErrorMessage = "El formato debe de ser : 999999.99")]
        public object ImporteCredito { get; set; }

        [RegularExpression(@"^[0-9]{1,3}?$", ErrorMessage = "El formato debe de ser : 999")]
        [StringLength(4, ErrorMessage = "Parcialidades no puede exceder de 4 numeros. ")]
        public object Parcialidades { get; set; }


    }
}