﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;
using Nova.Libraries;

namespace Nova.Models
{
    
    public class ImpresionHistorial
    {
        public Int64 IdCredencialesProceso { get; set; }
        public string Campus { get; set; }
        public string Curp { get; set; }

        public string ApPaterno { get; set; }
        public string ApMaterno { get; set; }
        public string Nombre { get; set; }
        public string LineaCaptura { get; set; }
        public string Documento { get; set; }

        public DateTime FechaImpresion { get; set; }

        
        
        public IQueryable GetHistorialImpresion(int Id) 
        {
            string filtro = string.Empty;

            if (Id != 0)
                filtro = string.Format( "and d.IdTipoCentro={0}",Id);


            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = string.Format( @"select a.IdCredencialesProceso,d.NumeroNombre as Campus,b.Curp,c.ApPaterno,c.ApMaterno,c.Nombre,b.LineaCaptura,b.Documento,a.FechaRegistro as FechaImpresion
                            from Credenciales_Proceso a
                            inner join bdCtlEscSeg.dbo.ptordenes b on a.IdCampus=b.IdCampus and a.IdOrden=b.IdOrden
                            inner join bdCtlEscSeg.dbo.ctAlumnos c on c.Curp=b.Curp
                            inner join bdCtlEscSeg.dbo.ctCampus d on d.IdCampus=b.IdCampus 
                            where Year(a.Fecharegistro)>=(year(GETDATE())-4) {0}
                            order by Year(a.Fecharegistro) desc,c.curp", filtro);
            
            List<ImpresionHistorial> model = new List<ImpresionHistorial>();
            model = (List<ImpresionHistorial>)dp.connection.Query<ImpresionHistorial>(query);
            dp.Close();
            return model.AsQueryable();
        }
    }


}

