﻿using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Net.Sockets;
using System.Web;
using Dapper;

namespace Nova.Models
{

    public class CredencialesHistorial
    {
        public long IdCredencialesProceso { get; set; }
        public Nullable<System.DateTime> FechaRegistro { get; set; }
        public int IdOrden { get; set; }
        public short IdCampus { get; set; }
        public short DiasSinCompletarDatos { get; set; }
        public short DiasSinImprimir { get; set; }
        public Nullable<short> DiasSinRecorgerCredencial { get; set; }
        public short DiasSinFoto { get; set; }
        public string Documento { get; set; }
        public short IdModalidadEstudio { get; set; }


        public virtual Catalogos_ctModalidadEstudio Catalogos_ctModalidadEstudio { get; set; }
        public virtual ptOrdenes ptOrdenes { get; set; }
        public string Campus { get; set; }
        public string Recibio { get; set; }
        public Nullable<System.DateTime> FechaRecoleccion { get; set; }


    }

    public class PersonalCredenciales
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string Nombre { get; set; }
    }
    public class OrdenesCredenciales
    {

        public int IdOrden { get; set; }
        public short IdCampus { get; set; }
        public Nullable<short> IdInstitucion { get; set; }

        public string EstatusAlumno { get; set; }
        public string Curp { get; set; }
        public string Campus { get; set; }
        public string Nombre { get; set; }
        public string Matricula { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public short IdCicloEscolar { get; set; }
        public short IdValorCiclo { get; set; }
        public decimal Impuesto { get; set; }
        public decimal ImporteTotal { get; set; }
        public System.DateTime FechaRegistro { get; set; }
        public Nullable<System.DateTime> FechaPago { get; set; }
        public Nullable<int> IdUsuario { get; set; }
        public Nullable<short> Idcajero { get; set; }
        public Nullable<bool> Cancelada { get; set; }
        public Nullable<System.DateTime> FechaCancelada { get; set; }
        public Nullable<decimal> Promedio { get; set; }
        public string FolioInstitucionCobro { get; set; }
        public string CaducidadAñoMes { get; set; }
        public string LineaCaptura { get; set; }
        public string Documento { get; set; }
        public string ImpuestoFinanzas { get; set; }
        public Nullable<System.DateTime> FechaVigenciaFinanzas { get; set; }
        public byte[] CodigoBarras { get; set; }

        public short IdPagoServicio { get; set; }
        public decimal ImporteBruto { get; set; }
        public decimal Descuento { get; set; }
        public decimal ImporteNeto { get; set; }
        public Nullable<short> Cantidad { get; set; }
        public Nullable<System.DateTime> FechaAtendido { get; set; }
        public Nullable<bool> Atendido { get; set; }

        public string cveServicio { get; set; }
        public string Servicio { get; set; }
        public short IdModalidadEstudio { get; set; }

        public Nullable<System.DateTime> FechaValidacion { get; set; }


        public Nullable<bool> CredencialValidada { get; set; }

        public Nullable<bool> TieneFoto { get; set; }

        public string TipoImagen { get; set; }

        public virtual ctAlumnos ctAlumnos { get; set; }

        public string PoblacionVivienda { get; set; }
        public short DiasSinCompletarDatos { get; set; }
        public short DiasSinImprimir { get; set; }
        public short DiasSinFoto { get; set; }

        public Nullable<short> DiasSinRecorgerCredencial { get; set; }

        public bool ParaEntrega { get; set; }

        public Nullable<long> IdCredencialesProceso { get; set; }

        public string CicloEscolarOrden { get; set; }

        public bool CuentaconImss { get; set; }

        public string CicloEscolarAlumno { get; set; }
        public string PlanEstudio { get; set; }

        public string GradoAlumno { get; set; }
    }


    public class UltimasCredenciales
    {

        public int Total { get; set; }


        public string Campus { get; set; }
        public string Recibio { get; set; }


        public Nullable<System.DateTime> FechaRecoleccion { get; set; }


    }
    public class CredencialesEmailReporte
    {

        public string Email { get; set; }


        public short TotalReporte { get; set; }
    }

    public class Credenciales
    {


        public const int DiasMinimosParaReportar = 12;


        bdAriesEntities bd = new bdAriesEntities();

        bdNovaEntities bdnova = new bdNovaEntities();





        public static string getNombreCampus(List<vwCampus> lista, int IdCampus)
        {
            return lista.Where(y => y.IdCampus == IdCampus).Select(r => r.NumeroNombre).FirstOrDefault();
        }

        //public bool ReportarCredencialesSinImprimir(long idconveniolaboraltrabajadorcategoria)
        //{

        //}

        public CredencialesEmailReporte EmailReporteSinRecoleccion(List<OrdenesCredenciales> credes, Seguridad.Convenios_stConvenioLaboralTrabajadorCategoria reporto, Convenios_stConvenioLaboralTrabajadorCategoria usuario, short idcampus)
        {
            int total = 0;

            CredencialesEmailReporte regresa = new CredencialesEmailReporte();

            string listaalumnos = @"  <table style='width:100%;margin:5px;' cellpadding='5' >
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Curp</th>
                        <th>Nombre</th>
                        <th>Grado</th> 
                        <th>Dias sin Recolección</th> 
                         <th>Fecha de Impresión<th>
                    </tr>
                </thead>
                <tbody>";
            string campus = "";
            foreach (var item in credes)
            {

                campus = item.Campus;

                total = total + 1;
                listaalumnos = listaalumnos + "<tr><td>" + total + "</td><td>" + item.Curp + "</td><td>" + item.Nombre + " " + item.ApellidoPaterno + " " + item.ApellidoMaterno + "</td><td>" + item.IdValorCiclo + "</td><td>" + item.DiasSinRecorgerCredencial + "</td><td>" + item.FechaAtendido + "</td></<tr>";



            }

            listaalumnos = listaalumnos + "</tbody></table>";


            string url = "<p>Estimado (a) " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "</p><p>" + usuario.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria + "</p><p>" + usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica + "</p><p>" + DateTime.Now + "</p>";
            string reporta = "<p>" + reporto.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + reporto.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + reporto.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "</p><p>" + reporto.Catalogos_ctEstructuraOrganica.EstructuraOrganica + "</p><p>" + DateTime.Now + "</p>";
            string msg = @"<!doctype html>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>

<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />

<title>Rporte de Credenciales</title>

<style type='text/css'>
	.ReadMsgBody {width: 100%; background-color: #ffffff;}
	.ExternalClass {width: 100%; background-color: #ffffff;}
	body	 {width: 100%; background-color: #ffffff; margin:0; padding:0; -webkit-font-smoothing: antialiased;font-family: Helvetica, Georgia, Times, serif}
	table {border-collapse: collapse;}

	@media only screen and (max-width: 640px)  {
					body[yahoo] .deviceWidth {width:440px!important; padding:0;}
					body[yahoo] .center {text-align: center!important;}
			}

	@media only screen and (max-width: 479px) {
					body[yahoo] .deviceWidth {width:280px!important; padding:0;}
					body[yahoo] .center {text-align: center!important;}
			}

</style>
</head>

<body leftmargin='0' topmargin='0' marginwidth='0' marginheight='0' yahoo='fix' style='font-family: Helvetica, Georgia, Times, serif'>

<!-- Wrapper -->
<table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
	<tr>
		<td width='100%' valign='top' bgcolor='#ffffff' style='padding-top:20px'>

			<!-- Start Header-->
			<table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
				<tr>
					<td width='100%' bgcolor='#ffffff'>

                            <!-- Logo -->
                            <table border='0' cellpadding='0' cellspacing='0' align='left' class='deviceWidth'>
                                <tr>
                                    <td style='padding:10px 20px' class='center'>
                                        <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>
                                    </td>
                                </tr>
                            </table><!-- End Logo -->

                            <!-- Nav -->
                            <table border='0' cellpadding='0' cellspacing='0' align='right' class='deviceWidth'>
                                <tr>
                                    <td class='center' style='font-size: 13px; color: #272727; font-weight: light; text-align: right; font-family: Helvetica, Georgia, Times, serif; line-height: 20px; vertical-align: middle; padding:10px 20px; font-style:italic'>
                                         
                                    </td>
                                </tr>
                            </table><!-- End Nav -->

					</td>
				</tr>
			</table><!-- End Header -->

		


<div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


            <!-- 2 Column Images & Text Side by SIde -->
            <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#202022' style='margin:0 auto;'>
                <tr>
                    <td style='padding:10px 0'>
                            <table align='left' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                <tr>
                                    <td valign='top' align='center' class='center' style='padding-top:20px;color:#fff;' >
                                         <h1 style='text-align:center;' >Reporte de Credenciales sin recolección</h1>
                                    </td>
                                </tr>
                            </table>
                            <table align='right' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                <tr>
                                    <td style='font-size: 12px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px'>

                                        <table>
                                            <tr>
                                                <td valign='top' style='padding:0 10px 10px 5px;color:#fff;'>
                                                  " + url + @"  
                                                </td>
                                                <td valign='middle' style='padding:0 10px 10px 0'><a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: bold; font-family:Arial, sans-serif '>Existen actualmente en el centro: " + campus + " un total de " + total + @" credenciales que estan listas para ser entregadas y las cuales llevan mas de " + DiasMinimosParaReportar + @" días sin ser reclamadas, por lo que se notifica por este medio se tenga a bien atender a la brevedad posible este asunto.</a>
                                                </td>
                                            </tr>
                                        </table>

                                        <p style='mso-table-lspace:0;mso-table-rspace:0; margin:0'>
                                             
                                            <br/><br/>

                                            

                                        </p>
                                    </td>
                                </tr>
                            </table>

                    </td>
                </tr>
                <tr>
                    <td bgcolor='#fe7f00'><div style='height:6px'>&nbsp;</div></td>
                </tr>
            </table><!-- End 2 Column Images & Text Side by SIde -->


<div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->

    <!-- One Column -->
            <table width='580'  class='deviceWidth' border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#eeeeed' style='margin:0 auto;'>
                <tr>
                    <td valign='top' style='padding:0' bgcolor='#ffffff'>
                        
                    </td>
                </tr>
                <tr>
                    <td style='font-size: 13px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px' bgcolor='#eeeeed'>

                        <table>
                            <tr>
                                <td valign='top' style='padding:0 10px 10px 0'>
                                    
                                </td>
                                <td valign='middle' style='padding:0 10px 10px 0'> 
                                </td>
                            </tr>
                        </table>

                            <h1>Listado de Alumnos</h1>
                            " + listaalumnos + @"
                    </td>
                </tr>
            </table><!-- End One Column -->

<div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->
			<!-- Two Column (Images Stacked over Text) -->
			 
 
        <!-- 2 Column Images - text left -->
            <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#eeeeed' style='margin:0 auto;'>
                <tr>
                    <td style='padding:10px 0'>
                            <table align='right' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                <tr>
                                    <td valign='top' align='left' class='center' style='padding:20px 10px 0 0'>
                                     " + reporta + @"
                                    </td>
                                </tr>
                            </table>
                            <table align='left' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                <tr>
                                    <td style='font-size: 13px; color: #959595; font-weight: normal; text-align: left; font-family: Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:20px 0 20px 15px'>

                                        <table>
                                            <tr>
                                                <td valign='top' style='padding:0 10px 15px 0'>
                                                  
                                                </td>
                                                <td valign='middle' style='padding:0 10px 10px 0'><a href='#' style='text-decoration: none; font-size: 16px; color: #363636; font-weight: bold; font-family:Arial, sans-serif '>Enviado por: </a>
                                                    
                                                </td>
                                            </tr>
                                        </table>

                                        
                                    </td>
                                </tr>
                            </table>
                    </td>
                </tr>
            </table><!-- End 2 Column Images  - text left -->
 

<div style='height:35px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


			<!-- 4 Columns -->
			<table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
				<tr>
					<td bgcolor='#363636' style='padding:30px 0'>
                        <table width='580' border='0' cellpadding='10' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
                            <tr>
                                <td>
                                        <table width='45%' cellpadding='0' cellspacing='0'  border='0' align='left' class='deviceWidth'>
                                            <tr>
                                                <td valign='top' style='font-size: 11px; color: #f1f1f1; color:#999; font-family: Arial, sans-serif; padding-bottom:20px' class='center'>

                                                   Departamento de Sistemas, Redes y Soporte Técnico | 
                                                    <a href='www.cecyteo.edu.mx/nova' style='color:#999;text-decoration:none;'>NOVA - " + DateTime.Now.Year + @"</a><br/>

                                                    <br/><br/>
                                                   

                                                </td>
                                            </tr>
                                        </table>

                                        <table width='40%' cellpadding='0' cellspacing='0'  border='0' align='right' class='deviceWidth'>
                                            <tr>
                                                <td valign='top' style='font-size: 11px; color: #f1f1f1; font-weight: normal; font-family: Helvetica, Georgia, Times, serif; line-height: 26px; vertical-align: top; text-align:right' class='center'>
                                                     Todos los Derechos Reservados - Cecyteo  

                                                    <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>

                                                   
                                                </td>
                                            </tr>
                                        </table>

                        		</td>
                        	</tr>
                        </table>
                    </td>
                </tr>
            </table><!-- End 4 Columns -->

		</td>
	</tr>
</table> <!-- End Wrapper -->
<div style='display:none; white-space:nowrap; font:15px courier; color:#ffffff;'>
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
</div>
</body>
</html>";





            //SmtpClient client = new SmtpClient();


            //client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            //client.Host = "smtp.gmail.com";
            //client.Port = 587;
            //client.DeliveryMethod = SmtpDeliveryMethod.Network;
            //client.EnableSsl = true;
            //// client.UseDefaultCredentials = false;

            //try
            //{
            //    client.Send(msg);

            //}
            //catch (Exception)
            //{
            //    regresa = false;
            //    // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            //}
            //return regresa;

            regresa.Email = msg;
            regresa.TotalReporte = (short)total;
            return regresa;
        }

        public CredencialesEmailReporte EmailReporteSinImpresion(Seguridad.Convenios_stConvenioLaboralTrabajadorCategoria usuario, short idcampus)
        {
            int total = 0;

            CredencialesEmailReporte regresa = new CredencialesEmailReporte();

            string listaalumnos = @"  <table style='width:100%;margin:5px;' cellpadding='5' >
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Curp</th>
                        <th>Nombre</th>
                        <th>Grado</th> 
                       
                         <th>Fecha Pago<th>
                    </tr>
                </thead>
                <tbody>";
            string campus = "";

            foreach (var item in getCredencialesParaImpresion(idcampus).OrderByDescending(e => e.DiasSinImprimir))
            {
                campus = item.Campus;
                if (item.CredencialValidada == true)
                    if (item.TieneFoto == true)
                        if (item.FechaPago.HasValue)
                            if (item.Atendido == false)
                                if (item.DiasSinImprimir > Nova.Models.Credenciales.DiasMinimosParaReportar)
                                {

                                    total = total + 1;
                                    // listaalumnos = listaalumnos + "<tr><td>" + total + "</td><td>" + item.Curp + "</td><td>" + item.Nombre + " " + item.ApellidoPaterno + " " + item.ApellidoMaterno + "</td><td>" + item.IdValorCiclo + "</td><td>" + item.DiasSinImprimir + "</td><td>" + item.FechaPago + "</td></<tr>";
                                    listaalumnos = listaalumnos + "<tr><td>" + total + "</td><td>" + item.Curp + "</td><td>" + item.Nombre + " " + item.ApellidoPaterno + " " + item.ApellidoMaterno + "</td><td>" + item.IdValorCiclo + "</td><td>" + item.FechaPago + "</td></<tr>";

                                }

            }

            listaalumnos = listaalumnos + "</tbody></table>";
            //bool regresa = true;
            //MailMessage msg = new MailMessage();

            //msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            //msg.To.Add(email);
            //msg.Subject = "Reporte de Credenciales sin imprimir";
            //msg.IsBodyHtml = true;
            // string codificado = Cifrado.Encrypt(email + id.ToString());

            //UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

            //string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Register", "Account", new { email = email, id = id, check = HttpUtility.UrlEncode(codificado) });

            string url = "<p>" + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "</p><p>" + usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica + "</p><p>" + DateTime.Now + "</p>";
            string msg = @"<!doctype html>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>

<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />

<title>Rporte de Credenciales</title>

<style type='text/css'>
	.ReadMsgBody {width: 100%; background-color: #ffffff;}
	.ExternalClass {width: 100%; background-color: #ffffff;}
	body	 {width: 100%; background-color: #ffffff; margin:0; padding:0; -webkit-font-smoothing: antialiased;font-family: Helvetica, Georgia, Times, serif}
	table {border-collapse: collapse;}

	@media only screen and (max-width: 640px)  {
					body[yahoo] .deviceWidth {width:440px!important; padding:0;}
					body[yahoo] .center {text-align: center!important;}
			}

	@media only screen and (max-width: 479px) {
					body[yahoo] .deviceWidth {width:280px!important; padding:0;}
					body[yahoo] .center {text-align: center!important;}
			}

</style>
</head>

<body leftmargin='0' topmargin='0' marginwidth='0' marginheight='0' yahoo='fix' style='font-family: Helvetica, Georgia, Times, serif'>

<!-- Wrapper -->
<table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
	<tr>
		<td width='100%' valign='top' bgcolor='#ffffff' style='padding-top:20px'>

			<!-- Start Header-->
			<table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
				<tr>
					<td width='100%' bgcolor='#ffffff'>

                            <!-- Logo -->
                            <table border='0' cellpadding='0' cellspacing='0' align='left' class='deviceWidth'>
                                <tr>
                                    <td style='padding:10px 20px' class='center'>
                                        <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>
                                    </td>
                                </tr>
                            </table><!-- End Logo -->

                            <!-- Nav -->
                            <table border='0' cellpadding='0' cellspacing='0' align='right' class='deviceWidth'>
                                <tr>
                                    <td class='center' style='font-size: 13px; color: #272727; font-weight: light; text-align: right; font-family: Helvetica, Georgia, Times, serif; line-height: 20px; vertical-align: middle; padding:10px 20px; font-style:italic'>
                                         
                                    </td>
                                </tr>
                            </table><!-- End Nav -->

					</td>
				</tr>
			</table><!-- End Header -->

		


<div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


            <!-- 2 Column Images & Text Side by SIde -->
            <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#202022' style='margin:0 auto;'>
                <tr>
                    <td style='padding:10px 0'>
                            <table align='left' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                <tr>
                                    <td valign='top' align='center' class='center' style='padding-top:20px;color:#fff;' >
                                         <h1 style='text-align:center;' >Reporte de Credenciales sin imprimir</h1>
                                    </td>
                                </tr>
                            </table>
                            <table align='right' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                <tr>
                                    <td style='font-size: 12px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px'>

                                        <table>
                                            <tr>
                                                <td valign='top' style='padding:0 10px 10px 5px;color:#fff;'>
                                                    
                                                </td>
                                                <td valign='middle' style='padding:0 10px 10px 0'><a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: bold; font-family:Arial, sans-serif '>Existen actualmente en el centro: " + campus + " un total de " + total + @" credenciales que estan listas para impresión y las cuales llevan mas de " + DiasMinimosParaReportar + @" días sin ser atendidas, por lo que se notifica por este medio la revisión de estos casos en particular</a>
                                                </td>
                                            </tr>
                                        </table>

                                        <p style='mso-table-lspace:0;mso-table-rspace:0; margin:0'>
                                             
                                            <br/><br/>

                                            

                                        </p>
                                    </td>
                                </tr>
                            </table>

                    </td>
                </tr>
                <tr>
                    <td bgcolor='#fe7f00'><div style='height:6px'>&nbsp;</div></td>
                </tr>
            </table><!-- End 2 Column Images & Text Side by SIde -->


<div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->

    <!-- One Column -->
            <table width='580'  class='deviceWidth' border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#eeeeed' style='margin:0 auto;'>
                <tr>
                    <td valign='top' style='padding:0' bgcolor='#ffffff'>
                        
                    </td>
                </tr>
                <tr>
                    <td style='font-size: 13px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px' bgcolor='#eeeeed'>

                        <table>
                            <tr>
                                <td valign='top' style='padding:0 10px 10px 0'>
                                    
                                </td>
                                <td valign='middle' style='padding:0 10px 10px 0'> 
                                </td>
                            </tr>
                        </table>

                            <h1>Listado de Alumnos</h1>
                            " + listaalumnos + @"
                    </td>
                </tr>
            </table><!-- End One Column -->

<div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->
			<!-- Two Column (Images Stacked over Text) -->
			 
 
        <!-- 2 Column Images - text left -->
            <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#eeeeed' style='margin:0 auto;'>
                <tr>
                    <td style='padding:10px 0'>
                            <table align='right' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                <tr>
                                    <td valign='top' align='left' class='center' style='padding:20px 10px 0 0'>
                                     " + url + @"
                                    </td>
                                </tr>
                            </table>
                            <table align='left' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                <tr>
                                    <td style='font-size: 13px; color: #959595; font-weight: normal; text-align: left; font-family: Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:20px 0 20px 15px'>

                                        <table>
                                            <tr>
                                                <td valign='top' style='padding:0 10px 15px 0'>
                                                  
                                                </td>
                                                <td valign='middle' style='padding:0 10px 10px 0'><a href='#' style='text-decoration: none; font-size: 16px; color: #363636; font-weight: bold; font-family:Arial, sans-serif '>Enviado por: </a>
                                                    
                                                </td>
                                            </tr>
                                        </table>

                                        
                                    </td>
                                </tr>
                            </table>
                    </td>
                </tr>
            </table><!-- End 2 Column Images  - text left -->
 

<div style='height:35px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


			<!-- 4 Columns -->
			<table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
				<tr>
					<td bgcolor='#363636' style='padding:30px 0'>
                        <table width='580' border='0' cellpadding='10' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
                            <tr>
                                <td>
                                        <table width='45%' cellpadding='0' cellspacing='0'  border='0' align='left' class='deviceWidth'>
                                            <tr>
                                                <td valign='top' style='font-size: 11px; color: #f1f1f1; color:#999; font-family: Arial, sans-serif; padding-bottom:20px' class='center'>

                                                   Departamento de Sistemas, Redes y Soporte Técnico | 
                                                    <a href='www.cecyteo.edu.mx/nova' style='color:#999;text-decoration:none;'>NOVA - " + DateTime.Now.Year + @"</a><br/>

                                                    <br/><br/>
                                                   

                                                </td>
                                            </tr>
                                        </table>

                                        <table width='40%' cellpadding='0' cellspacing='0'  border='0' align='right' class='deviceWidth'>
                                            <tr>
                                                <td valign='top' style='font-size: 11px; color: #f1f1f1; font-weight: normal; font-family: Helvetica, Georgia, Times, serif; line-height: 26px; vertical-align: top; text-align:right' class='center'>
                                                     Todos los Derechos Reservados - Cecyteo  

                                                    <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>

                                                   
                                                </td>
                                            </tr>
                                        </table>

                        		</td>
                        	</tr>
                        </table>
                    </td>
                </tr>
            </table><!-- End 4 Columns -->

		</td>
	</tr>
</table> <!-- End Wrapper -->
<div style='display:none; white-space:nowrap; font:15px courier; color:#ffffff;'>
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
</div>
</body>
</html>";





            //SmtpClient client = new SmtpClient();


            //client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            //client.Host = "smtp.gmail.com";
            //client.Port = 587;
            //client.DeliveryMethod = SmtpDeliveryMethod.Network;
            //client.EnableSsl = true;
            //// client.UseDefaultCredentials = false;

            //try
            //{
            //    client.Send(msg);

            //}
            //catch (Exception)
            //{
            //    regresa = false;
            //    // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            //}
            //return regresa;

            regresa.Email = msg;
            regresa.TotalReporte = (short)total;
            return regresa;
        }


        public void getEmailAdministradores(ref MailMessage m)
        {

            m.To.Add("credenciales@cecyteo.edu.mx");
            //m.To.Add("jdiaz@cecyteo.edu.mx");
            //m.Bcc.Add("juan.carlos.manuel@cecyteo.edu.mx");

        }

        public static string getFotografia64(string curp)
        {
            bdAriesEntities d = new bdAriesEntities();
            byte[] w = d.stAlumnosFotos.Where(a => a.Curp == curp).Select(s => s.Foto).SingleOrDefault();
            string base64String = Convert.ToBase64String(w);
            if (string.IsNullOrEmpty(base64String))
                return string.Empty;
            else
            {
                var img = "data:image/jpg;charset=utf-8;base64," + base64String;
                return img;
            }

        }

        public OrdenesCredenciales getCredencial(int idorden, short idcampus)
        {

            Credenciales_Proceso existe = bdnova.Credenciales_Proceso.Where(f => f.IdOrden == idorden && f.IdCampus == idcampus).FirstOrDefault();



            OrdenesCredenciales item = bd.ptOrdenes.Join(bd.stPagosServicios, orden => new { orden.IdOrden, orden.IdCampus }, servicio => new { servicio.IdOrden, servicio.IdCampus }, (orden, servicio) => new { orden, servicio })
               .Where(r => r.orden.IdOrden == idorden && r.orden.IdCampus == idcampus && r.servicio.ctPagoServicio.Nombre.Contains("credencial"))
              .OrderByDescending(b => b.orden.FechaRegistro).Select(s => new OrdenesCredenciales
              {
                  IdOrden = s.orden.IdOrden,
                  IdCampus = s.orden.IdCampus,
                  //Campus = getNombreCampus(Campus,s.orden.IdCampus),
                  IdInstitucion = s.orden.IdInstitucion,
                  Curp = s.orden.Curp,
                  Nombre = s.orden.ctAlumnos.Nombre,
                  ApellidoPaterno = s.orden.ctAlumnos.ApPaterno,
                  ApellidoMaterno = s.orden.ctAlumnos.ApMaterno,
                  ctAlumnos = s.orden.ctAlumnos,

                  IdCicloEscolar = s.orden.IdCicloEscolar,
                  IdValorCiclo = s.orden.IdValorCiclo,
                  Impuesto = s.orden.Impuesto,
                  ImporteTotal = s.orden.ImporteTotal,
                  FechaRegistro = s.orden.FechaRegistro,
                  FechaPago = s.orden.FechaPago,
                  IdUsuario = s.orden.IdUsuario,
                  Idcajero = s.orden.Idcajero,
                  Cancelada = s.orden.Cancelada,
                  FechaCancelada = s.orden.FechaCancelada,
                  Promedio = s.orden.Promedio,
                  FolioInstitucionCobro = s.orden.FolioInstitucionCobro,
                  CaducidadAñoMes = s.orden.CaducidadAñoMes,
                  LineaCaptura = s.orden.LineaCaptura,
                  Documento = s.orden.Documento,
                  ImpuestoFinanzas = s.orden.ImpuestoFinanzas,
                  FechaVigenciaFinanzas = s.orden.FechaVigenciaFinanzas,
                  CodigoBarras = s.orden.CodigoBarras,

                  IdPagoServicio = s.servicio.IdPagoServicio,
                  ImporteBruto = s.servicio.ImporteBruto,
                  Descuento = s.servicio.Descuento,
                  ImporteNeto = s.servicio.ImporteNeto,
                  Cantidad = s.servicio.Cantidad,
                  FechaAtendido = s.servicio.FechaAtendido,
                  Atendido = s.servicio.Atendido,

                  cveServicio = s.servicio.ctPagoServicio.cveServicio,
                  Servicio = s.servicio.ctPagoServicio.Nombre,
                  IdModalidadEstudio = s.servicio.ctPagoServicio.IdModalidadEstudio,
                  FechaValidacion = s.orden.ctAlumnos.stAlumnosValidados.FechaValidacion,
                  CredencialValidada = s.orden.ctAlumnos.stAlumnosValidados.InformacionValidada,
                  TieneFoto = (s.orden.ctAlumnos.stAlumnosFotos.Where(e => e.Curp == s.orden.Curp).Select(t => t.Foto).ToList().Count == 0) ? false : true,
                  // Foto = s.orden.ctAlumnos.stAlumnosFotos.Where(w => w.Curp == s.orden.Curp).Select(r => r.Foto).FirstOrDefault(),
                  TipoImagen = s.orden.ctAlumnos.stAlumnosFotos.Where(w => w.Curp == s.orden.Curp).Select(r => r.TipoImagen).FirstOrDefault(),
                  PoblacionVivienda = bd.vwLocalidades.Where(h => h.IdEstado == s.orden.ctAlumnos.IdEstadoViv && h.IdLocalidad == s.orden.ctAlumnos.IdLocalidadViv && h.IdMpio == s.orden.ctAlumnos.IdMpioViv).Select(d => new { Vivienda = d.Municipio }).FirstOrDefault().Vivienda,
                  CicloEscolarOrden = bd.stCicloEscolar.Where(w => w.IdCicloEscolar == s.orden.IdCicloEscolar).FirstOrDefault().ctCicloescolar.Nombre,
                  CicloEscolarAlumno = bd.stCicloEscolar.Where(w => w.IdCicloEscolar == s.orden.ctAlumnos.IdCicloEscolar).FirstOrDefault().ctCicloescolar.Nombre,
                  PlanEstudio = bd.ctPlanEstudio.Where(w => w.IdPlanEstudio == s.orden.ctAlumnos.IdPlanEstudio).FirstOrDefault().Nombre,
                  CuentaconImss = (s.orden.ctAlumnos.NoImss == null || s.orden.ctAlumnos.NoImss.Trim() == "") ? false : true


              }).FirstOrDefault();

            DateTime hoy = DateTime.Now;




            if (existe != null)
            {
                item.DiasSinCompletarDatos = existe.DiasSinCompletarDatos;
                item.DiasSinImprimir = existe.DiasSinImprimir;
                item.DiasSinFoto = existe.DiasSinFoto;

                if (item.Atendido == true)
                {
                    if (existe.DiasSinRecorgerCredencial == null)
                    {
                        item.ParaEntrega = true;
                        TimeSpan t = hoy - (DateTime)existe.FechaRegistro;
                        item.DiasSinRecorgerCredencial = (short)t.Days;
                        item.IdCredencialesProceso = existe.IdCredencialesProceso;
                    }
                    else
                    {
                        item.ParaEntrega = false;

                    }
                }
            }
            else
            {

                item.ParaEntrega = false;

                item.DiasSinCompletarDatos = 0;
                item.DiasSinFoto = 0;

                item.DiasSinImprimir = 0;

                TimeSpan t = hoy - (DateTime)item.FechaRegistro;
                bool lista = true;
                if (item.CredencialValidada == false)
                {
                    item.DiasSinCompletarDatos = (short)t.Days;
                    lista = false;
                }

                if (item.TieneFoto == false)
                {
                    item.DiasSinFoto = (short)t.Days;
                    lista = false;
                }

                if (lista && item.FechaPago.HasValue)
                {
                    // TimeSpan t2 = hoy - (DateTime)item.FechaPago;
                    item.DiasSinImprimir = (short)t.Days;
                }

            }


            item.Campus = bdnova.vwCampus.Where(w => w.IdCampus == item.IdCampus).FirstOrDefault().NumeroNombre;
            if (existe != null)
                item.IdCredencialesProceso = existe.IdCredencialesProceso;
            return item;


        }

        public List<OrdenesCredenciales> getCredencialesParaImpresion(long IdModalidad)
        {
            int anioactual = DateTime.Now.Year - 2;
            //int anioactual = 2018;



            //var impresas = bdnova.Credenciales_Impresiones.Select(v => v.IdCredencialesProceso).ToArray();
            //List<Credenciales_Proceso> procesocredenciales = bdnova.Credenciales_Proceso.Where(f => !impresas.Contains(f.IdCredencialesProceso)).ToList();


            DapperQuery dp = new DapperQuery("bdNovaEntities");
            DapperQuery dpa = new DapperQuery("bdAriesEntities");
            string query = "",queryold="";
            query = @"
select b.Nombre as EstatusAlumno,a.curp
,a.Nombre
,a.ApPaterno as ApellidoPaterno
,a.ApMaterno as ApellidoMaterno
, m.Nombre as PlanEstudio 
,a.NoImss
,a.IdValorCiclo
,a.Matricula
,a.IdCicloEscolar
,l.Nombre as CicloEscolarAlumno
into #AlumnosAltas
from ctAlumnos a
inner join CtPlanEstudio m on m.IdPlanEstudio=a.IdPlanEstudio
INNER join ctStatusAlumno x on x.IdStatusAlumno=a.IdStatusAlumno
inner join ctStatusAlumnoGrupal b on b.IdStatusAlumnoGrupal=x.IdStatusAlumnoGrupal
inner join stCicloEscolar k on a.IdCicloEscolar=k.IdCicloEscolar and m.IdModalidadEstudio=k.IdModalidadEstudio
inner join ctCicloescolar l on k.IdcicloEscolar=l.IdcicloEscolar
where b.Nombre in ('ALTAS','REINSCRIPCIONES')
 
select a.* 
,e.FechaValidacion
,cast( case when e.InformacionValidada is null then  0 else 1 end as bit) as CredencialValidada
,cast( case when f.curp is null then  0 else 1 end as bit) as TieneFoto
,cast( case when a.NoImss  is null or rtrim(a.NoImss)='' then 0 else 1 end as bit) as CuentaconImss
,f.TipoImagen
into #AlumnosAltasValidados
from #AlumnosAltas a
left join stAlumnosValidados e on e.Curp=a.Curp
left join stAlumnosFotos f on f.CURP=a.Curp
 

select 
a.IdOrden
,a.IdCampus
,a.IdInstitucion
,a.Curp
,x.EstatusAlumno
,x.Nombre
,x.Matricula
,ApellidoPaterno
,ApellidoMaterno
 ,a.IdCicloEscolar
,a.IdValorCiclo
,a.Impuesto
,a.ImporteTotal
,a.FechaRegistro
,a.FechaPago
,a.IdUsuario
,a.Idcajero
,a.Cancelada
,a.FechaCancelada
,a.Promedio
,a.FolioInstitucionCobro
,a.CaducidadAñoMes
,a.LineaCaptura
,a.Documento
,a.ImpuestoFinanzas
,a.FechaVigenciaFinanzas
,a.CodigoBarras
,b.IdPagoServicio
,b.ImporteBruto
,b.Descuento
,b.ImporteNeto
 ,b.Cantidad
,b.FechaAtendido
,b.Atendido
,d.cveServicio
,d.Nombre as Servicio
,d.IdModalidadEstudio
,FechaValidacion
,CredencialValidada
,TieneFoto
,TipoImagen
,Vivienda=''
,PlanEstudio
,CuentaconImss
,x.IdValorCiclo  as GradoAlumno 
,j.Nombre as CicloEscolarOrden
,x.CicloEscolarAlumno
from ptOrdenes a
inner join stPagosServicios b on a.AnioRegistro >=" + anioactual +

@"and   a.FechaCancelada is null and a.IdOrden=b.IdOrden and a.IdCampus=b.Idcampus 
inner join ctCampus c on a.IdCampus=c.IdCampus
inner join ctPagoServicio d on b.IdPagoServicio=d.IdPagoServicio
inner join #AlumnosAltasValidados x on a.Curp=x.Curp
inner join stCicloEscolar i on i.IdCicloEscolar=a.IdcicloEscolar and d.IdModalidadEstudio=i.IdModalidadEstudio
inner join ctCicloescolar j on i.IdcicloEscolar=j.IdcicloEscolar
 where d.Nombre like '%Credencial%' and Atendido=0 and d.IdModalidadEstudio=" + IdModalidad + " order by a.IdCicloEscolar desc,a.Curp";
             
            queryold = @"select a.IdOrden ,
        a.IdCampus ,
        a.IdInstitucion ,
        a.Curp ,
        d.Nombre,
        d.Matricula ,
        d.ApPaterno as ApellidoPaterno,
        d.ApMaterno as ApellidoMaterno,
        a.IdCicloEscolar ,
        a.IdValorCiclo ,
        a.Impuesto ,
        a.ImporteTotal ,
        a.FechaRegistro ,
        a.FechaPago ,
        a.IdUsuario ,
        a.Idcajero ,
        a.Cancelada ,
        a.FechaCancelada ,
        a.Promedio ,
        a.FolioInstitucionCobro ,
        a.CaducidadAñoMes ,
        a.LineaCaptura ,
        a.Documento ,
        a.ImpuestoFinanzas ,
        a.FechaVigenciaFinanzas ,
        a.CodigoBarras ,
                    b.IdPagoServicio,
                  b.ImporteBruto,
                  b.Descuento,
                  b.ImporteNeto,
                  b.Cantidad,
                  b.FechaAtendido,
                  b.Atendido,

 c.cveServicio,
                  c.Nombre as Servicio,
                  c.IdModalidadEstudio,
                  e.FechaValidacion,
                     cast( case when e.InformacionValidada is null then  0 else 1 end as bit) as CredencialValidada,
                  cast( case when f.curp is null then  0 else 1 end as bit) as TieneFoto,
                  f.TipoImagen,
                  g.Localidad + ',' + h.Municipio as Vivienda,
                  j.Nombre as CicloEscolarOrden ,
                   l.Nombre as CicloEscolarAlumno ,
                  m.Nombre as PlanEstudio ,
                   cast( case when d.NoImss  is null or rtrim(d.NoImss)='' then 0 else 1 end as bit) as CuentaconImss,
                 d.IdValorCiclo  as GradoAlumno 
from ptOrdenes a inner join stPagosServicios b on a.IdOrden=b.IdOrden and a.IdCampus=b.Idcampus
        inner join ctPagoServicio c on b.IdPagoServicio=c.IdPagoServicio 
        inner join   ctAlumnos d on d.Curp=a.Curp
            left join stAlumnosValidados e on e.Curp=a.Curp
                left join stAlumnosFotos f on f.CURP=a.Curp
                    left join ctlocalidades g on g.IdEstado=d.IdEstadoViv and g.IdMpio=d.IdMpioViv and g.IdLocalidad=d.IdLocalidadViv
                        left join ctmunicipios h on g.idMpio=h.IdMpio and g.idEstado=h.IdEstado
			inner join CtPlanEstudio m on m.IdPlanEstudio=d.IdPlanEstudio
                            inner join stCicloEscolar i on i.IdCicloEscolar=a.IdcicloEscolar and m.IdModalidadEstudio=i.IdModalidadEstudio
                                inner join ctCicloescolar j on i.IdcicloEscolar=j.IdcicloEscolar
                                    inner join stCicloEscolar k on k.IdCicloEscolar=d.IdcicloEscolar and m.IdModalidadEstudio=k.IdModalidadEstudio
                                inner join ctCicloescolar l on k.IdcicloEscolar=l.IdcicloEscolar
inner join   ctStatusAlumno kk on kk.IdStatusAlumno=d.IdStatusAlumno
                                inner join ctStatusAlumnoGrupal ff on ff.IdStatusAlumnoGrupal=kk.IdStatusAlumnoGrupal

        where ff.Nombre='ALTAS' and c.IdModalidadEstudio=" + IdModalidad + " and Year(FechaREgistro) >='" + anioactual + "' and c.Nombre like '%credencial%' and a.FechaCancelada is  null and LineaCaptura is not null ";


            List<OrdenesCredenciales> ordenes = (List<OrdenesCredenciales>)dpa.connection.Query<OrdenesCredenciales>(query);



            DateTime hoy = DateTime.Now;

            List<OrdenesCredenciales> eliminarordenes = new List<OrdenesCredenciales>();
            //    List<vwCampus> Campus = bdnova.vwCampus.ToList();


            query = @"SELECT  IdCampus ,
        Numero ,
        Nombre ,
        NombreLargo ,
        IdTipoCentro ,
        ClaveSep ,
         IdModelo ,
         IdAdscripcion ,
         IdResponsable ,
        FechaCreacion ,
         IdEstado ,
        IdLocalidad ,
         IdMpio ,
        Direccion ,
        LadaTelPropio ,
        TelPropio ,
        LadaFax ,
        Fax ,
        Mail ,
        LadaTelCaseta ,
        TelCaseta ,
        LadaTelMunicipio ,
        TelMunicipio ,
         IdAuxiliar ,
        RegPatronal ,
         IdTurnos ,
        Usuario ,
        HoraFechaMov ,
        idMpio2 ,
        idArealab ,
        NumeroNombre ,
         IdCampusOs ,
        RegistroPatronalImss ,
        SubDelegacion ,
        UnidadMedicinaFamiliar ,
        GuiaImss ,
        Latitud ,
        Longitud ,
 Vigente 
        FROM vwCampus";




            List<vwCampus> Campus = (List<vwCampus>)dp.connection.Query<vwCampus>(query);


            foreach (var item in ordenes)
            {

                item.Campus = getNombreCampus(Campus, item.IdCampus);

                //var existe = procesocredenciales.Where(e => e.IdOrden == item.IdOrden && e.IdCampus == item.IdCampus).FirstOrDefault();
                //  var existe = bdnova.Credenciales_Proceso.Where(e => e.IdOrden == item.IdOrden && e.IdCampus == item.IdCampus).FirstOrDefault();
                query = @"select  IdCredencialesProceso ,
         FechaRegistro ,
        IdOrden ,
        IdCampus ,
        DiasSinCompletarDatos ,
        DiasSinImprimir ,
         DiasSinRecorgerCredencial ,
        DiasSinFoto ,
        Documento ,
        IdModalidadEstudio ,
        Servicio ,
        CicloEscolarAlumno ,
        CicloEscolarOrden ,
        PlanEstudio ,
         FechaRecoleccion ,
         IdConvenioLaboralTrabajadorCategoriaRecibio from Credenciales_Proceso where  IdOrden = " + item.IdOrden + " and  IdCampus = " + item.IdCampus;

                var ultimo = dp.connection.Query<Credenciales_Proceso>(query);

                string temp = item.CicloEscolarOrden;
                temp = temp.Replace("-", "");
                temp = temp.Replace(" ", "");
                int i1 = int.Parse(temp);


                if (i1 <= 20152 && ultimo.Count() == 0)
                {
                    eliminarordenes.Add(item);
                }

                if (ultimo.Count() > 0)

                // if (existe != null)
                {

                    Credenciales_Proceso existe = (Credenciales_Proceso)ultimo.First();

                    item.DiasSinCompletarDatos = existe.DiasSinCompletarDatos;
                    item.DiasSinImprimir = existe.DiasSinImprimir;
                    item.DiasSinFoto = existe.DiasSinFoto;

                    if (item.Atendido == true)
                    {
                        if (existe.DiasSinRecorgerCredencial == null)
                        {
                            item.ParaEntrega = true;
                            TimeSpan t = hoy - (DateTime)existe.FechaRegistro;
                            item.DiasSinRecorgerCredencial = (short)t.Days;
                            item.IdCredencialesProceso = existe.IdCredencialesProceso;
                        }
                        else
                        {
                            item.ParaEntrega = false;
                            eliminarordenes.Add(item);
                        }
                    }
                }
                else
                {

                    item.ParaEntrega = false;

                    item.DiasSinCompletarDatos = 0;
                    item.DiasSinFoto = 0;

                    item.DiasSinImprimir = 0;

                    TimeSpan t = hoy - (DateTime)item.FechaRegistro;
                    bool lista = true;
                    if (item.CredencialValidada == false)
                    {
                        item.DiasSinCompletarDatos = (short)t.Days;
                        lista = false;
                    }

                    if (item.TieneFoto == false)
                    {
                        item.DiasSinFoto = (short)t.Days;
                        lista = false;
                    }

                    if (item.CuentaconImss == false)
                    {

                        lista = false;
                    }

                    if (lista && item.FechaPago.HasValue)
                    {
                        //TimeSpan t2 = hoy - (DateTime)item.FechaPago;
                        item.DiasSinImprimir = (short)t.Days;
                    }

                }

            }

            foreach (var item in eliminarordenes)
            {
                ordenes.Remove(item);
            }

            List<OrdenesCredenciales> finales = ordenes.OrderByDescending(q => q.ParaEntrega).OrderByDescending(w => w.DiasSinImprimir).ToList();
            dp.Close();
            dpa.Close();
            return finales;

        }

        public static IEnumerable<dynamic> getEstatusCredencialCicloVigente()
        {
         

            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string u = "";


           u = @"WITH CredencialesInfo AS (
                            SELECT a.IdCampus, a.IdOrden, c.Curp, c.Documento
                            FROM bdCtlEscSeg.dbo.stPagosServicios a
                            INNER JOIN bdCtlEscSeg.dbo.ctPagoServicio b ON b.IdPagoServicio = a.IdPagoServicio
                            INNER JOIN bdCtlEscSeg.dbo.ptOrdenes c ON c.IdOrden = a.IdOrden
                            WHERE a.Atendido = 1
                              AND b.Nombre LIKE '%CREDENCIAL%'
                        ),
                        UltimasImpresiones AS (
                            SELECT 
                                ci.Curp,
                                b.FechaReimpresion,
                                ci.Documento,
                                c.MotivoReimpresion,
                                ROW_NUMBER() OVER (PARTITION BY ci.Curp ORDER BY b.FechaReimpresion DESC) AS rn
                            FROM CredencialesInfo ci
                            INNER JOIN bdNova.dbo.Credenciales_Proceso cp ON cp.IdCampus = ci.IdCampus AND cp.IdOrden = ci.IdOrden
                            INNER JOIN bdNova.dbo.Credenciales_Impresiones b ON cp.IdCredencialesProceso = b.IdCredencialesProceso
                            LEFT JOIN bdNova.dbo.Credenciales_MotivoReimpresion c ON c.IdCredencialesMotivoReimpresion = b.IdCredencialesMotivoReimpresion
                        )

                        SELECT 
                            d.IdTipoCentro,
                            d.IdCampus,
                            d.NombreLargo,
                            a.ApPaterno,
                            a.ApMaterno,
                            a.Nombre,
                            a.CURP,
                            a.Sexo,
                            e.Nombre AS Semestre,
                            UPPER(f.Descripcion) AS PlanEstudio,
                            c.Nombre AS Estatus,
                            g.Nombre AS CicloEscolar,
                            -- Información de la última impresión de credencial
                            isnull(CONVERT(VARCHAR(10), ui.FechaReimpresion, 103),'') AS FechaImpresion,
                            isnull(CONVERT(VARCHAR(8), ui.FechaReimpresion, 108),'') AS HoraImpresion,
                            isnull(ui.Documento,''),
	                        isnull(ui.MotivoReimpresion,'') as TipoImpresion,
                            CASE WHEN ui.FechaReimpresion IS NULL THEN 'PENDIENTE DE IMPRESIÓN' ELSE 'IMPRESA' END AS EstadoCredencial
                        FROM ctAlumnos a
                        INNER JOIN ctStatusAlumno b ON a.IdStatusAlumno = b.IdStatusAlumno
                        INNER JOIN ctStatusAlumnoGrupal c ON c.IdStatusAlumnoGrupal = b.IdStatusAlumnoGrupal
                        INNER JOIN ctCampus d ON d.IdCampus = a.IdCampus
                        INNER JOIN ctValorCiclo e ON e.IdValorCiclo = a.IdValorCiclo
                        INNER JOIN ctPlanEstudio f ON f.IdPlanEstudio = a.IdPlanEstudio
                        INNER JOIN ctCicloescolar g ON g.IdCicloEscolar = a.IdCicloEscolar
                        LEFT JOIN UltimasImpresiones ui ON ui.Curp = a.CURP AND ui.rn = 1
                        WHERE g.IdCicloEscolar=bdCtlEscSeg.dbo.fnObtenCicloEscolarVigente(1)
                        order by 1,NombreLargo,f.Descripcion,c.Nombre,Curp
                ";
           

            // Ejecutar consulta
            var m = (IEnumerable<dynamic>)dp.connection.Query<dynamic>(u);
            dp.Close();

            return m;
        }

        public static List<dynamic> getCredencialesReporteGral()
        {
            List<dynamic> m = new List<dynamic>();

            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string u = "";



            u = @"
                    select a.curp
                    ,a.Nombre
                    ,a.ApPaterno as ApellidoPaterno
                    ,a.ApMaterno as ApellidoMaterno
                    , m.Nombre as PlanEstudio 
                    ,a.NoImss
                    ,a.IdValorCiclo
                    ,a.Matricula
                    ,a.IdCicloEscolar
                    ,l.Nombre as CicloEscolarAlumno
                    into #AlumnosAltas
                    from ctAlumnos a
                    inner join CtPlanEstudio m on m.IdPlanEstudio=a.IdPlanEstudio
                    INNER join ctStatusAlumno x on x.IdStatusAlumno=a.IdStatusAlumno
                    inner join ctStatusAlumnoGrupal b on b.IdStatusAlumnoGrupal=x.IdStatusAlumnoGrupal
                    inner join stCicloEscolar k on a.IdCicloEscolar=k.IdCicloEscolar and m.IdModalidadEstudio=k.IdModalidadEstudio
                    inner join ctCicloescolar l on k.IdcicloEscolar=l.IdcicloEscolar
                    where b.Nombre in ('ALTAS','REINSCRIPCIONES')
 
                    select a.* 
                    ,e.FechaValidacion
                    ,cast( case when e.InformacionValidada is null then  0 else 1 end as bit) as CredencialValidada
                    ,cast( case when f.curp is null then  0 else 1 end as bit) as TieneFoto
                    ,cast( case when a.NoImss  is null or rtrim(a.NoImss)='' then 0 else 1 end as bit) as CuentaconImss
                    ,f.TipoImagen
                    into #AlumnosAltasValidados
                    from #AlumnosAltas a
                    left join stAlumnosValidados e on e.Curp=a.Curp
                    left join stAlumnosFotos f on f.CURP=a.Curp
 
                    select 
                        a.Numero,
                        a.NombreLargo,
	
	                    sum(case when a.Atendido = 0 then 1 else 0 end) as TotalParaAtender,
	                    sum(case when a.CredencialValidada = 1 then 1 else 0 end) as TotalEsperaImpresion,
                        sum(case when a.CredencialValidada = 0 then 1 else 0 end) as TotalCredencialNoValidada,
	                    sum(case when a.CuentaconImss = 0 then 1 else 0 end) as TotalSinImss,
	                    sum(case when a.FechaPago is null then 1 else 0 end) as TotalFechaPagoNull,
                        sum(case when a.TieneFoto = 0 then 1 else 0 end) as TotalSinFoto
    
    
    
                    from (
                        select 
                            a.IdOrden,
                            a.IdCampus,
		                    c.Numero,
                            a.IdInstitucion,
                            a.Curp,
                            x.Nombre,
                            x.Matricula,
                            ApellidoPaterno,
                            ApellidoMaterno,
                            a.IdCicloEscolar,
                            a.IdValorCiclo,
                            a.Impuesto,
                            a.ImporteTotal,
                            a.FechaRegistro,
                            a.FechaPago,
                            a.IdUsuario,
                            a.IdCajero,
                            a.Cancelada,
                            a.FechaCancelada,
                            a.Promedio,
                            a.FolioInstitucionCobro,
                            a.CaducidadAñoMes,
                            a.LineaCaptura,
                            a.Documento,
                            a.ImpuestoFinanzas,
                            a.FechaVigenciaFinanzas,
                            a.CodigoBarras,
                            b.IdPagoServicio,
                            b.ImporteBruto,
                            b.Descuento,
                            b.ImporteNeto,
                            b.Cantidad,
                            b.FechaAtendido,
                            b.Atendido,
                            d.cveServicio,
                            d.Nombre as Servicio,
                            d.IdModalidadEstudio,
                            FechaValidacion,
                            CredencialValidada,
                            TieneFoto,
                            TipoImagen,
                            Vivienda = '',
                            PlanEstudio,
                            CuentaconImss,
                            x.IdValorCiclo as GradoAlumno,
                            j.Nombre as CicloEscolarOrden,
                            x.CicloEscolarAlumno,
                            c.NombreLargo
                        from ptOrdenes a
                        inner join stPagosServicios b on a.AnioRegistro >= 2018
                                                        and a.FechaCancelada is null
                                                        and a.IdOrden = b.IdOrden
                                                        and a.IdCampus = b.IdCampus
                        inner join ctCampus c on a.IdCampus = c.IdCampus
                        inner join ctPagoServicio d on b.IdPagoServicio = d.IdPagoServicio
                        inner join #AlumnosAltasValidados x on a.Curp = x.Curp
                        inner join stCicloEscolar i on i.IdCicloEscolar = a.IdCicloEscolar
                                                    and d.IdModalidadEstudio = i.IdModalidadEstudio
                        inner join ctCicloEscolar j on i.IdCicloEscolar = j.IdCicloEscolar
                        where d.Nombre like '%Credencial%'
                          and Atendido = 0
  
                    ) a
                    group by  a.NombreLargo, a.IdModalidadEstudio,a.Numero
                    order by    a.IdModalidadEstudio,a.Numero,a.NombreLargo;

                ";

            // Ejecutar consulta
            m = (List<dynamic>)dp.connection.Query<dynamic>(u);
            dp.Close();

            return m;
        }

        public List<OrdenesCredenciales>
            getCredencialesParaImpresion(short idcampus)
        {



            int anioactual = DateTime.Now.Year - 1;
            //int anioactual = 2018;



            //var impresas = bdnova.Credenciales_Impresiones.Select(v => v.IdCredencialesProceso).ToArray();
            //List<Credenciales_Proceso> procesocredenciales = bdnova.Credenciales_Proceso.Where(f => !impresas.Contains(f.IdCredencialesProceso)).ToList();


            DapperQuery dp = new DapperQuery("bdNovaEntities");
            DapperQuery dpa = new DapperQuery("bdAriesEntities");

            string query = "",queryold="";

            query = @"
select a.curp
,a.Nombre
,a.ApPaterno as ApellidoPaterno
,a.ApMaterno as ApellidoMaterno
, m.Nombre as PlanEstudio 
,a.NoImss
,a.IdValorCiclo
,a.Matricula
,a.IdCicloEscolar
,l.Nombre as CicloEscolarAlumno
into #AlumnosAltas
from ctAlumnos a
inner join CtPlanEstudio m on m.IdPlanEstudio=a.IdPlanEstudio
INNER join ctStatusAlumno x on x.IdStatusAlumno=a.IdStatusAlumno
inner join ctStatusAlumnoGrupal b on b.IdStatusAlumnoGrupal=x.IdStatusAlumnoGrupal
inner join stCicloEscolar k on a.IdCicloEscolar=k.IdCicloEscolar and m.IdModalidadEstudio=k.IdModalidadEstudio
inner join ctCicloescolar l on k.IdcicloEscolar=l.IdcicloEscolar
where b.Nombre in ('ALTAS','REINSCRIPCIONES')
 

select a.* 
,e.FechaValidacion
,cast( case when e.InformacionValidada is null then  0 else 1 end as bit) as CredencialValidada
,cast( case when f.curp is null then  0 else 1 end as bit) as TieneFoto
,cast( case when a.NoImss  is null or rtrim(a.NoImss)='' then 0 else 1 end as bit) as CuentaconImss
,f.TipoImagen
into #AlumnosAltasValidados
from #AlumnosAltas a
left join stAlumnosValidados e on e.Curp=a.Curp
left join stAlumnosFotos f on f.CURP=a.Curp


select 
a.IdOrden
,a.IdCampus
,a.IdInstitucion
,a.Curp
,x.Nombre
,x.Matricula
,ApellidoPaterno
,ApellidoMaterno
 ,a.IdCicloEscolar
,a.IdValorCiclo
,a.Impuesto
,a.ImporteTotal
,a.FechaRegistro
,a.FechaPago
,a.IdUsuario
,a.Idcajero
,a.Cancelada
,a.FechaCancelada
,a.Promedio
,a.FolioInstitucionCobro
,a.CaducidadAñoMes
,a.LineaCaptura
,a.Documento
,a.ImpuestoFinanzas
,a.FechaVigenciaFinanzas
,a.CodigoBarras
,b.IdPagoServicio
,b.ImporteBruto
,b.Descuento
,b.ImporteNeto
 ,b.Cantidad
,b.FechaAtendido
,b.Atendido
,d.cveServicio
,d.Nombre as Servicio
,d.IdModalidadEstudio
,FechaValidacion
,CredencialValidada
,TieneFoto
,TipoImagen
,Vivienda=''
,PlanEstudio
,CuentaconImss
,x.IdValorCiclo  as GradoAlumno 
,j.Nombre as CicloEscolarOrden
,x.CicloEscolarAlumno
from ptOrdenes a
inner join stPagosServicios b on a.AnioRegistro >= " + anioactual +

@"and   a.FechaCancelada is null and a.IdOrden=b.IdOrden and a.IdCampus=b.Idcampus 
inner join ctCampus c on a.IdCampus=c.IdCampus
inner join ctPagoServicio d on b.IdPagoServicio=d.IdPagoServicio
inner join #AlumnosAltasValidados x on a.Curp=x.Curp
inner join stCicloEscolar i on i.IdCicloEscolar=a.IdcicloEscolar and d.IdModalidadEstudio=i.IdModalidadEstudio
inner join ctCicloescolar j on i.IdcicloEscolar=j.IdcicloEscolar
 where d.Nombre like '%Credencial%' and Atendido=0 and a.IdCampus=" + idcampus + " order by a.IdCicloEscolar desc,a.Curp";


            queryold = @"select a.IdOrden ,
        a.IdCampus ,
        a.IdInstitucion ,
        a.Curp ,
        d.Nombre,
        d.Matricula ,
        d.ApPaterno as ApellidoPaterno,
        d.ApMaterno as ApellidoMaterno,
        
        a.IdCicloEscolar ,
        a.IdValorCiclo ,
        a.Impuesto ,
        a.ImporteTotal ,
        a.FechaRegistro ,
        a.FechaPago ,
        a.IdUsuario ,
        a.Idcajero ,
        a.Cancelada ,
        a.FechaCancelada ,
        a.Promedio ,
        a.FolioInstitucionCobro ,
        a.CaducidadAñoMes ,
        a.LineaCaptura ,
        a.Documento ,
        a.ImpuestoFinanzas ,
        a.FechaVigenciaFinanzas ,
        a.CodigoBarras ,
                    b.IdPagoServicio,
                  b.ImporteBruto,
                  b.Descuento,
                  b.ImporteNeto,
                  b.Cantidad,
                  b.FechaAtendido,
                  b.Atendido,

 c.cveServicio,
                  c.Nombre as Servicio,
                  c.IdModalidadEstudio,
                  e.FechaValidacion,
                  
                    cast( case when e.InformacionValidada is null then  0 else 1 end as bit) as CredencialValidada,
                  cast( case when f.curp is null then  0 else 1 end as bit) as TieneFoto,
                  f.Foto,
                  f.TipoImagen,
                  g.Localidad + ',' + h.Municipio as Vivienda,
                  j.Nombre as CicloEscolarOrden ,
                   l.Nombre as CicloEscolarAlumno ,
                  m.Nombre as PlanEstudio ,
                   cast( case when d.NoImss  is null or rtrim(d.NoImss)='' then 0 else 1 end as bit) as CuentaconImss,
                 d.IdValorCiclo as GradoAlumno 
from ptOrdenes a inner join stPagosServicios b on a.IdOrden=b.IdOrden and a.IdCampus=b.Idcampus
        inner join ctPagoServicio c on b.IdPagoServicio=c.IdPagoServicio 
        inner join   ctAlumnos d on d.Curp=a.Curp
            left join stAlumnosValidados e on e.Curp=a.Curp
                left join stAlumnosFotos f on f.CURP=a.Curp
                    left join ctlocalidades g on g.IdEstado=d.IdEstadoViv and g.IdMpio=d.IdMpioViv and g.IdLocalidad=d.IdLocalidadViv
                        left join ctmunicipios h on g.idMpio=h.IdMpio and g.idEstado=h.IdEstado
			inner join CtPlanEstudio m on m.IdPlanEstudio=d.IdPlanEstudio
                            inner join stCicloEscolar i on i.IdCicloEscolar=a.IdcicloEscolar and m.IdModalidadEstudio=i.IdModalidadEstudio
                                inner join ctCicloescolar j on i.IdcicloEscolar=j.IdcicloEscolar
                                    inner join stCicloEscolar k on k.IdCicloEscolar=d.IdcicloEscolar and m.IdModalidadEstudio=k.IdModalidadEstudio
                                inner join ctCicloescolar l on k.IdcicloEscolar=l.IdcicloEscolar
 inner join   ctStatusAlumno kk on kk.IdStatusAlumno=d.IdStatusAlumno
                                inner join ctStatusAlumnoGrupal ff on ff.IdStatusAlumnoGrupal=kk.IdStatusAlumnoGrupal
        where ff.Nombre='ALTAS' and  a.IdCampus=" + idcampus + " and year(FechaREgistro) >='" + anioactual + "' and c.Nombre like '%credencial%' and a.FechaCancelada is null and LineaCaptura is not null ";


            List<OrdenesCredenciales> ordenes = (List<OrdenesCredenciales>)dpa.connection.Query<OrdenesCredenciales>(query);

            //List<OrdenesCredenciales> ordenes = bd.ptOrdenes.Join(bd.stPagosServicios, orden => new { orden.IdOrden, orden.IdCampus }, servicio => new { servicio.IdOrden, servicio.IdCampus }, (orden, servicio) => new { orden, servicio })

            //   .Where(r => r.orden.IdCampus==idcampus && r.orden.FechaRegistro.Year > anioactual && r.servicio.ctPagoServicio.Nombre.Contains("credencial") && !r.orden.FechaCancelada.HasValue && r.orden.LineaCaptura != null)
            //  .OrderByDescending(b => b.orden.FechaRegistro).Select(s => new OrdenesCredenciales
            //  {
            //      IdOrden = s.orden.IdOrden,
            //      IdCampus = s.orden.IdCampus,
            //      //Campus = getNombreCampus(Campus,s.orden.IdCampus),
            //      IdInstitucion = s.orden.IdInstitucion,
            //      Curp = s.orden.Curp,
            //      Nombre = s.orden.ctAlumnos.Nombre,
            //      ApellidoPaterno = s.orden.ctAlumnos.ApPaterno,
            //      ApellidoMaterno = s.orden.ctAlumnos.ApMaterno,
            //      ctAlumnos = s.orden.ctAlumnos,

            //      IdCicloEscolar = s.orden.IdCicloEscolar,
            //      IdValorCiclo = s.orden.IdValorCiclo,
            //      Impuesto = s.orden.Impuesto,
            //      ImporteTotal = s.orden.ImporteTotal,
            //      FechaRegistro = s.orden.FechaRegistro,
            //      FechaPago = s.orden.FechaPago,
            //      IdUsuario = s.orden.IdUsuario,
            //      Idcajero = s.orden.Idcajero,
            //      Cancelada = s.orden.Cancelada,
            //      FechaCancelada = s.orden.FechaCancelada,
            //      Promedio = s.orden.Promedio,
            //      FolioInstitucionCobro = s.orden.FolioInstitucionCobro,
            //      CaducidadAñoMes = s.orden.CaducidadAñoMes,
            //      LineaCaptura = s.orden.LineaCaptura,
            //      Documento = s.orden.Documento,
            //      ImpuestoFinanzas = s.orden.ImpuestoFinanzas,
            //      FechaVigenciaFinanzas = s.orden.FechaVigenciaFinanzas,
            //      CodigoBarras = s.orden.CodigoBarras,

            //      IdPagoServicio = s.servicio.IdPagoServicio,
            //      ImporteBruto = s.servicio.ImporteBruto,
            //      Descuento = s.servicio.Descuento,
            //      ImporteNeto = s.servicio.ImporteNeto,
            //      Cantidad = s.servicio.Cantidad,
            //      FechaAtendido = s.servicio.FechaAtendido,
            //      Atendido = s.servicio.Atendido,

            //      cveServicio = s.servicio.ctPagoServicio.cveServicio,
            //      Servicio = s.servicio.ctPagoServicio.Nombre,
            //      IdModalidadEstudio = s.servicio.ctPagoServicio.IdModalidadEstudio,
            //      FechaValidacion = s.orden.ctAlumnos.stAlumnosValidados.FechaValidacion,
            //      CredencialValidada = s.orden.ctAlumnos.stAlumnosValidados.InformacionValidada,
            //      TieneFoto = (s.orden.ctAlumnos.stAlumnosFotos.Where(e => e.Curp == s.orden.Curp).Select(t => t.Foto).ToList().Count == 0) ? false : true,
            //      Foto = s.orden.ctAlumnos.stAlumnosFotos.Where(w => w.Curp == s.orden.Curp).Select(r => r.Foto).FirstOrDefault(),
            //      TipoImagen = s.orden.ctAlumnos.stAlumnosFotos.Where(w => w.Curp == s.orden.Curp).Select(r => r.TipoImagen).FirstOrDefault(),
            //      PoblacionVivienda = bd.vwLocalidades.Where(h => h.IdEstado == s.orden.ctAlumnos.IdEstadoViv && h.IdLocalidad == s.orden.ctAlumnos.IdLocalidadViv && h.IdMpio == s.orden.ctAlumnos.IdMpioViv).Select(d => new { Vivienda = d.Localidad + "," + d.Municipio }).FirstOrDefault().Vivienda,
            //      CicloEscolarOrden = bd.stCicloEscolar.Where(w => w.IdCicloEscolar == s.orden.IdCicloEscolar).FirstOrDefault().ctCicloescolar.Nombre,
            //      CicloEscolarAlumno = bd.stCicloEscolar.Where(w => w.IdCicloEscolar == s.orden.ctAlumnos.IdCicloEscolar).FirstOrDefault().ctCicloescolar.Nombre,
            //      PlanEstudio = bd.CtPlanEstudio.Where(w => w.IdPlanEstudio == s.orden.ctAlumnos.IdPlanEstudio).FirstOrDefault().Nombre,
            //      CuentaconImss=(s.orden.ctAlumnos.NoImss==null || s.orden.ctAlumnos.NoImss.Trim()=="") ? false : true
            //  }).ToList();

            DateTime hoy = DateTime.Now;

            List<OrdenesCredenciales> eliminarordenes = new List<OrdenesCredenciales>();



            query = @"SELECT  IdCampus ,
        Numero ,
        Nombre ,
        NombreLargo ,
        IdTipoCentro ,
        ClaveSep ,
         IdModelo ,
         IdAdscripcion ,
         IdResponsable ,
        FechaCreacion ,
         IdEstado ,
        IdLocalidad ,
         IdMpio ,
        Direccion ,
        LadaTelPropio ,
        TelPropio ,
        LadaFax ,
        Fax ,
        Mail ,
        LadaTelCaseta ,
        TelCaseta ,
        LadaTelMunicipio ,
        TelMunicipio ,
         IdAuxiliar ,
        RegPatronal ,
         IdTurnos ,
        Usuario ,
        HoraFechaMov ,
        idMpio2 ,
        idArealab ,
        NumeroNombre ,
         IdCampusOs ,
        RegistroPatronalImss ,
        SubDelegacion ,
        UnidadMedicinaFamiliar ,
        GuiaImss ,
        Latitud ,
        Longitud ,
 Vigente 
        FROM vwCampus";




            List<vwCampus> Campus = (List<vwCampus>)dp.connection.Query<vwCampus>(query);


            foreach (var item in ordenes)
            {


                item.Campus = getNombreCampus(Campus, item.IdCampus);


                query = @"select  IdCredencialesProceso ,
         FechaRegistro ,
        IdOrden ,
        IdCampus ,
        DiasSinCompletarDatos ,
        DiasSinImprimir ,
         DiasSinRecorgerCredencial ,
        DiasSinFoto ,
        Documento ,
        IdModalidadEstudio ,
        Servicio ,
        CicloEscolarAlumno ,
        CicloEscolarOrden ,
        PlanEstudio ,
         FechaRecoleccion ,
         IdConvenioLaboralTrabajadorCategoriaRecibio from Credenciales_Proceso where  IdOrden = " + item.IdOrden + " and  IdCampus = " + item.IdCampus;

                var ultimo = dp.connection.Query<Credenciales_Proceso>(query);

                string temp = item.CicloEscolarOrden;
                temp = temp.Replace("-", "");
                temp = temp.Replace(" ", "");

                int i1 = int.Parse(temp);

                if (i1 <= 20152 && ultimo.Count() == 0)
                {
                    eliminarordenes.Add(item);
                }

                if (ultimo.Count() > 0)



                {
                    Credenciales_Proceso existe = (Credenciales_Proceso)ultimo.First();

                    item.DiasSinCompletarDatos = existe.DiasSinCompletarDatos;
                    item.DiasSinImprimir = existe.DiasSinImprimir;
                    item.DiasSinFoto = existe.DiasSinFoto;

                    if (item.Atendido == true)
                    {
                        if (existe.DiasSinRecorgerCredencial == null)
                        {
                            item.ParaEntrega = true;
                            TimeSpan t = hoy - (DateTime)existe.FechaRegistro;
                            item.DiasSinRecorgerCredencial = (short)t.Days;
                            item.IdCredencialesProceso = existe.IdCredencialesProceso;
                        }
                        else
                        {
                            item.ParaEntrega = false;
                            eliminarordenes.Add(item);
                        }
                    }
                }
                else
                {


                    item.ParaEntrega = false;
                    item.DiasSinCompletarDatos = 0;
                    item.DiasSinFoto = 0;

                    item.DiasSinImprimir = 0;

                    TimeSpan t = hoy - (DateTime)item.FechaRegistro;
                    bool lista = true;
                    if (item.CredencialValidada == false)
                    {
                        item.DiasSinCompletarDatos = (short)t.Days;
                        lista = false;
                    }

                    if (item.TieneFoto == false)
                    {
                        item.DiasSinFoto = (short)t.Days;
                        lista = false;
                    }

                    if (lista && item.FechaPago.HasValue)
                    {
                        // TimeSpan t2 = hoy - (DateTime)item.FechaPago;
                        item.DiasSinImprimir = (short)t.Days;
                    }

                    if (item.CuentaconImss == false)
                    {

                        lista = false;
                    }

                }

            }

            foreach (var item in eliminarordenes)
            {
                ordenes.Remove(item);
            }
            List<OrdenesCredenciales> finales = ordenes.OrderByDescending(w => w.DiasSinRecorgerCredencial).OrderByDescending(a => a.DiasSinImprimir).ToList();
            dp.Close();
            dpa.Close();
            return finales;

        }


        public static IQueryable HistorialUsuario(short idestructuraorganica)
        {
            bdNovaEntities db = new bdNovaEntities();
            bdAriesEntities dbaries = new bdAriesEntities();
            short idcampus = 0;
            Catalogos_ctEstructuraOrganica lugar = db.Catalogos_ctEstructuraOrganica.Where(m => m.IdEstructuraOrganica == idestructuraorganica).FirstOrDefault();
            if (lugar.IdCampusEquivalencia == null)
                throw new ApplicationException("Esta opción esta reservada para las personas adscritas a un centro educativo");
            else
                idcampus = (short)lugar.IdCampusEquivalencia;

            //List<vwCampus> campus = db.vwCampus.ToList();
            //List<Credenciales_Proceso> tempo = db.Credenciales_Proceso
            //    .Where(
            //    d => d.IdCampus == idcampus
            //        ).OrderByDescending(w=> w.FechaRecoleccion).ToList();
            //List<CredencialesHistorial> resultado = new List<CredencialesHistorial>();
            //foreach (var item in tempo)
            //{
            //    CredencialesHistorial histo = new CredencialesHistorial();
            //    histo.IdCredencialesProceso = item.IdCredencialesProceso;
            //    histo.FechaRegistro = item.FechaRegistro;
            //    histo.IdOrden = item.IdOrden;
            //    histo.IdCampus = item.IdCampus;
            //    histo.DiasSinCompletarDatos = item.DiasSinCompletarDatos;
            //    histo.DiasSinImprimir = item.DiasSinImprimir;
            //    histo.DiasSinRecorgerCredencial = item.DiasSinRecorgerCredencial;
            //    histo.DiasSinFoto = item.DiasSinFoto;
            //    histo.Documento = item.Documento;
            //    histo.IdModalidadEstudio = item.IdModalidadEstudio;
            //    histo.ptOrdenes = dbaries.ptOrdenes.Where(q => q.IdOrden == item.IdOrden && q.IdCampus == item.IdCampus).FirstOrDefault();
            //    histo.Campus = campus.Where(d => d.IdCampus == item.IdCampus).FirstOrDefault().NumeroNombre;
            //    resultado.Add(histo);
            //}




            List<PersonalCredenciales> convenios = (List<PersonalCredenciales>)db.Convenios_stConvenioLaboralTrabajadorCategoria.Select(t => new PersonalCredenciales { IdConvenioLaboralTrabajadorCategoria = t.IdConvenioLaboralTrabajadorCategoria, Nombre = t.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + t.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + t.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }).ToList();

            List<vwCampus> campus = db.vwCampus.ToList();

            List<Credenciales_Proceso> tempo = db.Credenciales_Proceso
                .Where(
              d => d.IdCampus == idcampus
                    ).OrderBy(d => d.FechaRecoleccion).ToList();
            List<CredencialesHistorial> resultado = new List<CredencialesHistorial>();
            foreach (var item in tempo)
            {
                CredencialesHistorial histo = new CredencialesHistorial();
                histo.IdCredencialesProceso = item.IdCredencialesProceso;
                histo.FechaRegistro = item.FechaRegistro;
                histo.IdOrden = item.IdOrden;
                histo.IdCampus = item.IdCampus;
                histo.DiasSinCompletarDatos = item.DiasSinCompletarDatos;
                histo.DiasSinImprimir = item.DiasSinImprimir;
                histo.DiasSinRecorgerCredencial = item.DiasSinRecorgerCredencial;
                histo.DiasSinFoto = item.DiasSinFoto;
                histo.Documento = item.Documento;
                histo.IdModalidadEstudio = item.IdModalidadEstudio;
                histo.ptOrdenes = dbaries.ptOrdenes.Where(q => q.IdOrden == item.IdOrden && q.IdCampus == item.IdCampus).FirstOrDefault();
                histo.Campus = campus.Where(d => d.IdCampus == item.IdCampus).FirstOrDefault().NumeroNombre;
                histo.FechaRecoleccion = (item.FechaRecoleccion == null) ? null : item.FechaRecoleccion;
                var recibio = convenios.Where(f => f.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoriaRecibio).FirstOrDefault();
                string nombre = "error desconocido";
                if (recibio != null)
                    nombre = recibio.Nombre;

                histo.Recibio = (item.IdConvenioLaboralTrabajadorCategoriaRecibio == null) ? null : nombre;
                //histo.Recibio = (item.IdConvenioLaboralTrabajadorCategoriaRecibio == null ) ? null : convenios.Where(f => f.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoriaRecibio).FirstOrDefault().Nombre;
                resultado.Add(histo);
            }

            return resultado.OrderByDescending(s => s.FechaRecoleccion).AsQueryable();

        }

        public static List<UltimasCredenciales> getUltimasEntregas(short idmodalidad)
        {




            //var impresas = bdnova.Credenciales_Impresiones.Select(v => v.IdCredencialesProceso).ToArray();
            //List<Credenciales_Proceso> procesocredenciales = bdnova.Credenciales_Proceso.Where(f => !impresas.Contains(f.IdCredencialesProceso)).ToList();



            DapperQuery dpa = new DapperQuery("bdNovaEntities");
            string query = "";

            string ultimomes = DateTime.Now.Year.ToString() + System.DateTime.Today.Month.ToString("#00") + "01";

            query = @" select top 10 count(a.IdCredencialesProceso) as  Total, g.NumeroNombre as Campus ,max(e.Nombre) +' '+max(e.ApellidoPaterno)+' ' +max(e.ApellidoMaterno) as Recibio,max(FechaRecoleccion) as FechaRecoleccion
from Credenciales_Proceso a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoriaRecibio=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador d on d.IdTrabajador=c.IdTrabajador
inner join Kardex_ctDatosPersonales e on e.IdKardex=d.IdKardex
inner join vwCampus g  on g.IdCampus=a.IdCampus
 where DiasSinRecorgerCredencial is not null and   a.IdModalidadEstudio=" + idmodalidad + @"  and FechaRecoleccion >= '" + ultimomes + @"'
group by IdModalidadEstudio,IdConvenioLaboralTrabajadorCategoriaRecibio,g.NumeroNombre
order by FechaRecoleccion desc,g.NumeroNombre";



            List<UltimasCredenciales> ordenes = (List<UltimasCredenciales>)dpa.connection.Query<UltimasCredenciales>(query);
            dpa.Close();

            return ordenes;
        }


        public static IQueryable HistorialAdministrador(long idmodalidad)
        {

            bdNovaEntities db = new bdNovaEntities();
            bdAriesEntities dbaries = new bdAriesEntities();



            List<PersonalCredenciales> convenios = (List<PersonalCredenciales>)db.Convenios_stConvenioLaboralTrabajadorCategoria.Select(t => new PersonalCredenciales { IdConvenioLaboralTrabajadorCategoria = t.IdConvenioLaboralTrabajadorCategoria, Nombre = t.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + t.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + t.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }).ToList();

            List<vwCampus> campus = db.vwCampus.ToList();

            List<Credenciales_Proceso> tempo = db.Credenciales_Proceso
                .Where(
                d => d.IdModalidadEstudio == idmodalidad
                    ).OrderBy(d => d.FechaRecoleccion).ToList();
            List<CredencialesHistorial> resultado = new List<CredencialesHistorial>();
            foreach (var item in tempo)
            {
                CredencialesHistorial histo = new CredencialesHistorial();
                histo.IdCredencialesProceso = item.IdCredencialesProceso;
                histo.FechaRegistro = item.FechaRegistro;
                histo.IdOrden = item.IdOrden;
                histo.IdCampus = item.IdCampus;
                histo.DiasSinCompletarDatos = item.DiasSinCompletarDatos;
                histo.DiasSinImprimir = item.DiasSinImprimir;
                histo.DiasSinRecorgerCredencial = item.DiasSinRecorgerCredencial;
                histo.DiasSinFoto = item.DiasSinFoto;
                histo.Documento = item.Documento;
                histo.IdModalidadEstudio = item.IdModalidadEstudio;
                histo.ptOrdenes = dbaries.ptOrdenes.Where(q => q.IdOrden == item.IdOrden && q.IdCampus == item.IdCampus).FirstOrDefault();
                histo.Campus = campus.Where(d => d.IdCampus == item.IdCampus).FirstOrDefault().NumeroNombre;
                histo.FechaRecoleccion = (item.FechaRecoleccion == null) ? null : item.FechaRecoleccion;
                histo.Recibio = (item.IdConvenioLaboralTrabajadorCategoriaRecibio == null || item.IdConvenioLaboralTrabajadorCategoriaRecibio == 0) ? null : (convenios.Where(f => f.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoriaRecibio).Count() > 0) ? convenios.Where(f => f.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoriaRecibio).FirstOrDefault().Nombre : "Error en IdCLT [ " + item.IdConvenioLaboralTrabajadorCategoriaRecibio.ToString() + " ]";
                resultado.Add(histo);
            }

            return resultado.OrderByDescending(s => s.FechaRecoleccion).AsQueryable();

        }


        public static string localIPAddress()
        {
            IPHostEntry host;
            string localIP = "";
            host = Dns.GetHostEntry(Dns.GetHostName());

            foreach (IPAddress ip in host.AddressList)
            {
                localIP = ip.ToString();

                string[] temp = localIP.Split('.');

                if (ip.AddressFamily == AddressFamily.InterNetwork && temp[0] == "192")
                {
                    break;
                }
                else
                {
                    localIP = null;
                }
            }

            return localIP;
        }


       

    }
    ///NERI
    public class UltimasCredencialesEntregadas
    {

        public int Total { get; set; }


        public string Campus { get; set; }
        public string Recibio { get; set; }


        public Nullable<System.DateTime> FechaRecoleccion { get; set; }
        public string Alumno { get; set; }
        public string Matricula { get; set; }


    }


    /////
}