﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Models
{
    public class CursoParticipantes
    {
        public string Curso { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public int Cupo { get; set; }
        public int Participantes { get; set; }
        public decimal Porcentaje { get; set; }
        public int Iniciaron { get; set; }
    }
    public class ServicioParticipantes
    {
        public string Servicio { get; set; }
        public int Participantes { get; set; }
    }
    public class SexoParticipantes
    {
        public string Sexo { get; set; }
        public int Participantes { get; set; }
    }

    public class EstructuraPadreParticipante
    {
        public short EstructuraOrganica{ get; set; }
        public int Participantes { get; set; }
    }
    public partial class Capacitacion_stConvocatoria
    {
        public static IEnumerable<SelectListItem> GetConvocatorias()
        {
            bdNovaEntities db = new bdNovaEntities();
            List<SelectListItem> roles = db.Capacitacion_stConvocatoria.OrderByDescending(f => f.FechaInicioConvocatoria)
                        .Select(x =>
                                new SelectListItem
                                {
                                    Value = x.IdConvocatoria.ToString(),
                                    Text = x.Convocatoria + " " + x.FechaInicioConvocatoria.ToString() + " - " + x.FechaTerminoConvocatoria.ToString()

                                }).ToList();

            //SelectListItem vacia = new SelectListItem();

            //vacia.Value = "0";
            //vacia.Text = "Todas";
            //vacia.Selected = true;
            //roles.Add(vacia);
            return new SelectList(roles, "Value", "Text");
        }
        public static List<CursoParticipantes> ObtenTotalParticipantesCurso(int idconvocatoria)
        {
            bdNovaEntities db = new bdNovaEntities();
            List<CursoParticipantes> listasolicitudes = new List<CursoParticipantes>();


            var CursoParticipanteAsistencia = from r in db.Capacitacion_stAsistencia
                                              where r.Capacitacion_stParticipantes.FechaCancelacion == null && r.Capacitacion_stParticipantes.EsCanceladoPorAdministrador == false && r.Capacitacion_stParticipantes.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == idconvocatoria
                                              orderby r.Capacitacion_stParticipantes.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso
                                              group r by new { r.Capacitacion_stParticipantes.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso,r.Capacitacion_stParticipantes.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.FechaInicioCurso,r.Capacitacion_stParticipantes.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.FechaTerminoCurso, r.Capacitacion_stParticipantes.IdParticipantes } into grp
                                              select new { key = grp.Key, cnt = grp.Count(n => n.Asistencia == true) };


            var sm = from r in db.Capacitacion_stParticipantes
                     where r.FechaCancelacion == null && r.EsCanceladoPorAdministrador == false && r.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == idconvocatoria
                     orderby r.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso
                     group r by new { r.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso, r.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.FechaInicioCurso, r.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.FechaTerminoCurso } into grp
                     select new { key = grp.Key, cnt = grp.Count() };

            int totalsolicitudes = 0;
            int totalIniciaron = 0;
            int totalCupo = 0;
            int iniciarioncurso = 0;
            int cupocurso = 0;
            foreach (var item in sm)
            {
                CursoParticipantes sol = new CursoParticipantes();
                sol.Curso = item.key.Curso;
                sol.FechaInicio = item.key.FechaInicioCurso;
                sol.FechaTermino = item.key.FechaTerminoCurso;
                sol.Participantes = item.cnt;
                iniciarioncurso = 0;
                cupocurso = 0;
                var cupoc = from b in db.Capacitacion_stConvocatoriasCursosSedesAulas
                            join c in db.Capacitacion_stConvocatoriasCursos on b.IdConvocatoriaCursos equals c.IdConvocatoriaCursos
                            join d in db.Capacitacion_ctCurso on c.IdCurso equals d.IdCurso
                            join e in db.Capacitacion_stConvocatoria on c.IdConvocatoria equals e.IdConvocatoria
                            where e.IdConvocatoria == idconvocatoria && d.Curso == item.key.Curso && c.FechaInicioCurso==item.key.FechaInicioCurso &&
                            c.FechaTerminoCurso == item.key.FechaTerminoCurso 
                             
                            select new { cup = b.NumeroParticipantes };
                foreach (var item3 in cupoc)
                {
                    cupocurso = item3.cup;
                }
                var iniciaron = from a in CursoParticipanteAsistencia
                                where a.key.Curso == item.key.Curso
                                group a by new { a.key.Curso } into grp
                                select new { key = grp.Key, cnt = grp.Count(x => x.cnt > 0) };
                foreach (var item2 in iniciaron)
                {
                    iniciarioncurso = item2.cnt;
                }
                sol.Cupo = cupocurso;
                sol.Iniciaron = iniciarioncurso;
                sol.Porcentaje = decimal.Round((Convert.ToDecimal(sol.Participantes) / Convert.ToDecimal(cupocurso)) * 100m, 0);
                totalsolicitudes = totalsolicitudes + sol.Participantes;
                totalIniciaron = totalIniciaron + sol.Iniciaron;
                totalCupo = totalCupo + sol.Cupo;
                listasolicitudes.Add(sol);
            }
            CursoParticipantes total = new CursoParticipantes();
            total.Curso = "_Total";
            total.Cupo = totalCupo;
            total.Participantes = totalsolicitudes;
            total.Iniciaron = totalIniciaron;
            if (total.Cupo == 0)
            {
                total.Porcentaje = 0M;
            }
            else
            {
                total.Porcentaje = decimal.Round((Convert.ToDecimal(total.Participantes) / Convert.ToDecimal(total.Cupo)) * 100m, 0);

            }
            listasolicitudes.Add(total);
            return listasolicitudes;
        }
        public static List<ServicioParticipantes> ObtenTotalParticipantesServicio(int idconvocatoria)
        {
            bdNovaEntities db = new bdNovaEntities();
            List<ServicioParticipantes> listasolicitudes = new List<ServicioParticipantes>();

                var sm = from r in db.Capacitacion_stParticipantes
                         join t in db.vwDatosAspirantesTrabajadores on r.IdKardex equals t.IdKardex
                         where r.FechaCancelacion == null && r.EsCanceladoPorAdministrador == false && r.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == idconvocatoria
                         && t.RestringirMenu == null
                         orderby t.UbicacionFisica
                         group r by new { t.UbicacionFisica} into grp
                         select new { key = grp.Key, cnt = grp.Count() };

            int totalsolicitudes = 0;
            foreach (var item in sm)
            {
                ServicioParticipantes sol = new ServicioParticipantes();
                sol.Servicio = item.key.UbicacionFisica;
                sol.Participantes = item.cnt;
                totalsolicitudes = totalsolicitudes + sol.Participantes;
                listasolicitudes.Add(sol);
            }
            ServicioParticipantes total = new ServicioParticipantes();
            total.Servicio = "_Total";
            total.Participantes = totalsolicitudes;
            listasolicitudes.Add(total);
            return listasolicitudes;
        }
        public static List<SexoParticipantes> ObtenTotalParticipantesSexo(int idconvocatoria)
        {
            bdNovaEntities db = new bdNovaEntities();
            List<SexoParticipantes> listasolicitudes = new List<SexoParticipantes>();

            var sm = from r in db.Capacitacion_stParticipantes
                     join t in db.vwDatosAspirantesTrabajadores on r.IdKardex equals t.IdKardex
                     where r.FechaCancelacion == null && r.EsCanceladoPorAdministrador == false && r.Capacitacion_stConvocatoriasCursosSedesAulas.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == idconvocatoria
                     && t.RestringirMenu == null
                     orderby t.Sexo
                     group r by new { t.Sexo } into grp
                     select new { key = grp.Key, cnt = grp.Count() };

            int totalsolicitudes = 0;
            foreach (var item in sm)
            {
                SexoParticipantes sol = new SexoParticipantes();
                sol.Sexo = item.key.Sexo;
                sol.Participantes = item.cnt;
                totalsolicitudes = totalsolicitudes + sol.Participantes;
                listasolicitudes.Add(sol);
            }
            SexoParticipantes total = new SexoParticipantes();
            total.Sexo = "_Total";
            total.Participantes = totalsolicitudes;
            listasolicitudes.Add(total);
            return listasolicitudes;
        }

    }
}