﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public partial class Capacitacion_stAsistencia
    {
        public static IEnumerable getInstructores(int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Capacitacion_ctInstructores.Where(f=> f.IdInstructor==id).OrderBy(r => new { r.Nombre }).ToList();
        }

        public static IEnumerable getParticipantes(int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Capacitacion_stParticipantes.Where(g=> g.IdParticipantes==id).OrderBy(r => new { r.Kardex_ctDatosPersonales.Nombre, r.Kardex_ctDatosPersonales.ApellidoPaterno }).ToList();
        }

        public static IEnumerable getInstructores()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Capacitacion_ctInstructores.OrderBy(r => new { r.Nombre }).ToList();
        }

        public static IEnumerable getParticipantes()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Capacitacion_stParticipantes.OrderBy(r => new { r.Kardex_ctDatosPersonales.Nombre, r.Kardex_ctDatosPersonales.ApellidoPaterno }).ToList();
        }

        public  IEnumerable getCurso(int IdConvocatoriaCursosSedesAulas)
        {
            bdNovaEntities db = new bdNovaEntities();
            var ca = (from a in db.Capacitacion_stConvocatoriasCursosSedesAulas
                      join c in db.Capacitacion_stConvocatoriasCursos on a.IdConvocatoriaCursos equals c.IdConvocatoriaCursos
                      where a.IdConvocatoriaCursosSedesAulas == IdConvocatoriaCursosSedesAulas
                      select new { Cursos = c.Capacitacion_ctCurso.Curso, FechaInicioCurso = c.FechaInicioCurso, FechaFinCurso = c.FechaTerminoCurso });
            return ca.ToList();
        }

    }
}