﻿using Nova.Models.Correo;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Web;
using System.Web.Mvc;

namespace Nova.Models
{
    public partial class Capacitacion_PersonalPermitidoCategoria
    {
        public static IEnumerable getCategorias()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Plazas_ctCategoria.OrderBy(r => r.Categoria).ToList();
        }

        public static IEnumerable getRelacionLaboral()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Catalogos_ctRelacionLaboral.OrderBy(r => r.RelacionLaboral).ToList();
        }

        public static IEnumerable getConvenioLaboral()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Catalogos_ctConvenioLaboral.OrderBy(r => r.ConvenioLaboral).ToList();
        }
        public static IEnumerable getEstructuraOrganica()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Catalogos_ctEstructuraOrganica.OrderBy(r => r.EstructuraOrganica).ToList();
        }

        public static IEnumerable getConvocatorias()
        {
            bdNovaEntities db = new bdNovaEntities();
            DateTime hoy = DateTime.Now;
            return db.Capacitacion_stConvocatoriasCursos.Where(h=> h.FechaInicioCurso > hoy ).OrderByDescending(y => y.Capacitacion_stConvocatoria.FechaInicioConvocatoria).ToList();
        }

        public static bool EnviarEmailInvitacion(string email, Capacitacion_stConvocatoriasCursos item, string url)
        {
            bool regresa = true;
            string cuerpoHtml = @"<html xmlns='http://www.w3.org/1999/xhtml'>
<head>

    <!-- Define Charset -->
    <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
    <!-- Responsive Meta Tag -->
    <meta name='viewport' content='width=device-width; initial-scale=1.0; maximum-scale=1.0;'>
    <!-- Facebook sharing information tags -->
    
    <title>Activacion de cuenta</title>

    <link href='https://fonts.googleapis.com/css?family=Source+Sans+Pro:200,300,400' rel='stylesheet' type='text/css'>


    <style type='text/css' data-premailer='ignore'>
        /* iPad Text Smoother */
        div, p, a, li, td {
            -webkit-text-size-adjust: none;
        }

        .ReadMsgBody {
            width: 100%;
            background-color: #ffffff;
        }

        .ExternalClass {
            width: 100%;
            background-color: #ffffff;
        }

        body {
            width: 100%;
            background-color: #ffffff;
            margin: 0;
            padding: 0;
            -webkit-font-smoothing: antialiased;
            text-align: left;
        }

        html {
            width: 100%;
        }

        img {
            border: 0px;
            outline: none;
            text-decoration: none;
            display: block;
        }

        a img {
            border: none;
        }

        a {
            color: inherit;
            text-decoration: none;
            text-align: inherit;
        }

        .Rounded_Bottom {
            border-bottom-left-radius: 3px;
            -webkit-border-bottom-left-radius: 3px;
            -moz-border-radius-bottomleft: 3px;
            border-bottom-right-radius: 3px;
            -webkit-border-bottom-right-radius: 3px;
            -moz-border-radius-bottomright: 3px;
        }

        .Rounded_Top {
            border-top-left-radius: 3px;
            -webkit-border-top-left-radius: 3px;
            -moz-border-radius-topleft: 3px;
            border-top-right-radius: 3px;
            -webkit-border-top-right-radius: 3px;
            -moz-border-radius-topright: 3px;
        }

        .Text_H1 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 36px;
            letter-spacing: -1px;
            font-weight: 400;
            font-style: normal;
          
            color: #222427;
            line-height: 120%;
            text-align: left;
        }

        .Text_H2 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 24px;
            letter-spacing: -1px;
            font-weight: 400;
            font-style: normal;
          
            color: #222427;
            line-height: 150%;
            text-align: left;
        }

        .Text_H3 {
            font-family: 'Source Sans Pro', sans-serif;
            font-size: 14px;
            letter-spacing: 0px;
            font-weight: 400;
            font-style: normal;
            text-decoration: none;
          
            color: #656d78;
            line-height: 175%;
            text-align: left;
        }

        .Text_H4 {
            font-family: sans-serif;
            
            font-weight: normal;
            font-style: normal;
            text-decoration: none;
            text-transform: uppercase;
            color: #DBDBDB;
            line-height: 200%;
            text-align: left;
        }

        .btn-style {
          border-color: #B3B1B1;
             border-width: 1px;
            border-style: solid;
            border-radius: 4px;
            moz-border-radius: 4px;
        }

        .plan-style {
            border-color: #ffffff;
            border-width: 1px;
            border-style: solid;
        }

        .border-style {
            border-color: #ffffff;
            border-width: 7px;
            border-style: solid;
        }
        /*-------------------------------------- Responsive 600px PC Attributes --------------------------------------*/
        @media only screen and (max-width: 900px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 600px !important;
            }

            .BookLeft {
                width: 300px !important;
            }

            .BookRight {
                width: 280px !important;
            }

            .Respo1Column {
                width: 560px !important;
            }

            .Respo2Column {
                width: 270px !important;
            }

            .Respo3Column {
                width: 560px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 600px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 600px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 270px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 270px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 560px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 560px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 560px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 560px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 264px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 264px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 554px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 554px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-margin {
                width: 20px !important;
            }

            .respo-hide-pc {
                display: none !important;
            }

            .respo-show-pc {
                display: block !important;
            }
            /* General  */
            .respo-text-left {
                text-align: left !important;
            }

            .respo-center-pc {
                text-align: center !important;
            }
        }

        /*-------------------------------------- Responsive 440px Tablet Attributes --------------------------------------*/
        @media only screen and (max-width: 640px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 440px !important;
            }

            .BookLeft {
                width: 440px !important;
            }

            .BookRight {
                width: 440px !important;
            }

            .Respo1Column {
                width: 420px !important;
            }

            .Respo2Column {
                width: 400px !important;
            }

            .Respo3Column {
                width: 400px !important;
            }

            .RespoTabletWidth {
                width: 400px !important;
            }

            .Respo2ColumnTablet {
                width: 400px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 440px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 440px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColTablet {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage3ColWTablet Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 394px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 394px !important;
                height: auto !important;
            }
            /* Responsive Tablet and Mobile Only */
            .RespoImage2ColTablet {
                width: 400px !important;
                height: auto !important;
            }

            .RespoImage2ColTabletW Img {
                width: 400px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-hide-tablet {
                display: none !important;
            }

            .respo-show-tablet {
                display: block !important;
            }
            /* Responsive Text Align & Size */
            .Text_H1 {
                font-size: 36px !important;
                line-height: 125% !important;
            }

            .Text_H2 {
                font-size: 36px !important;
                line-height: 140% !important;
            }

            .Text_H3 {
                font-size: 14px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .Text_H4 {
                font-size: 15px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .respo-center-tablet {
                text-align: center !important;
            }

            .respo-spacer {
                height: 200px !important;
            }
        }

        /*-------------------------------------- Responsive 280px Mobile Attributes --------------------------------------*/
        @media only screen and (max-width: 480px) {
            body {
                width: auto !important;
            }
            /* Responsive Wrappers  */
            .BoxWrap {
                width: 280px !important;
            }

            .BookLeft {
                width: 280px !important;
            }

            .BookRight {
                width: 280px !important;
            }

            .Respo1Column {
                width: 260px !important;
            }

            .Respo2Column {
                width: 240px !important;
            }

            .Respo3Column {
                width: 240px !important;
            }

            .RespoTabletWidth {
                width: 240px !important;
            }

            .Respo2ColumnTablet {
                width: 240px !important;
            }
            /* Responsive Images  */
            .RespoImage1Col {
                width: 280px !important;
                height: auto !important;
            }

            .RespoImage1ColW Img {
                width: 280px !important;
                height: auto !important;
            }

            .RespoImage2Col {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage2ColW Img {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3Col {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColW Img {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColTablet {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage3ColWTablet Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Responsive Images with Padding */
            .RespoImage1ColPadding {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage1ColPaddingW Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Responsive Framed Images */
            .RespoImage2ColFramed {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage2ColFramedW Img {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage3ColFramed {
                width: 234px !important;
                height: auto !important;
            }

            .RespoImage3ColFramedW Img {
                width: 234px !important;
                height: auto !important;
            }
            /* Responsive Tablet and Mobile Only */
            .RespoImage2ColTablet {
                width: 240px !important;
                height: auto !important;
            }

            .RespoImage2ColTabletW Img {
                width: 240px !important;
                height: auto !important;
            }
            /* Show/Hide  */
            .respo-hide-mobile {
                display: none !important;
            }
            /* Responsive Text Align & Size */
            .Text_H1 {
                font-size: 24px !important;
                line-height: 125% !important;
            }

            .Text_H2 {
                font-size: 24px !important;
                line-height: 140% !important;
            }

            .Text_H3 {
                font-size: 18px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .Text_H4 {
                font-size: 11px !important;
                line-height: 150% !important;
                font-weight: normal !important;
            }

            .respo-center-mobile {
                text-align: center !important;
            }

            .respo-spacer {
                height: 100px !important;
            }
        }
    </style>


</head>
<body>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 1 Column | NoPadding | NoBreak -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td height='20'></td>
                            </tr>
                            <tr>
                                <td>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td class='Text_H3' style='text-align:center; color:#ffffff!important;' mc:edit='Text_H31'>
                                                    <span><i> </i></span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 1 Column | NoPadding | NoBreak -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 2 Column | Padding | BreakOnPC -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap BackgroundColor05 Rounded_Top' bgcolor='#DBDBDB' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td width='560'>
                                    <!-- // Begin: First Column \\ -->
                                    <table class='Respo1Column' align='left' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td width='75' class='Respo1Column' align='center' valign='top'>
                                                    <img mc:edit='' src='https://www.cecyteo.edu.mx/Nova/img/logocecyte.png' alt=' ' border=' 0' style='width: 75px; display: block;'>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: First Column \\ -->
                                    <!-- ************************** -->
                                    <!-- // Begin: Second Column \\ -->
                                    <table class='Respo1Column' align='right' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; color:#ffffff!important;' mc:edit='Text_H32'>
                                                                    
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: Second Column \\ -->
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 2 Column | Padding | BreakOnPC -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: Caption - One Column Segment -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap fixed-bg-style BackgroundColor01' bgcolor='#ffffff' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td class='RespoTabletWidth' width='560'>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td class='Text_H1' style='text-align:center;' mc:edit='Text_H13'>
                                                    <span>Lo invitamos a formar parte del curso  " + item.Capacitacion_ctCurso.Curso + " del " + item.FechaInicioCurso.ToShortDateString() + " al " + item.FechaTerminoCurso.ToShortDateString() + @"</span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td width='100%' height='5'></td>
                                            </tr>
                                            <tr>
                                                <td class='Text_H3' style='text-align:center;' mc:edit='Text_H34'>
                                                    <span>" + item.Capacitacion_stConvocatoria.Convocatoria + " con vigencia del " + item.Capacitacion_stConvocatoria.FechaInicioConvocatoria.ToShortDateString() + " al " + item.Capacitacion_stConvocatoria.FechaTerminoConvocatoria.ToShortDateString() + @"</span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
 
    <!-- Begin Module: Paragraph - One Column Segment -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap fixed-bg-style BackgroundColor05' bgcolor='#DBDBDB' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td class='RespoTabletWidth' width='560'>
                                    <table width='100%' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td class='Text_H1 respo-center-tablet' style='color:#ffffff!important; text-align:center;' mc:edit='Text_H117'>
                                                   
                                                </td>
                                            </tr>
                                            <tr>
                                                <td height='20'>&nbsp;</td>
                                            </tr>
                                            <!-- Button -->
                                            <tr>
                                                <td width='100%' align='center'>
                                                    <table class='BackgroundColor05 btn-style RespoTabletWidth' bgcolor='#DBDBDB' align='center' cellpadding='7' cellspacing='0' style='border-radius:4px;'>
                                                        <tbody style='background-color: #82BA00;'>
                                                            <tr>
                                                                <td>&nbsp; </td>
                                                                <td class='Text_H4' style='text-align: center; color:#ffffff; vertical-align: middle; text-transform:uppercase;' mc:edit='Text_H418'>
                                                                    <span style='color:#ffffff;'><a href='" + url + @"' style='text-align: center; color:#ffffff; vertical-align: middle; text-transform:uppercase;'>Ver mas información</a></span>
                                                                </td>
                                                                <td>&nbsp; </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                            <tr>
                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>
    <!-- End Module: Paragraph - One Column Segment -->
    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 2 Column | Padding | BreakOnPC -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap BackgroundColor01 Rounded_Bottom' bgcolor='#ffffff' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                            <tr>
                                <td width='120' class='respo-margin'></td>
                                <td width='560'>
                                    <!-- // Begin: First Column \\ -->
                                    <table class='Respo1Column' align='left' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; text-align:center;' mc:edit='Text_H319'>
                                                                    <span>Departamento de Sistemas | Departamento de Capacitación - " + DateTime.Now.Year + @" </span>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: First Column \\ -->
                                    <!-- ************************** -->
                                    <!-- // Begin: Second Column \\ -->
                                    <table class='Respo1Column' align='right' cellpadding='0' cellspacing='0'>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <table align='center' cellpadding='0' cellspacing='0'>
                                                        <tbody>
                                                            <tr>
                                                                <td class='Text_H3' style='line-height:50px!important; text-align:center;' mc:edit='Text_H320'>
                                                                    <span><a href='https://www.cecyteo.edu.mx/Nova'>Sistema Nova - Cecyteo </a></span>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- // End: Second Column \\ -->
                                </td>
                                <td width='120' class='respo-margin'></td>
                            </tr>
                            <tr>
                                <td colspan='3' width='100%' height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 2 Column | Padding | BreakOnPC -->
        </tbody>
    </table>

    <!-- ********************************************************************************************************* -->
    <!-- Begin Module: 1 Column | NoPadding | NoBreak -->
    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        <tbody>
            <tr>
                <td align='center'>
                    <table class='BoxWrap' width='800' align='center' cellpadding='0' cellspacing='0'>
                        <tbody>
                            <tr>
                                <td height='20'></td>
                            </tr>
                            <tr>
                                <td height='20'></td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- End Module: 1 Column | NoPadding | NoBreak -->
        </tbody>
    </table>


</body>
</html>";



            try
            {
                CorreoPersonalizado correo = new CorreoPersonalizado
                {
                    Nombre = email,
                    DestinatarioEmail = email,
                    TituloCorreo = "Invitación para el curso " + item.Capacitacion_ctCurso.Curso,
                    LugarTrabajo = "",
                    Firma = "",
                    DirigidoA = "",
                    DireccionFirma = "",
                    Fecha = DateTime.Now.ToString("dd/MM/yyyy"),
                    Hora = DateTime.Now.ToString("HH:mm"),
                    LinkUrl = url
                };

                // Llamar a tu CorreoService para enviar
                CorreoService.EnviarCorreoPersonalizadoConCuerpoDirecto(correo, cuerpoHtml);

            }
            catch (Exception)
            {
                regresa = false;
                // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }
            return regresa;
        }


        //        public static bool EnviarEmailInvitacion(string email, Capacitacion_stConvocatoriasCursos item, string url)
        //        {
        //            bool regresa = true;
        //            MailMessage msg = new MailMessage();

        //            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
        //            msg.To.Add(email);
        //            msg.Subject = "Invitación para el curso " + item.Capacitacion_ctCurso.Curso;
        //            msg.IsBodyHtml = true;
        //            // string codificado = Cifrado.Encrypt(email + id.ToString());

        //            //UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

        //          //  string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Index", "Home");

        //            msg.Body = @"<html xmlns='http://www.w3.org/1999/xhtml'>
        //<head>

        //    <!-- Define Charset -->
        //    <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
        //    <!-- Responsive Meta Tag -->
        //    <meta name='viewport' content='width=device-width; initial-scale=1.0; maximum-scale=1.0;'>
        //    <!-- Facebook sharing information tags -->

        //    <title>Activacion de cuenta</title>

        //    <link href='https://fonts.googleapis.com/css?family=Source+Sans+Pro:200,300,400' rel='stylesheet' type='text/css'>


        //    <style type='text/css' data-premailer='ignore'>
        //        /* iPad Text Smoother */
        //        div, p, a, li, td {
        //            -webkit-text-size-adjust: none;
        //        }

        //        .ReadMsgBody {
        //            width: 100%;
        //            background-color: #ffffff;
        //        }

        //        .ExternalClass {
        //            width: 100%;
        //            background-color: #ffffff;
        //        }

        //        body {
        //            width: 100%;
        //            background-color: #ffffff;
        //            margin: 0;
        //            padding: 0;
        //            -webkit-font-smoothing: antialiased;
        //            text-align: left;
        //        }

        //        html {
        //            width: 100%;
        //        }

        //        img {
        //            border: 0px;
        //            outline: none;
        //            text-decoration: none;
        //            display: block;
        //        }

        //        a img {
        //            border: none;
        //        }

        //        a {
        //            color: inherit;
        //            text-decoration: none;
        //            text-align: inherit;
        //        }

        //        .Rounded_Bottom {
        //            border-bottom-left-radius: 3px;
        //            -webkit-border-bottom-left-radius: 3px;
        //            -moz-border-radius-bottomleft: 3px;
        //            border-bottom-right-radius: 3px;
        //            -webkit-border-bottom-right-radius: 3px;
        //            -moz-border-radius-bottomright: 3px;
        //        }

        //        .Rounded_Top {
        //            border-top-left-radius: 3px;
        //            -webkit-border-top-left-radius: 3px;
        //            -moz-border-radius-topleft: 3px;
        //            border-top-right-radius: 3px;
        //            -webkit-border-top-right-radius: 3px;
        //            -moz-border-radius-topright: 3px;
        //        }

        //        .Text_H1 {
        //            font-family: 'Source Sans Pro', sans-serif;
        //            font-size: 36px;
        //            letter-spacing: -1px;
        //            font-weight: 400;
        //            font-style: normal;

        //            color: #222427;
        //            line-height: 120%;
        //            text-align: left;
        //        }

        //        .Text_H2 {
        //            font-family: 'Source Sans Pro', sans-serif;
        //            font-size: 24px;
        //            letter-spacing: -1px;
        //            font-weight: 400;
        //            font-style: normal;

        //            color: #222427;
        //            line-height: 150%;
        //            text-align: left;
        //        }

        //        .Text_H3 {
        //            font-family: 'Source Sans Pro', sans-serif;
        //            font-size: 14px;
        //            letter-spacing: 0px;
        //            font-weight: 400;
        //            font-style: normal;
        //            text-decoration: none;

        //            color: #656d78;
        //            line-height: 175%;
        //            text-align: left;
        //        }

        //        .Text_H4 {
        //            font-family: sans-serif;

        //            font-weight: normal;
        //            font-style: normal;
        //            text-decoration: none;
        //            text-transform: uppercase;
        //            color: #DBDBDB;
        //            line-height: 200%;
        //            text-align: left;
        //        }

        //        .btn-style {
        //          border-color: #B3B1B1;
        //             border-width: 1px;
        //            border-style: solid;
        //            border-radius: 4px;
        //            moz-border-radius: 4px;
        //        }

        //        .plan-style {
        //            border-color: #ffffff;
        //            border-width: 1px;
        //            border-style: solid;
        //        }

        //        .border-style {
        //            border-color: #ffffff;
        //            border-width: 7px;
        //            border-style: solid;
        //        }
        //        /*-------------------------------------- Responsive 600px PC Attributes --------------------------------------*/
        //        @media only screen and (max-width: 900px) {
        //            body {
        //                width: auto !important;
        //            }
        //            /* Responsive Wrappers  */
        //            .BoxWrap {
        //                width: 600px !important;
        //            }

        //            .BookLeft {
        //                width: 300px !important;
        //            }

        //            .BookRight {
        //                width: 280px !important;
        //            }

        //            .Respo1Column {
        //                width: 560px !important;
        //            }

        //            .Respo2Column {
        //                width: 270px !important;
        //            }

        //            .Respo3Column {
        //                width: 560px !important;
        //            }
        //            /* Responsive Images  */
        //            .RespoImage1Col {
        //                width: 600px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage1ColW Img {
        //                width: 600px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2Col {
        //                width: 270px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2ColW Img {
        //                width: 270px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3Col {
        //                width: 560px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColW Img {
        //                width: 560px !important;
        //                height: auto !important;
        //            }
        //            /* Responsive Images with Padding */
        //            .RespoImage1ColPadding {
        //                width: 560px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage1ColPaddingW Img {
        //                width: 560px !important;
        //                height: auto !important;
        //            }
        //            /* Responsive Framed Images */
        //            .RespoImage2ColFramed {
        //                width: 264px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2ColFramedW Img {
        //                width: 264px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColFramed {
        //                width: 554px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColFramedW Img {
        //                width: 554px !important;
        //                height: auto !important;
        //            }
        //            /* Show/Hide  */
        //            .respo-margin {
        //                width: 20px !important;
        //            }

        //            .respo-hide-pc {
        //                display: none !important;
        //            }

        //            .respo-show-pc {
        //                display: block !important;
        //            }
        //            /* General  */
        //            .respo-text-left {
        //                text-align: left !important;
        //            }

        //            .respo-center-pc {
        //                text-align: center !important;
        //            }
        //        }

        //        /*-------------------------------------- Responsive 440px Tablet Attributes --------------------------------------*/
        //        @media only screen and (max-width: 640px) {
        //            body {
        //                width: auto !important;
        //            }
        //            /* Responsive Wrappers  */
        //            .BoxWrap {
        //                width: 440px !important;
        //            }

        //            .BookLeft {
        //                width: 440px !important;
        //            }

        //            .BookRight {
        //                width: 440px !important;
        //            }

        //            .Respo1Column {
        //                width: 420px !important;
        //            }

        //            .Respo2Column {
        //                width: 400px !important;
        //            }

        //            .Respo3Column {
        //                width: 400px !important;
        //            }

        //            .RespoTabletWidth {
        //                width: 400px !important;
        //            }

        //            .Respo2ColumnTablet {
        //                width: 400px !important;
        //            }
        //            /* Responsive Images  */
        //            .RespoImage1Col {
        //                width: 440px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage1ColW Img {
        //                width: 440px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2Col {
        //                width: 400px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2ColW Img {
        //                width: 400px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3Col {
        //                width: 400px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColW Img {
        //                width: 400px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColTablet {
        //                width: 400px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColWTablet Img {
        //                width: 400px !important;
        //                height: auto !important;
        //            }
        //            /* Responsive Images with Padding */
        //            .RespoImage1ColPadding {
        //                width: 400px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage1ColPaddingW Img {
        //                width: 400px !important;
        //                height: auto !important;
        //            }
        //            /* Responsive Framed Images */
        //            .RespoImage2ColFramed {
        //                width: 394px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2ColFramedW Img {
        //                width: 394px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColFramed {
        //                width: 394px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColFramedW Img {
        //                width: 394px !important;
        //                height: auto !important;
        //            }
        //            /* Responsive Tablet and Mobile Only */
        //            .RespoImage2ColTablet {
        //                width: 400px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2ColTabletW Img {
        //                width: 400px !important;
        //                height: auto !important;
        //            }
        //            /* Show/Hide  */
        //            .respo-hide-tablet {
        //                display: none !important;
        //            }

        //            .respo-show-tablet {
        //                display: block !important;
        //            }
        //            /* Responsive Text Align & Size */
        //            .Text_H1 {
        //                font-size: 36px !important;
        //                line-height: 125% !important;
        //            }

        //            .Text_H2 {
        //                font-size: 36px !important;
        //                line-height: 140% !important;
        //            }

        //            .Text_H3 {
        //                font-size: 14px !important;
        //                line-height: 150% !important;
        //                font-weight: normal !important;
        //            }

        //            .Text_H4 {
        //                font-size: 15px !important;
        //                line-height: 150% !important;
        //                font-weight: normal !important;
        //            }

        //            .respo-center-tablet {
        //                text-align: center !important;
        //            }

        //            .respo-spacer {
        //                height: 200px !important;
        //            }
        //        }

        //        /*-------------------------------------- Responsive 280px Mobile Attributes --------------------------------------*/
        //        @media only screen and (max-width: 480px) {
        //            body {
        //                width: auto !important;
        //            }
        //            /* Responsive Wrappers  */
        //            .BoxWrap {
        //                width: 280px !important;
        //            }

        //            .BookLeft {
        //                width: 280px !important;
        //            }

        //            .BookRight {
        //                width: 280px !important;
        //            }

        //            .Respo1Column {
        //                width: 260px !important;
        //            }

        //            .Respo2Column {
        //                width: 240px !important;
        //            }

        //            .Respo3Column {
        //                width: 240px !important;
        //            }

        //            .RespoTabletWidth {
        //                width: 240px !important;
        //            }

        //            .Respo2ColumnTablet {
        //                width: 240px !important;
        //            }
        //            /* Responsive Images  */
        //            .RespoImage1Col {
        //                width: 280px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage1ColW Img {
        //                width: 280px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2Col {
        //                width: 240px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2ColW Img {
        //                width: 240px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3Col {
        //                width: 240px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColW Img {
        //                width: 240px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColTablet {
        //                width: 240px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColWTablet Img {
        //                width: 240px !important;
        //                height: auto !important;
        //            }
        //            /* Responsive Images with Padding */
        //            .RespoImage1ColPadding {
        //                width: 240px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage1ColPaddingW Img {
        //                width: 240px !important;
        //                height: auto !important;
        //            }
        //            /* Responsive Framed Images */
        //            .RespoImage2ColFramed {
        //                width: 234px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2ColFramedW Img {
        //                width: 234px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColFramed {
        //                width: 234px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage3ColFramedW Img {
        //                width: 234px !important;
        //                height: auto !important;
        //            }
        //            /* Responsive Tablet and Mobile Only */
        //            .RespoImage2ColTablet {
        //                width: 240px !important;
        //                height: auto !important;
        //            }

        //            .RespoImage2ColTabletW Img {
        //                width: 240px !important;
        //                height: auto !important;
        //            }
        //            /* Show/Hide  */
        //            .respo-hide-mobile {
        //                display: none !important;
        //            }
        //            /* Responsive Text Align & Size */
        //            .Text_H1 {
        //                font-size: 24px !important;
        //                line-height: 125% !important;
        //            }

        //            .Text_H2 {
        //                font-size: 24px !important;
        //                line-height: 140% !important;
        //            }

        //            .Text_H3 {
        //                font-size: 18px !important;
        //                line-height: 150% !important;
        //                font-weight: normal !important;
        //            }

        //            .Text_H4 {
        //                font-size: 11px !important;
        //                line-height: 150% !important;
        //                font-weight: normal !important;
        //            }

        //            .respo-center-mobile {
        //                text-align: center !important;
        //            }

        //            .respo-spacer {
        //                height: 100px !important;
        //            }
        //        }
        //    </style>


        //</head>
        //<body>

        //    <!-- ********************************************************************************************************* -->
        //    <!-- Begin Module: 1 Column | NoPadding | NoBreak -->
        //    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        //        <tbody>
        //            <tr>
        //                <td align='center'>
        //                    <table class='BoxWrap' width='800' align='center' cellpadding='0' cellspacing='0'>
        //                        <tbody>
        //                            <tr>
        //                                <td height='20'></td>
        //                            </tr>
        //                            <tr>
        //                                <td>
        //                                    <table width='100%' cellpadding='0' cellspacing='0'>
        //                                        <tbody>
        //                                            <tr>
        //                                                <td class='Text_H3' style='text-align:center; color:#ffffff!important;' mc:edit='Text_H31'>
        //                                                    <span><i> </i></span>
        //                                                </td>
        //                                            </tr>
        //                                        </tbody>
        //                                    </table>
        //                                </td>
        //                            </tr>
        //                            <tr>
        //                                <td height='20'></td>
        //                            </tr>
        //                        </tbody>
        //                    </table>
        //                </td>
        //            </tr>
        //            <!-- End Module: 1 Column | NoPadding | NoBreak -->
        //        </tbody>
        //    </table>

        //    <!-- ********************************************************************************************************* -->
        //    <!-- Begin Module: 2 Column | Padding | BreakOnPC -->
        //    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        //        <tbody>
        //            <tr>
        //                <td align='center'>
        //                    <table class='BoxWrap BackgroundColor05 Rounded_Top' bgcolor='#DBDBDB' width='800' align='center' cellpadding='0' cellspacing='0'>
        //                        <tbody>
        //                            <tr>
        //                                <td colspan='3' width='100%' height='20'></td>
        //                            </tr>
        //                            <tr>
        //                                <td width='120' class='respo-margin'></td>
        //                                <td width='560'>
        //                                    <!-- // Begin: First Column \\ -->
        //                                    <table class='Respo1Column' align='left' cellpadding='0' cellspacing='0'>
        //                                        <tbody>
        //                                            <tr>
        //                                                <td width='75' class='Respo1Column' align='center' valign='top'>
        //                                                    <img mc:edit='' src='https://www.cecyteo.edu.mx/Nova/img/logocecyte.png' alt=' ' border=' 0' style='width: 75px; display: block;'>
        //                                                </td>
        //                                            </tr>
        //                                        </tbody>
        //                                    </table>
        //                                    <!-- // End: First Column \\ -->
        //                                    <!-- ************************** -->
        //                                    <!-- // Begin: Second Column \\ -->
        //                                    <table class='Respo1Column' align='right' cellpadding='0' cellspacing='0'>
        //                                        <tbody>
        //                                            <tr>
        //                                                <td>
        //                                                    <table align='center' cellpadding='0' cellspacing='0'>
        //                                                        <tbody>
        //                                                            <tr>
        //                                                                <td class='Text_H3' style='line-height:50px!important; color:#ffffff!important;' mc:edit='Text_H32'>

        //                                                                </td>
        //                                                            </tr>
        //                                                        </tbody>
        //                                                    </table>
        //                                                </td>
        //                                            </tr>
        //                                        </tbody>
        //                                    </table>
        //                                    <!-- // End: Second Column \\ -->
        //                                </td>
        //                                <td width='120' class='respo-margin'></td>
        //                            </tr>
        //                            <tr>
        //                                <td colspan='3' width='100%' height='20'></td>
        //                            </tr>
        //                        </tbody>
        //                    </table>
        //                </td>
        //            </tr>
        //            <!-- End Module: 2 Column | Padding | BreakOnPC -->
        //        </tbody>
        //    </table>

        //    <!-- ********************************************************************************************************* -->
        //    <!-- Begin Module: Caption - One Column Segment -->
        //    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        //        <tbody>
        //            <tr>
        //                <td align='center'>
        //                    <table class='BoxWrap fixed-bg-style BackgroundColor01' bgcolor='#ffffff' width='800' align='center' cellpadding='0' cellspacing='0'>
        //                        <tbody>
        //                            <tr>
        //                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
        //                            </tr>
        //                            <tr>
        //                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
        //                            </tr>
        //                            <tr>
        //                                <td width='120' class='respo-margin'></td>
        //                                <td class='RespoTabletWidth' width='560'>
        //                                    <table width='100%' cellpadding='0' cellspacing='0'>
        //                                        <tbody>
        //                                            <tr>
        //                                                <td class='Text_H1' style='text-align:center;' mc:edit='Text_H13'>
        //                                                    <span>Lo invitamos a formar parte del curso  " + item.Capacitacion_ctCurso.Curso + " del " + item.FechaInicioCurso.ToShortDateString() + " al " + item.FechaTerminoCurso.ToShortDateString() + @"</span>
        //                                                </td>
        //                                            </tr>
        //                                            <tr>
        //                                                <td width='100%' height='5'></td>
        //                                            </tr>
        //                                            <tr>
        //                                                <td class='Text_H3' style='text-align:center;' mc:edit='Text_H34'>
        //                                                    <span>" + item.Capacitacion_stConvocatoria.Convocatoria + " con vigencia del " + item.Capacitacion_stConvocatoria.FechaInicioConvocatoria.ToShortDateString() + " al " + item.Capacitacion_stConvocatoria.FechaTerminoConvocatoria.ToShortDateString() + @"</span>
        //                                                </td>
        //                                            </tr>
        //                                        </tbody>
        //                                    </table>
        //                                </td>
        //                                <td width='120' class='respo-margin'></td>
        //                            </tr>
        //                        </tbody>
        //                    </table>
        //                </td>
        //            </tr>
        //        </tbody>
        //    </table>

        //    <!-- Begin Module: Paragraph - One Column Segment -->
        //    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        //        <tbody>
        //            <tr>
        //                <td align='center'>
        //                    <table class='BoxWrap fixed-bg-style BackgroundColor05' bgcolor='#DBDBDB' width='800' align='center' cellpadding='0' cellspacing='0'>
        //                        <tbody>
        //                            <tr>
        //                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
        //                            </tr>
        //                            <tr>
        //                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
        //                            </tr>
        //                            <tr>
        //                                <td width='120' class='respo-margin'></td>
        //                                <td class='RespoTabletWidth' width='560'>
        //                                    <table width='100%' cellpadding='0' cellspacing='0'>
        //                                        <tbody>
        //                                            <tr>
        //                                                <td class='Text_H1 respo-center-tablet' style='color:#ffffff!important; text-align:center;' mc:edit='Text_H117'>

        //                                                </td>
        //                                            </tr>
        //                                            <tr>
        //                                                <td height='20'>&nbsp;</td>
        //                                            </tr>
        //                                            <!-- Button -->
        //                                            <tr>
        //                                                <td width='100%' align='center'>
        //                                                    <table class='BackgroundColor05 btn-style RespoTabletWidth' bgcolor='#DBDBDB' align='center' cellpadding='7' cellspacing='0' style='border-radius:4px;'>
        //                                                        <tbody style='background-color: #82BA00;'>
        //                                                            <tr>
        //                                                                <td>&nbsp; </td>
        //                                                                <td class='Text_H4' style='text-align: center; color:#ffffff; vertical-align: middle; text-transform:uppercase;' mc:edit='Text_H418'>
        //                                                                    <span style='color:#ffffff;'><a href='" + url + @"' style='text-align: center; color:#ffffff; vertical-align: middle; text-transform:uppercase;'>Ver mas información</a></span>
        //                                                                </td>
        //                                                                <td>&nbsp; </td>
        //                                                            </tr>
        //                                                        </tbody>
        //                                                    </table>
        //                                                </td>
        //                                            </tr>
        //                                        </tbody>
        //                                    </table>
        //                                </td>
        //                                <td width='120' class='respo-margin'></td>
        //                            </tr>
        //                            <tr>
        //                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
        //                            </tr>
        //                            <tr>
        //                                <td width='100%' colspan='3' height='20'>&nbsp;</td>
        //                            </tr>
        //                        </tbody>
        //                    </table>
        //                </td>
        //            </tr>
        //        </tbody>
        //    </table>
        //    <!-- End Module: Paragraph - One Column Segment -->
        //    <!-- ********************************************************************************************************* -->
        //    <!-- Begin Module: 2 Column | Padding | BreakOnPC -->
        //    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        //        <tbody>
        //            <tr>
        //                <td align='center'>
        //                    <table class='BoxWrap BackgroundColor01 Rounded_Bottom' bgcolor='#ffffff' width='800' align='center' cellpadding='0' cellspacing='0'>
        //                        <tbody>
        //                            <tr>
        //                                <td colspan='3' width='100%' height='20'></td>
        //                            </tr>
        //                            <tr>
        //                                <td width='120' class='respo-margin'></td>
        //                                <td width='560'>
        //                                    <!-- // Begin: First Column \\ -->
        //                                    <table class='Respo1Column' align='left' cellpadding='0' cellspacing='0'>
        //                                        <tbody>
        //                                            <tr>
        //                                                <td>
        //                                                    <table align='center' cellpadding='0' cellspacing='0'>
        //                                                        <tbody>
        //                                                            <tr>
        //                                                                <td class='Text_H3' style='line-height:50px!important; text-align:center;' mc:edit='Text_H319'>
        //                                                                    <span>Departamento de Sistemas | Departamento de Capacitación - " + DateTime.Now.Year + @" </span>
        //                                                                </td>
        //                                                            </tr>
        //                                                        </tbody>
        //                                                    </table>
        //                                                </td>
        //                                            </tr>
        //                                        </tbody>
        //                                    </table>
        //                                    <!-- // End: First Column \\ -->
        //                                    <!-- ************************** -->
        //                                    <!-- // Begin: Second Column \\ -->
        //                                    <table class='Respo1Column' align='right' cellpadding='0' cellspacing='0'>
        //                                        <tbody>
        //                                            <tr>
        //                                                <td>
        //                                                    <table align='center' cellpadding='0' cellspacing='0'>
        //                                                        <tbody>
        //                                                            <tr>
        //                                                                <td class='Text_H3' style='line-height:50px!important; text-align:center;' mc:edit='Text_H320'>
        //                                                                    <span><a href='https://www.cecyteo.edu.mx/Nova'>Sistema Nova - Cecyteo </a></span>
        //                                                                </td>
        //                                                            </tr>
        //                                                        </tbody>
        //                                                    </table>
        //                                                </td>
        //                                            </tr>
        //                                        </tbody>
        //                                    </table>
        //                                    <!-- // End: Second Column \\ -->
        //                                </td>
        //                                <td width='120' class='respo-margin'></td>
        //                            </tr>
        //                            <tr>
        //                                <td colspan='3' width='100%' height='20'></td>
        //                            </tr>
        //                        </tbody>
        //                    </table>
        //                </td>
        //            </tr>
        //            <!-- End Module: 2 Column | Padding | BreakOnPC -->
        //        </tbody>
        //    </table>

        //    <!-- ********************************************************************************************************* -->
        //    <!-- Begin Module: 1 Column | NoPadding | NoBreak -->
        //    <table width='100%' class='BackgroundColor04' bgcolor='#262a2b' cellpadding='0' cellspacing='0' border='0' style='table-layout: fixed; margin: 0 auto;'>
        //        <tbody>
        //            <tr>
        //                <td align='center'>
        //                    <table class='BoxWrap' width='800' align='center' cellpadding='0' cellspacing='0'>
        //                        <tbody>
        //                            <tr>
        //                                <td height='20'></td>
        //                            </tr>
        //                            <tr>
        //                                <td height='20'></td>
        //                            </tr>
        //                        </tbody>
        //                    </table>
        //                </td>
        //            </tr>
        //            <!-- End Module: 1 Column | NoPadding | NoBreak -->
        //        </tbody>
        //    </table>


        //</body>
        //</html>";
        //            //msg.Body = "<p>Estimado Trabajador</p><strong></strong><p>Para activar su cuenta para acceso al sistema NOVA del CECYTEO de clic en la siguiente liga <a href='" + url + "'>clic aquí</a> ";

        //            //msg.Body = msg.Body + " <p></p><p><strong>Cualquier duda o aclaración con este proceso favor de dirigirse con el Departamento de Sistemas a los teléfonos : (951) 666-666  ext. 666 de 08:00 a 16:00 horas de Lunes a Viernes.</strong></p> ";

        //            //msg.Body = msg.Body + " <p></p><p>Este correo fue generado automáticamente, favor de no responder.</p>";


        //            //  msg.Priority = MailPriority.High;

        //            SmtpClient client = new SmtpClient();


        //            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
        //            client.Host = "smtp.gmail.com";
        //            client.Port = 587;
        //            client.DeliveryMethod = SmtpDeliveryMethod.Network;
        //            client.EnableSsl = true;
        //            // client.UseDefaultCredentials = false;

        //            try
        //            {
        //                client.Send(msg);

        //            }
        //            catch (Exception)
        //            {
        //                regresa = false;
        //                // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
        //            }
        //            return regresa;
        //        }

    }
}