﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;
using Nova.Models.Calculos;
using Nova.Libraries;

namespace Nova.Models
{


    public sealed class SingletonAntiguedad
    {
        // AntiguedadTrabajador
        private static volatile SingletonAntiguedad instance;
        private static object syncRoot = new Object();
        private static bdAriesEntities db = new bdAriesEntities();
        private static bdNovaEntities dbNova = new bdNovaEntities();

        public static DateTime FechaNomina = DateTime.Now;

        public List<AntiguedadLaboralQuinquenioTrabajador> Trabajadores = new List<AntiguedadLaboralQuinquenioTrabajador>();


        private void setAntiguedad()
        {
            DateTime fecha = DateTime.Now;
            dbNova.Database.CommandTimeout = 0;
            // this:Trabajadores = db.vwPlanesEstudioAsignaturas.ToList();
            //this.campus = db.vwCampus.ToList();


            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"   SELECT IdTrabajador 
      , IdKardex 
      , FechaAsignacion 
  FROM   Kardex_ctTrabajador ";

            List<Kardex_ctTrabajador> trabajadoresbd = new List<Kardex_ctTrabajador>();

            List<vwDatosAspirantesTrabajadores> trabajadoresBajas = new List<vwDatosAspirantesTrabajadores>();

            string querybajas;

            querybajas = @"   SELECT * FROM   vwDatosAspirantesTrabajadores where EstatusTrabajador='BAJA' ";
            trabajadoresBajas = (List<vwDatosAspirantesTrabajadores>)dp.connection.Query<vwDatosAspirantesTrabajadores>(querybajas);

            trabajadoresbd = (List<Kardex_ctTrabajador>)dp.connection.Query<Kardex_ctTrabajador>(query);

            query = "select * from vwLicenciasTrabajadores where   TipoIncidenciaPermiso IN ('COMISIÓN','PERMISO')";
            var trabajadoresComisionados = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(query);

            var iddTrabajadoresVigentes = string.Join(",", trabajadoresbd
                                       .Select(p => p.IdTrabajador.ToString())); ;

            string query2 = @"
  SELeCT * FRoM 
  Convenios_SuplenciasControl a inner join [IncidenciaPermiso_stIncidenciaTrabajador] b
  on a.IdIncidenciaTrabajador=b.IdIncidenciaTrabajador 
  inner join Convenios_stConvenioLaboralTrabajadorCategoria z on
  z.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoriaAnterior
  inner join Convenios_stConvenioLaboralTrabajador x on
  z.IdConvenioLaboralTrabajador=x.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador y on y.IdTrabajador=x.IdTrabajador
  inner join [Catalogos_ctTipoIncidencia] c
   on c.IdTipoIncidencia=b.IdTipoIncidencia
   inner join Catalogos_ctTipoIncidenciaPermiso d
   on d.[IdTipoIncidenciaPermiso]=c.[IdTipoIncidenciaPermiso]
  where [IdConvenioLaboralTrabajadorCategoriaAnterior]
  in (select [IdConvenioLaboralTrabajadorCategoria] from
  [vwDatosAspirantesTrabajadoresHistorial]
  where idtrabajador in("+ iddTrabajadoresVigentes + @")
  
  )
  )";


            query = @"SELECT  IdConvenioLaboralTrabajadorCategoria
      ,a.IdConvenioLaboralTrabajador
      ,a.IdDistribucionPlazaCategoria
      ,a.IdEstructuraOrganica
      ,EsComisionado
      ,a.FechaInicio
      ,a.FechaTermino
      ,EsCancelado
      ,UserId
      ,FechaCreacion
      ,a.Observacion
      ,EsCuotaSindical
      ,FechaCuotaSindical
      ,IdTrabajador,g.ConvenioLaboral
  FROM Convenios_stConvenioLaboralTrabajadorCategoria a
  inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
  inner join Plazas_stDistribucionPlazaCategoria c on a.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
  inner join Plazas_ctCategoria d on d.IdCategoria=c.IdCategoria
  inner join Convenios_stRelacionConvenioLaboral e on e.IdRelacionConvenioLaboral=d.IdRelacionConvenioLaboral
    inner join Catalogos_ctConvenioLaboral g on g.IdConvenioLaboral=e.IdConvenioLaboral
where g.ConvenioLaboral NOT  IN ('HONORARIOS')
  order by IdTrabajador,a.FechaInicio,a.FechaTermino";

            List<ConveniosTrabajadores> convenios = new List<ConveniosTrabajadores>();

            convenios = (List<ConveniosTrabajadores>)dp.connection.Query<ConveniosTrabajadores>(query);

            
            List<TrabajadoresCalculosDias> diasantiguedadlaboral = new List<TrabajadoresCalculosDias>();

            string consulta = @"SELECT IdConvenioLaboralTrabajadorCategoria
  FROM vwDatosAspirantesTrabajadoresHistorial 
  where
 cast(IdTrabajador as nvarchar(10))+'-'+ cast(cast(fechainicio  as date)as nvarchar(10))+'-' + cast(cast(fechatermino as date) as nvarchar(10))  in 
   (select  cast(IdTrabajador as nvarchar(10))+'-'+cast(cast(fechainicioincidencia as date) as nvarchar(10)) + '-' + cast(cast(fechaterminoincidencia as date) as nvarchar(10))
   from vwLicenciasTrabajadores where (TipoIncidenciaPermiso='COMISIÓN' or Incidencia='LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA')
   )";
            consulta = @"SELECT   a.IdConvenioLaboralTrabajadorCategoria  FROM Convenios_SuplenciasControl a
left join  Nomina_SuplenciasSolicitudes b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
left join Nomina_SuplenciaTipo c on c.IdTipoSuplencia=b.IdTipoSuplencia
where (a.IdSuplenciaSolicitud is null  ) or (a.IdSuplenciaSolicitud is not null  and 
c.TipoSuplencia<>'POR NECESIDADES DEL CENTRO'
)";
            //         string consulta = @"SELECT IdConvenioLaboralTrabajadorCategoria
            //from vwLicenciasTrabajadores where  ESTATUS<>'ACTIVA' and (TipoIncidenciaPermiso='COMISIÓN' or Incidencia='LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA')";

            List<Int64> removercomisiones = new List<Int64>();
                         removercomisiones = (List<Int64>)dp.connection.Query<Int64>(consulta);


            foreach (var item in trabajadoresbd)
            {
  //              string consulta = @"SELECT IdConvenioLaboralTrabajadorCategoria
  //FROM vwDatosAspirantesTrabajadoresHistorial 
  //where
  //IdTrabajador="+item.IdTrabajador+ @"
  //and cast(cast(fechainicio  as date)as nvarchar(10))+'-' + cast(cast(fechatermino as date) as nvarchar(10))  in 
  // (select cast(cast(fechainicioincidencia as date) as nvarchar(10)) + '-' + cast(cast(fechaterminoincidencia as date) as nvarchar(10))
  // from vwLicenciasTrabajadores where IdTrabajador="+item.IdTrabajador + @" and  (TipoIncidenciaPermiso='COMISIÓN' or Incidencia='LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA')
  // )";
  //              List<Int64> removercomisiones = new List<Int64>();
  //              removercomisiones = (List<Int64>)dp.connection.Query<Int64>(consulta);

                List<ConveniosTrabajadores> puestos = convenios.Where(w => w.IdTrabajador == item.IdTrabajador && !removercomisiones.Contains(w.IdConvenioLaboralTrabajadorCategoria)).ToList();


                DateTime ultimoconvenio;
                    int ultimoConvenioLaboral = 0;
                int ultimoIdConvenioLaboralCategoria = 0;
                int c = puestos.Count;
                int i = 0;

                if (c > 0)
                {



                    if (c == 1)
                    {
                        //ultimoconvenio = puestos[0].IdConvenioLaboralTrabajadorCategoria;
                        var esbaja = trabajadoresBajas.Where(a => a.IdTrabajador == item.IdTrabajador).FirstOrDefault();
                        double dias = 0;
                        if (esbaja==null)
                        dias = (DateTime.Now - puestos[0].FechaInicio).TotalDays;
                        else
                            dias = (esbaja.FechaTermino.Value - puestos[0].FechaInicio).TotalDays;

                        diasantiguedadlaboral.Add(new TrabajadoresCalculosDias { IdTrabajador = item.IdTrabajador, Dias = (int)dias, DiasQuinquenio = (int)dias, IdConvenioLaboralTrabajador = puestos[0].IdConvenioLaboralTrabajador, IdConvenioLaboralTrabajadorCategoria = puestos[0].IdConvenioLaboralTrabajadorCategoria });
                    }
                    else
                    {
                        bool interrupcion = false;
                        ultimoconvenio = puestos[0].FechaInicio;
                        ultimoConvenioLaboral = puestos[0].IdConvenioLaboralTrabajador;
                        int totaldias = 0;
                        List<TrabajadoresCalculosDias> tempodias = new List<TrabajadoresCalculosDias>();

                        // con estas variables se identifica
                        //cuando hay un contrato que empiece con la misma
                        //fecha, esto se puede dar en caso de una comision
                        // asi no se debe de contar mas de una vez los dias
                        // de esos 2 registros y la fecha de inicio del quinquenio sea correcta
                        int fechasIgualesEntreConvenioAnteriorYActual = 0;
                        int fechasIgualesEntreConvenioAnteriorYActualAplicados = 0;

                        foreach (var ele in puestos)
                        {
                            i++;
                            double diasdiferencia = 0;

                            double diasporregistro = 0;

                            var existeComision = trabajadoresComisionados.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                            if (fechasIgualesEntreConvenioAnteriorYActual == fechasIgualesEntreConvenioAnteriorYActualAplicados)
                            {
                                if (ele.FechaTermino != null)
                                {
                                    if (ele.FechaTermino > DateTime.Now)
                                        diasporregistro = (DateTime.Now.AddDays(1) - (DateTime)ele.FechaInicio).TotalDays;
                                    else
                                        diasporregistro = ((DateTime)ele.FechaTermino - (DateTime)ele.FechaInicio).TotalDays;
                                }
                                else
                                    diasporregistro = (DateTime.Now - (DateTime)ele.FechaInicio).TotalDays;

                                totaldias = totaldias + (int)diasporregistro;


                                //if (i <= c)
                                //{
                                if (ele.FechaTermino != null)
                                //    diasdiferencia = (DateTime.Now - puestos[0].FechaInicio).TotalDays;
                                //else
                                {
                                    if (i < c)
                                        if (puestos[i].FechaInicio != ele.FechaInicio && (puestos[i].FechaInicio != puestos[i].FechaTermino))
                                        {
                                            diasdiferencia = ((DateTime)puestos[i].FechaInicio - (DateTime)ele.FechaTermino).TotalDays;

                                            if (Math.Ceiling(diasdiferencia) == 1)
                                                totaldias = totaldias + 1;
                                        }
                                        else
                                            fechasIgualesEntreConvenioAnteriorYActual = fechasIgualesEntreConvenioAnteriorYActual + 1;

                                }
                                else
                                {
                                    // VERIFICA SI EXISTEN COMISIONES
                                   // var existeComision = trabajadoresComisionados.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                                    if (i <= (puestos.Count() - 1))
                                        if ((puestos[i].FechaInicio == ele.FechaInicio) || existeComision != null)
                                        {
                                            fechasIgualesEntreConvenioAnteriorYActual = fechasIgualesEntreConvenioAnteriorYActual + 1;
                                        }
                                }
                            }
                            else
                                fechasIgualesEntreConvenioAnteriorYActualAplicados = fechasIgualesEntreConvenioAnteriorYActualAplicados + 1;

                            //}

                            if (diasdiferencia > 1 || diasdiferencia < 0)
                            {
                                interrupcion = true;
                                ultimoconvenio = puestos[i].FechaInicio;
                                ultimoConvenioLaboral = puestos[i].IdConvenioLaboralTrabajador;
                                ultimoIdConvenioLaboralCategoria = puestos[i].IdConvenioLaboralTrabajadorCategoria;
                                if (diasdiferencia > 1)
                                    totaldias = (int)diasporregistro;
                                else
                                    totaldias = totaldias - (int)diasporregistro;

                                diasporregistro = 0;
                            }

                            tempodias.Add(new TrabajadoresCalculosDias { IdTrabajador = ele.IdTrabajador, Dias = (int)diasporregistro, DiasQuinquenio = (int)diasporregistro, IdConvenioLaboralTrabajador = ele.IdConvenioLaboralTrabajador, IdConvenioLaboralTrabajadorCategoria = ele.IdConvenioLaboralTrabajadorCategoria });

                        }

                        if (interrupcion)
                        {
                            //var totalquinquenio = tempodias.Where(e => e.IdConvenioLaboralTrabajador == ultimoConvenioLaboral).Sum(e => e.Dias);
                            var totalquinquenio = totaldias;

                            diasantiguedadlaboral.Add(new TrabajadoresCalculosDias { IdTrabajador = item.IdTrabajador, Dias = (int)totaldias, DiasQuinquenio = (int)totalquinquenio, IdConvenioLaboralTrabajador = (short)ultimoConvenioLaboral, IdConvenioLaboralTrabajadorCategoria = ultimoIdConvenioLaboralCategoria });
                        }
                        else
                        {
                            //  double dias = (DateTime.Now - ultimoconvenio).TotalDays;
                            diasantiguedadlaboral.Add(new TrabajadoresCalculosDias { IdTrabajador = item.IdTrabajador, Dias = (int)totaldias, DiasQuinquenio = (int)totaldias, IdConvenioLaboralTrabajador = (short)ultimoConvenioLaboral, IdConvenioLaboralTrabajadorCategoria = ultimoIdConvenioLaboralCategoria });
                        }

                    }

                }//if count >0
            }

            query = @"select * from (
select q.*,w.IdIncidenciaTrabajador as IdIncidencia from(
 SELECT 
idtrabajador,a.IdIncidenciaTrabajador
 ,case when  a.FechaTermino>getdate() then  DATEDIFF(DAY, a.FechaInicio, getdate()) else  
                              DATEDIFF(DAY, a.FechaInicio, a.FechaTermino) end as dias
                          FROM IncidenciaPermiso_stIncidenciaTrabajador  a 
                          inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                          inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
                            INNER JOIN Catalogos_ctTipoIncidencia qq on a.IdTipoIncidencia=qq.IdTipoIncidencia
  inner join Catalogos_ctTipoIncidenciaPermiso ww on ww.IdTipoIncidenciaPermiso=qq.IdTipoIncidenciaPermiso
                          where  qq.EsPermiso=1 and qq.Incidencia in ('LICENCIA SIN GOCE DE SUELDO PARA ATENDER SITUACIONES PERSONALES','LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE ELECCIÓN POPULAR')
                          ) as q 
                           left join vwLicenciasTrabajadores w 
                           on q.IdTrabajador=w.IdTrabajador and w.IdIncidenciaTrabajador=q.IdIncidenciaTrabajador
                           and  ESTATUS<>'PROXIMA' 
                           ) as r where
                           IdIncidencia is not null";
           // int diasPermisos = dp.connection.ExecuteScalar<int>(query);
            List<DiasComisionesTrabajadores> diascomisiones = new List<DiasComisionesTrabajadores>();

            diascomisiones = (List<DiasComisionesTrabajadores>)dp.connection.Query<DiasComisionesTrabajadores>(query);


            Trabajadores.Clear();
            foreach (var item in diasantiguedadlaboral)
            {
                //                query = @" select case when sum(dias) is null then 0 else  SUM(dias) end  as dias
                //                        from (
                //                        SELECT 
                //                              --MODIF 08/05/2020 DATEDIFF(DAY, a.FechaInicio, a.FechaTermino) as dias
                // case when  a.FechaTermino>getdate() then  DATEDIFF(DAY, a.FechaInicio, getdate()) else  
                //                              DATEDIFF(DAY, a.FechaInicio, a.FechaTermino) end as dias
                //                          FROM IncidenciaPermiso_stIncidenciaTrabajador  a 
                //                          inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                //                          inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
                //                            INNER JOIN Catalogos_ctTipoIncidencia qq on a.IdTipoIncidencia=qq.IdTipoIncidencia
                //  inner join Catalogos_ctTipoIncidenciaPermiso ww on ww.IdTipoIncidenciaPermiso=qq.IdTipoIncidenciaPermiso
                //                          where qq.Incidencia in ('LICENCIA SIN GOCE DE SUELDO PARA ATENDER SITUACIONES PERSONALES','LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE ELECCIÓN POPULAR')
                //and a.IdIncidenciaTrabajador in (select IdIncidenciaTrabajador from vwLicenciasTrabajadores where IdTrabajador=" + item.IdTrabajador.ToString() + @" and ESTATUS<>'PROXIMA') 
                //                and qq.EsPermiso=1 and c.IdTrabajador=" + item.IdTrabajador.ToString() + ") as x";


                //                int diasPermisos = dp.connection.ExecuteScalar<int>(query);

                int diasPermisos = 0;
                var existendias=diascomisiones.Where(s => s.IdTrabajador == item.IdTrabajador).FirstOrDefault();

                if (existendias != null)
                    diasPermisos = diascomisiones.Where(s => s.IdTrabajador == item.IdTrabajador).Sum(a=>a.Dias);


                item.DiasQuinquenio = item.DiasQuinquenio - diasPermisos;

                DateTime diainicial = DateTime.Now.AddDays(-item.DiasQuinquenio);


                var dateSpan = DateTimeSpan.CompareDates(diainicial, DateTime.Now);




                AntiguedadLaboralQuinquenioTrabajador trabajador = new AntiguedadLaboralQuinquenioTrabajador();
                trabajador.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                trabajador.IdTrabajador = item.IdTrabajador;
                trabajador.AñosQuinquenio = dateSpan.Years;
                trabajador.MesesQuinquenio = dateSpan.Months;
                trabajador.DiasQuinquenio = dateSpan.Days;
                trabajador.FechaInicioQuinquenio = diainicial;




                DateTime inicialLaboral = DateTime.Now.AddDays(-item.Dias);
                var dateLaboral = DateTimeSpan.CompareDates(inicialLaboral, DateTime.Now);

                trabajador.AñosLaboral = dateLaboral.Years;
                trabajador.MesesLaboral = dateLaboral.Months;
                trabajador.DiasLaboral = dateLaboral.Days;
                Trabajadores.Add(trabajador);

            }





        }
        public void Reset()

        {

            setAntiguedad();
        }
        private SingletonAntiguedad()
        {

            // setAntiguedad();

        }

        public static SingletonAntiguedad Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new SingletonAntiguedad();


                    }
                }

                //if (fecha.ToShortDateString()!=DateTime.Now.ToShortDateString())
                //{ instance.Reset(); 

                //}
                return instance;
            }
        }

        public AntiguedadLaboralQuinquenioTrabajador getAntiguedad(int IdTrabajador)
        {

            return Trabajadores.Where(e => e.IdTrabajador == IdTrabajador).FirstOrDefault();
        }






    }

    class DateDiff
    {
        public DateDiff(DateTime startDate, DateTime endDate)
        {
            GetYears(startDate, endDate); // Get the Number of Years Difference between two dates
            GetMonths(startDate.AddYears(YearsDiff), endDate); // Getting the Number of Months Difference but using the Years difference earlier
            GetDays(startDate.AddYears(YearsDiff).AddMonths(MonthsDiff), endDate); // Getting the Number of Days Difference but using Years and Months difference earlier
        }
        void GetYears(DateTime startDate, DateTime endDate)
        {
            int Years = 0;
            // Traverse until start date parameter is beyond the end date parameter
            while (endDate.CompareTo(startDate.AddYears(++Years)) >= 0) { }
            YearsDiff = --Years; // Deduct the extra 1 Year and save to YearsDiff property
        }
        void GetMonths(DateTime startDate, DateTime endDate)
        {
            // Provide your own code here
        }
        void GetDays(DateTime startDate, DateTime endDate)
        {
            // Provided your own code here
        }

        public int YearsDiff { get; set; }
        public int MonthsDiff { get; set; }
        public int DaysDiff { get; set; }
    }

    public class TrabajadoresCalculosDias
    {


        public int IdTrabajador { get; set; }
        public int Dias { get; set; }
        public int DiasQuinquenio { get; set; }
        public short IdConvenioLaboralTrabajador { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
    }

    public class DiasComisionesTrabajadores
    {

        public int IdTrabajador { get; set; }
        public int IdIncidenciaTrabajador { get; set; }
        public int Dias { get; set; }
        public int IdIncidencia  { get; set; }
       
    }
        public class ConveniosTrabajadores
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public short IdConvenioLaboralTrabajador { get; set; }
        public int IdDistribucionPlazaCategoria { get; set; }
        public short IdEstructuraOrganica { get; set; }
        public bool EsComisionado { get; set; }
        public System.DateTime FechaInicio { get; set; }
        public Nullable<System.DateTime> FechaTermino { get; set; }
        public bool EsCancelado { get; set; }
        public int UserId { get; set; }
        public System.DateTime FechaCreacion { get; set; }
        public string Observacion { get; set; }
        public bool EsCuotaSindical { get; set; }
        public Nullable<System.DateTime> FechaCuotaSindical { get; set; }
        public int IdTrabajador { get; set; }
        public string ConvenioLaboral { get; set; }

    }

    public struct DateTimeSpan

    {

        private readonly int years;

        private readonly int months;

        private readonly int days;

        private readonly int hours;

        private readonly int minutes;

        private readonly int seconds;

        private readonly int milliseconds;



        public DateTimeSpan(int years, int months, int days, int hours, int minutes, int seconds, int milliseconds)

        {

            this.years = years;

            this.months = months;

            this.days = days;

            this.hours = hours;

            this.minutes = minutes;

            this.seconds = seconds;

            this.milliseconds = milliseconds;

        }



        public int Years { get { return years; } }

        public int Months { get { return months; } }

        public int Days { get { return days; } }

        public int Hours { get { return hours; } }

        public int Minutes { get { return minutes; } }

        public int Seconds { get { return seconds; } }

        public int Milliseconds { get { return milliseconds; } }



        enum Phase { Years, Months, Days, Done }

        public static DateTimeSpan DateDiffYMD(DateTime f1, DateTime f2)
        {
            
            int numberOfDays =(int) Math.Round((f2 - f1).TotalDays);
            DateTime date = new DateTime(new TimeSpan(numberOfDays, 0, 0, 0).Ticks);
            string dateUntil = string.Format("{0} year(s), {1} month(s) and {2} day(s)", date.Year - 1, date.Month - 1, date.Day - 1);

            DateTimeSpan spanResult = new DateTimeSpan(date.Year - 1, date.Month - 1, date.Day - 1, 0, 0, 0, 0);

            return spanResult;
        }

            public static DateTimeSpan DateDiff(DateTime dt1, DateTime dt2)
        {

            DateTime zeroTime = new DateTime(1, 1, 1);

            int leapDaysInBetween = CountLeapDays(dt1, dt2);

            TimeSpan span = dt2 - dt1;

            int years = (zeroTime + span).Year - 1;
            int months = (zeroTime + span).Month - 1;
            int days = (zeroTime + span).Day - (leapDaysInBetween % 2 == 1 ? 1 : 0);
            int weeks = days / 7;
            int remainingdays = days % 7;

            //   Console.WriteLine(String.Format("\nThe difference between date {0} and date {1} is: \n\t {2} year(s), {3} month(s), and {4} day(s).", dt1, dt2, years, months, days));
            //  Console.WriteLine(String.Format("\nThe difference between date {0} and date {1} is: \n\t {2} year(s), {3} month(s), {4} week(s) and {5} day(s).", dt1, dt2, years, months, weeks, remainingdays));

            DateTimeSpan spanResult = new DateTimeSpan(years, months, days, 0, 0, 0, 0);

            return spanResult;
        }

        private static int CountLeapDays(DateTime dt1, DateTime dt2)
        {
            int leapDaysInBetween = 0;
            int year1 = dt1.Year, year2 = dt2.Year;
            DateTime dateValue;

            for (int i = year1; i <= year2; i++)
            {
                if (DateTime.TryParse("02/29/" + i.ToString(), out dateValue))
                {
                    if (dateValue >= dt1 && dateValue <= dt2)
                        leapDaysInBetween++;
                }
            }

            return leapDaysInBetween;
        }



        public static DateTimeSpan CompareDates(DateTime date1, DateTime date2)

        {

            //if (date2 < date1)

            //{

            //    var sub = date1;

            //    date1 = date2;

            //    date2 = sub;

            //}



            //DateTime current = date1;

            //int years = 0;

            //int months = 0;

            //int days = 0;



            //Phase phase = Phase.Years;

            //DateTimeSpan span = new DateTimeSpan();



            //while (phase != Phase.Done)

            //{

            //    switch (phase)

            //    {

            //        case Phase.Years:

            //            if (current.AddYears(years + 1) > date2)

            //            {

            //                phase = Phase.Months;

            //                current = current.AddYears(years);

            //            }

            //            else

            //            {

            //                years++;

            //            }

            //            break;

            //        case Phase.Months:

            //            if (current.AddMonths(months + 1) > date2)

            //            {

            //                phase = Phase.Days;

            //                current = current.AddMonths(months);

            //            }

            //            else

            //            {

            //                months++;

            //            }

            //            break;

            //        case Phase.Days:

            //            if (current.AddDays(days + 1) > date2)

            //            {

            //                current = current.AddDays(days);

            //                var timespan = date2 - current;

            //                span = new DateTimeSpan(years, months, days, timespan.Hours, timespan.Minutes, timespan.Seconds, timespan.Milliseconds);

            //                phase = Phase.Done;

            //            }

            //            else

            //            {

            //                days++;

            //            }

            //            break;

            //    }

            //}



            //return span;


            int oldMonth = date2.Month;
            while (oldMonth == date2.Month)
            {
                date1 = date1.AddDays(-1);
                date2 = date2.AddDays(-1);
            }

            int years = 0, months = 0, days = 0, hours = 0, minutes = 0, seconds = 0, milliseconds = 0;

            // getting number of years
            while (date2.CompareTo(date1) >= 0)
            {
                years++;
                date2 = date2.AddYears(-1);
            }
            date2 = date2.AddYears(1);
            years--;


            // getting number of months and days
            oldMonth = date2.Month;
            while (date2.CompareTo(date1) >= 0)
            {
                days++;
                date2 = date2.AddDays(-1);
                if ((date2.CompareTo(date1) >= 0) && (oldMonth != date2.Month))
                {
                    months++;
                    days = 0;
                    oldMonth = date2.Month;
                }
            }
            date2 = date2.AddDays(1);
            days--;

            DateTimeSpan span = new DateTimeSpan(years,months,days,0,0,0,0);

            return span;
            // TimeSpan difference =(DateTimeSpan) date2.Subtract(date1);


        }

    }

    public class AntiguedadLaboralQuinquenioTrabajador
    {
        public int IdTrabajador { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int AñosLaboral { get; set; }
        public int MesesLaboral { get; set; }
        public int DiasLaboral { get; set; }
        public int AñosQuinquenio { get; set; }
        public int MesesQuinquenio { get; set; }
        public int DiasQuinquenio { get; set; }
        public DateTime FechaInicioQuinquenio { get; set; }


    }
}