﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Nomina;

namespace Nova.Models.Calculos.Percepciones
{
   
    public class SuperacionAcademica : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {

            var percepciones = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina_stNomina.IdPlantillaNomina && x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA LA SUPERACIÓN ACADÉMICA").FirstOrDefault();

                if (percepciones != null)
                if (percepciones.Calcular)
                {
                int HorasJornada = 0;


                int HorasExcedentes = 0;


                int totaleshoras = 0;


                int totaleshorasClub = 0;
                if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                    if (NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes == "18" || NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")
                    {
                        Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();


                        if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.ToString());


                        var resul = NominaTrabajador.HorariosVigenteAnteriorTrabajador;




                        Nomina_DocentesHorasPago horario = NominaTrabajador.ListaNomina_DocentesHorasPago.Where(c => c.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();



                        if (resul.TieneHorario)

                        {
                            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado == false)
                            {

                                foreach (var dat in resul.NominaHorariosDocentesDetalle)
                                {

                                    if (dat.TipoHoras == "HORAS CLUB")

                                        totaleshorasClub = totaleshorasClub + (int)dat.Horas;

                                    else
                                        totaleshoras = totaleshoras + (int)dat.Horas;
                                }

                            }
                            else
                            {
                                foreach (var dat in resul.NominaHorariosDocentesDetalle)
                                {
                                    if (dat.TipoHoras == "HORAS CLUB")

                                        totaleshorasClub = totaleshorasClub + (int)dat.Horas;

                                    else
                                        totaleshoras = totaleshoras + (int)dat.Horas;


                                }




                            }




                        }
                        else if (horario != null)
                        {
                            totaleshoras = (short)horario.TotalHorasPago;
                            totaleshorasClub = horario.HorasClub;
                        }


                        // solo aplica para horas totales sin restar nada



                        decimal importedividido = 0;

                        if (totaleshoras < 20)
                        {
                            importedividido = (decimal)NominaTrabajador.ParametrosRelacionLaboral.SuperacionAcademicaHasta19 / 2;
                        }
                        else
                            if (totaleshoras >= 20 && totaleshoras < 40)
                        {
                            importedividido = (decimal)NominaTrabajador.ParametrosRelacionLaboral.SuperacionAcademica2039 / 2;
                        }
                        else
                        {
                            importedividido = (decimal)NominaTrabajador.ParametrosRelacionLaboral.SuperacionAcademica40 / 2;
                        }

                        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA LA SUPERACIÓN ACADÉMICA").FirstOrDefault().IdPlantillaNominaPercepcion;
                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA LA SUPERACIÓN ACADÉMICA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                        percepcion.Importe = importedividido;

                        percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA LA SUPERACIÓN ACADÉMICA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                    }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }

   

}