﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class SueldoRetroactivo : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

            int idtrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador;
            NominaTrabajador.CostoPorHora = NominaTrabajador.CostoHoraJornada.CostoPorHora;
            NominaTrabajador.CostoPorHoraExcedente = NominaTrabajador.CostoHoraJornada.CostoPorHoraExcedente;
            //Costo horas interinas
            NominaTrabajador.CostoPorHorasInterinas = 0;



            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
            percepcion.IdNomina = NominaTrabajador.IdNomina;
            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;
            Decimal porcentajeincremento = (decimal)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Porcentaje;
            bdNovaEntities bd = new bdNovaEntities();
            Decimal importeyapagadopercepcion = bd.Percepciones_stNominaTrabajadorPercepciones.Where(z => z.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion == "SUELDO"
                && z.Nomina_stNominaTrabajador.Nomina_stNomina.FechaInicio >= NominaTrabajador.Nomina.FechaInicio
                && z.Nomina_stNominaTrabajador.Nomina_stNomina.FechaTermino <= NominaTrabajador.Nomina.FechaTermino
                && z.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idtrabajador).Sum(x => x.Importe);
            //percepcion.Importe = NominaTrabajador.CostoPorHora * NominaTrabajador.DiasPagados * NominaTrabajador.JornadaLaboral.HorasMaximo;
            percepcion.Importe = importeyapagadopercepcion * porcentajeincremento;
            percepcion.Tipo = "RETROACTIVO";
            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().EsGravable;
            percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
            percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


        }
        public void Grabar(Nomina_stNominaTrabajador NominaTrabajador)
        {
            //foreach (var percepcion in NominaTrabajador.ListaPercepcionesTrabajadores)
            //{
            //    Percepciones_stNominaTrabajadorPercepciones pnt = new Percepciones_stNominaTrabajadorPercepciones();
            //    pnt.IdNominaTrabajador = percepcion;
            //}



        }

    }


    //public class Sueldo:ISueldo
    //{

    //    private decimal costoporhora=0,sueldo=0;
    //    private int horasjornada = 0;
    //    private int DiasNomina = 0;
    //    private int IdNomina = 0;
    //    private short IdPlantillaNominaPercepcion;
    //    public PercepcionesNominaTrabajador Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
    //    {

    //        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

    //        this.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;

    //        this.DiasNomina=NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.Dias;
    //        this.IdNomina = NominaTrabajador.Nomina.IdNomina;

    //        horasjornada = NominaTrabajador.JornadaLaboral.HorasMaximo;
    //        costoporhora = NominaTrabajador.CostoHoraJornada.CostoPorHora;
    //        NominaTrabajador.CostoPorHora = costoporhora;
    //        NominaTrabajador.CostoPorHoraExcedente = NominaTrabajador.CostoHoraJornada.CostoPorHoraExcedente;
    //        //Costo horas interinas
    //        NominaTrabajador.CostoPorHorasInterinas=0;

    //        sueldo = costoporhora * this.DiasNomina * horasjornada;

    //        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
    //        percepcion.IdNomina = this.IdNomina;
    //        percepcion.IdPlantillaNominaPercepcion = this.IdPlantillaNominaPercepcion;
    //        percepcion.Importe = sueldo;

    //        return percepcion;
    //    }


    //}
}