﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class SueldoMandoMedio : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault() != null)
            {
                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.ToString());

                NominaTrabajador.CostoPorHora = costos.CostoPorHora;
                NominaTrabajador.CostoPorHoraExcedente = 0;
                //Costo horas interinas
                NominaTrabajador.CostoPorHorasInterinas = 0;



                percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                percepcion.IdNomina = NominaTrabajador.IdNomina;
                percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;
                percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;



                //var permiso = NominaTrabajador.ListaVariablesNominaTrabajador.Where(d => d.Concepto == "PERMISOGOCESUELDO" && d.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                //if (permiso!=null)
                //    //dias pagados
                //   NominaTrabajador.DiasPagados=(short)permiso.Importe ;
                var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;
                NominaTrabajador.DiasPagados = (short)diaslaborados;

                // percepcion.Importe = ((costos.CostoPorHora * NominaTrabajador.DiasNomina * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina;
                percepcion.Importe = ((costos.CostoPorHora * NominaTrabajador.DiasNomina * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina;

                percepcion.Tipo = "NORMAL";
                percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;


                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

            }
        }
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }
}