﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class Sueldo : IPercepcionBehavior
    {
        private void CalcularDiferenciasCreditos(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {

            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.AplicaCalculoCreditos)
            {
                decimal VecesSalarioMinimo = 0, CuotaFija = 0, Porcentaje = 0, Infonavit, sueldoRemanente = 0;

                //sueldoRemanente = NominaTrabajador.ListaVariablesNominaTrabajador.Where(c => c.Concepto == "SUELDO REMANENTE PENSION" && c.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe;

                string qna = NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes;

                var Remanente = NominaTrabajador.ListaVariablesNominaTrabajador.Where(c => c.Concepto == "SUELDO REMANENTE PENSION" && c.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                ////////
                ///
                if (Remanente == null)
                {
                    var iddeduccionisr = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault().IdPlantillaNominaDeduccion;

                    //var iddeduccionsubsidio = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaDeduccion;

                    var iddeduccionsubsidio = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    DeduccionesNominaTrabajador ISR = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaDeduccion == iddeduccionisr).FirstOrDefault();

                    if (ISR == null)
                    //    ISR = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaDeduccion == iddeduccionsubsidio).FirstOrDefault();
                    {
                        var subsidio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaPercepcion== iddeduccionsubsidio).FirstOrDefault();
                        DeduccionesNominaTrabajador isrtempo = new DeduccionesNominaTrabajador();
                        if (subsidio != null)
                        {
                            isrtempo.Importe = subsidio.Importe;
                            ISR = isrtempo;
                                }
                    }

                    DeduccionesNominaTrabajador IMSS = null;
                    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null)
                        IMSS = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaDeduccion == NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault().IdPlantillaNominaDeduccion).FirstOrDefault();

                    decimal remanente = 0;

                    if (ISR != null)
                    {
                        if (IMSS != null)
                            remanente = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(x => x.Importe) - ISR.Importe - IMSS.Importe;
                        else
                            remanente = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(x => x.Importe) - ISR.Importe;
                    }

                    sueldoRemanente = remanente;
                }

                var miscreditoslista = NominaTrabajador.CreditosTrabajador.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();

                foreach (var item in miscreditoslista)
                {

                    decimal totalcreditos = 0;
                    CreditosTrabajador micredito = new CreditosTrabajador();
                    micredito.IdCreditoTrabajador = item.IdCreditoTrabajador;

                    micredito.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;


                    if (item.Catalogos_ctTipoCredito.TipoCredito == "CRÉDITO FONACOT")
                    {
                        if (item.Saldo != 0)
                        {

                            decimal descuentoqnal = Math.Round((decimal)(item.CuotaFija / 2), 2);
                            if (item.Saldo < descuentoqnal)
                            {
                                descuentoqnal = (decimal)item.Saldo;
                            }
                            else
                                if (Convert.ToInt16(qna) % 2 == 0)
                            {
                                descuentoqnal = (decimal)item.CuotaFija - (descuentoqnal);
                            }

                            if (item.Saldo != null)
                            {
                                micredito.Saldo = (decimal)item.Saldo - descuentoqnal;
                            }

                            totalcreditos = descuentoqnal;
                            micredito.Importe = totalcreditos;
                        }
                    }
                    else
                        if (item.Catalogos_ctTipoCredito.TipoCredito == "INFONAVIT")
                    {
                        //if (NominaTrabajador.CreditosTrabajador.Where(c => c.Catalogos_ctTipoCredito.TipoCredito == "CRÉDITO INFONAVIT").SingleOrDefault().VecesSalarioMinimo != null)
                        if (item.VecesSalarioMinimo != null)
                        {
                            VecesSalarioMinimo = Convert.ToDecimal(item.VecesSalarioMinimo.Value);
                            //VecesSalarioMinimo = VecesSalarioMinimo + (VecesSalarioMinimo*2);
                        }
                        else if (item.CuotaFija != null)
                            CuotaFija = Convert.ToDecimal(item.CuotaFija.Value);
                        else if (item.Porcentaje != null)
                            Porcentaje = Convert.ToDecimal(item.Porcentaje.Value);
                        else
                            throw new Exception("Error con el cálculo del crédito infonavit del trabajador: " + NominaTrabajador.TrabajadorSelccionado.IdConvenioLaboralTrabajadorCategoria.ToString());

                        if (VecesSalarioMinimo != 0)
                        {
                            if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "MENSUAL")
                            {
                                totalcreditos = (((NominaTrabajador.ctUMI.Monto * VecesSalarioMinimo) / 2) + 3.75M);

                            }
                            else
                            {
                                totalcreditos = (((NominaTrabajador.ctUMI.Monto * VecesSalarioMinimo)) + 3.75M);

                            }
                        }

                        else
                        if (CuotaFija != 0)
                        {


                            if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "MENSUAL")
                            {
                                totalcreditos = (CuotaFija / 2);

                                if (Convert.ToInt16(qna) % 2 == 0)
                                {
                                    totalcreditos = (decimal)item.CuotaFija - (totalcreditos);
                                }
                                totalcreditos = totalcreditos + 3.75M;
                            }
                            else
                                totalcreditos = CuotaFija + 3.75M;
                        }

                        else
                        {
                            try
                            {
                                totalcreditos = NominaTrabajador.ListaVariablesNominaTrabajador.Where(c =>
                              c.Concepto == "SALARIO DIARIO INTEGRADO"
                              && c.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria)
                              .SingleOrDefault().Importe * (Porcentaje / 100);
                            }
                            catch (Exception e)
                            {

                                var a = e;
                            }
                            

                            if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "QUINCENAL")
                            {
                                totalcreditos = (((totalcreditos) / 2));

                            }

                        }



                    }
                    else
                    {
                        if (item.Saldo != 0 || item.Catalogos_ctTipoCredito.Deducciones_ctDeduccion.Deduccion == "SEGURO DE VIDA")
                        {
                            if (item.VecesSalarioMinimo != null)
                            {
                                totalcreditos = totalcreditos + (decimal)(item.VecesSalarioMinimo * NominaTrabajador.SalarioMinimoDF.Monto);

                            }
                            else
                                if (item.CuotaFija != null)
                            {
                                totalcreditos = totalcreditos + (decimal)item.CuotaFija;
                            }
                            else
                                    if (item.Porcentaje != null)
                            {
                                totalcreditos = totalcreditos + (decimal)item.Porcentaje * NominaTrabajador.SueldoBruto;
                            }

                            if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "MENSUAL")
                            {
                                totalcreditos = (((totalcreditos) / 2));

                            }

                            if (item.Saldo != null)
                                micredito.Saldo = (decimal)item.Saldo - totalcreditos;


                        }
                    }

                    micredito.Importe = 0;
                    if (NominaTrabajador.DiasPagados > 0)
                    {
                        if ((sueldoRemanente - totalcreditos) > 0)
                            micredito.Importe = totalcreditos;

                        sueldoRemanente = sueldoRemanente - totalcreditos;



                    }

                    //solo si le alcanza lo agrega como dedución
                    if (totalcreditos > 0 )

                    {
                        

                        if (totalcreditos > 0)
                        {
                          

                            //devoluciones
                            if (item.EsParaDevolucion == true && item.EsYaDevuelto == false)
                            {

                                var diasremanentes = (NominaTrabajador.Nomina.FechaInicio - (DateTime)item.FechaTermino).TotalDays;

                                decimal importe100 = 0M;
                                if (diasremanentes > 0)
                                {
                                    importe100 = Math.Round((totalcreditos * (decimal)diasremanentes) / 15, 2);




                                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    percepcion.Importe = importe100;

                                    percepcion.Tipo = "NORMAL";
                                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                    percepcion.Concepto = item.Catalogos_ctTipoCredito.TipoCredito;
                                    percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                    percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                                }
                            }
                        }
                    }





                }

            }


        }
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault() != null)
            {
                
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x =>   x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault();
                if (percepcionCalculo.Calcular && !percepcionCalculo.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") )

                {
                    var apoyoNomina = NominaTrabajador.ListaNominaApoyoEstudios.Where(z => z.IdTrabajador== ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    Decimal PorcentajeApoyo = 0M;
                    if (apoyoNomina != null)
                        PorcentajeApoyo = apoyoNomina.PorcentajeApoyo;


                   



                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.ToString());

                    NominaTrabajador.CostoPorHora = costos.CostoPorHora;
                    NominaTrabajador.CostoPorHoraExcedente = costos.CostoPorHoraExcedente;
                    //Costo horas interinas
                    NominaTrabajador.CostoPorHorasInterinas = 0;
                    decimal diaslaborados = 0;
                    try
                    {
                          diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;
                    }
                    catch (Exception es)
                    {

                        throw new Exception($"error en el convenio al culcular sueldo {ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria}");
                    }
                    
                    NominaTrabajador.DiasPagados = (short)diaslaborados;

                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                    VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                    vnt4.Concepto = "DiasPagados";
                    vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    vnt4.Importe = NominaTrabajador.DiasPagados;
                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);
                    var jornada = NominaTrabajador.JornadasLaborales.Where(s => s.IdJornadaLaboral == costos.Plazas_ctCategoria.IdJornadaLaboral).FirstOrDefault();
                    percepcion.Importe = ((costos.CostoPorHora * NominaTrabajador.DiasNomina * jornada.HorasMaximo) * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina;

                    //sueldo al N %
                    if (PorcentajeApoyo > 0)
                        percepcion.Importe = (PorcentajeApoyo * percepcion.Importe) / 100;


                    if (
                    NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "01"
                    && NominaTrabajador.Nomina_stNomina.Año == 2024)
                    {
                        if (ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == 9118)
                        {
                            percepcion.Importe = 9793.83M;
                           
                        }

                        if (ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == 9113)
                        {
                            percepcion.Importe = 9793.83M;
                        }
                    }

                    percepcion.Tipo = "NORMAL";

                    VariablesNominaTrabajador vnt11 = new VariablesNominaTrabajador();
                    vnt11.Concepto = "ajustepercepciones";
                    vnt11.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;

                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt11);

                    bool ajuste = false;
                    if (ConvenioLaboralTrabajadorCategoria.FechaTermino != null)
                        if (ConvenioLaboralTrabajadorCategoria.FechaTermino <= NominaTrabajador.Nomina_stNomina.FechaInicio)
                            if (diaslaborados > NominaTrabajador.Nomina_stNomina.DiasNomina)
                            {
                                ajuste = true;
                            }

                    if (ajuste)
                    {
                        PercepcionesNominaTrabajador percepcion2 = new PercepcionesNominaTrabajador();

                        percepcion2.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcion2.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
                        percepcion2.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().IdPlantillaNominaPercepcion;
                        percepcion2.Importe = percepcion.Importe;

                        percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                        percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;

                        percepcion2.Tipo = "NORMAL";
                        percepcion2.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                        percepcion2.Concepto = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.Percepcion;
                        percepcion2.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                        percepcion2.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion2);

                       
                    }

                    else
                    {
                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;




                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                        percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                        percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;


                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                    }

                }

               // CalcularDiferenciasCreditos(ConvenioLaboralTrabajadorCategoria, NominaTrabajador, per);
            }
        }
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }
}