﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class QuinquenioHomologados : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "SUPERVISOR" ||
                ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "INGENIERO EN SISTEMAS" ||
                ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "SECRETARIA DE DIRECTOR DE AREA" ||
                ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "SECRETARIA DE DIRECTOR GENERAL" ||
                ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "COOR. DE TECNICOS ESPECIALIZADOS" ||
                ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("RESPONSABLE DE CENTRO") ||
             ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("SUBDIRECTOR DE CENTRO EMSAD"))
            {
                percepcion.Importe = ImporteQuinquenioTrabajadorHomologados(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                if (percepcion.Importe != 0)
                {
                    

                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                    percepcion.Tipo = "NORMAL";
                    percepcion.EsPrevisionSocial = false;
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                }

            }
        }

        private decimal ImporteQuinquenioTrabajadorHomologados(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            int idtrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador;
             
            decimal SueldoQuincenal = NominaTrabajador.ListaPercepcionesTrabajadores.Where(lp => lp.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && lp.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion).SingleOrDefault().Importe
            , Importe = 0;



            //SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

            //AntiguedadLaboralQuinquenioTrabajador quinquenio = antiguedad.getAntiguedad(idtrabajador);



            //double diferencia = (DateTime.Now  - NominaTrabajador.Nomina_stNomina.FechaTermino    ).TotalDays;

            //quinquenio.FechaInicioQuinquenio = quinquenio.FechaInicioQuinquenio.AddDays(diferencia);
            //var quinquenioNomina = DateTimeSpan.CompareDates(quinquenio.FechaInicioQuinquenio, DateTime.Now);

            var quinquenioNomina = NominaTrabajador.QuinquenioTrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);


            if (quinquenioNomina.Years >= NominaTrabajador.ParametrosRelacionLaboral.AñosQuinquenio)
            {
                if (quinquenioNomina.Years >= 21)
                    Importe = SueldoQuincenal * (0.025M * quinquenioNomina.Years);
                else
                    Importe = SueldoQuincenal * (Convert.ToDecimal(NominaTrabajador.ParametrosRelacionLaboral.PorcentajeQuinquenio) * quinquenioNomina.Years);
            }
            
            

            return Importe;
        }




        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }

}