﻿using Dapper;
using Nova.Libraries;
using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Calculos.Percepciones
{
    public class PuntualidadyAsistenciaDocente: IPercepcionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA").FirstOrDefault();
            if (percepcionCalculo!=null)
            if (percepcionCalculo.Calcular)

            {
                    var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    var ultimocontrato = NominaTrabajador.PartesProporcionalesUltimoContrato.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                     && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();


                    if (NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "14" 
                        || NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "24"
                         || (solicitud != null && ultimocontrato != null
                         && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                        
                        )
                {

                        //SingletonAntiguedad antiguedadMeses = SingletonAntiguedad.Instance;

                        //AntiguedadLaboralQuinquenioTrabajador antiguedadtrabajadorMeses = antiguedadMeses.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                        //var tiempoMeses = DateTimeSpan.CompareDates(antiguedadtrabajadorMeses.FechaInicioQuinquenio, NominaTrabajador.Nomina.FechaTermino.AddDays(1));
                        var tiempoMeses = NominaTrabajador.TrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);


                        if (tiempoMeses.Years > 0 || (tiempoMeses.Years == 0 && tiempoMeses.Months > 5 && tiempoMeses.Days > 0))
                        {
                            var perdioPuntualidad = NominaTrabajador.TrabajadoresPuntualidadYAsistenciaPerdidas.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                            

                            decimal diasAPagar = 6;
                            //if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                            //    diasAPagar = 7.5M;

                            decimal constante = 1.25M;

                            if (NominaTrabajador.Nomina_stNomina.Año == 2022)
                            {
                                diasAPagar = 3;
                                //if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                //    diasAPagar = 4.5M;

                                constante = 1;
                            }

                            if (perdioPuntualidad != null)
                                diasAPagar = 0;

                            if (solicitud != null && ultimocontrato != null
                         && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                            {
                                DapperQuery dp = new DapperQuery("bdNovaEntities");

                                DateTime fechatermino = DateTime.Now;


                                if (ConvenioLaboralTrabajadorCategoria.FechaTermino == null)
                                {
                                    //BUSCAR SU INCIDENCIA
                                    string consulta = $@"  select * from vwLicenciasTrabajadores
                                            where idtrabajador={ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador }
                                            and Incidencia like '%SIN GOCE DE SUELDO%'
                                            AND YEAR(FechaInicioIncidencia)={solicitud.Año} order by FechaTerminoIncidencia ";
                                    List<vwLicenciasTrabajadores> licencias = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(consulta).ToList();
                                    if (licencias.Count() > 0)
                                        fechatermino = licencias[0].FechaInicioIncidencia;
                                }
                                else
                                {
                                    
                                    //       var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                                    string sqlnomina = @"select b.* from Nomina_stNominaTrabajador a
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
where    EstatusNominaGrupo ='PARA PAGO' and b.EsCerrada=1 and year(b.fechainicio)=" + solicitud.Año + " and  c.Plantilla like '%sueldo%' and a.IdConvenioLaboralTrabajadorCategoria=" + ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria + "  order by b.fechatermino Asc";

                                    List<Nomina_stNomina> ultimanominas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(sqlnomina).ToList();
                                    
                                    fechatermino = ultimanominas.LastOrDefault().FechaTermino.AddDays(1);
                                }
                                dp.Close();
                                var fechanicio = ConvenioLaboralTrabajadorCategoria.FechaInicio;
                                if (ConvenioLaboralTrabajadorCategoria.FechaInicio.Year < solicitud.Año)
                                    fechanicio = DateTime.Parse(solicitud.Año.ToString() + "-01-01");

                                //decimal diasremanentes = 0;
                                //TimeSpan Diff_dates = fechatermino.Subtract(fechanicio);
                                //diasremanentes = (Decimal)Diff_dates.Days;
                                //var factordias = (diasremanentes * diasAPagar) / 365;
                                diasAPagar =DiasPuntualidadSegunFecha(fechatermino, diasAPagar);
                                //diasAPagar = factordias;
                            }

                            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                            {
                                diasAPagar = diasAPagar * constante;

                            }

                            if (perdioPuntualidad != null)
                                if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                    diasAPagar = diasAPagar - (perdioPuntualidad.Meses * constante);
                                else
                                    diasAPagar = diasAPagar - perdioPuntualidad.Meses;

                            if (diasAPagar > 0)
                            {

                            



                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                                bdNovaEntities qq = new bdNovaEntities();
                                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                                Decimal Sueldodiario = 0;

                                //busca si termino una licencia
                                var regresadeLicencia = NominaTrabajador.LicenciasTrabajadoresPrimavacacional.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                                //int diasAPagar = 8;
                                //if (regresadeLicencia != null)
                                //    if (regresadeLicencia.FechaTerminoIncidencia != null)
                                //    {
                                //        diasAPagar = diasAPagar - NominaTrabajador.DiasdePrima(ConvenioLaboralTrabajadorCategoria, regresadeLicencia);

                                //    }


                                var apoyoNomina = NominaTrabajador.ListaNominaApoyoEstudios.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                                Decimal PorcentajeApoyo = 0M;
                                if (apoyoNomina != null)
                                    PorcentajeApoyo = apoyoNomina.PorcentajeApoyo;



                                var trabajadorconprestacionescongasto = NominaTrabajador.TrabajadoresConPercepcionesCongasto.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();



                                PercepcionesNominaTrabajador percepcionImporte = new PercepcionesNominaTrabajador();

                                VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                                var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;



                                if (solicitud != null && ultimocontrato != null
                      && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                                {
                                    NominaTrabajador.setSalariosDiariosDocentesPartesProporcionales(solicitud.Año, solicitud.IdTrabajador);
                                    if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                        Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPartesProporcionales.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().Importe;
                                    else
                                        Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPartesProporcionales.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                                }
                                else
                                {
                                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORD"))
                                    {
                                        if (NominaTrabajador.SalariosDiarioDocentesParaPrimaHorasExtras.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault() != null)
                                        {
                                            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                                Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrimaHorasExtras.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().Importe;
                                            else
                                                Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrimaHorasExtras.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                                        }
                                    }
                                    else
                                    if (NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault()!=null)
                                            {
                                        if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                            Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().Importe;
                                        else
                                            Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                                    }
                                }


                                Decimal Materialdiario = 0M;



                                decimal importegrava = 0;


                                importegrava = (Sueldodiario) * diasAPagar;



                                PercepcionesNominaTrabajador PrimaVacacionalExenta = new PercepcionesNominaTrabajador();

                                if (PorcentajeApoyo > 0)
                                    importegrava = (PorcentajeApoyo * importegrava) / 100;


                                percepcionImporte.Importe = importegrava;

                                percepcionImporte.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                percepcionImporte.IdNomina = NominaTrabajador.IdNomina;
                                percepcionImporte.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA").FirstOrDefault().IdPlantillaNominaPercepcion;
                                percepcionImporte.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                percepcionImporte.EsImprimibleRecibo = true;
                                percepcionImporte.Tipo = "NORMAL";
                                percepcionImporte.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcionImporte);


                                // aplica para los de base que se les dio el derecho de gasto adminitrativo
                                if (trabajadorconprestacionescongasto != null)
                                {
                                    var IdPlantillaNominaPercepcion = percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;

                                    var datosgastoadministrativo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                    var diariogastoadministrativo = (datosgastoadministrativo.Importe / 15) * diasAPagar;

                                    PercepcionesNominaTrabajador percepciongasto = new PercepcionesNominaTrabajador();

                                    percepciongasto.Importe = diariogastoadministrativo;
                                    percepciongasto.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    percepciongasto.IdNomina = NominaTrabajador.IdNomina;
                                    percepciongasto.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    percepciongasto.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                    percepciongasto.EsImprimibleRecibo = true;
                                    percepciongasto.Tipo = "NORMAL";
                                    percepciongasto.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepciongasto);


                                }


                            }
                        }
                }
                 }
            }

        private decimal DiasPuntualidadSegunFecha(DateTime inicioincidencia,decimal derechodias)
        {
            int dias = 0;
            int mesfinal = inicioincidencia.Month;
            int mesfinalincidencia = inicioincidencia.Month;
            int days = System.DateTime.DaysInMonth(inicioincidencia.Year, mesfinal);
            if (inicioincidencia.Day < days)
                mesfinal = mesfinal - 1;

            if (mesfinalincidencia < 7)
            {
                mesfinal =  6-mesfinal;
            }
            else
            {
                mesfinal = mesfinal - 6;
            }

            var res = (mesfinal * derechodias) / 6;
            return res;
        }
        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }
}