﻿using Dapper;
using Nova.Libraries;
using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Nova.Models.Calculos.Percepciones
{
    public class PrimaAntiguedad : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {

            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DE ANTIGUEDAD").FirstOrDefault() != null)
            {
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DE ANTIGUEDAD").FirstOrDefault();
                if (percepcionCalculo.Calcular)

                {
                    var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    var ultimocontrato = NominaTrabajador.PartesProporcionalesUltimoContrato.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                     && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                    if (solicitud != null && ultimocontrato != null)
                        if (solicitud.CalcularPrimaAntiguedad)
                        {

                            DapperQuery dp = new DapperQuery("bdNovaEntities");

                            string sqlnomina = @"select b.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and  b.EsCerrada=1 and year(b.fechainicio)=" + NominaTrabajador.Nomina_stNomina.FechaInicio.Year + " and  c.Plantilla like '%sueldo%' and w.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + "  order by b.fechatermino desc";

                            List<Nomina_stNomina> ultimanominas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(sqlnomina).ToList();

                            DateTime fechaultiimanomina = NominaTrabajador.Nomina.FechaTermino.AddDays(1);
                            if (ultimanominas.Count > 0)
                            {
                                fechaultiimanomina = ultimanominas[0].FechaTermino.AddDays(1);
                            }

                            //        SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                            //AntiguedadLaboralQuinquenioTrabajador antiguedadtrabajador = antiguedad.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                            var antiguedadtrabajador = NominaTrabajador.TrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);


                            int años = antiguedadtrabajador.Years;
                            Double dias = 0;
                    if (antiguedadtrabajador.Years > 0)
                    {
                                dias = (365 * antiguedadtrabajador.Years);
                                if (antiguedadtrabajador.Months > 0)
                                    dias = dias + ((double)Math.Round(antiguedadtrabajador.Months * 30.4))+1;
                                if (antiguedadtrabajador.Days> 0)
                                    dias = dias + antiguedadtrabajador.Days;
                            //años = años + 1;

                    }

                            decimal factordias = (decimal)(dias * 12) / 365M;


                    var importebase = NominaTrabajador.ctUMA.Monto*2;

                            // decimal totalprima = (importebase * 12 )* años  ;
                            decimal totalprima = importebase *factordias;

                            // decimal importeexcento = (NominaTrabajador.ctUMA.Monto * 90) * años;

                            decimal importeexcento = (NominaTrabajador.ctUMA.Monto * 90) * años;



                            if (totalprima > 0)
                    {
                        if (totalprima < importeexcento)
                        {
                            importeexcento = totalprima;

                            PercepcionesNominaTrabajador PrimalExenta = new PercepcionesNominaTrabajador();
                            PrimalExenta.Importe = importeexcento;

                            PrimalExenta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            PrimalExenta.IdNomina = NominaTrabajador.IdNomina;
                            PrimalExenta.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DE ANTIGUEDAD EXENTA").FirstOrDefault().IdPlantillaNominaPercepcion;
                            PrimalExenta.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DE ANTIGUEDAD EXENTA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                            PrimalExenta.EsImprimibleRecibo = true;
                            PrimalExenta.Tipo = "NORMAL";
                            PrimalExenta.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DE ANTIGUEDAD EXENTA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                    PrimalExenta.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == PrimalExenta.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                                    PrimalExenta.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == PrimalExenta.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;
                                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(PrimalExenta);
                                }
                                if ((totalprima - importeexcento) > 0)
                        {
                            PercepcionesNominaTrabajador Prima = new PercepcionesNominaTrabajador();



                            Prima.Importe = totalprima - importeexcento;

                            Prima.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            Prima.IdNomina = NominaTrabajador.IdNomina;
                            Prima.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DE ANTIGUEDAD").FirstOrDefault().IdPlantillaNominaPercepcion;
                            Prima.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DE ANTIGUEDAD").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                            Prima.EsImprimibleRecibo = true;
                            Prima.Tipo = "NORMAL";
                            Prima.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DE ANTIGUEDAD").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                    Prima.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == Prima.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                                    Prima.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == Prima.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;
                                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(Prima);
                        }
                    }
                }
                 
                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

    }
}

