﻿ 
using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;

namespace Nova.Models.Calculos.Percepciones
{

    public class PartesProporcionales : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
            {

                if (NominaTrabajador.Nomina_PartesProporcionales.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault() != null)
                {

                    DapperQuery dp = new DapperQuery("bdNovaEntities");
                    string query = @"SELECT IdConvenioLaboralTrabajadorCategoria,SueldoDiario,sum(a.DiasEfectivosLaborados) DiasEfectivosLaborados,c.IdRelacionConvenioLaboral
,max(DiasAguinaldo)as dg
,(MAX(cast(DiasAguinaldo as float)/cast(365 as float))*sum(a.DiasEfectivosLaborados))*SueldoDiario as Aguinaldo
,(MAX(cast(DiasPrimaVacacional as float)/cast(365 as float))*sum(a.DiasEfectivosLaborados))*SueldoDiario as PrimaVacacional

  FROM  Nomina_stNominaTrabajador a
  inner join  Nomina_stNomina b on a.idnomina=b.idnomina
   inner join  Nomina_ctPlantillaNomina c on c.IdPlantillaNomina=b.IdPlantillaNomina
   inner join Catalogos_ctParametrosRelacionLaboral w on w.IdRelacionConvenioLaboral=c.IdRelacionConvenioLaboral
  where c.Plantilla like '%sueldo%' and  b.Año=" + NominaTrabajador.Nomina_stNomina.Año + @" and year(w.FechaFinal)=" + NominaTrabajador.Nomina_stNomina.Año + @"and  IdConvenioLaboralTrabajadorCategoria
  
  in (
  select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadoresHistorial where IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + @"
)  
  group by IdConvenioLaboralTrabajadorCategoria,SueldoDiario,c.IdRelacionConvenioLaboral";

                    List<PartesProporcionalesTrabajador> PartesProporcionalesDatos = (List<PartesProporcionalesTrabajador>)dp.connection.Query<PartesProporcionalesTrabajador>(query);

                    if (PartesProporcionalesDatos.Count() > 0)
                    {
                        foreach (var item in PartesProporcionalesDatos)
                        {
                            //aguinaldo
                            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            percepcion.IdNomina = NominaTrabajador.IdNomina;
                            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault().IdPlantillaNominaPercepcion;
                            percepcion.Importe = item.Aguinaldo;

                            percepcion.Tipo = "NORMAL";
                            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                            percepcion.Concepto = "";
                            percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                            percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                            //prima
                            PercepcionesNominaTrabajador prima = new PercepcionesNominaTrabajador();

                            prima.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            prima.IdNomina = NominaTrabajador.IdNomina;
                            prima.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GRAVADA").FirstOrDefault().IdPlantillaNominaPercepcion;
                            prima.Importe = item.PrimaVacacional;

                            prima.Tipo = "NORMAL";
                            prima.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GRAVADA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                            prima.Concepto = "";
                            prima.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GRAVADA").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                            prima.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA VACACIONAL GRAVADA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(prima);

                        }

                    }

                    dp.Close();
                }
            }

        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

    }


}