﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class Onomastico : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.ValidarEmpleadoRestriccionSincuota(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador, ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador))
                if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault() != null)
            {
                

                var dpt = NominaTrabajador.TrabajadoresVigentesKardex_ctDatosPersonales.Where(a => a.IdKardex == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex).FirstOrDefault();
                if (NominaTrabajador.EsPagoOnomastico(dpt.FechaNacimiento, NominaTrabajador.Nomina.FechaInicio, NominaTrabajador.Nomina.FechaTermino))
                {
                    var apoyoNomina = NominaTrabajador.ListaNominaApoyoEstudios.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    Decimal PorcentajeApoyo = 0M;
                    if (apoyoNomina != null)
                        PorcentajeApoyo = apoyoNomina.PorcentajeApoyo;
                    var trabajadorconprestacionescongasto = NominaTrabajador.TrabajadoresConPercepcionesCongasto.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                    if (trabajadorconprestacionescongasto != null)
                    {
                        
                        var GASTO = NominaTrabajador.PercepcionPersonalizada.Where(c => c.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();

                        if (PorcentajeApoyo > 0)
                            GASTO.Importe = (PorcentajeApoyo * GASTO.Importe) / 100;

                        var diariogastoadministrativo = (GASTO.Importe / 15);
                        PercepcionesNominaTrabajador percepciong = new PercepcionesNominaTrabajador();

                        percepciong.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepciong.IdNomina = NominaTrabajador.IdNomina;  
                        percepciong.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;
                        percepciong.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                        percepciong.TratamientoEspecialIncapacidadesSueldoIsr = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.TratamientoEspecialIncapacidadesSueldoIsr;
                        percepciong.Importe = diariogastoadministrativo;



                    percepciong.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepciong);


                }

                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                    percepcion.TratamientoEspecialIncapacidadesSueldoIsr = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault().Percepciones_ctPercepcion.TratamientoEspecialIncapacidadesSueldoIsr;

                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                    percepcion.Importe = costos.CostoPorHora * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo;

                    if (PorcentajeApoyo > 0)
                        percepcion.Importe = (PorcentajeApoyo * percepcion.Importe) / 100;


                    if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "AUXILIAR DE SERVICIOS Y MANTENIMIENTO" 
                        || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "OFICIAL DE SERVICIOS"
                        || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "OFICIAL DE MANTENIMIENTO"
                        || ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "VIGILANTE")
                    {
                        if (NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes=="01" && NominaTrabajador.Nomina_stNomina.Año==2020 )
                            percepcion.Importe = percepcion.Importe ;
                        else
                        percepcion.Importe = percepcion.Importe * 2;
                    }

                    percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "ONOMÁSTICO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                   
                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }
    }

}