﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class MaterialDidacticoJornadaExcedente : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per ="")
        {

            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE JORNADA").FirstOrDefault() != null)
            {
                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.ToString());


                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                percepcion.IdNomina = NominaTrabajador.IdNomina;
                percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE JORNADA").FirstOrDefault().IdPlantillaNominaPercepcion;
                percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE JORNADA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE JORNADA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;

                decimal ImporteMat = (decimal)NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault().CostoMaterialDidactico;

                //percepcion.Importe = Decimal.Round(NominaTrabajador.HorasSemanaMes  * ImporteMat * 2, 4);

                int diaslaborados = (int)NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.Concepto == "DIASLABORADOS" && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe;

                var existhh = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.Concepto == "HorasHHBASE" && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                if (existhh!=null)
                { diaslaborados = (int)existhh.Importe; }
                

                percepcion.Importe = Decimal.Round((((NominaTrabajador.HorasSemanaMes * ImporteMat * 2)) / 15) * diaslaborados, 4);
                //jose dijo qeu se pagan proporcionales a los dias trabajados 01 ene 2022 se cambio lalinea de abajo, caso roberto toledo termina 13 de feb 2022
                //percepcion.Importe = Decimal.Round((((NominaTrabajador.HorasSemanaMes * ImporteMat * 2)) / 15) * NominaTrabajador.DiasPagados, 4);


                PercepcionesNominaTrabajador percepcionExcedente = new PercepcionesNominaTrabajador();
              
                if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                {
                    //decimal ImporteApagar = (decimal) ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.CostoMaterialDidactico;
                    decimal ImporteApagar = (decimal)NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault().CostoMaterialDidacticoExcedente;

                    if (NominaTrabajador.HorasSemanaMes < costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo)
                    {
                        decimal totalsueldo = 0;
                        if (NominaTrabajador.HorasSemanaMes <= 19)
                        {


                            //percepcion.Importe = Decimal.Round((ImporteApagar * (NominaTrabajador.HorasSemanaMes * 2) / 15) * NominaTrabajador.DiasPagados, 4);
                            percepcion.Importe = Decimal.Round((ImporteApagar * (NominaTrabajador.HorasSemanaMes * 2) / 15) * diaslaborados, 4);
                        }
                        else
                        {

                            var importe100 = Decimal.Round(NominaTrabajador.HorasTrabajadasExcedentes * ImporteApagar * 2, 4);
                            percepcionExcedente.Importe = ((importe100 * diaslaborados) / NominaTrabajador.DiasNomina);
                            //percepcionExcedente.Importe = ((importe100 * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina);
                            



                        }


                        percepcionExcedente.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcionExcedente.IdNomina = NominaTrabajador.IdNomina;
                        percepcionExcedente.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE HORAS EXCEDENTES").FirstOrDefault().IdPlantillaNominaPercepcion;
                        percepcionExcedente.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE HORAS EXCEDENTES").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                        percepcionExcedente.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE HORAS EXCEDENTES").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                    }
                

                }
                else
                {
                     
                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA MATERIAL DIDÁCTICO DOCENTE").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA MATERIAL DIDÁCTICO DOCENTE").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                    percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA MATERIAL DIDÁCTICO DOCENTE").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;

                }

                if (percepcion.Importe > 0)
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                if (percepcionExcedente.Importe > 0)
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcionExcedente);
            }
            
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }
    }

}