﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Calculos.Percepciones
{
    public class GuarderiaBaseDocente : IPercepcionBehavior
    {
   
    public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
    {
        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

        if (NominaTrabajador.ParametrosRelacionLaboral.EsAplicaGuarderia && ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Sexo.Trim() == "M")
        {
                var hijos = HijosGuarderia(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                if (hijos > 0)
                {
                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                    var HorasSemanaMes = (short)NominaTrabajador.ListaVariablesNominaTrabajador.Where(q => q.Concepto == "HorasSemanaMes" && q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Select(e => e.Importe).FirstOrDefault();

                    percepcion.Importe =
                    ( (decimal)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Porcentaje * HorasSemanaMes)*hijos;

                 


                  //  percepcion.Importe = (NominaTrabajador.DiasPagados * percepcion.Importe) / NominaTrabajador.DiasNomina;

                    percepcion.Tipo = "NORMAL";
                    percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GUARDERIA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                }
        }
    }

    private int HijosGuarderia(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
    {

        //var listahijosmenores = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares.Where(x => NominaTrabajador.Nomina.FechaTermino.Subtract(x.FechaNacimiento).Days / 365 < 7
        //    && (x.Kardex_ctParentesco.Parentesco == "HIJA" || x.Kardex_ctParentesco.Parentesco == "HIJO")).ToList();

            var listahijosmenores = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares.Where(x => x.Kardex_ctParentesco.Parentesco == "HIJA" || x.Kardex_ctParentesco.Parentesco == "HIJO").ToList();
            int hijosmenores = 0;
        foreach (var item in listahijosmenores)
        {

                if (hijosmenores<=2)
                { var edad = DateTimeSpan.CompareDates(item.FechaNacimiento, NominaTrabajador.Nomina_stNomina.FechaTermino);

                    if (edad.Years <= 6)
                    {
                        hijosmenores++;
                    }

                }
        }
        return hijosmenores;
    }





    void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
    {
        throw new NotImplementedException();
    }

    }
}